/*
 * Decompiled with CFR 0.152.
 */
package org.h2.build.doc;

import java.util.Arrays;

public class XMLParser {
    public static final int ERROR = 0;
    public static final int START_ELEMENT = 1;
    public static final int END_ELEMENT = 2;
    public static final int PROCESSING_INSTRUCTION = 3;
    public static final int CHARACTERS = 4;
    public static final int COMMENT = 5;
    public static final int START_DOCUMENT = 7;
    public static final int END_DOCUMENT = 8;
    public static final int DTD = 11;
    private final String xml;
    private int pos;
    private int eventType;
    private String currentText;
    private String currentToken;
    private String prefix;
    private String localName;
    private String[] attributeValues = new String[3];
    private int currentAttribute;
    private boolean endElement;
    private boolean html;

    public XMLParser(String xml) {
        this.xml = xml;
        this.eventType = 7;
    }

    public void setHTML(boolean html) {
        this.html = html;
    }

    private void addAttributeName(String pre, String name) {
        if (this.attributeValues.length <= this.currentAttribute) {
            this.attributeValues = Arrays.copyOf(this.attributeValues, this.attributeValues.length * 2);
        }
        this.attributeValues[this.currentAttribute++] = pre;
        this.attributeValues[this.currentAttribute++] = name;
    }

    private void addAttributeValue(String v) {
        this.attributeValues[this.currentAttribute++] = v;
    }

    private int readChar() {
        if (this.pos >= this.xml.length()) {
            return -1;
        }
        return this.xml.charAt(this.pos++);
    }

    private void back() {
        --this.pos;
    }

    private void error(String expected) {
        throw new RuntimeException("Expected: " + expected + " got: " + this.xml.substring(this.pos, Math.min(this.pos + 1000, this.xml.length())));
    }

    private void read(String chars) {
        int i = 0;
        while (i < chars.length()) {
            if (this.readChar() != chars.charAt(i)) {
                this.error(chars);
            }
            ++i;
        }
    }

    private void skipSpaces() {
        while (this.pos < this.xml.length() && this.xml.charAt(this.pos) <= ' ') {
            ++this.pos;
        }
    }

    private void read() {
        int tokenStart;
        block41: {
            this.currentText = null;
            this.currentAttribute = 0;
            tokenStart = this.pos;
            int currentStart = this.pos;
            int ch = this.readChar();
            if (ch < 0) {
                this.eventType = 8;
            } else if (ch == 60) {
                currentStart = this.pos;
                ch = this.readChar();
                if (ch < 0) {
                    this.eventType = 0;
                } else if (ch == 63) {
                    this.eventType = 3;
                    currentStart = this.pos;
                    do {
                        if ((ch = this.readChar()) >= 0) continue;
                        this.error("?>");
                    } while (ch != 63 || this.readChar() != 62);
                    if (this.xml.substring(currentStart).startsWith("xml")) {
                        int back = tokenStart;
                        this.read();
                        tokenStart = back;
                    } else {
                        this.currentText = this.xml.substring(currentStart, this.pos - 1);
                    }
                } else if (ch == 33) {
                    ch = this.readChar();
                    if (ch == 45) {
                        this.eventType = 5;
                        if (this.readChar() != 45) {
                            this.error("-");
                        }
                        currentStart = this.pos;
                        do {
                            if ((ch = this.readChar()) >= 0) continue;
                            this.error("-->");
                        } while (ch != 45 || this.readChar() != 45);
                        this.read(">");
                        this.currentText = this.xml.substring(currentStart, this.pos - 1);
                    } else if (ch == 68) {
                        this.read("OCTYPE");
                        this.eventType = 11;
                        while ((ch = this.readChar()) >= 0 && ch != 62) {
                        }
                    } else if (ch == 91) {
                        this.read("CDATA[");
                        currentStart = this.pos;
                        this.eventType = 4;
                        while (true) {
                            if ((ch = this.readChar()) < 0) {
                                this.error("]]>");
                            } else if (ch != 93) continue;
                            ch = this.readChar();
                            if (ch < 0) {
                                this.error("]]>");
                                continue;
                            }
                            if (ch != 93) continue;
                            do {
                                if ((ch = this.readChar()) >= 0) continue;
                                this.error("]]>");
                            } while (ch == 93);
                            if (ch == 62) break;
                        }
                        this.currentText = this.xml.substring(currentStart, this.pos - 3);
                    }
                } else if (ch == 47) {
                    currentStart = this.pos;
                    this.prefix = null;
                    this.eventType = 2;
                    while (true) {
                        if ((ch = this.readChar()) < 0) {
                            this.error(">");
                            continue;
                        }
                        if (ch == 58) {
                            this.prefix = this.xml.substring(currentStart, this.pos - 1);
                            currentStart = this.pos + 1;
                            continue;
                        }
                        if (ch == 62) {
                            this.localName = this.xml.substring(currentStart, this.pos - 1);
                            break block41;
                        }
                        if (ch <= 32) break;
                    }
                    this.localName = this.xml.substring(currentStart, this.pos - 1);
                    this.skipSpaces();
                    this.read(">");
                } else {
                    this.prefix = null;
                    this.localName = null;
                    this.eventType = 1;
                    do {
                        if ((ch = this.readChar()) < 0) {
                            this.error(">");
                        } else if (ch == 58) {
                            this.prefix = this.xml.substring(currentStart, this.pos - 1);
                            currentStart = this.pos + 1;
                        } else if (ch <= 32) {
                            this.localName = this.xml.substring(currentStart, this.pos - 1);
                            this.readAttributeValues();
                            ch = this.readChar();
                        }
                        if (ch != 47) continue;
                        if (this.localName == null) {
                            this.localName = this.xml.substring(currentStart, this.pos - 1);
                        }
                        this.read(">");
                        this.endElement = true;
                        break block41;
                    } while (ch != 62);
                    if (this.localName == null) {
                        this.localName = this.xml.substring(currentStart, this.pos - 1);
                    }
                }
            } else {
                this.eventType = 4;
                while ((ch = this.readChar()) >= 0) {
                    if (ch != 60) continue;
                    this.back();
                    break;
                }
                this.currentText = this.xml.substring(currentStart, this.pos);
            }
        }
        this.currentToken = this.xml.substring(tokenStart, this.pos);
    }

    private void readAttributeValues() {
        while (true) {
            int end;
            int start = this.pos;
            int ch = this.readChar();
            if (ch < 0) {
                this.error(">");
            } else {
                if (ch <= 32) continue;
                if (ch == 47 || ch == 62) {
                    this.back();
                    return;
                }
            }
            int localNameStart = start;
            boolean noValue = false;
            while (true) {
                end = this.pos;
                ch = this.readChar();
                if (ch < 0) {
                    this.error("=");
                    continue;
                }
                if (ch <= 32) {
                    this.skipSpaces();
                    ch = this.readChar();
                    if (ch == 61) break;
                    if (this.html) {
                        this.back();
                        noValue = true;
                        break;
                    }
                    this.error("=");
                    break;
                }
                if (ch == 61) break;
                if (ch == 58) {
                    localNameStart = this.pos;
                    continue;
                }
                if (ch != 47 && ch != 62) continue;
                if (this.html) {
                    this.back();
                    noValue = true;
                    break;
                }
                this.error("=");
            }
            if (localNameStart == start) {
                this.addAttributeName("", this.xml.substring(localNameStart, end));
            } else {
                this.addAttributeName(this.xml.substring(start, localNameStart - 1), this.xml.substring(localNameStart, end));
            }
            if (noValue) {
                noValue = false;
            } else {
                this.skipSpaces();
                ch = this.readChar();
                if (ch != 34) {
                    this.error("\"");
                }
                start = this.pos;
                while (true) {
                    end = this.pos;
                    ch = this.readChar();
                    if (ch < 0) {
                        this.error("\"");
                        continue;
                    }
                    if (ch == 34) break;
                }
            }
            this.addAttributeValue(this.xml.substring(start, end));
        }
    }

    public boolean hasNext() {
        return this.pos < this.xml.length();
    }

    public int next() {
        if (this.endElement) {
            this.endElement = false;
            this.eventType = 2;
            this.currentToken = "";
        } else {
            this.read();
        }
        return this.eventType;
    }

    public int getEventType() {
        return this.eventType;
    }

    public String getText() {
        return this.currentText;
    }

    public String getToken() {
        return this.currentToken;
    }

    public int getAttributeCount() {
        return this.currentAttribute / 3;
    }

    public String getAttributePrefix(int index) {
        return this.attributeValues[index * 3];
    }

    public String getAttributeLocalName(int index) {
        return this.attributeValues[index * 3 + 1];
    }

    public String getName() {
        return this.prefix == null || this.prefix.length() == 0 ? this.localName : this.prefix + ":" + this.localName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isWhiteSpace() {
        return this.getText().trim().length() == 0;
    }

    public String getRemaining() {
        return this.xml.substring(this.pos);
    }

    public int getPos() {
        return this.pos;
    }
}

