/*
 * Decompiled with CFR 0.152.
 */
package org.h2.build.indexer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.h2.build.indexer.Page;
import org.h2.build.indexer.Weight;

public class Word {
    String name;
    final HashMap<Page, Weight> pages = new HashMap();
    private ArrayList<Weight> weightList;

    Word(String name) {
        this.name = name;
    }

    void addPage(Page page, int weight) {
        Weight w = this.pages.get(page);
        if (w == null) {
            w = new Weight();
            w.page = page;
            this.pages.put(page, w);
        }
        w.value += weight;
        ++page.relations;
    }

    public String toString() {
        return this.name + ":" + String.valueOf(this.pages);
    }

    void addAll(Word other) {
        for (Map.Entry<Page, Weight> entry : other.pages.entrySet()) {
            Page p = entry.getKey();
            Weight w = entry.getValue();
            this.addPage(p, w.value);
        }
    }

    ArrayList<Weight> getSortedWeights() {
        if (this.weightList == null) {
            this.weightList = new ArrayList<Weight>(this.pages.values());
            this.weightList.sort((w0, w1) -> Integer.compare(w1.value, w0.value));
        }
        return this.weightList;
    }
}

