/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.h2.command.Command;
import org.h2.command.CommandContainer;
import org.h2.command.Prepared;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.expression.Parameter;
import org.h2.expression.ParameterInterface;
import org.h2.result.ResultInterface;
import org.h2.result.ResultWithGeneratedKeys;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class CommandList
extends Command {
    private final CommandContainer command;
    private final ArrayList<Prepared> commands;
    private final ArrayList<Parameter> parameters;
    private String remaining;
    private Command remainingCommand;

    CommandList(SessionLocal session, String sql, CommandContainer command, ArrayList<Prepared> commands, ArrayList<Parameter> parameters, String remaining) {
        super(session, sql);
        this.command = command;
        this.commands = commands;
        this.parameters = parameters;
        this.remaining = remaining;
    }

    @Override
    public ArrayList<? extends ParameterInterface> getParameters() {
        return this.parameters;
    }

    private void executeRemaining() {
        for (Prepared prepared : this.commands) {
            CommandContainer commandContainer = new CommandContainer(this.session, prepared.getSQL(), prepared);
            prepared.prepare();
            if (prepared.isQuery()) {
                this.executeQuery(0L, false);
                continue;
            }
            commandContainer.executeUpdate(null);
        }
        if (this.remaining != null) {
            this.remainingCommand = this.session.prepareLocal(this.remaining);
            this.remaining = null;
            if (this.remainingCommand.isQuery()) {
                this.remainingCommand.executeQuery(0L, false);
            } else {
                this.remainingCommand.executeUpdate(null);
            }
        }
    }

    @Override
    public ResultWithGeneratedKeys update(Object generatedKeysRequest) {
        ResultWithGeneratedKeys result = this.command.executeUpdate(null);
        this.executeRemaining();
        return result;
    }

    @Override
    public ResultInterface query(long maxrows) {
        ResultInterface result = this.command.query(maxrows);
        this.executeRemaining();
        return result;
    }

    @Override
    public void stop(boolean commitIfAutoCommit) {
        this.command.stop(commitIfAutoCommit);
        if (this.remainingCommand != null) {
            this.remainingCommand.stop(commitIfAutoCommit);
        }
    }

    @Override
    public boolean isQuery() {
        return this.command.isQuery();
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() {
        return this.command.queryMeta();
    }

    @Override
    public int getCommandType() {
        return this.command.getCommandType();
    }

    @Override
    public Set<DbObject> getDependencies() {
        HashSet<DbObject> dependencies = new HashSet<DbObject>();
        for (Prepared prepared : this.commands) {
            prepared.collectDependencies(dependencies);
        }
        return dependencies;
    }

    @Override
    protected boolean isRetryable() {
        if (!this.command.isRetryable()) {
            return false;
        }
        for (Prepared prepared : this.commands) {
            if (prepared.isRetryable()) continue;
            return false;
        }
        return this.remainingCommand == null || this.remainingCommand.isRetryable();
    }
}

