/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import org.h2.api.IntervalQualifier;
import org.h2.command.Command;
import org.h2.command.CommandContainer;
import org.h2.command.CommandList;
import org.h2.command.ParserBase;
import org.h2.command.Prepared;
import org.h2.command.QueryScope;
import org.h2.command.Token;
import org.h2.command.ddl.AlterDomainAddConstraint;
import org.h2.command.ddl.AlterDomainDropConstraint;
import org.h2.command.ddl.AlterDomainExpressions;
import org.h2.command.ddl.AlterDomainRename;
import org.h2.command.ddl.AlterDomainRenameConstraint;
import org.h2.command.ddl.AlterIndexRename;
import org.h2.command.ddl.AlterSchemaRename;
import org.h2.command.ddl.AlterSequence;
import org.h2.command.ddl.AlterTableAddConstraint;
import org.h2.command.ddl.AlterTableAlterColumn;
import org.h2.command.ddl.AlterTableDropConstraint;
import org.h2.command.ddl.AlterTableRename;
import org.h2.command.ddl.AlterTableRenameColumn;
import org.h2.command.ddl.AlterTableRenameConstraint;
import org.h2.command.ddl.AlterUser;
import org.h2.command.ddl.AlterView;
import org.h2.command.ddl.Analyze;
import org.h2.command.ddl.CommandWithColumns;
import org.h2.command.ddl.CreateAggregate;
import org.h2.command.ddl.CreateConstant;
import org.h2.command.ddl.CreateDomain;
import org.h2.command.ddl.CreateFunctionAlias;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.CreateLinkedTable;
import org.h2.command.ddl.CreateMaterializedView;
import org.h2.command.ddl.CreateRole;
import org.h2.command.ddl.CreateSchema;
import org.h2.command.ddl.CreateSequence;
import org.h2.command.ddl.CreateSynonym;
import org.h2.command.ddl.CreateTable;
import org.h2.command.ddl.CreateTrigger;
import org.h2.command.ddl.CreateUser;
import org.h2.command.ddl.CreateView;
import org.h2.command.ddl.DeallocateProcedure;
import org.h2.command.ddl.DefineCommand;
import org.h2.command.ddl.DropAggregate;
import org.h2.command.ddl.DropConstant;
import org.h2.command.ddl.DropDatabase;
import org.h2.command.ddl.DropDomain;
import org.h2.command.ddl.DropFunctionAlias;
import org.h2.command.ddl.DropIndex;
import org.h2.command.ddl.DropMaterializedView;
import org.h2.command.ddl.DropRole;
import org.h2.command.ddl.DropSchema;
import org.h2.command.ddl.DropSequence;
import org.h2.command.ddl.DropSynonym;
import org.h2.command.ddl.DropTable;
import org.h2.command.ddl.DropTrigger;
import org.h2.command.ddl.DropUser;
import org.h2.command.ddl.DropView;
import org.h2.command.ddl.GrantRevoke;
import org.h2.command.ddl.PrepareProcedure;
import org.h2.command.ddl.RefreshMaterializedView;
import org.h2.command.ddl.SequenceOptions;
import org.h2.command.ddl.SetComment;
import org.h2.command.ddl.TruncateTable;
import org.h2.command.dml.AlterTableSet;
import org.h2.command.dml.BackupCommand;
import org.h2.command.dml.Call;
import org.h2.command.dml.CommandWithValues;
import org.h2.command.dml.DataChangeStatement;
import org.h2.command.dml.Delete;
import org.h2.command.dml.ExecuteImmediate;
import org.h2.command.dml.ExecuteProcedure;
import org.h2.command.dml.Explain;
import org.h2.command.dml.Help;
import org.h2.command.dml.Insert;
import org.h2.command.dml.Merge;
import org.h2.command.dml.MergeUsing;
import org.h2.command.dml.NoOperation;
import org.h2.command.dml.RunScriptCommand;
import org.h2.command.dml.ScriptCommand;
import org.h2.command.dml.Set;
import org.h2.command.dml.SetClauseList;
import org.h2.command.dml.SetSessionCharacteristics;
import org.h2.command.dml.SetTypes;
import org.h2.command.dml.TransactionCommand;
import org.h2.command.dml.Update;
import org.h2.command.query.ForUpdate;
import org.h2.command.query.Query;
import org.h2.command.query.QueryOrderBy;
import org.h2.command.query.Select;
import org.h2.command.query.SelectUnion;
import org.h2.command.query.TableValueConstructor;
import org.h2.constraint.ConstraintActionType;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.IsolationLevel;
import org.h2.engine.Mode;
import org.h2.engine.NullsDistinct;
import org.h2.engine.Procedure;
import org.h2.engine.SessionLocal;
import org.h2.engine.User;
import org.h2.expression.Alias;
import org.h2.expression.ArrayConstructorByQuery;
import org.h2.expression.ArrayElementReference;
import org.h2.expression.BinaryOperation;
import org.h2.expression.ConcatenationOperation;
import org.h2.expression.DomainValueExpression;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionList;
import org.h2.expression.ExpressionWithFlags;
import org.h2.expression.ExpressionWithVariableParameters;
import org.h2.expression.FieldReference;
import org.h2.expression.Format;
import org.h2.expression.Parameter;
import org.h2.expression.Rownum;
import org.h2.expression.SearchedCase;
import org.h2.expression.SequenceValue;
import org.h2.expression.SimpleCase;
import org.h2.expression.Subquery;
import org.h2.expression.TimeZoneOperation;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.UnaryOperation;
import org.h2.expression.ValueExpression;
import org.h2.expression.Variable;
import org.h2.expression.Wildcard;
import org.h2.expression.aggregate.AbstractAggregate;
import org.h2.expression.aggregate.Aggregate;
import org.h2.expression.aggregate.AggregateType;
import org.h2.expression.aggregate.JavaAggregate;
import org.h2.expression.aggregate.ListaggArguments;
import org.h2.expression.analysis.DataAnalysisOperation;
import org.h2.expression.analysis.Window;
import org.h2.expression.analysis.WindowFrame;
import org.h2.expression.analysis.WindowFrameBound;
import org.h2.expression.analysis.WindowFrameBoundType;
import org.h2.expression.analysis.WindowFrameExclusion;
import org.h2.expression.analysis.WindowFrameUnits;
import org.h2.expression.analysis.WindowFunction;
import org.h2.expression.analysis.WindowFunctionType;
import org.h2.expression.condition.BetweenPredicate;
import org.h2.expression.condition.BooleanTest;
import org.h2.expression.condition.CompareLike;
import org.h2.expression.condition.Comparison;
import org.h2.expression.condition.ConditionAndOr;
import org.h2.expression.condition.ConditionAndOrN;
import org.h2.expression.condition.ConditionIn;
import org.h2.expression.condition.ConditionInArray;
import org.h2.expression.condition.ConditionInQuery;
import org.h2.expression.condition.ConditionLocalAndGlobal;
import org.h2.expression.condition.ConditionNot;
import org.h2.expression.condition.ExistsPredicate;
import org.h2.expression.condition.IsJsonPredicate;
import org.h2.expression.condition.NullPredicate;
import org.h2.expression.condition.TypePredicate;
import org.h2.expression.condition.UniquePredicate;
import org.h2.expression.function.ArrayFunction;
import org.h2.expression.function.BitFunction;
import org.h2.expression.function.BuiltinFunctions;
import org.h2.expression.function.CSVWriteFunction;
import org.h2.expression.function.CardinalityExpression;
import org.h2.expression.function.CastSpecification;
import org.h2.expression.function.CoalesceFunction;
import org.h2.expression.function.CompatibilitySequenceValueFunction;
import org.h2.expression.function.CompressFunction;
import org.h2.expression.function.ConcatFunction;
import org.h2.expression.function.CryptFunction;
import org.h2.expression.function.CurrentDateTimeValueFunction;
import org.h2.expression.function.CurrentGeneralValueSpecification;
import org.h2.expression.function.DBObjectFunction;
import org.h2.expression.function.DataTypeSQLFunction;
import org.h2.expression.function.DateTimeFormatFunction;
import org.h2.expression.function.DateTimeFunction;
import org.h2.expression.function.DayMonthNameFunction;
import org.h2.expression.function.FileFunction;
import org.h2.expression.function.HashFunction;
import org.h2.expression.function.JavaFunction;
import org.h2.expression.function.JsonConstructorFunction;
import org.h2.expression.function.LengthFunction;
import org.h2.expression.function.MathFunction;
import org.h2.expression.function.MathFunction1;
import org.h2.expression.function.MathFunction2;
import org.h2.expression.function.NullIfFunction;
import org.h2.expression.function.RandFunction;
import org.h2.expression.function.RegexpFunction;
import org.h2.expression.function.SessionControlFunction;
import org.h2.expression.function.SetFunction;
import org.h2.expression.function.SignalFunction;
import org.h2.expression.function.SoundexFunction;
import org.h2.expression.function.StringFunction;
import org.h2.expression.function.StringFunction1;
import org.h2.expression.function.StringFunction2;
import org.h2.expression.function.SubstringFunction;
import org.h2.expression.function.SysInfoFunction;
import org.h2.expression.function.TableInfoFunction;
import org.h2.expression.function.ToCharFunction;
import org.h2.expression.function.TrimFunction;
import org.h2.expression.function.TruncateValueFunction;
import org.h2.expression.function.XMLFunction;
import org.h2.expression.function.table.ArrayTableFunction;
import org.h2.expression.function.table.CSVReadFunction;
import org.h2.expression.function.table.JavaTableFunction;
import org.h2.expression.function.table.LinkSchemaFunction;
import org.h2.expression.function.table.TableFunction;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.mode.FunctionsPostgreSQL;
import org.h2.mode.ModeFunction;
import org.h2.mode.OnDuplicateKeyValues;
import org.h2.mode.Regclass;
import org.h2.schema.Domain;
import org.h2.schema.FunctionAlias;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.schema.UserAggregate;
import org.h2.schema.UserDefinedFunction;
import org.h2.table.CTE;
import org.h2.table.Column;
import org.h2.table.DataChangeDeltaTable;
import org.h2.table.DualTable;
import org.h2.table.FunctionTable;
import org.h2.table.IndexColumn;
import org.h2.table.IndexHints;
import org.h2.table.MaterializedView;
import org.h2.table.QueryExpressionTable;
import org.h2.table.RangeTable;
import org.h2.table.ShadowTable;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.table.TableView;
import org.h2.util.IntervalUtils;
import org.h2.util.ParserUtil;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.util.geometry.EWKTUtils;
import org.h2.util.json.JSONItemType;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.ExtTypeInfoEnum;
import org.h2.value.ExtTypeInfoGeometry;
import org.h2.value.ExtTypeInfoNumeric;
import org.h2.value.ExtTypeInfoRow;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBigint;
import org.h2.value.ValueDate;
import org.h2.value.ValueDouble;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInteger;
import org.h2.value.ValueInterval;
import org.h2.value.ValueJson;
import org.h2.value.ValueNull;
import org.h2.value.ValueRow;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueUuid;
import org.h2.value.ValueVarchar;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Parser
extends ParserBase {
    private CreateView createView;
    private Prepared currentPrepared;
    private Select currentSelect;
    private String schemaName;
    private boolean rightsChecked;
    private boolean recompileAlways;
    private int orderInFrom;
    private boolean parseDomainConstraint;
    private QueryScope queryScope;
    private boolean parsingRecursiveWithList;

    public Parser(SessionLocal session) {
        super(session);
    }

    public Prepared prepare(String sql) {
        Prepared p = this.parse(sql, null);
        p.prepare();
        if (this.currentTokenType != 93) {
            throw this.getSyntaxError();
        }
        return p;
    }

    public Query prepareQueryExpression(String sql) {
        Query q = (Query)this.parse(sql, null);
        q.prepareExpressions();
        if (this.currentTokenType != 93) {
            throw this.getSyntaxError();
        }
        return q;
    }

    public Command prepareCommand(String sql) {
        try {
            Prepared p = this.parse(sql, null);
            if (this.currentTokenType != 115 && this.currentTokenType != 93) {
                this.addExpected(115);
                throw this.getSyntaxError();
            }
            p.prepare();
            int sqlIndex = this.token.start();
            if (sqlIndex < sql.length()) {
                sql = sql.substring(0, sqlIndex);
            }
            CommandContainer c = new CommandContainer(this.session, sql, p);
            while (this.currentTokenType == 115) {
                this.read();
            }
            if (this.currentTokenType != 93) {
                int offset = this.token.start();
                return this.prepareCommandList(c, p, sql, this.sqlCommand.substring(offset), this.getRemainingTokens(offset));
            }
            return c;
        }
        catch (DbException e) {
            throw e.addSQL(this.sqlCommand);
        }
    }

    /*
     * Unable to fully structure code
     */
    private CommandList prepareCommandList(CommandContainer command, Prepared p, String sql, String remainingSql, ArrayList<Token> remainingTokens) {
        list = Utils.newSmallArrayList();
        while (true) {
            if (p instanceof DefineCommand) {
                return new CommandList(this.session, sql, command, list, this.parameters, remainingSql);
            }
            try {
                p = this.parse(remainingSql, remainingTokens);
            }
            catch (DbException ex) {
                if (ex.getErrorCode() == 90123) {
                    throw ex;
                }
                return new CommandList(this.session, sql, command, list, this.parameters, remainingSql);
            }
            list.add(p);
            if (this.currentTokenType == 115 || this.currentTokenType == 93) ** GOTO lbl18
            this.addExpected(115);
            throw this.getSyntaxError();
lbl-1000:
            // 1 sources

            {
                this.read();
lbl18:
                // 2 sources

                ** while (this.currentTokenType == 115)
            }
lbl19:
            // 1 sources

            if (this.currentTokenType == 93) break;
            offset = this.token.start();
            remainingSql = this.sqlCommand.substring(offset);
            remainingTokens = this.getRemainingTokens(offset);
        }
        return new CommandList(this.session, sql, command, list, this.parameters, null);
    }

    Prepared parse(String sql, ArrayList<Token> tokens) {
        Prepared p;
        this.initialize(sql, tokens, false);
        try {
            p = this.parse(false);
        }
        catch (DbException e) {
            if (e.getErrorCode() == 42000) {
                this.resetTokenIndex();
                p = this.parse(true);
            }
            throw e.addSQL(sql);
        }
        return p;
    }

    private Prepared parse(boolean withExpectedList) {
        this.expectedList = withExpectedList ? new ArrayList() : null;
        this.currentSelect = null;
        this.currentPrepared = null;
        this.createView = null;
        this.recompileAlways = false;
        this.usedParameters.clear();
        this.read();
        Prepared p = this.parsePrepared();
        p.setPrepareAlways(this.recompileAlways);
        p.setParameterList(this.parameters);
        return p;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Prepared parsePrepared() {
        int start = this.tokenIndex;
        Prepared c = null;
        switch (this.currentTokenType) {
            case 93: 
            case 115: {
                c = new NoOperation(this.session);
                this.setSQL(c, start);
                return c;
            }
            case 92: {
                this.readParameter().setValue(ValueNull.INSTANCE);
                this.read(95);
                start = this.tokenIndex;
                this.read("CALL");
                c = this.parseCall();
                break;
            }
            case 69: 
            case 75: 
            case 85: 
            case 89: 
            case 105: {
                c = this.parseQuery();
                break;
            }
            case 71: {
                this.read();
                c = this.parseSet();
                break;
            }
            case 2: {
                if (this.token.isQuoted()) break;
                switch (this.currentToken.charAt(0) & 0xFFDF) {
                    case 65: {
                        if (this.readIf("ALTER")) {
                            c = this.parseAlter();
                            break;
                        }
                        if (!this.readIf("ANALYZE")) break;
                        c = this.parseAnalyze();
                        break;
                    }
                    case 66: {
                        if (this.readIf("BACKUP")) {
                            c = this.parseBackup();
                            break;
                        }
                        if (!this.readIf("BEGIN")) break;
                        c = this.parseBegin();
                        break;
                    }
                    case 67: {
                        if (this.readIf("COMMIT")) {
                            c = this.parseCommit();
                            break;
                        }
                        if (this.readIf("CREATE")) {
                            c = this.parseCreate();
                            break;
                        }
                        if (this.readIf("CALL")) {
                            c = this.parseCall();
                            break;
                        }
                        if (this.readIf("CHECKPOINT")) {
                            c = this.parseCheckpoint();
                            break;
                        }
                        if (!this.readIf("COMMENT")) break;
                        c = this.parseComment();
                        break;
                    }
                    case 68: {
                        if (this.readIf("DELETE")) {
                            c = this.parseDelete(start);
                            break;
                        }
                        if (this.readIf("DROP")) {
                            c = this.parseDrop();
                            break;
                        }
                        if (this.readIfCompat("DECLARE")) {
                            c = this.parseCreate();
                            break;
                        }
                        if (this.database.getMode().getEnum() == Mode.ModeEnum.MSSQLServer || !this.readIfCompat("DEALLOCATE")) break;
                        c = this.parseDeallocate();
                        break;
                    }
                    case 69: {
                        if (this.readIf("EXPLAIN")) {
                            c = this.parseExplain();
                            break;
                        }
                        if (this.readIf("EXECUTE")) {
                            if (this.readIf("IMMEDIATE")) {
                                c = new ExecuteImmediate(this.session, this.readExpression());
                                break;
                            }
                            if (this.database.getMode().getEnum() == Mode.ModeEnum.MSSQLServer) {
                                c = this.parseExecuteSQLServer();
                                break;
                            }
                            c = this.parseExecutePostgre();
                            break;
                        }
                        if (this.database.getMode().getEnum() != Mode.ModeEnum.MSSQLServer || !this.readIfCompat("EXEC")) break;
                        c = this.parseExecuteSQLServer();
                        break;
                    }
                    case 71: {
                        if (!this.readIf("GRANT")) break;
                        c = this.parseGrantRevoke(49);
                        break;
                    }
                    case 72: {
                        if (!this.readIf("HELP")) break;
                        c = this.parseHelp();
                        break;
                    }
                    case 73: {
                        if (!this.readIf("INSERT")) break;
                        c = this.parseInsert(start);
                        break;
                    }
                    case 77: {
                        if (!this.readIf("MERGE")) break;
                        c = this.parseMerge(start);
                        break;
                    }
                    case 80: {
                        if (!this.readIf("PREPARE")) break;
                        c = this.parsePrepare();
                        break;
                    }
                    case 82: {
                        if (this.readIf("ROLLBACK")) {
                            c = this.parseRollback();
                            break;
                        }
                        if (this.readIf("REVOKE")) {
                            c = this.parseGrantRevoke(50);
                            break;
                        }
                        if (this.readIf("RUNSCRIPT")) {
                            c = this.parseRunScript();
                            break;
                        }
                        if (this.readIf("RELEASE")) {
                            c = this.parseReleaseSavepoint();
                            break;
                        }
                        if (this.database.getMode().replaceInto && this.readIfCompat("REPLACE")) {
                            c = this.parseReplace(start);
                            break;
                        }
                        if (!this.readIf("REFRESH")) break;
                        c = this.parseRefresh(start);
                        break;
                    }
                    case 83: {
                        if (this.readIf("SAVEPOINT")) {
                            c = this.parseSavepoint();
                            break;
                        }
                        if (this.readIf("SCRIPT")) {
                            c = this.parseScript();
                            break;
                        }
                        if (this.readIf("SHUTDOWN")) {
                            c = this.parseShutdown();
                            break;
                        }
                        if (!this.readIfCompat("SHOW")) break;
                        c = this.parseShow();
                        break;
                    }
                    case 84: {
                        if (!this.readIf("TRUNCATE")) break;
                        c = this.parseTruncate();
                        break;
                    }
                    case 85: {
                        if (this.readIf("UPDATE")) {
                            c = this.parseUpdate(start);
                            break;
                        }
                        if (!this.readIfCompat("USE")) break;
                        c = this.parseUse();
                    }
                }
                break;
            }
        }
        if (c == null) {
            throw this.getSyntaxError();
        }
        boolean withParamValues = this.readIf(111);
        if (withParamValues) {
            do {
                int index;
                if ((index = (int)this.readLong() - 1) < 0 || index >= this.parameters.size()) {
                    throw this.getSyntaxError();
                }
                Parameter p = (Parameter)this.parameters.get(index);
                if (p == null) {
                    throw this.getSyntaxError();
                }
                this.read(116);
                Expression expr = this.readExpression();
                expr = expr.optimize(this.session);
                p.setValue(expr.getValue(this.session));
            } while (this.readIf(109));
            this.read(112);
            for (Parameter p : this.parameters) {
                p.checkSet();
            }
            c.setWithParamValues(true);
        }
        if (withParamValues || c.getSQL() == null) {
            this.setSQL(c, start);
        }
        return c;
    }

    private Prepared parseBackup() {
        BackupCommand command = new BackupCommand(this.session);
        this.read(76);
        command.setFileName(this.readExpression());
        return command;
    }

    private Prepared parseAnalyze() {
        Analyze command = new Analyze(this.session);
        if (this.readIf(75)) {
            Table table = this.readTableOrView();
            command.setTable(table);
        }
        if (this.readIf("SAMPLE_SIZE")) {
            command.setTop(this.readNonNegativeInt());
        }
        return command;
    }

    private TransactionCommand parseBegin() {
        if (!this.readIf("WORK")) {
            this.readIf("TRANSACTION");
        }
        TransactionCommand command = new TransactionCommand(this.session, 83);
        return command;
    }

    private TransactionCommand parseCommit() {
        if (this.readIf("TRANSACTION")) {
            TransactionCommand command = new TransactionCommand(this.session, 78);
            command.setTransactionName(this.readIdentifier());
            return command;
        }
        TransactionCommand command = new TransactionCommand(this.session, 71);
        this.readIf("WORK");
        return command;
    }

    private TransactionCommand parseShutdown() {
        int type = 80;
        if (this.readIf("IMMEDIATELY")) {
            type = 81;
        } else if (this.readIf("COMPACT")) {
            type = 82;
        } else if (this.readIf("DEFRAG")) {
            type = 84;
        } else {
            this.readIf("SCRIPT");
        }
        return new TransactionCommand(this.session, type);
    }

    private TransactionCommand parseRollback() {
        TransactionCommand command;
        if (this.readIf("TRANSACTION")) {
            TransactionCommand command2 = new TransactionCommand(this.session, 79);
            command2.setTransactionName(this.readIdentifier());
            return command2;
        }
        this.readIf("WORK");
        if (this.readIf(76, "SAVEPOINT")) {
            command = new TransactionCommand(this.session, 75);
            command.setSavepointName(this.readIdentifier());
        } else {
            command = new TransactionCommand(this.session, 72);
        }
        return command;
    }

    private Prepared parsePrepare() {
        if (this.readIf("COMMIT")) {
            TransactionCommand command = new TransactionCommand(this.session, 77);
            command.setTransactionName(this.readIdentifier());
            return command;
        }
        return this.parsePrepareProcedure();
    }

    private Prepared parsePrepareProcedure() {
        if (this.database.getMode().getEnum() == Mode.ModeEnum.MSSQLServer) {
            throw this.getSyntaxError();
        }
        String procedureName = this.readIdentifier();
        if (this.readIf(105)) {
            ArrayList list = Utils.newSmallArrayList();
            int i = 0;
            while (true) {
                Column column = this.parseColumnForTable("C" + i, true);
                list.add(column);
                if (!this.readIfMore()) break;
                ++i;
            }
        }
        this.read(7);
        Prepared prep = this.parsePrepared();
        PrepareProcedure command = new PrepareProcedure(this.session);
        command.setProcedureName(procedureName);
        command.setPrepared(prep);
        return command;
    }

    private TransactionCommand parseSavepoint() {
        TransactionCommand command = new TransactionCommand(this.session, 74);
        command.setSavepointName(this.readIdentifier());
        return command;
    }

    private Prepared parseReleaseSavepoint() {
        NoOperation command = new NoOperation(this.session);
        this.readIf("SAVEPOINT");
        this.readIdentifier();
        return command;
    }

    private Schema findSchema(String schemaName) {
        if (schemaName == null) {
            return null;
        }
        Schema schema = this.database.findSchema(schemaName);
        if (schema == null && this.equalsToken("SESSION", schemaName)) {
            schema = this.database.getSchema(this.session.getCurrentSchemaName());
        }
        return schema;
    }

    private Schema getSchema(String schemaName) {
        if (schemaName == null) {
            return null;
        }
        Schema schema = this.findSchema(schemaName);
        if (schema == null) {
            throw DbException.get(90079, schemaName);
        }
        return schema;
    }

    private Schema getSchema() {
        return this.getSchema(this.schemaName);
    }

    private Schema getSchemaWithDefault() {
        if (this.schemaName == null) {
            this.schemaName = this.session.getCurrentSchemaName();
        }
        return this.getSchema(this.schemaName);
    }

    private Column readTableColumn(TableFilter filter) {
        String columnName = this.readIdentifier();
        if (this.readIf(110)) {
            columnName = this.readTableColumn(filter, columnName);
        }
        return filter.getTable().getColumn(columnName);
    }

    private String readTableColumn(TableFilter filter, String tableAlias) {
        String columnName = this.readIdentifier();
        if (this.readIf(110)) {
            String schema = tableAlias;
            tableAlias = columnName;
            columnName = this.readIdentifier();
            if (this.readIf(110)) {
                this.checkDatabaseName(schema);
                schema = tableAlias;
                tableAlias = columnName;
                columnName = this.readIdentifier();
            }
            if (!this.equalsToken(schema, filter.getTable().getSchema().getName())) {
                throw DbException.get(90079, schema);
            }
        }
        if (!this.equalsToken(tableAlias, filter.getTableAlias())) {
            throw DbException.get(42102, tableAlias);
        }
        return columnName;
    }

    private DataChangeStatement parseUpdate(int start) {
        Update command = new Update(this.session);
        this.currentPrepared = command;
        Expression fetch = null;
        if (this.database.getMode().topInDML && this.readIfCompat("TOP")) {
            this.read(105);
            fetch = this.readTerm().optimize(this.session);
            this.read(106);
        }
        TableFilter targetTableFilter = this.readSimpleTableFilter();
        command.setTableFilter(targetTableFilter);
        int backupIndex = this.tokenIndex;
        if (this.database.getMode().discardWithTableHints) {
            this.discardWithTableHints();
        }
        command.setSetClauseList(this.readUpdateSetClause(targetTableFilter));
        if (this.database.getMode().allowUsingFromClauseInUpdateStatement && this.readIfCompat(35)) {
            this.setTokenIndex(backupIndex);
            return this.parseUpdateFrom(targetTableFilter, start);
        }
        if (this.readIf(87)) {
            command.setCondition(this.readExpression());
        }
        if (fetch == null) {
            this.readIfOrderBy();
            fetch = this.readFetchOrLimit();
        }
        command.setFetch(fetch);
        this.setSQL(command, start);
        return command;
    }

    private MergeUsing parseUpdateFrom(TableFilter targetTableFilter, int start) {
        MergeUsing command = new MergeUsing(this.session, targetTableFilter);
        this.currentPrepared = command;
        SetClauseList updateSetClause = this.readUpdateSetClause(targetTableFilter);
        this.read(35);
        command.setSourceTableFilter(this.readTableReference());
        command.setOnCondition(this.readIf(87) ? this.readExpression() : ValueExpression.TRUE);
        MergeUsing.WhenMatchedThenUpdate update = new MergeUsing.WhenMatchedThenUpdate(command);
        update.setSetClauseList(updateSetClause);
        command.addWhen(update);
        this.setSQL(command, start);
        return command;
    }

    private SetClauseList readUpdateSetClause(TableFilter filter) {
        this.read(71);
        SetClauseList list = new SetClauseList(filter.getTable());
        do {
            if (this.readIf(105)) {
                ArrayList<Column> columns = Utils.newSmallArrayList();
                ArrayList<Expression[]> allIndexes = Utils.newSmallArrayList();
                do {
                    columns.add(this.readTableColumn(filter));
                    allIndexes.add(this.readUpdateSetClauseArrayIndexes());
                } while (this.readIfMore());
                this.read(95);
                list.addMultiple(columns, allIndexes, this.readExpression());
                continue;
            }
            Column column = this.readTableColumn(filter);
            Expression[] arrayIndexes = this.readUpdateSetClauseArrayIndexes();
            this.read(95);
            list.addSingle(column, arrayIndexes, arrayIndexes == null ? this.readExpressionOrDefault() : this.readExpression());
        } while (this.readIf(109));
        return list;
    }

    private Expression[] readUpdateSetClauseArrayIndexes() {
        if (this.readIf(117)) {
            ArrayList<Expression> list = Utils.newSmallArrayList();
            do {
                list.add(this.readExpression());
                this.read(118);
            } while (this.readIf(117));
            return list.toArray(new Expression[0]);
        }
        return null;
    }

    private TableFilter readSimpleTableFilter() {
        return new TableFilter(this.session, this.readTableOrView(), this.readFromAlias(null), this.rightsChecked, this.currentSelect, 0, null);
    }

    private Delete parseDelete(int start) {
        Delete command = new Delete(this.session);
        Expression fetch = null;
        if (this.database.getMode().topInDML && this.readIfCompat("TOP")) {
            fetch = this.readTerm().optimize(this.session);
        }
        this.currentPrepared = command;
        if (!this.readIf(35) && this.database.getMode().deleteIdentifierFrom) {
            this.readIdentifierWithSchema();
            this.read(35);
        }
        command.setTableFilter(this.readSimpleTableFilter());
        if (this.readIf(87)) {
            command.setCondition(this.readExpression());
        }
        if (fetch == null) {
            fetch = this.readFetchOrLimit();
        }
        command.setFetch(fetch);
        this.setSQL(command, start);
        return command;
    }

    private Expression readFetchOrLimit() {
        Expression fetch = null;
        if (this.readIf(32)) {
            if (!this.readIf("FIRST")) {
                this.read("NEXT");
            }
            if (this.readIf(66) || this.readIf("ROWS")) {
                fetch = ValueExpression.get(ValueInteger.get(1));
            } else {
                fetch = this.readExpression().optimize(this.session);
                if (!this.readIf(66)) {
                    this.read("ROWS");
                }
            }
            this.read("ONLY");
        } else if (this.database.getMode().limit && this.readIfCompat(50)) {
            fetch = this.readTerm().optimize(this.session);
        }
        return fetch;
    }

    private IndexColumn[] parseIndexColumnList() {
        ArrayList<IndexColumn> columns = Utils.newSmallArrayList();
        do {
            columns.add(new IndexColumn(this.readIdentifier(), this.parseSortType()));
        } while (this.readIfMore());
        return columns.toArray(new IndexColumn[0]);
    }

    private int parseSortType() {
        int sortType;
        int n = sortType = !this.readIf("ASC") && this.readIf("DESC") ? 1 : 0;
        if (this.readIf("NULLS")) {
            if (this.readIf("FIRST")) {
                sortType |= 2;
            } else {
                this.read("LAST");
                sortType |= 4;
            }
        }
        return sortType;
    }

    private String[] parseColumnList() {
        ArrayList<String> columns = Utils.newSmallArrayList();
        if (!this.readIf(106)) {
            do {
                columns.add(this.readIdentifier());
            } while (this.readIfMore());
        }
        return columns.toArray(new String[0]);
    }

    private Column[] parseColumnList(Table table) {
        ArrayList<Column> columns = Utils.newSmallArrayList();
        HashSet<Column> set = new HashSet<Column>();
        if (!this.readIf(106)) {
            do {
                Column column;
                if (!set.add(column = this.parseColumn(table))) {
                    throw DbException.get(42121, column.getTraceSQL());
                }
                columns.add(column);
            } while (this.readIfMore());
        }
        return columns.toArray(new Column[0]);
    }

    private Column parseColumn(Table table) {
        if (this.currentTokenType == 91) {
            this.read();
            return table.getRowIdColumn();
        }
        return table.getColumn(this.readIdentifier());
    }

    private Prepared parseHelp() {
        HashSet<String> conditions = new HashSet<String>();
        while (this.currentTokenType != 93) {
            conditions.add(StringUtils.toUpperEnglish(this.readIdentifierOrKeyword()));
        }
        return new Help(this.session, conditions.toArray(new String[0]));
    }

    private Prepared parseShow() {
        StringBuilder buff = new StringBuilder("SELECT ");
        if (this.readIf("CLIENT_ENCODING")) {
            buff.append("'UNICODE' CLIENT_ENCODING");
        } else if (this.readIf("DEFAULT_TRANSACTION_ISOLATION")) {
            buff.append("'read committed' DEFAULT_TRANSACTION_ISOLATION");
        } else if (this.readIf("TRANSACTION")) {
            this.read("ISOLATION");
            this.read("LEVEL");
            buff.append("LOWER(ISOLATION_LEVEL) TRANSACTION_ISOLATION FROM INFORMATION_SCHEMA.SESSIONS WHERE SESSION_ID = SESSION_ID()");
        } else if (this.readIf("DATESTYLE")) {
            buff.append("'ISO' DATESTYLE");
        } else if (this.readIf("SEARCH_PATH")) {
            String[] searchPath = this.session.getSchemaSearchPath();
            StringBuilder searchPathBuff = new StringBuilder();
            if (searchPath != null) {
                int i = 0;
                while (i < searchPath.length) {
                    if (i > 0) {
                        searchPathBuff.append(", ");
                    }
                    ParserUtil.quoteIdentifier(searchPathBuff, searchPath[i], 1);
                    ++i;
                }
            }
            StringUtils.quoteStringSQL(buff, searchPathBuff.toString());
            buff.append(" SEARCH_PATH");
        } else if (this.readIf("SERVER_VERSION")) {
            buff.append("'8.2.23' SERVER_VERSION");
        } else if (this.readIf("SERVER_ENCODING")) {
            buff.append("'UTF8' SERVER_ENCODING");
        } else if (this.readIf("SSL")) {
            buff.append("'off' SSL");
        } else if (this.readIf("TABLES")) {
            String schema = this.database.getMainSchema().getName();
            if (this.readIf(35)) {
                schema = this.readIdentifier();
            }
            buff.append("TABLE_NAME, TABLE_SCHEMA FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA=");
            StringUtils.quoteStringSQL(buff, schema).append(" ORDER BY TABLE_NAME");
        } else if (this.readIf("COLUMNS")) {
            this.read(35);
            String tableName = this.readIdentifierWithSchema();
            String schemaName = this.getSchema().getName();
            if (this.readIf(35)) {
                schemaName = this.readIdentifier();
            }
            buff.append("C.COLUMN_NAME FIELD, ");
            boolean oldInformationSchema = this.session.isOldInformationSchema();
            if (oldInformationSchema) {
                buff.append("C.COLUMN_TYPE");
            } else {
                buff.append("DATA_TYPE_SQL(");
                StringUtils.quoteStringSQL(buff, schemaName).append(", ");
                StringUtils.quoteStringSQL(buff, tableName).append(", 'TABLE', C.DTD_IDENTIFIER)");
            }
            buff.append(" TYPE, C.IS_NULLABLE \"NULL\", CASE (SELECT MAX(I.INDEX_TYPE_NAME) FROM INFORMATION_SCHEMA.INDEXES I ");
            if (!oldInformationSchema) {
                buff.append("JOIN INFORMATION_SCHEMA.INDEX_COLUMNS IC ");
            }
            buff.append("WHERE I.TABLE_SCHEMA=C.TABLE_SCHEMA AND I.TABLE_NAME=C.TABLE_NAME ");
            if (oldInformationSchema) {
                buff.append("AND I.COLUMN_NAME=C.COLUMN_NAME");
            } else {
                buff.append("AND IC.TABLE_SCHEMA=C.TABLE_SCHEMA AND IC.TABLE_NAME=C.TABLE_NAME AND IC.INDEX_SCHEMA=I.INDEX_SCHEMA AND IC.INDEX_NAME=I.INDEX_NAME AND IC.COLUMN_NAME=C.COLUMN_NAME");
            }
            buff.append(")WHEN 'PRIMARY KEY' THEN 'PRI' WHEN 'UNIQUE INDEX' THEN 'UNI' ELSE '' END `KEY`, COALESCE(COLUMN_DEFAULT, 'NULL') `DEFAULT` FROM INFORMATION_SCHEMA.COLUMNS C WHERE C.TABLE_SCHEMA=");
            StringUtils.quoteStringSQL(buff, schemaName).append(" AND C.TABLE_NAME=");
            StringUtils.quoteStringSQL(buff, tableName).append(" ORDER BY C.ORDINAL_POSITION");
        } else if (this.readIf("DATABASES") || this.readIf("SCHEMAS")) {
            buff.append("SCHEMA_NAME FROM INFORMATION_SCHEMA.SCHEMATA");
        } else if (this.database.getMode().getEnum() == Mode.ModeEnum.PostgreSQL && this.readIf(3)) {
            buff.append("NAME, SETTING FROM PG_CATALOG.PG_SETTINGS");
        }
        boolean b = this.session.getAllowLiterals();
        try {
            this.session.setAllowLiterals(true);
            Prepared prepared = this.session.prepare(buff.toString());
            return prepared;
        }
        finally {
            this.session.setAllowLiterals(b);
        }
    }

    private boolean isDerivedTable() {
        int offset = this.tokenIndex;
        int level = 0;
        while (((Token)this.tokens.get(offset)).tokenType() == 105) {
            ++level;
            ++offset;
        }
        boolean query = this.isDirectQuery(offset);
        if (query && level > 0) {
            if ((offset = this.scanToCloseParen(offset + 1)) < 0) {
                query = false;
            } else {
                block7: while (true) {
                    switch (((Token)this.tokens.get(offset)).tokenType()) {
                        case 93: 
                        case 115: {
                            query = false;
                            break block7;
                        }
                        case 105: {
                            if ((offset = this.scanToCloseParen(offset + 1)) >= 0) continue block7;
                            query = false;
                            break block7;
                        }
                        case 106: {
                            if (--level == 0) break block7;
                            ++offset;
                            continue block7;
                        }
                        case 46: {
                            query = false;
                            break block7;
                        }
                        default: {
                            ++offset;
                            continue block7;
                        }
                    }
                    break;
                }
            }
        }
        return query;
    }

    private boolean isQuery() {
        int offset = this.tokenIndex;
        int level = 0;
        while (((Token)this.tokens.get(offset)).tokenType() == 105) {
            ++level;
            ++offset;
        }
        boolean query = this.isDirectQuery(offset);
        if (query && level > 0) {
            ++offset;
            block4: while (true) {
                if ((offset = this.scanToCloseParen(offset)) < 0) {
                    query = false;
                    break;
                }
                switch (((Token)this.tokens.get(offset)).tokenType()) {
                    default: {
                        query = false;
                        break block4;
                    }
                    case 29: 
                    case 32: 
                    case 43: 
                    case 50: 
                    case 53: 
                    case 59: 
                    case 62: 
                    case 79: 
                    case 93: 
                    case 106: 
                    case 115: {
                        if (--level > 0) continue block4;
                    }
                }
                break;
            }
        }
        return query;
    }

    private int scanToCloseParen(int offset) {
        int level = 0;
        while (true) {
            switch (((Token)this.tokens.get(offset)).tokenType()) {
                case 93: 
                case 115: {
                    return -1;
                }
                case 105: {
                    ++level;
                    break;
                }
                case 106: {
                    if (--level >= 0) break;
                    return offset + 1;
                }
            }
            ++offset;
        }
    }

    private boolean isQueryQuick() {
        int offset = this.tokenIndex;
        while (((Token)this.tokens.get(offset)).tokenType() == 105) {
            ++offset;
        }
        return this.isDirectQuery(offset);
    }

    private boolean isDirectQuery(int offset) {
        boolean query;
        switch (((Token)this.tokens.get(offset)).tokenType()) {
            case 69: 
            case 85: 
            case 89: {
                query = true;
                break;
            }
            case 75: {
                query = ((Token)this.tokens.get(offset + 1)).tokenType() != 105;
                break;
            }
            default: {
                query = false;
            }
        }
        return query;
    }

    private Prepared parseMerge(int start) {
        this.read("INTO");
        TableFilter targetTableFilter = this.readSimpleTableFilter();
        if (this.readIf(83)) {
            return this.parseMergeUsing(targetTableFilter, start);
        }
        return this.parseMergeInto(targetTableFilter, start);
    }

    private Prepared parseMergeInto(TableFilter targetTableFilter, int start) {
        Merge command = new Merge(this.session, false);
        this.currentPrepared = command;
        command.setTable(targetTableFilter.getTable());
        Table table = command.getTable();
        if (this.readIf(105)) {
            if (this.isQueryQuick()) {
                command.setQuery(this.parseQuery());
                this.read(106);
                return command;
            }
            command.setColumns(this.parseColumnList(table));
        }
        if (this.readIf(47, 105)) {
            command.setKeys(this.parseColumnList(table));
        }
        if (this.readIf(85)) {
            this.parseValuesForCommand(command);
        } else {
            command.setQuery(this.parseQuery());
        }
        this.setSQL(command, start);
        return command;
    }

    private MergeUsing parseMergeUsing(TableFilter targetTableFilter, int start) {
        MergeUsing command = new MergeUsing(this.session, targetTableFilter);
        this.currentPrepared = command;
        command.setSourceTableFilter(this.readTableReference());
        this.read(60);
        Expression condition = this.readExpression();
        command.setOnCondition(condition);
        this.read(86);
        do {
            boolean matched;
            if (matched = this.readIf("MATCHED")) {
                this.parseWhenMatched(command);
                continue;
            }
            this.parseWhenNotMatched(command);
        } while (this.readIf(86));
        this.setSQL(command, start);
        return command;
    }

    private void parseWhenMatched(MergeUsing command) {
        MergeUsing.When when;
        Expression and = this.readIf(4) ? this.readExpression() : null;
        this.read("THEN");
        if (this.readIf("UPDATE")) {
            MergeUsing.WhenMatchedThenUpdate update = new MergeUsing.WhenMatchedThenUpdate(command);
            update.setSetClauseList(this.readUpdateSetClause(command.getTargetTableFilter()));
            when = update;
        } else {
            this.read("DELETE");
            when = new MergeUsing.WhenMatchedThenDelete(command);
        }
        if (and == null && this.database.getMode().mergeWhere && this.readIf(87)) {
            and = this.readExpression();
        }
        when.setAndCondition(and);
        command.addWhen(when);
    }

    private void parseWhenNotMatched(MergeUsing command) {
        this.read(57);
        this.read("MATCHED");
        Expression and = this.readIf(4) ? this.readExpression() : null;
        this.read("THEN");
        this.read("INSERT");
        Column[] columns = this.readIf(105) ? this.parseColumnList(command.getTargetTableFilter().getTable()) : null;
        Boolean overridingSystem = this.readIfOverriding();
        this.read(85);
        this.read(105);
        ArrayList<Expression> values = Utils.newSmallArrayList();
        if (!this.readIf(106)) {
            do {
                values.add(this.readExpressionOrDefault());
            } while (this.readIfMore());
        }
        MergeUsing mergeUsing = command;
        mergeUsing.getClass();
        MergeUsing.WhenNotMatched when = new MergeUsing.WhenNotMatched(mergeUsing, columns, overridingSystem, values.toArray(new Expression[0]));
        when.setAndCondition(and);
        command.addWhen(when);
    }

    /*
     * Unable to fully structure code
     */
    private Insert parseInsert(int start) {
        command = new Insert(this.session);
        this.currentPrepared = command;
        mode = this.database.getMode();
        if (mode.onDuplicateKeyUpdate && this.readIfCompat("IGNORE")) {
            command.setIgnore(true);
        }
        this.read("INTO");
        table = this.readTableOrView();
        command.setTable(table);
        columns = null;
        if (this.readIf(105)) {
            if (this.isQueryQuick()) {
                command.setQuery(this.parseQuery());
                this.read(106);
                return command;
            }
            columns = this.parseColumnList(table);
            command.setColumns(columns);
        }
        overridingSystem = this.readIfOverriding();
        command.setOverridingSystem(overridingSystem);
        requireQuery = false;
        if (this.readIf("DIRECT")) {
            requireQuery = true;
            command.setInsertFromSelect(true);
        }
        if (this.readIfCompat("SORTED")) {
            requireQuery = true;
        }
        if (requireQuery) ** GOTO lbl-1000
        if (overridingSystem == null && this.readIf(25, 85)) {
            command.addRow(new Expression[0]);
        } else if (this.readIf(85)) {
            this.parseValuesForCommand(command);
        } else if (this.readIf(71)) {
            this.parseInsertSet(command, table, columns);
        } else lbl-1000:
        // 2 sources

        {
            command.setQuery(this.parseQuery());
        }
        if (mode.onDuplicateKeyUpdate || mode.insertOnConflict || mode.isolationLevelInSelectOrInsertStatement) {
            this.parseInsertCompatibility(command, table, mode);
        }
        this.setSQL(command, start);
        return command;
    }

    private Boolean readIfOverriding() {
        Boolean overridingSystem = null;
        if (this.readIf("OVERRIDING", 82, 84)) {
            overridingSystem = Boolean.FALSE;
        } else if (this.readIf("OVERRIDING", "SYSTEM", 84)) {
            overridingSystem = Boolean.TRUE;
        }
        return overridingSystem;
    }

    private void parseInsertSet(Insert command, Table table, Column[] columns) {
        if (columns != null) {
            throw this.getSyntaxError();
        }
        ArrayList<Column> columnList = Utils.newSmallArrayList();
        ArrayList<Expression> values = Utils.newSmallArrayList();
        do {
            columnList.add(this.parseColumn(table));
            this.read(95);
            values.add(this.readExpressionOrDefault());
        } while (this.readIf(109));
        command.setColumns(columnList.toArray(new Column[0]));
        command.addRow(values.toArray(new Expression[0]));
    }

    private void parseInsertCompatibility(Insert command, Table table, Mode mode) {
        if (mode.onDuplicateKeyUpdate && this.readIfCompat(60, "DUPLICATE", 47, "UPDATE")) {
            do {
                String columnName = this.readIdentifier();
                if (this.readIf(110)) {
                    String schemaOrTableName = columnName;
                    String tableOrColumnName = this.readIdentifier();
                    if (this.readIf(110)) {
                        if (!table.getSchema().getName().equals(schemaOrTableName)) {
                            throw DbException.get(90080);
                        }
                        columnName = this.readIdentifier();
                    } else {
                        columnName = tableOrColumnName;
                        tableOrColumnName = schemaOrTableName;
                    }
                    if (!table.getName().equals(tableOrColumnName)) {
                        throw DbException.get(42102, tableOrColumnName);
                    }
                }
                Column column = table.getColumn(columnName);
                this.read(95);
                command.addAssignmentForDuplicate(column, this.readExpressionOrDefault());
            } while (this.readIf(109));
        }
        if (mode.insertOnConflict && this.readIfCompat(60, "CONFLICT", "DO", "NOTHING")) {
            command.setIgnore(true);
        }
        if (mode.isolationLevelInSelectOrInsertStatement) {
            this.parseIsolationClause();
        }
    }

    private Merge parseReplace(int start) {
        Merge command = new Merge(this.session, true);
        this.currentPrepared = command;
        this.read("INTO");
        Table table = this.readTableOrView();
        command.setTable(table);
        if (this.readIf(105)) {
            if (this.isQueryQuick()) {
                command.setQuery(this.parseQuery());
                this.read(106);
                return command;
            }
            command.setColumns(this.parseColumnList(table));
        }
        if (this.readIf(85)) {
            this.parseValuesForCommand(command);
        } else {
            command.setQuery(this.parseQuery());
        }
        this.setSQL(command, start);
        return command;
    }

    private RefreshMaterializedView parseRefresh(int start) {
        this.read("MATERIALIZED");
        this.read("VIEW");
        Table table = this.readTableOrView(false);
        if (!(table instanceof MaterializedView)) {
            throw DbException.get(90037, table.getName());
        }
        RefreshMaterializedView command = new RefreshMaterializedView(this.session, this.getSchema());
        this.currentPrepared = command;
        command.setView((MaterializedView)table);
        this.setSQL(command, start);
        return command;
    }

    private void parseValuesForCommand(CommandWithValues command) {
        ArrayList<Expression> values = Utils.newSmallArrayList();
        do {
            values.clear();
            boolean multiColumn = this.readIf(66, 105) ? true : this.readIf(105);
            if (multiColumn) {
                if (!this.readIf(106)) {
                    do {
                        values.add(this.readExpressionOrDefault());
                    } while (this.readIfMore());
                }
            } else {
                values.add(this.readExpressionOrDefault());
            }
            command.addRow(values.toArray(new Expression[0]));
        } while (this.readIf(109));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private TableFilter readTablePrimary() {
        void var1_16;
        String alias;
        block8: {
            String tableName;
            block15: {
                Schema schema;
                block14: {
                    block13: {
                        block12: {
                            int backupIndex;
                            boolean quoted;
                            block11: {
                                block10: {
                                    block9: {
                                        alias = null;
                                        if (this.readIf(105)) {
                                            if (this.isDerivedTable()) {
                                                return this.readDerivedTableWithCorrelation();
                                            }
                                            TableFilter tableFilter = this.readTableReference();
                                            this.read(106);
                                            return this.readCorrelation(tableFilter);
                                        }
                                        if (!this.readIf(85)) break block9;
                                        BitSet outerUsedParameters = this.openParametersScope();
                                        TableValueConstructor query = this.parseValues();
                                        alias = this.session.getNextSystemIdentifier(this.sqlCommand);
                                        Table table = query.toTable(alias, null, this.closeParametersScope(outerUsedParameters), this.createView != null, this.currentSelect);
                                        break block8;
                                    }
                                    if (!this.readIf(75, 105)) break block10;
                                    ArrayTableFunction function = this.readTableFunction(1);
                                    FunctionTable functionTable = new FunctionTable(this.database.getMainSchema(), this.session, function);
                                    break block8;
                                }
                                quoted = this.token.isQuoted();
                                tableName = this.readIdentifier();
                                backupIndex = this.tokenIndex;
                                this.schemaName = null;
                                if (!this.readIf(110)) break block11;
                                tableName = this.readIdentifierWithSchema2(tableName);
                                break block12;
                            }
                            if (quoted || !this.readIf(75, 105)) break block12;
                            Table table = this.readDataChangeDeltaTable(this.upperName(tableName), backupIndex);
                            break block8;
                        }
                        if (this.schemaName != null) break block13;
                        schema = null;
                        break block14;
                    }
                    schema = this.findSchema(this.schemaName);
                    if (schema != null) break block14;
                    if (!this.isDualTable(tableName)) throw DbException.get(90079, this.schemaName);
                    DualTable dualTable = new DualTable(this.database);
                    break block8;
                }
                boolean foundLeftParen = this.readIf(105);
                if (foundLeftParen && this.readIfCompat("INDEX")) {
                    this.readIdentifierWithSchema(null);
                    this.read(106);
                    foundLeftParen = false;
                }
                if (!foundLeftParen) break block15;
                Schema mainSchema = this.database.getMainSchema();
                if (this.equalsToken(tableName, "SYSTEM_RANGE") || this.equalsToken(tableName, "GENERATE_SERIES")) {
                    Expression min = this.readExpression();
                    this.read(109);
                    Expression max = this.readExpression();
                    if (this.readIf(109)) {
                        Expression step = this.readExpression();
                        this.read(106);
                        RangeTable rangeTable = new RangeTable(mainSchema, min, max, step);
                        break block8;
                    } else {
                        this.read(106);
                        RangeTable rangeTable = new RangeTable(mainSchema, min, max);
                    }
                    break block8;
                } else {
                    FunctionTable functionTable = new FunctionTable(mainSchema, this.session, this.readTableFunction(tableName, schema));
                }
                break block8;
            }
            Table table = this.readTableOrView(tableName, true);
        }
        ArrayList<String> derivedColumnNames = null;
        IndexHints indexHints = null;
        if (this.readIfUseIndex()) {
            indexHints = this.parseIndexHints((Table)var1_16);
            return this.buildTableFilter((Table)var1_16, alias, derivedColumnNames, indexHints);
        }
        if ((alias = this.readFromAlias(alias)) == null) return this.buildTableFilter((Table)var1_16, alias, derivedColumnNames, indexHints);
        derivedColumnNames = this.readDerivedColumnNames();
        if (!this.readIfUseIndex()) return this.buildTableFilter((Table)var1_16, alias, derivedColumnNames, indexHints);
        indexHints = this.parseIndexHints((Table)var1_16);
        return this.buildTableFilter((Table)var1_16, alias, derivedColumnNames, indexHints);
    }

    private TableFilter readCorrelation(TableFilter tableFilter) {
        String alias = this.readFromAlias(null);
        if (alias != null) {
            tableFilter.setAlias(alias);
            ArrayList<String> derivedColumnNames = this.readDerivedColumnNames();
            if (derivedColumnNames != null) {
                tableFilter.setDerivedColumns(derivedColumnNames);
            }
        }
        return tableFilter;
    }

    private TableFilter readDerivedTableWithCorrelation() {
        Table table;
        String alias;
        BitSet outerUsedParameters = this.openParametersScope();
        Query query = this.parseQueryExpression();
        ArrayList<Parameter> queryParameters = this.closeParametersScope(outerUsedParameters);
        this.read(106);
        ArrayList<String> derivedColumnNames = null;
        IndexHints indexHints = null;
        if (this.readIfUseIndex()) {
            alias = this.session.getNextSystemIdentifier(this.sqlCommand);
            table = query.toTable(alias, null, queryParameters, this.createView != null, this.currentSelect);
            indexHints = this.parseIndexHints(table);
        } else {
            alias = this.readFromAlias(null);
            if (alias != null) {
                derivedColumnNames = this.readDerivedColumnNames();
                Column[] columnTemplates = null;
                if (derivedColumnNames != null) {
                    query.init();
                    columnTemplates = QueryExpressionTable.createQueryColumnTemplateList(derivedColumnNames.toArray(new String[0]), query).toArray(new Column[0]);
                }
                table = query.toTable(alias, columnTemplates, queryParameters, this.createView != null, this.currentSelect);
                if (this.readIfUseIndex()) {
                    indexHints = this.parseIndexHints(table);
                }
            } else {
                alias = this.session.getNextSystemIdentifier(this.sqlCommand);
                table = query.toTable(alias, null, queryParameters, this.createView != null, this.currentSelect);
            }
        }
        return this.buildTableFilter(table, alias, derivedColumnNames, indexHints);
    }

    private TableFilter buildTableFilter(Table table, String alias, ArrayList<String> derivedColumnNames, IndexHints indexHints) {
        if (this.database.getMode().discardWithTableHints) {
            this.discardWithTableHints();
        }
        if (alias == null && table instanceof CTE) {
            alias = table.getName();
        }
        TableFilter filter = new TableFilter(this.session, table, alias, this.rightsChecked, this.currentSelect, this.orderInFrom++, indexHints);
        if (derivedColumnNames != null) {
            filter.setDerivedColumns(derivedColumnNames);
        }
        return filter;
    }

    private Table readDataChangeDeltaTable(String resultOptionName, int backupIndex) {
        DataChangeStatement statement;
        int start = this.tokenIndex;
        DataChangeDeltaTable.ResultOption resultOption = DataChangeDeltaTable.ResultOption.FINAL;
        switch (resultOptionName) {
            case "OLD": {
                resultOption = DataChangeDeltaTable.ResultOption.OLD;
                if (this.readIf("UPDATE")) {
                    statement = this.parseUpdate(start);
                    break;
                }
                if (this.readIf("DELETE")) {
                    statement = this.parseDelete(start);
                    break;
                }
                if (this.readIf("MERGE")) {
                    statement = (DataChangeStatement)this.parseMerge(start);
                    break;
                }
                if (this.database.getMode().replaceInto && this.readIfCompat("REPLACE")) {
                    statement = this.parseReplace(start);
                    break;
                }
                throw this.getSyntaxError();
            }
            case "NEW": {
                resultOption = DataChangeDeltaTable.ResultOption.NEW;
            }
            case "FINAL": {
                if (this.readIf("INSERT")) {
                    statement = this.parseInsert(start);
                    break;
                }
                if (this.readIf("UPDATE")) {
                    statement = this.parseUpdate(start);
                    break;
                }
                if (this.readIf("MERGE")) {
                    statement = (DataChangeStatement)this.parseMerge(start);
                    break;
                }
                if (this.database.getMode().replaceInto && this.readIfCompat("REPLACE")) {
                    statement = this.parseReplace(start);
                    break;
                }
                throw this.getSyntaxError();
            }
            default: {
                this.setTokenIndex(backupIndex);
                this.addExpected("OLD TABLE");
                this.addExpected("NEW TABLE");
                this.addExpected("FINAL TABLE");
                throw this.getSyntaxError();
            }
        }
        this.read(106);
        if (this.currentSelect != null) {
            this.currentSelect.setNeverLazy(true);
        }
        return new DataChangeDeltaTable(this.getSchemaWithDefault(), this.session, statement, resultOption);
    }

    private TableFunction readTableFunction(String name, Schema schema) {
        FunctionAlias functionAlias;
        block19: {
            if (schema != null) break block19;
            switch (this.upperName(name)) {
                case "UNNEST": {
                    return this.readUnnestFunction();
                }
                case "TABLE_DISTINCT": {
                    return this.readTableFunction(2);
                }
                case "CSVREAD": {
                    this.recompileAlways = true;
                    return this.readParameters(new CSVReadFunction());
                }
                case "LINK_SCHEMA": {
                    this.recompileAlways = true;
                    return this.readParameters(new LinkSchemaFunction());
                }
            }
        }
        if (!(functionAlias = this.getFunctionAliasWithinPath(name, schema)).isDeterministic()) {
            this.recompileAlways = true;
        }
        ArrayList<Expression> argList = Utils.newSmallArrayList();
        if (!this.readIf(106)) {
            do {
                argList.add(this.readExpression());
            } while (this.readIfMore());
        }
        return new JavaTableFunction(functionAlias, argList.toArray(new Expression[0]));
    }

    private boolean readIfUseIndex() {
        int start = this.tokenIndex;
        if (!this.readIf("USE")) {
            return false;
        }
        if (!this.readIf("INDEX")) {
            this.setTokenIndex(start);
            return false;
        }
        return true;
    }

    private IndexHints parseIndexHints(Table table) {
        this.read(105);
        LinkedHashSet<String> indexNames = new LinkedHashSet<String>();
        if (!this.readIf(106)) {
            do {
                String indexName = this.readIdentifierWithSchema();
                Index index = table.getIndex(indexName);
                indexNames.add(index.getName());
            } while (this.readIfMore());
        }
        return IndexHints.createUseIndexHints(indexNames);
    }

    private String readFromAlias(String alias) {
        if (this.readIf(7) || this.isIdentifier()) {
            alias = this.readIdentifier();
        }
        return alias;
    }

    private ArrayList<String> readDerivedColumnNames() {
        if (this.readIf(105)) {
            ArrayList<String> derivedColumnNames = new ArrayList<String>();
            do {
                derivedColumnNames.add(this.readIdentifier());
            } while (this.readIfMore());
            return derivedColumnNames;
        }
        return null;
    }

    private void discardWithTableHints() {
        if (this.readIfCompat(89, 105)) {
            do {
                this.discardTableHint();
            } while (this.readIfMore());
        }
    }

    private void discardTableHint() {
        if (this.readIfCompat("INDEX")) {
            if (this.readIf(105)) {
                do {
                    this.readExpression();
                } while (this.readIfMore());
            } else {
                this.read(95);
                this.readExpression();
            }
        } else {
            this.readExpression();
        }
    }

    private Prepared parseTruncate() {
        this.read(75);
        Table table = this.readTableOrView();
        boolean restart = this.database.getMode().truncateTableRestartIdentity;
        if (this.readIf("CONTINUE", "IDENTITY")) {
            restart = false;
        } else if (this.readIf("RESTART", "IDENTITY")) {
            restart = true;
        }
        TruncateTable command = new TruncateTable(this.session);
        command.setTable(table);
        command.setRestart(restart);
        return command;
    }

    private boolean readIfExists(boolean ifExists) {
        if (this.readIf(40, 30)) {
            ifExists = true;
        }
        return ifExists;
    }

    private Prepared parseComment() {
        String objectName;
        int type = 0;
        this.read(60);
        boolean column = false;
        if (this.readIf(75) || this.readIf("VIEW")) {
            type = 0;
        } else if (this.readIf("COLUMN")) {
            column = true;
            type = 0;
        } else if (this.readIf("CONSTANT")) {
            type = 11;
        } else if (this.readIf(14)) {
            type = 5;
        } else if (this.readIf("ALIAS")) {
            type = 9;
        } else if (this.readIf("INDEX")) {
            type = 1;
        } else if (this.readIf("ROLE")) {
            type = 7;
        } else if (this.readIf("SCHEMA")) {
            type = 10;
        } else if (this.readIf("SEQUENCE")) {
            type = 3;
        } else if (this.readIf("TRIGGER")) {
            type = 4;
        } else if (this.readIf(82)) {
            type = 2;
        } else if (this.readIf("DOMAIN")) {
            type = 12;
        } else {
            throw this.getSyntaxError();
        }
        SetComment command = new SetComment(this.session);
        if (column) {
            String columnName;
            objectName = this.readIdentifier();
            String tmpSchemaName = null;
            this.read(110);
            boolean allowEmpty = this.database.getMode().allowEmptySchemaValuesAsDefaultSchema;
            String string = columnName = allowEmpty && this.currentTokenType == 110 ? null : this.readIdentifier();
            if (this.readIf(110)) {
                tmpSchemaName = objectName;
                objectName = columnName;
                String string2 = columnName = allowEmpty && this.currentTokenType == 110 ? null : this.readIdentifier();
                if (this.readIf(110)) {
                    this.checkDatabaseName(tmpSchemaName);
                    tmpSchemaName = objectName;
                    objectName = columnName;
                    columnName = this.readIdentifier();
                }
            }
            if (columnName == null || objectName == null) {
                throw DbException.getSyntaxError(this.sqlCommand, this.token.start(), "table.column");
            }
            this.schemaName = tmpSchemaName != null ? tmpSchemaName : this.session.getCurrentSchemaName();
            command.setColumn(true);
            command.setColumnName(columnName);
        } else {
            objectName = this.readIdentifierWithSchema();
        }
        command.setSchemaName(this.schemaName);
        command.setObjectName(objectName);
        command.setObjectType(type);
        this.read(45);
        command.setCommentExpression(this.readExpression());
        return command;
    }

    private Prepared parseDrop() {
        if (this.readIf(75)) {
            boolean ifExists = this.readIfExists(false);
            DropTable command = new DropTable(this.session);
            do {
                String tableName = this.readIdentifierWithSchema();
                command.addTable(this.getSchema(), tableName);
            } while (this.readIf(109));
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            if (this.readIf("CASCADE")) {
                command.setDropAction(ConstraintActionType.CASCADE);
                this.readIf("CONSTRAINTS");
            } else if (this.readIf("RESTRICT")) {
                command.setDropAction(ConstraintActionType.RESTRICT);
            } else if (this.readIf("IGNORE")) {
                command.setDropAction(ConstraintActionType.SET_DEFAULT);
            }
            return command;
        }
        if (this.readIf("INDEX")) {
            boolean ifExists = this.readIfExists(false);
            String indexName = this.readIdentifierWithSchema();
            DropIndex command = new DropIndex(this.session, this.getSchema());
            command.setIndexName(indexName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            if (this.readIf(60)) {
                this.readIdentifierWithSchema();
            }
            return command;
        }
        if (this.readIf(82)) {
            boolean ifExists = this.readIfExists(false);
            DropUser command = new DropUser(this.session);
            command.setUserName(this.readIdentifier());
            ifExists = this.readIfExists(ifExists);
            this.readIf("CASCADE");
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("SEQUENCE")) {
            boolean ifExists = this.readIfExists(false);
            String sequenceName = this.readIdentifierWithSchema();
            DropSequence command = new DropSequence(this.session, this.getSchema());
            command.setSequenceName(sequenceName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("CONSTANT")) {
            boolean ifExists = this.readIfExists(false);
            String constantName = this.readIdentifierWithSchema();
            DropConstant command = new DropConstant(this.session, this.getSchema());
            command.setConstantName(constantName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("TRIGGER")) {
            boolean ifExists = this.readIfExists(false);
            String triggerName = this.readIdentifierWithSchema();
            DropTrigger command = new DropTrigger(this.session, this.getSchema());
            command.setTriggerName(triggerName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("MATERIALIZED")) {
            this.read("VIEW");
            boolean ifExists = this.readIfExists(false);
            String viewName = this.readIdentifierWithSchema();
            DropMaterializedView command = new DropMaterializedView(this.session, this.getSchema());
            command.setViewName(viewName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("VIEW")) {
            boolean ifExists = this.readIfExists(false);
            String viewName = this.readIdentifierWithSchema();
            DropView command = new DropView(this.session, this.getSchema());
            command.setViewName(viewName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            ConstraintActionType dropAction = this.parseCascadeOrRestrict();
            if (dropAction != null) {
                command.setDropAction(dropAction);
            }
            return command;
        }
        if (this.readIf("ROLE")) {
            boolean ifExists = this.readIfExists(false);
            DropRole command = new DropRole(this.session);
            command.setRoleName(this.readIdentifier());
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("ALIAS")) {
            boolean ifExists = this.readIfExists(false);
            String aliasName = this.readIdentifierWithSchema();
            DropFunctionAlias command = new DropFunctionAlias(this.session, this.getSchema());
            command.setAliasName(aliasName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        if (this.readIf("SCHEMA")) {
            boolean ifExists = this.readIfExists(false);
            DropSchema command = new DropSchema(this.session);
            command.setSchemaName(this.readIdentifier());
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            ConstraintActionType dropAction = this.parseCascadeOrRestrict();
            if (dropAction != null) {
                command.setDropAction(dropAction);
            }
            return command;
        }
        if (this.readIf(3, "OBJECTS")) {
            DropDatabase command = new DropDatabase(this.session);
            command.setDropAllObjects(true);
            if (this.readIf("DELETE", "FILES")) {
                command.setDeleteFiles(true);
            }
            return command;
        }
        if (this.readIf("DOMAIN") || this.readIf("TYPE") || this.readIfCompat("DATATYPE")) {
            return this.parseDropDomain();
        }
        if (this.readIf("AGGREGATE")) {
            return this.parseDropAggregate();
        }
        if (this.readIf("SYNONYM")) {
            boolean ifExists = this.readIfExists(false);
            String synonymName = this.readIdentifierWithSchema();
            DropSynonym command = new DropSynonym(this.session, this.getSchema());
            command.setSynonymName(synonymName);
            ifExists = this.readIfExists(ifExists);
            command.setIfExists(ifExists);
            return command;
        }
        throw this.getSyntaxError();
    }

    private DropDomain parseDropDomain() {
        boolean ifExists = this.readIfExists(false);
        String domainName = this.readIdentifierWithSchema();
        DropDomain command = new DropDomain(this.session, this.getSchema());
        command.setDomainName(domainName);
        ifExists = this.readIfExists(ifExists);
        command.setIfDomainExists(ifExists);
        ConstraintActionType dropAction = this.parseCascadeOrRestrict();
        if (dropAction != null) {
            command.setDropAction(dropAction);
        }
        return command;
    }

    private DropAggregate parseDropAggregate() {
        boolean ifExists = this.readIfExists(false);
        String name = this.readIdentifierWithSchema();
        DropAggregate command = new DropAggregate(this.session, this.getSchema());
        command.setName(name);
        ifExists = this.readIfExists(ifExists);
        command.setIfExists(ifExists);
        return command;
    }

    private TableFilter readTableReference() {
        TableFilter top;
        TableFilter last = top = this.readTablePrimary();
        while (true) {
            TableFilter join;
            switch (this.currentTokenType) {
                case 65: {
                    this.read();
                    this.readIf("OUTER");
                    this.read(46);
                    join = this.readTableReference();
                    Expression on = this.readJoinSpecification(top, join, true);
                    this.addJoin(join, top, true, on);
                    top = join;
                    break;
                }
                case 48: {
                    this.read();
                    this.readIf("OUTER");
                    this.read(46);
                    join = this.readTableReference();
                    Expression on = this.readJoinSpecification(top, join, false);
                    this.addJoin(top, join, true, on);
                    break;
                }
                case 36: {
                    this.read();
                    throw this.getSyntaxError();
                }
                case 42: {
                    this.read();
                    this.read(46);
                    join = this.readTableReference();
                    Expression on = this.readJoinSpecification(top, join, false);
                    this.addJoin(top, join, false, on);
                    break;
                }
                case 46: {
                    this.read();
                    join = this.readTableReference();
                    Expression on = this.readJoinSpecification(top, join, false);
                    this.addJoin(top, join, false, on);
                    break;
                }
                case 15: {
                    this.read();
                    this.read(46);
                    join = this.readTablePrimary();
                    this.addJoin(top, join, false, null);
                    break;
                }
                case 56: {
                    this.read();
                    this.read(46);
                    join = this.readTablePrimary();
                    Expression on = null;
                    Column[] columnArray = last.getTable().getColumns();
                    int n = columnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Column column1 = columnArray[n2];
                        Column column2 = join.getColumn(last.getColumnName(column1), true);
                        if (column2 != null) {
                            on = this.addJoinColumn(on, last, join, column1, column2, false);
                        }
                        ++n2;
                    }
                    this.addJoin(top, join, false, on);
                    break;
                }
                default: {
                    if (this.expectedList != null) {
                        this.addMultipleExpected(65, 48, 42, 46, 15, 56);
                    }
                    return top;
                }
            }
            last = join;
        }
    }

    private Expression readJoinSpecification(TableFilter filter1, TableFilter filter2, boolean rightJoin) {
        Expression on = null;
        if (this.readIf(60)) {
            on = this.readExpression();
        } else if (this.readIf(83, 105)) {
            do {
                String columnName = this.readIdentifier();
                on = this.addJoinColumn(on, filter1, filter2, filter1.getColumn(columnName, false), filter2.getColumn(columnName, false), rightJoin);
            } while (this.readIfMore());
        }
        return on;
    }

    private Expression addJoinColumn(Expression on, TableFilter filter1, TableFilter filter2, Column column1, Column column2, boolean rightJoin) {
        if (rightJoin) {
            filter1.addCommonJoinColumns(column1, column2, filter2);
            filter2.addCommonJoinColumnToExclude(column2);
        } else {
            filter1.addCommonJoinColumns(column1, column1, filter1);
            filter2.addCommonJoinColumnToExclude(column2);
        }
        ExpressionColumn tableExpr = new ExpressionColumn(this.database, filter1.getSchemaName(), filter1.getTableAlias(), filter1.getColumnName(column1));
        ExpressionColumn joinExpr = new ExpressionColumn(this.database, filter2.getSchemaName(), filter2.getTableAlias(), filter2.getColumnName(column2));
        Comparison equal = new Comparison(0, tableExpr, joinExpr, false);
        on = on == null ? equal : new ConditionAndOr(0, on, equal);
        return on;
    }

    private void addJoin(TableFilter top, TableFilter join, boolean outer, Expression on) {
        if (join.getJoin() != null) {
            String joinTable = "SYSTEM_JOIN_" + this.token.start();
            TableFilter n = new TableFilter(this.session, new DualTable(this.database), joinTable, this.rightsChecked, this.currentSelect, join.getOrderInFrom(), null);
            n.setNestedJoin(join);
            join = n;
        }
        top.addJoin(join, outer, on);
    }

    private Prepared parseExecutePostgre() {
        ExecuteProcedure command = new ExecuteProcedure(this.session);
        String procedureName = this.readIdentifier();
        Procedure p = this.session.getProcedure(procedureName);
        if (p == null) {
            throw DbException.get(90077, procedureName);
        }
        command.setProcedure(p);
        if (this.readIf(105)) {
            int i = 0;
            while (true) {
                command.setExpression(i, this.readExpression());
                if (!this.readIfMore()) break;
                ++i;
            }
        }
        return command;
    }

    private Prepared parseExecuteSQLServer() {
        Call command = new Call(this.session);
        this.currentPrepared = command;
        String schemaName = null;
        String name = this.readIdentifier();
        if (this.readIf(110)) {
            schemaName = name;
            name = this.readIdentifier();
            if (this.readIf(110)) {
                this.checkDatabaseName(schemaName);
                schemaName = name;
                name = this.readIdentifier();
            }
        }
        FunctionAlias functionAlias = this.getFunctionAliasWithinPath(name, schemaName != null ? this.database.getSchema(schemaName) : null);
        ArrayList<Expression> argList = Utils.newSmallArrayList();
        if (this.currentTokenType != 115 && this.currentTokenType != 93) {
            do {
                argList.add(this.readExpression());
            } while (this.readIf(109));
        }
        Expression[] args = argList.toArray(new Expression[0]);
        command.setExpression(new JavaFunction(functionAlias, args));
        return command;
    }

    private FunctionAlias getFunctionAliasWithinPath(String name, Schema schema) {
        UserDefinedFunction userDefinedFunction = this.findUserDefinedFunctionWithinPath(schema, name);
        if (userDefinedFunction instanceof FunctionAlias) {
            return (FunctionAlias)userDefinedFunction;
        }
        throw DbException.get(90022, name);
    }

    private DeallocateProcedure parseDeallocate() {
        this.readIf("PLAN");
        DeallocateProcedure command = new DeallocateProcedure(this.session);
        command.setProcedureName(this.readIdentifier());
        return command;
    }

    private Explain parseExplain() {
        Explain command = new Explain(this.session);
        if (this.readIf("ANALYZE")) {
            command.setExecuteCommand(true);
        } else if (this.readIfCompat("PLAN")) {
            this.readIf(33);
        }
        switch (this.currentTokenType) {
            case 69: 
            case 75: 
            case 85: 
            case 89: 
            case 105: {
                Query query = this.parseQuery();
                query.setNeverLazy(true);
                command.setCommand(query);
                break;
            }
            default: {
                int start = this.tokenIndex;
                if (this.readIf("DELETE")) {
                    command.setCommand(this.parseDelete(start));
                    break;
                }
                if (this.readIf("UPDATE")) {
                    command.setCommand(this.parseUpdate(start));
                    break;
                }
                if (this.readIf("INSERT")) {
                    command.setCommand(this.parseInsert(start));
                    break;
                }
                if (this.readIf("MERGE")) {
                    command.setCommand(this.parseMerge(start));
                    break;
                }
                throw this.getSyntaxError();
            }
        }
        return command;
    }

    private Query parseQuery() {
        BitSet outerUsedParameters = this.openParametersScope();
        Query query = this.parseQueryExpression();
        ArrayList<Parameter> params = this.closeParametersScope(outerUsedParameters);
        query.setParameterList(params);
        query.init();
        return query;
    }

    private Query parseQueryExpression() {
        Query query;
        int start = this.tokenIndex;
        QueryScope outerQueryScope = this.queryScope;
        if (this.readIf(89)) {
            boolean oldRecursive = this.parsingRecursiveWithList;
            boolean isPotentiallyRecursive = !oldRecursive && this.readIf("RECURSIVE");
            this.queryScope = new QueryScope(outerQueryScope);
            try {
                if (isPotentiallyRecursive) {
                    this.parsingRecursiveWithList = true;
                }
                try {
                    do {
                        this.parseSingleCommonTableExpression(isPotentiallyRecursive);
                    } while (this.readIf(109));
                }
                finally {
                    this.parsingRecursiveWithList = oldRecursive;
                }
                query = this.parseQueryExpressionBodyAndEndOfQuery(start);
                query.setNeverLazy(true);
                query.setWithClause(this.queryScope.tableSubqueries);
            }
            finally {
                this.queryScope = outerQueryScope;
            }
        }
        query = this.parseQueryExpressionBodyAndEndOfQuery(start);
        query.setOuterQueryScope(outerQueryScope);
        return query;
    }

    private Query parseQueryExpressionBodyAndEndOfQuery(int start) {
        Query query = this.parseQueryExpressionBody();
        this.parseEndOfQuery(query);
        this.setSQL(query, start);
        return query;
    }

    private Query parseQueryExpressionBody() {
        Query command = this.parseQueryTerm();
        while (true) {
            SelectUnion.UnionType type;
            if (this.readIf(79)) {
                if (this.readIf(3)) {
                    type = SelectUnion.UnionType.UNION_ALL;
                } else {
                    this.readIf(26);
                    type = SelectUnion.UnionType.UNION;
                }
            } else {
                if (!this.readIf(29) && !this.readIfCompat(53)) break;
                type = SelectUnion.UnionType.EXCEPT;
            }
            command = new SelectUnion(this.session, type, command, this.parseQueryTerm());
        }
        return command;
    }

    private Query parseQueryTerm() {
        Query command = this.parseQueryPrimary();
        while (this.readIf(43)) {
            command = new SelectUnion(this.session, SelectUnion.UnionType.INTERSECT, command, this.parseQueryPrimary());
        }
        return command;
    }

    private void parseEndOfQuery(Query command) {
        if (this.readIf(62, "BY")) {
            Select oldSelect = this.currentSelect;
            if (command instanceof Select) {
                this.currentSelect = (Select)command;
            }
            ArrayList<QueryOrderBy> orderList = Utils.newSmallArrayList();
            do {
                boolean canBeNumber = this.currentTokenType == 94;
                QueryOrderBy order = new QueryOrderBy();
                Expression expr = this.readExpression();
                if (canBeNumber && expr instanceof ValueExpression && expr.getType().getValueType() == 11) {
                    order.columnIndexExpr = expr;
                } else if (expr instanceof Parameter) {
                    this.recompileAlways = true;
                    order.columnIndexExpr = expr;
                } else {
                    order.expression = expr;
                }
                order.sortType = this.parseSortType();
                orderList.add(order);
            } while (this.readIf(109));
            command.setOrder(orderList);
            this.currentSelect = oldSelect;
        }
        if (command.getFetch() == null) {
            Select temp = this.currentSelect;
            this.currentSelect = null;
            boolean hasOffsetOrFetch = false;
            if (this.readIf(59)) {
                hasOffsetOrFetch = true;
                command.setOffset(this.readExpression().optimize(this.session));
                if (!this.readIf(66)) {
                    this.readIf("ROWS");
                }
            }
            if (this.readIf(32)) {
                hasOffsetOrFetch = true;
                if (!this.readIf("FIRST")) {
                    this.read("NEXT");
                }
                if (this.readIf(66) || this.readIf("ROWS")) {
                    command.setFetch(ValueExpression.get(ValueInteger.get(1)));
                } else {
                    command.setFetch(this.readExpression().optimize(this.session));
                    if (this.readIf("PERCENT")) {
                        command.setFetchPercent(true);
                    }
                    if (!this.readIf(66)) {
                        this.read("ROWS");
                    }
                }
                if (this.readIf(89, "TIES")) {
                    command.setWithTies(true);
                } else {
                    this.read("ONLY");
                }
            }
            if (!hasOffsetOrFetch && this.database.getMode().limit && this.readIfCompat(50)) {
                Expression limit = this.readExpression().optimize(this.session);
                if (this.readIf(59)) {
                    command.setOffset(this.readExpression().optimize(this.session));
                } else if (this.readIf(109)) {
                    Expression offset = limit;
                    limit = this.readExpression().optimize(this.session);
                    command.setOffset(offset);
                }
                command.setFetch(limit);
            }
            this.currentSelect = temp;
        }
        if (this.readIf(33)) {
            if (this.readIf("UPDATE")) {
                ForUpdate forUpdate;
                if (this.readIfCompat("OF")) {
                    do {
                        this.readIdentifierWithSchema();
                    } while (this.readIf(109));
                }
                if (this.readIf("NOWAIT")) {
                    forUpdate = ForUpdate.NOWAIT;
                } else if (this.readIf("WAIT")) {
                    BigDecimal timeout;
                    if (this.currentTokenType != 94 || (timeout = this.token.value(this.session).getBigDecimal()) == null || timeout.signum() < 0 || timeout.compareTo(BigDecimal.valueOf(Integer.MAX_VALUE, 3)) > 0) {
                        throw DbException.getSyntaxError(this.sqlCommand, this.token.start(), "timeout (0..2147483.647)");
                    }
                    this.read();
                    forUpdate = ForUpdate.wait(timeout.movePointRight(3).intValue());
                } else {
                    forUpdate = this.readIf("SKIP", "LOCKED") ? ForUpdate.SKIP_LOCKED : ForUpdate.DEFAULT;
                }
                command.setForUpdate(forUpdate);
            } else if (this.readIfCompat("READ") || this.readIfCompat(32)) {
                this.read("ONLY");
            }
        }
        if (this.database.getMode().isolationLevelInSelectOrInsertStatement) {
            this.parseIsolationClause();
        }
    }

    private void parseIsolationClause() {
        if (this.readIfCompat(89)) {
            if (this.readIf("RR") || this.readIf("RS")) {
                if (this.readIf("USE", 4, "KEEP")) {
                    if (!this.readIf("SHARE") && !this.readIf("UPDATE")) {
                        this.readIf("EXCLUSIVE");
                    }
                    this.read("LOCKS");
                }
            } else if (!this.readIf("CS")) {
                this.readIf("UR");
            }
        }
    }

    private Query parseQueryPrimary() {
        if (this.readIf(105)) {
            Query query = this.parseQueryExpressionBodyAndEndOfQuery(this.tokenIndex);
            query.setOuterQueryScope(this.queryScope);
            this.read(106);
            return query;
        }
        int start = this.tokenIndex;
        if (this.readIf(69)) {
            return this.parseSelect(start);
        }
        if (this.readIf(75)) {
            return this.parseExplicitTable(start);
        }
        this.read(85);
        return this.parseValues();
    }

    private void parseSelectFromPart(Select command) {
        block0: do {
            TableFilter top = this.readTableReference();
            command.addTableFilter(top, true);
            boolean isOuter = false;
            while (true) {
                TableFilter join;
                TableFilter n;
                if ((n = top.getNestedJoin()) != null) {
                    n.visit(f -> command.addTableFilter(f, false));
                }
                if ((join = top.getJoin()) == null) continue block0;
                if (isOuter |= join.isJoinOuter()) {
                    command.addTableFilter(join, false);
                } else {
                    Expression on = join.getJoinCondition();
                    if (on != null) {
                        command.addCondition(on);
                    }
                    join.removeJoinCondition();
                    top.removeJoin();
                    command.addTableFilter(join, true);
                }
                top = join;
            }
        } while (this.readIf(109));
    }

    private void parseSelectExpressions(Select command) {
        ArrayList<Expression> expressions;
        if (this.database.getMode().topInSelect && this.readIfCompat("TOP")) {
            Select temp = this.currentSelect;
            this.currentSelect = null;
            command.setFetch(this.readTerm().optimize(this.session));
            if (this.readIf("PERCENT")) {
                command.setFetchPercent(true);
            }
            if (this.readIf(89, "TIES")) {
                command.setWithTies(true);
            }
            this.currentSelect = temp;
        }
        if (this.readIf(26)) {
            if (this.readIf(60, 105)) {
                ArrayList<Expression> distinctExpressions = Utils.newSmallArrayList();
                do {
                    distinctExpressions.add(this.readExpression());
                } while (this.readIfMore());
                command.setDistinct(distinctExpressions.toArray(new Expression[0]));
            } else {
                command.setDistinct();
            }
        } else {
            this.readIf(3);
        }
        switch (this.currentTokenType) {
            case 32: 
            case 35: 
            case 37: 
            case 38: 
            case 59: 
            case 62: 
            case 64: 
            case 87: 
            case 88: 
            case 93: 
            case 106: 
            case 115: {
                expressions = new ArrayList();
                break;
            }
            default: {
                expressions = Utils.newSmallArrayList();
                do {
                    if (this.readIf(108)) {
                        expressions.add(this.parseWildcard(null, null));
                        continue;
                    }
                    Expression expr = this.readExpression();
                    if (this.readIf(7) || this.isIdentifier()) {
                        expr = new Alias(expr, this.readIdentifier(), this.database.getMode().aliasColumnName);
                    }
                    expressions.add(expr);
                } while (this.readIf(109));
            }
        }
        command.setExpressions(expressions);
    }

    private Select parseSelect(int start) {
        Select command = new Select(this.session, this.currentSelect);
        Select oldSelect = this.currentSelect;
        Prepared oldPrepared = this.currentPrepared;
        BitSet outerUsedParameters = this.openParametersScope();
        this.currentSelect = command;
        this.currentPrepared = command;
        this.parseSelectExpressions(command);
        if (!this.readIf(35)) {
            TableFilter filter = new TableFilter(this.session, new DualTable(this.database), null, this.rightsChecked, this.currentSelect, 0, null);
            command.addTableFilter(filter, true);
        } else {
            this.parseSelectFromPart(command);
        }
        if (this.readIf(87)) {
            command.addCondition(this.readExpressionWithGlobalConditions());
        }
        this.currentSelect = oldSelect;
        if (this.readIf(37, "BY")) {
            command.setGroupQuery();
            ArrayList<Expression> list = Utils.newSmallArrayList();
            do {
                if (this.isToken(105) && this.isOrdinaryGroupingSet()) {
                    if (this.readIf(106)) continue;
                    do {
                        list.add(this.readExpression());
                    } while (this.readIfMore());
                    continue;
                }
                Expression expr = this.readExpression();
                if (this.database.getMode().groupByColumnIndex && expr instanceof ValueExpression && expr.getType().getValueType() == 11) {
                    ArrayList<Expression> expressions = command.getExpressions();
                    for (Expression e : expressions) {
                        if (!(e instanceof Wildcard)) continue;
                        throw this.getSyntaxError();
                    }
                    int idx = expr.getValue(this.session).getInt();
                    if (idx < 1 || idx > expressions.size()) {
                        throw DbException.get(90157, Integer.toString(idx), Integer.toString(expressions.size()));
                    }
                    list.add(expressions.get(idx - 1));
                    continue;
                }
                list.add(expr);
            } while (this.readIf(109));
            if (!list.isEmpty()) {
                command.setGroupBy(list);
            }
        }
        this.currentSelect = command;
        if (this.readIf(38)) {
            command.setGroupQuery();
            command.setHaving(this.readExpressionWithGlobalConditions());
        }
        if (this.readIf(88)) {
            do {
                int sqlIndex = this.token.start();
                String name = this.readIdentifier();
                this.read(7);
                Window w = this.readWindowSpecification();
                if (this.currentSelect.addWindow(name, w)) continue;
                throw DbException.getSyntaxError(this.sqlCommand, sqlIndex, "unique identifier");
            } while (this.readIf(109));
        }
        if (this.readIf(64)) {
            command.setWindowQuery();
            command.setQualify(this.readExpressionWithGlobalConditions());
        }
        command.setParameterList(this.closeParametersScope(outerUsedParameters));
        this.currentSelect = oldSelect;
        this.currentPrepared = oldPrepared;
        this.setSQL(command, start);
        return command;
    }

    private boolean isOrdinaryGroupingSet() {
        int offset = this.scanToCloseParen(this.tokenIndex + 1);
        if (offset < 0) {
            return false;
        }
        switch (((Token)this.tokens.get(offset)).tokenType()) {
            case 29: 
            case 32: 
            case 33: 
            case 38: 
            case 43: 
            case 50: 
            case 53: 
            case 59: 
            case 62: 
            case 64: 
            case 79: 
            case 88: 
            case 93: 
            case 106: 
            case 109: 
            case 115: {
                this.setTokenIndex(this.tokenIndex + 1);
                return true;
            }
        }
        return false;
    }

    private Query parseExplicitTable(int start) {
        Table table = this.readTableOrView();
        Select command = new Select(this.session, this.currentSelect);
        TableFilter filter = new TableFilter(this.session, table, null, this.rightsChecked, command, this.orderInFrom++, null);
        command.addTableFilter(filter, true);
        command.setExplicitTable();
        this.setSQL(command, start);
        return command;
    }

    private void setSQL(Prepared command, int start) {
        ArrayList<Token> commandTokens;
        String s = this.sqlCommand;
        int beginIndex = ((Token)this.tokens.get(start)).start();
        int endIndex = this.token.start();
        while (beginIndex < endIndex && s.charAt(beginIndex) <= ' ') {
            ++beginIndex;
        }
        while (beginIndex < endIndex && s.charAt(endIndex - 1) <= ' ') {
            --endIndex;
        }
        s = s.substring(beginIndex, endIndex);
        if (start == 0 && this.currentTokenType == 93) {
            commandTokens = this.tokens;
            if (beginIndex != 0) {
                int i = 0;
                int l = commandTokens.size() - 1;
                while (i < l) {
                    commandTokens.get(i).subtractFromStart(beginIndex);
                    ++i;
                }
            }
            this.token.setStart(s.length());
            this.sqlCommand = s;
        } else {
            List subList = this.tokens.subList(start, this.tokenIndex);
            commandTokens = new ArrayList<Token>(subList.size() + 1);
            int i = start;
            while (i < this.tokenIndex) {
                Token t = ((Token)this.tokens.get(i)).clone();
                t.subtractFromStart(beginIndex);
                commandTokens.add(t);
                ++i;
            }
            commandTokens.add(new Token.EndOfInputToken(s.length()));
        }
        command.setSQL(s, commandTokens);
    }

    private Expression readExpressionOrDefault() {
        if (this.readIf(25)) {
            return ValueExpression.DEFAULT;
        }
        return this.readExpression();
    }

    private Expression readExpressionWithGlobalConditions() {
        Expression r = this.readCondition();
        if (this.readIf(4)) {
            r = this.readAnd(new ConditionAndOr(0, r, this.readCondition()));
        } else if (this.readIf("_LOCAL_AND_GLOBAL_")) {
            r = this.readAnd(new ConditionLocalAndGlobal(r, this.readCondition()));
        }
        return this.readExpressionPart2(r);
    }

    private Expression readExpression() {
        return this.readExpressionPart2(this.readAnd(this.readCondition()));
    }

    private Expression readExpressionPart2(Expression r1) {
        if (!this.readIf(61)) {
            return r1;
        }
        Expression r2 = this.readAnd(this.readCondition());
        if (!this.readIf(61)) {
            return new ConditionAndOr(1, r1, r2);
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.add(r1);
        expressions.add(r2);
        do {
            expressions.add(this.readAnd(this.readCondition()));
        } while (this.readIf(61));
        return new ConditionAndOrN(1, expressions);
    }

    private Expression readAnd(Expression r) {
        if (!this.readIf(4)) {
            return r;
        }
        Expression expr2 = this.readCondition();
        if (!this.readIf(4)) {
            return new ConditionAndOr(0, r, expr2);
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        expressions.add(r);
        expressions.add(expr2);
        do {
            expressions.add(this.readCondition());
        } while (this.readIf(4));
        return new ConditionAndOrN(0, expressions);
    }

    private Expression readCondition() {
        boolean not;
        Expression l;
        switch (this.currentTokenType) {
            case 57: {
                this.read();
                return new ConditionNot(this.readCondition());
            }
            case 30: {
                this.read();
                this.read(105);
                Query query = this.parseQuery();
                this.read(106);
                return new ExistsPredicate(query);
            }
            case 80: {
                this.read();
                NullsDistinct nullsDistinct = this.readNullsDistinct(NullsDistinct.DISTINCT);
                this.read(105);
                Query query = this.parseQuery();
                this.read(106);
                return new UniquePredicate(query, nullsDistinct);
            }
        }
        if (this.readIf("INTERSECTS", 105)) {
            Expression r1 = this.readConcat();
            this.read(109);
            Expression r2 = this.readConcat();
            this.read(106);
            return new Comparison(8, r1, r2, false);
        }
        if (this.expectedList != null) {
            this.addMultipleExpected(57, 30, 80);
            this.addExpected("INTERSECTS");
        }
        Expression c = this.readConcat();
        do {
            l = c;
            int backup = this.tokenIndex;
            not = this.readIf(57);
            if (!not || this.currentTokenType != 58) continue;
            this.setTokenIndex(backup);
            break;
        } while ((c = this.readConditionRightHandSide(l, not, false)) != null);
        return l;
    }

    private Expression readConditionRightHandSide(Expression r, boolean not, boolean whenOperand) {
        if (!not && this.readIf(45)) {
            r = this.readConditionIs(r, whenOperand);
        } else {
            switch (this.currentTokenType) {
                case 10: {
                    this.read();
                    boolean symmetric = this.readIf(73);
                    if (!symmetric) {
                        this.readIf(8);
                    }
                    Expression a = this.readConcat();
                    this.read(4);
                    r = new BetweenPredicate(r, not, whenOperand, symmetric, a, this.readConcat());
                    break;
                }
                case 41: {
                    this.read();
                    r = this.readInPredicate(r, not, whenOperand);
                    break;
                }
                case 49: {
                    this.read();
                    r = this.readLikePredicate(r, CompareLike.LikeType.LIKE, not, whenOperand);
                    break;
                }
                default: {
                    if (this.readIf("ILIKE")) {
                        r = this.readLikePredicate(r, CompareLike.LikeType.ILIKE, not, whenOperand);
                        break;
                    }
                    if (this.readIf("REGEXP")) {
                        Expression b = this.readConcat();
                        this.recompileAlways = true;
                        r = new CompareLike(this.database, r, not, whenOperand, b, null, CompareLike.LikeType.REGEXP);
                        break;
                    }
                    if (not) {
                        if (whenOperand) {
                            return null;
                        }
                        if (this.expectedList != null) {
                            this.addMultipleExpected(10, 41, 49);
                        }
                        throw this.getSyntaxError();
                    }
                    int compareType = Parser.getCompareType(this.currentTokenType);
                    if (compareType < 0) {
                        return null;
                    }
                    this.read();
                    r = this.readComparison(r, compareType, whenOperand);
                }
            }
        }
        return r;
    }

    private Expression readConditionIs(Expression left, boolean whenOperand) {
        boolean isNot = this.readIf(57);
        switch (this.currentTokenType) {
            case 58: {
                this.read();
                left = new NullPredicate(left, isNot, whenOperand);
                break;
            }
            case 26: {
                this.read();
                this.read(35);
                left = this.readComparison(left, isNot ? 6 : 7, whenOperand);
                break;
            }
            case 77: {
                this.read();
                left = new BooleanTest(left, isNot, whenOperand, true);
                break;
            }
            case 31: {
                this.read();
                left = new BooleanTest(left, isNot, whenOperand, false);
                break;
            }
            case 81: {
                this.read();
                left = new BooleanTest(left, isNot, whenOperand, null);
                break;
            }
            default: {
                if (this.readIf("OF")) {
                    left = this.readTypePredicate(left, isNot, whenOperand);
                    break;
                }
                if (this.readIf("JSON")) {
                    left = this.readJsonPredicate(left, isNot, whenOperand);
                    break;
                }
                if (this.expectedList != null) {
                    this.addMultipleExpected(58, 26, 77, 31, 81);
                }
                if (whenOperand || !this.session.isQuirksMode()) {
                    throw this.getSyntaxError();
                }
                left = new Comparison(isNot ? 7 : 6, left, this.readConcat(), false);
            }
        }
        return left;
    }

    private TypePredicate readTypePredicate(Expression left, boolean not, boolean whenOperand) {
        this.read(105);
        ArrayList<TypeInfo> typeList = Utils.newSmallArrayList();
        do {
            typeList.add(this.parseDataType());
        } while (this.readIfMore());
        return new TypePredicate(left, not, whenOperand, typeList.toArray(new TypeInfo[0]));
    }

    private Expression readInPredicate(Expression left, boolean not, boolean whenOperand) {
        ArrayList<Expression> v;
        this.read(105);
        if (!whenOperand && this.database.getMode().allowEmptyInPredicate && this.readIf(106)) {
            return ValueExpression.getBoolean(not);
        }
        if (this.isQuery()) {
            Query query = this.parseQuery();
            if (!this.readIfMore()) {
                return new ConditionInQuery(left, not, whenOperand, query, false, 0);
            }
            v = Utils.newSmallArrayList();
            v.add(new Subquery(query));
        } else {
            v = Utils.newSmallArrayList();
        }
        do {
            v.add(this.readExpression());
        } while (this.readIfMore());
        return new ConditionIn(left, not, whenOperand, v);
    }

    private IsJsonPredicate readJsonPredicate(Expression left, boolean not, boolean whenOperand) {
        JSONItemType itemType = this.readIf(84) ? JSONItemType.VALUE : (this.readIf(6) ? JSONItemType.ARRAY : (this.readIf("OBJECT") ? JSONItemType.OBJECT : (this.readIf("SCALAR") ? JSONItemType.SCALAR : JSONItemType.VALUE)));
        boolean unique = false;
        if (this.readIf(89, 80)) {
            this.readIf("KEYS");
            unique = true;
        } else if (this.readIf("WITHOUT", 80)) {
            this.readIf("KEYS");
        }
        return new IsJsonPredicate(left, not, whenOperand, unique, itemType);
    }

    private Expression readLikePredicate(Expression left, CompareLike.LikeType likeType, boolean not, boolean whenOperand) {
        Expression right = this.readConcat();
        Expression esc = this.readIf("ESCAPE") ? this.readConcat() : null;
        this.recompileAlways = true;
        return new CompareLike(this.database, left, not, whenOperand, right, esc, likeType);
    }

    private Expression readComparison(Expression left, int compareType, boolean whenOperand) {
        int start = this.tokenIndex;
        if (this.readIf(3, 105)) {
            left = this.isQuery() ? new ConditionInQuery(left, false, whenOperand, this.parseQuery(), true, compareType) : new ConditionInArray(left, whenOperand, this.readExpression(), true, compareType);
            this.read(106);
        } else {
            left = this.readIf(5, 105) ? this.readAnyComparison(left, compareType, whenOperand, start) : (this.readIf(72, 105) ? this.readAnyComparison(left, compareType, whenOperand, start) : new Comparison(compareType, left, this.readConcat(), whenOperand));
        }
        return left;
    }

    private Expression readAnyComparison(Expression left, int compareType, boolean whenOperand, int start) {
        left = this.isQuery() ? new ConditionInQuery(left, false, whenOperand, this.parseQuery(), false, compareType) : new ConditionInArray(left, whenOperand, this.readExpression(), false, compareType);
        this.read(106);
        return left;
    }

    private Expression readConcat() {
        Expression op1 = this.readSum();
        block5: while (true) {
            switch (this.currentTokenType) {
                case 104: {
                    this.read();
                    Expression op2 = this.readSum();
                    if (this.readIf(104)) {
                        ConcatenationOperation c = new ConcatenationOperation();
                        c.addParameter(op1);
                        c.addParameter(op2);
                        do {
                            c.addParameter(this.readSum());
                        } while (this.readIf(104));
                        c.doneWithParameters();
                        op1 = c;
                        continue block5;
                    }
                    op1 = new ConcatenationOperation(op1, op2);
                    continue block5;
                }
                case 119: {
                    op1 = this.readTildeCondition(op1, false);
                    continue block5;
                }
                case 122: {
                    op1 = this.readTildeCondition(op1, true);
                    continue block5;
                }
            }
            break;
        }
        this.addExpected(104);
        return op1;
    }

    private Expression readSum() {
        Expression r = this.readFactor();
        while (true) {
            if (this.readIf(103)) {
                r = new BinaryOperation(BinaryOperation.OpType.PLUS, r, this.readFactor());
                continue;
            }
            if (!this.readIf(102)) break;
            r = new BinaryOperation(BinaryOperation.OpType.MINUS, r, this.readFactor());
        }
        return r;
    }

    private Expression readFactor() {
        Expression r = this.readTerm();
        while (true) {
            if (this.readIf(108)) {
                r = new BinaryOperation(BinaryOperation.OpType.MULTIPLY, r, this.readTerm());
                continue;
            }
            if (this.readIf(113)) {
                r = new BinaryOperation(BinaryOperation.OpType.DIVIDE, r, this.readTerm());
                continue;
            }
            if (!this.readIf(114)) break;
            r = new MathFunction(r, this.readTerm(), 1);
        }
        return r;
    }

    private Expression readTildeCondition(Expression r, boolean not) {
        this.read();
        if (this.readIf(108)) {
            r = new CastSpecification(r, TypeInfo.TYPE_VARCHAR_IGNORECASE);
        }
        return new CompareLike(this.database, r, not, false, this.readSum(), null, CompareLike.LikeType.REGEXP);
    }

    private Expression readAggregate(AggregateType aggregateType, String aggregateName) {
        Aggregate r;
        if (this.currentSelect == null) {
            this.expectedList = null;
            throw this.getSyntaxError();
        }
        switch (aggregateType) {
            case COUNT: {
                if (this.readIf(108)) {
                    r = new Aggregate(AggregateType.COUNT_ALL, new Expression[0], this.currentSelect, false);
                    break;
                }
                boolean distinct = this.readDistinctAgg();
                Expression on = this.readExpression();
                if (on instanceof Wildcard && !distinct) {
                    r = new Aggregate(AggregateType.COUNT_ALL, new Expression[0], this.currentSelect, false);
                    break;
                }
                r = new Aggregate(AggregateType.COUNT, new Expression[]{on}, this.currentSelect, distinct);
                break;
            }
            case COVAR_POP: 
            case COVAR_SAMP: 
            case CORR: 
            case REGR_SLOPE: 
            case REGR_INTERCEPT: 
            case REGR_COUNT: 
            case REGR_R2: 
            case REGR_AVGX: 
            case REGR_AVGY: 
            case REGR_SXX: 
            case REGR_SYY: 
            case REGR_SXY: {
                r = new Aggregate(aggregateType, new Expression[]{this.readExpression(), this.readNextArgument()}, this.currentSelect, false);
                break;
            }
            case HISTOGRAM: {
                r = new Aggregate(aggregateType, new Expression[]{this.readExpression()}, this.currentSelect, false);
                break;
            }
            case LISTAGG: {
                ArrayList<QueryOrderBy> orderByList;
                boolean distinct = this.readDistinctAgg();
                Expression arg = this.readExpression();
                ListaggArguments extraArguments = new ListaggArguments();
                if ("STRING_AGG".equals(aggregateName)) {
                    this.read(109);
                    extraArguments.setSeparator(this.readStringOrParameter());
                    orderByList = this.readIfOrderBy();
                } else if ("GROUP_CONCAT".equals(aggregateName)) {
                    orderByList = this.readIfOrderBy();
                    if (this.readIf("SEPARATOR")) {
                        extraArguments.setSeparator(this.readStringOrParameter());
                    }
                } else {
                    if (this.readIf(109)) {
                        extraArguments.setSeparator(this.readStringOrParameter());
                    }
                    if (this.readIf(60)) {
                        this.read("OVERFLOW");
                        if (this.readIf("TRUNCATE")) {
                            extraArguments.setOnOverflowTruncate(true);
                            if (this.currentTokenType == 94) {
                                extraArguments.setFilter(this.readStringOrParameter());
                            }
                            if (!this.readIf(89)) {
                                this.read("WITHOUT");
                                extraArguments.setWithoutCount(true);
                            }
                            this.read("COUNT");
                        } else {
                            this.read("ERROR");
                        }
                    }
                    orderByList = null;
                }
                Expression[] args = new Expression[]{arg};
                int index = this.tokenIndex;
                this.read(106);
                if (orderByList == null && this.isToken("WITHIN")) {
                    r = this.readWithinGroup(aggregateType, args, distinct, extraArguments, false, false);
                    break;
                }
                this.setTokenIndex(index);
                r = new Aggregate(AggregateType.LISTAGG, args, this.currentSelect, distinct);
                r.setExtraArguments(extraArguments);
                if (orderByList == null) break;
                r.setOrderByList(orderByList);
                break;
            }
            case ARRAY_AGG: {
                boolean distinct = this.readDistinctAgg();
                r = new Aggregate(AggregateType.ARRAY_AGG, new Expression[]{this.readExpression()}, this.currentSelect, distinct);
                r.setOrderByList(this.readIfOrderBy());
                break;
            }
            case RANK: 
            case DENSE_RANK: 
            case PERCENT_RANK: 
            case CUME_DIST: {
                if (this.isToken(106)) {
                    return this.readWindowFunction(aggregateName);
                }
                ArrayList<Expression> expressions = Utils.newSmallArrayList();
                do {
                    expressions.add(this.readExpression());
                } while (this.readIfMore());
                r = this.readWithinGroup(aggregateType, expressions.toArray(new Expression[0]), false, null, true, false);
                break;
            }
            case PERCENTILE_CONT: 
            case PERCENTILE_DISC: {
                Expression num = this.readExpression();
                this.read(106);
                r = this.readWithinGroup(aggregateType, new Expression[]{num}, false, null, false, true);
                break;
            }
            case MODE: {
                if (this.readIf(106)) {
                    r = this.readWithinGroup(AggregateType.MODE, new Expression[0], false, null, false, true);
                    break;
                }
                Expression expr = this.readExpression();
                r = new Aggregate(AggregateType.MODE, new Expression[0], this.currentSelect, false);
                if (this.readIf(62)) {
                    this.read("BY");
                    Expression expr2 = this.readExpression();
                    String sql = expr.getSQL(0);
                    String sql2 = expr2.getSQL(0);
                    if (!sql.equals(sql2)) {
                        throw DbException.getSyntaxError(42131, this.sqlCommand, this.token.start(), sql, sql2);
                    }
                    this.readAggregateOrder(r, expr, true);
                    break;
                }
                this.readAggregateOrder(r, expr, false);
                break;
            }
            case JSON_OBJECTAGG: {
                boolean withKey = this.readIf(47);
                Expression key = this.readExpression();
                if (withKey) {
                    this.read(84);
                } else if (!(this.readIf(84) || this.database.getMode().acceptsCommaAsJsonKeyValueSeparator && this.readIf(109))) {
                    this.read(116);
                }
                Expression value = this.readExpression();
                r = new Aggregate(AggregateType.JSON_OBJECTAGG, new Expression[]{key, value}, this.currentSelect, false);
                this.readJsonObjectFunctionFlags(r, false);
                break;
            }
            case JSON_ARRAYAGG: {
                boolean distinct = this.readDistinctAgg();
                r = new Aggregate(AggregateType.JSON_ARRAYAGG, new Expression[]{this.readExpression()}, this.currentSelect, distinct);
                r.setOrderByList(this.readIfOrderBy());
                r.setFlags(1);
                this.readJsonObjectFunctionFlags(r, true);
                break;
            }
            default: {
                boolean distinct = this.readDistinctAgg();
                r = new Aggregate(aggregateType, new Expression[]{this.readExpression()}, this.currentSelect, distinct);
            }
        }
        this.read(106);
        this.readFilterAndOver(r);
        return r;
    }

    private Aggregate readWithinGroup(AggregateType aggregateType, Expression[] args, boolean distinct, Object extraArguments, boolean forHypotheticalSet, boolean simple) {
        this.read("WITHIN");
        this.read(37);
        this.read(105);
        this.read(62);
        this.read("BY");
        Aggregate r = new Aggregate(aggregateType, args, this.currentSelect, distinct);
        r.setExtraArguments(extraArguments);
        if (forHypotheticalSet) {
            int count = args.length;
            ArrayList<QueryOrderBy> orderList = new ArrayList<QueryOrderBy>(count);
            int i = 0;
            while (i < count) {
                if (i > 0) {
                    this.read(109);
                }
                orderList.add(this.parseSortSpecification());
                ++i;
            }
            r.setOrderByList(orderList);
        } else if (simple) {
            this.readAggregateOrder(r, this.readExpression(), true);
        } else {
            r.setOrderByList(this.parseSortSpecificationList());
        }
        return r;
    }

    private void readAggregateOrder(Aggregate r, Expression expr, boolean parseSortType) {
        ArrayList<QueryOrderBy> orderList = new ArrayList<QueryOrderBy>(1);
        QueryOrderBy order = new QueryOrderBy();
        order.expression = expr;
        if (parseSortType) {
            order.sortType = this.parseSortType();
        }
        orderList.add(order);
        r.setOrderByList(orderList);
    }

    private ArrayList<QueryOrderBy> readIfOrderBy() {
        if (this.readIf(62, "BY")) {
            return this.parseSortSpecificationList();
        }
        return null;
    }

    private ArrayList<QueryOrderBy> parseSortSpecificationList() {
        ArrayList<QueryOrderBy> orderList = Utils.newSmallArrayList();
        do {
            orderList.add(this.parseSortSpecification());
        } while (this.readIf(109));
        return orderList;
    }

    private QueryOrderBy parseSortSpecification() {
        QueryOrderBy order = new QueryOrderBy();
        order.expression = this.readExpression();
        order.sortType = this.parseSortType();
        return order;
    }

    private Expression readUserDefinedFunctionIf(Schema schema, String functionName) {
        UserDefinedFunction userDefinedFunction = this.findUserDefinedFunctionWithinPath(schema, functionName);
        if (userDefinedFunction == null) {
            return null;
        }
        if (userDefinedFunction instanceof FunctionAlias) {
            FunctionAlias functionAlias = (FunctionAlias)userDefinedFunction;
            ArrayList<Expression> argList = Utils.newSmallArrayList();
            if (!this.readIf(106)) {
                do {
                    argList.add(this.readExpression());
                } while (this.readIfMore());
            }
            return new JavaFunction(functionAlias, argList.toArray(new Expression[0]));
        }
        UserAggregate aggregate = (UserAggregate)userDefinedFunction;
        boolean distinct = this.readDistinctAgg();
        ArrayList<Expression> params = Utils.newSmallArrayList();
        do {
            params.add(this.readExpression());
        } while (this.readIfMore());
        Expression[] list = params.toArray(new Expression[0]);
        JavaAggregate agg = new JavaAggregate(aggregate, list, this.currentSelect, distinct);
        this.readFilterAndOver(agg);
        return agg;
    }

    private boolean readDistinctAgg() {
        if (this.readIf(26)) {
            return true;
        }
        this.readIf(3);
        return false;
    }

    private void readFilterAndOver(AbstractAggregate aggregate) {
        if (this.readIf("FILTER", 105, 87)) {
            Expression filterCondition = this.readExpression();
            this.read(106);
            aggregate.setFilterCondition(filterCondition);
        }
        this.readOver(aggregate);
    }

    private void readOver(DataAnalysisOperation operation) {
        if (this.readIf("OVER")) {
            operation.setOverCondition(this.readWindowNameOrSpecification());
            this.currentSelect.setWindowQuery();
        } else if (operation.isAggregate()) {
            this.currentSelect.setGroupQuery();
        } else {
            throw this.getSyntaxError();
        }
    }

    private Window readWindowNameOrSpecification() {
        return this.isToken(105) ? this.readWindowSpecification() : new Window(this.readIdentifier(), null, null, null);
    }

    private Window readWindowSpecification() {
        this.read(105);
        String parent = null;
        if (this.currentTokenType == 2) {
            String current = this.currentToken;
            if (this.token.isQuoted() || !this.equalsToken(current, "PARTITION") && !this.equalsToken(current, "ROWS") && !this.equalsToken(current, "RANGE") && !this.equalsToken(current, "GROUPS")) {
                parent = current;
                this.read();
            }
        }
        ArrayList<Expression> partitionBy = null;
        if (this.readIf("PARTITION", "BY")) {
            partitionBy = Utils.newSmallArrayList();
            do {
                Expression expr = this.readExpression();
                partitionBy.add(expr);
            } while (this.readIf(109));
        }
        ArrayList<QueryOrderBy> orderBy = this.readIfOrderBy();
        WindowFrame frame = this.readWindowFrame();
        this.read(106);
        return new Window(parent, partitionBy, orderBy, frame);
    }

    private WindowFrame readWindowFrame() {
        WindowFrame frame;
        WindowFrameBound following;
        WindowFrameBound starting;
        WindowFrameUnits units;
        if (this.readIf("ROWS")) {
            units = WindowFrameUnits.ROWS;
        } else if (this.readIf("RANGE")) {
            units = WindowFrameUnits.RANGE;
        } else if (this.readIf("GROUPS")) {
            units = WindowFrameUnits.GROUPS;
        } else {
            return null;
        }
        if (this.readIf(10)) {
            starting = this.readWindowFrameRange();
            this.read(4);
            following = this.readWindowFrameRange();
        } else {
            starting = this.readWindowFrameStarting();
            following = null;
        }
        int sqlIndex = this.token.start();
        WindowFrameExclusion exclusion = WindowFrameExclusion.EXCLUDE_NO_OTHERS;
        if (this.readIf("EXCLUDE")) {
            if (this.readIf("CURRENT", 66)) {
                exclusion = WindowFrameExclusion.EXCLUDE_CURRENT_ROW;
            } else if (this.readIf(37)) {
                exclusion = WindowFrameExclusion.EXCLUDE_GROUP;
            } else if (this.readIf("TIES")) {
                exclusion = WindowFrameExclusion.EXCLUDE_TIES;
            } else {
                this.read("NO");
                this.read("OTHERS");
            }
        }
        if (!(frame = new WindowFrame(units, starting, following, exclusion)).isValid()) {
            throw DbException.getSyntaxError(this.sqlCommand, sqlIndex);
        }
        return frame;
    }

    private WindowFrameBound readWindowFrameStarting() {
        if (this.readIf("UNBOUNDED")) {
            this.read("PRECEDING");
            return new WindowFrameBound(WindowFrameBoundType.UNBOUNDED_PRECEDING, null);
        }
        if (this.readIf("CURRENT")) {
            this.read(66);
            return new WindowFrameBound(WindowFrameBoundType.CURRENT_ROW, null);
        }
        Expression value = this.readExpression();
        this.read("PRECEDING");
        return new WindowFrameBound(WindowFrameBoundType.PRECEDING, value);
    }

    private WindowFrameBound readWindowFrameRange() {
        if (this.readIf("UNBOUNDED")) {
            if (this.readIf("PRECEDING")) {
                return new WindowFrameBound(WindowFrameBoundType.UNBOUNDED_PRECEDING, null);
            }
            this.read("FOLLOWING");
            return new WindowFrameBound(WindowFrameBoundType.UNBOUNDED_FOLLOWING, null);
        }
        if (this.readIf("CURRENT")) {
            this.read(66);
            return new WindowFrameBound(WindowFrameBoundType.CURRENT_ROW, null);
        }
        Expression value = this.readExpression();
        if (this.readIf("PRECEDING")) {
            return new WindowFrameBound(WindowFrameBoundType.PRECEDING, value);
        }
        this.read("FOLLOWING");
        return new WindowFrameBound(WindowFrameBoundType.FOLLOWING, value);
    }

    private Expression readFunction(Schema schema, String name) {
        Expression e;
        String upperName = this.upperName(name);
        if (schema != null) {
            return this.readFunctionWithSchema(schema, name, upperName);
        }
        boolean allowOverride = this.database.isAllowBuiltinAliasOverride();
        if (allowOverride && (e = this.readUserDefinedFunctionIf(null, name)) != null) {
            return e;
        }
        AggregateType agg = Aggregate.getAggregateType(upperName);
        if (agg != null) {
            return this.readAggregate(agg, upperName);
        }
        Expression e2 = this.readBuiltinFunctionIf(upperName);
        if (e2 != null) {
            return e2;
        }
        e2 = this.readWindowFunction(upperName);
        if (e2 != null) {
            return e2;
        }
        e2 = this.readCompatibilityFunction(upperName);
        if (e2 != null) {
            return e2;
        }
        if (!allowOverride && (e2 = this.readUserDefinedFunctionIf(null, name)) != null) {
            return e2;
        }
        throw DbException.get(90022, name);
    }

    private Expression readFunctionWithSchema(Schema schema, String name, String upperName) {
        Expression function;
        if (this.database.getMode().getEnum() == Mode.ModeEnum.PostgreSQL && schema.getName().equals(this.database.sysIdentifier("PG_CATALOG")) && (function = FunctionsPostgreSQL.getFunction(upperName)) != null) {
            return this.readParameters(function);
        }
        function = this.readUserDefinedFunctionIf(schema, name);
        if (function != null) {
            return function;
        }
        throw DbException.get(90022, name);
    }

    private Expression readCompatibilityFunction(String name) {
        switch (name) {
            case "ARRAY_APPEND": 
            case "ARRAY_CAT": {
                return new ConcatenationOperation(this.readExpression(), this.readLastArgument());
            }
            case "ARRAY_GET": {
                return new ArrayElementReference(this.readExpression(), this.readLastArgument());
            }
            case "ARRAY_LENGTH": {
                return new CardinalityExpression(this.readSingleArgument(), false);
            }
            case "DECODE": {
                SimpleCase.SimpleWhen when;
                Expression caseOperand = this.readExpression();
                boolean canOptimize = caseOperand.isConstant() && !caseOperand.getValue(this.session).containsNull();
                Expression a = this.readNextArgument();
                Expression b = this.readNextArgument();
                SimpleCase.SimpleWhen current = when = this.decodeToWhen(caseOperand, canOptimize, a, b);
                Expression elseResult = null;
                while (this.readIf(109)) {
                    a = this.readExpression();
                    if (this.readIf(109)) {
                        b = this.readExpression();
                        SimpleCase.SimpleWhen next = this.decodeToWhen(caseOperand, canOptimize, a, b);
                        current.setWhen(next);
                        current = next;
                        continue;
                    }
                    elseResult = a;
                    break;
                }
                this.read(106);
                return new SimpleCase(caseOperand, when, elseResult);
            }
            case "CASEWHEN": {
                return this.readCompatibilityCase(this.readExpression());
            }
            case "NVL2": {
                return this.readCompatibilityCase(new NullPredicate(this.readExpression(), true, false));
            }
            case "CONVERT": {
                Expression arg;
                Column column;
                if (this.database.getMode().swapConvertFunctionParameters) {
                    column = this.parseColumnWithType(null);
                    arg = this.readNextArgument();
                } else {
                    arg = this.readExpression();
                    this.read(109);
                    column = this.parseColumnWithType(null);
                }
                this.read(106);
                return new CastSpecification(arg, column);
            }
            case "IFNULL": {
                return new CoalesceFunction(0, this.readExpression(), this.readLastArgument());
            }
            case "NVL": {
                return this.readCoalesceFunction(0);
            }
            case "DATABASE": {
                this.read(106);
                return new CurrentGeneralValueSpecification(0);
            }
            case "CURDATE": {
                return this.readCurrentDateTimeValueFunction(0, true, name);
            }
            case "TODAY": {
                this.read(106);
                return ModeFunction.getCompatibilityDateTimeValueFunction(this.database, "TODAY", -1);
            }
            case "SCHEMA": {
                this.read(106);
                return new CurrentGeneralValueSpecification(3);
            }
            case "SYSTIMESTAMP": {
                int scale = -1;
                if (!this.readIf(106)) {
                    scale = this.readInt();
                    if (scale < 0 || scale > 9) {
                        throw DbException.get(90151, Integer.toString(scale), "0", "9");
                    }
                    this.read(106);
                }
                return ModeFunction.getCompatibilityDateTimeValueFunction(this.database, "SYSTIMESTAMP", scale);
            }
            case "DAY_OF_MONTH": 
            case "DAY": 
            case "DAYOFMONTH": {
                return new DateTimeFunction(0, 2, this.readSingleArgument(), null);
            }
            case "DAYOFWEEK": 
            case "DAY_OF_WEEK": {
                return new DateTimeFunction(0, 20, this.readSingleArgument(), null);
            }
            case "DAYOFYEAR": 
            case "DAY_OF_YEAR": {
                return new DateTimeFunction(0, 16, this.readSingleArgument(), null);
            }
            case "HOUR": {
                return new DateTimeFunction(0, 3, this.readSingleArgument(), null);
            }
            case "ISO_DAY_OF_WEEK": {
                return new DateTimeFunction(0, 17, this.readSingleArgument(), null);
            }
            case "ISO_WEEK": {
                return new DateTimeFunction(0, 18, this.readSingleArgument(), null);
            }
            case "ISO_YEAR": {
                return new DateTimeFunction(0, 19, this.readSingleArgument(), null);
            }
            case "MINUTE": {
                return new DateTimeFunction(0, 4, this.readSingleArgument(), null);
            }
            case "MONTH": {
                return new DateTimeFunction(0, 1, this.readSingleArgument(), null);
            }
            case "QUARTER": {
                return new DateTimeFunction(0, 12, this.readSingleArgument(), null);
            }
            case "SECOND": {
                return new DateTimeFunction(0, 5, this.readSingleArgument(), null);
            }
            case "WEEK": {
                return new DateTimeFunction(0, 21, this.readSingleArgument(), null);
            }
            case "YEAR": {
                return new DateTimeFunction(0, 0, this.readSingleArgument(), null);
            }
            case "CURTIME": {
                return this.readCurrentDateTimeValueFunction(2, true, "CURTIME");
            }
            case "NOW": {
                return this.readCurrentDateTimeValueFunction(4, true, "NOW");
            }
            case "SYSDATE": {
                this.read(106);
                return ModeFunction.getCompatibilityDateTimeValueFunction(this.database, "SYSDATE", -1);
            }
            case "INSTR": {
                Expression arg1 = this.readExpression();
                return new StringFunction(this.readNextArgument(), arg1, this.readIfArgument(), 0);
            }
            case "POSITION": {
                Expression arg1 = this.readConcat();
                if (!this.readIf(109)) {
                    this.read(41);
                }
                return new StringFunction(arg1, this.readSingleArgument(), null, 0);
            }
            case "LCASE": {
                return new StringFunction1(this.readSingleArgument(), 1);
            }
            case "SUBSTR": {
                return this.readSubstringFunction();
            }
            case "UCASE": {
                return new StringFunction1(this.readSingleArgument(), 0);
            }
            case "CURRVAL": {
                return this.readCompatibilitySequenceValueFunction(true);
            }
            case "NEXTVAL": {
                return this.readCompatibilitySequenceValueFunction(false);
            }
        }
        return null;
    }

    private <T extends ExpressionWithVariableParameters> T readParameters(T expression) {
        if (!this.readIf(106)) {
            do {
                expression.addParameter(this.readExpression());
            } while (this.readIfMore());
        }
        expression.doneWithParameters();
        return expression;
    }

    private SimpleCase.SimpleWhen decodeToWhen(Expression caseOperand, boolean canOptimize, Expression whenOperand, Expression result) {
        if (!(canOptimize || whenOperand.isConstant() && !whenOperand.getValue(this.session).containsNull())) {
            whenOperand = new Comparison(6, caseOperand, whenOperand, true);
        }
        return new SimpleCase.SimpleWhen(whenOperand, result);
    }

    private Expression readCompatibilityCase(Expression when) {
        return new SearchedCase(new Expression[]{when, this.readNextArgument(), this.readLastArgument()});
    }

    private Expression readCompatibilitySequenceValueFunction(boolean current) {
        Expression arg1 = this.readExpression();
        Expression arg2 = this.readIf(109) ? this.readExpression() : null;
        this.read(106);
        return new CompatibilitySequenceValueFunction(arg1, arg2, current);
    }

    private Expression readBuiltinFunctionIf(String upperName) {
        switch (upperName) {
            case "ABS": {
                return new MathFunction(this.readSingleArgument(), null, 0);
            }
            case "MOD": {
                return new MathFunction(this.readExpression(), this.readLastArgument(), 1);
            }
            case "SIN": {
                return new MathFunction1(this.readSingleArgument(), 0);
            }
            case "COS": {
                return new MathFunction1(this.readSingleArgument(), 1);
            }
            case "TAN": {
                return new MathFunction1(this.readSingleArgument(), 2);
            }
            case "COT": {
                return new MathFunction1(this.readSingleArgument(), 3);
            }
            case "SINH": {
                return new MathFunction1(this.readSingleArgument(), 4);
            }
            case "COSH": {
                return new MathFunction1(this.readSingleArgument(), 5);
            }
            case "TANH": {
                return new MathFunction1(this.readSingleArgument(), 6);
            }
            case "ASIN": {
                return new MathFunction1(this.readSingleArgument(), 7);
            }
            case "ACOS": {
                return new MathFunction1(this.readSingleArgument(), 8);
            }
            case "ATAN": {
                return new MathFunction1(this.readSingleArgument(), 9);
            }
            case "ATAN2": {
                return new MathFunction2(this.readExpression(), this.readLastArgument(), 0);
            }
            case "LOG": {
                Expression arg1 = this.readExpression();
                if (this.readIf(109)) {
                    return new MathFunction2(arg1, this.readSingleArgument(), 1);
                }
                this.read(106);
                return new MathFunction1(arg1, this.database.getMode().logIsLogBase10 ? 10 : 11);
            }
            case "LOG10": {
                return new MathFunction1(this.readSingleArgument(), 10);
            }
            case "LN": {
                return new MathFunction1(this.readSingleArgument(), 11);
            }
            case "EXP": {
                return new MathFunction1(this.readSingleArgument(), 12);
            }
            case "POWER": {
                return new MathFunction2(this.readExpression(), this.readLastArgument(), 2);
            }
            case "SQRT": {
                return new MathFunction1(this.readSingleArgument(), 13);
            }
            case "FLOOR": {
                return new MathFunction(this.readSingleArgument(), null, 2);
            }
            case "CEIL": 
            case "CEILING": {
                return new MathFunction(this.readSingleArgument(), null, 3);
            }
            case "ROUND": {
                return new MathFunction(this.readExpression(), this.readIfArgument(), 4);
            }
            case "ROUNDMAGIC": {
                return new MathFunction(this.readSingleArgument(), null, 5);
            }
            case "SIGN": {
                return new MathFunction(this.readSingleArgument(), null, 6);
            }
            case "TRUNCATE": 
            case "TRUNC": {
                return new MathFunction(this.readExpression(), this.readIfArgument(), 7);
            }
            case "DEGREES": {
                return new MathFunction1(this.readSingleArgument(), 14);
            }
            case "RADIANS": {
                return new MathFunction1(this.readSingleArgument(), 15);
            }
            case "BITAND": {
                return new BitFunction(this.readExpression(), this.readLastArgument(), 0);
            }
            case "BITOR": {
                return new BitFunction(this.readExpression(), this.readLastArgument(), 1);
            }
            case "BITXOR": {
                return new BitFunction(this.readExpression(), this.readLastArgument(), 2);
            }
            case "BITNOT": {
                return new BitFunction(this.readSingleArgument(), null, 3);
            }
            case "BITNAND": {
                return new BitFunction(this.readExpression(), this.readLastArgument(), 4);
            }
            case "BITNOR": {
                return new BitFunction(this.readExpression(), this.readLastArgument(), 5);
            }
            case "BITXNOR": {
                return new BitFunction(this.readExpression(), this.readLastArgument(), 6);
            }
            case "BITGET": {
                return new BitFunction(this.readExpression(), this.readLastArgument(), 7);
            }
            case "BITCOUNT": {
                return new BitFunction(this.readSingleArgument(), null, 8);
            }
            case "LSHIFT": {
                return new BitFunction(this.readExpression(), this.readLastArgument(), 9);
            }
            case "RSHIFT": {
                return new BitFunction(this.readExpression(), this.readLastArgument(), 10);
            }
            case "ULSHIFT": {
                return new BitFunction(this.readExpression(), this.readLastArgument(), 11);
            }
            case "URSHIFT": {
                return new BitFunction(this.readExpression(), this.readLastArgument(), 12);
            }
            case "ROTATELEFT": {
                return new BitFunction(this.readExpression(), this.readLastArgument(), 13);
            }
            case "ROTATERIGHT": {
                return new BitFunction(this.readExpression(), this.readLastArgument(), 14);
            }
            case "EXTRACT": {
                int field = this.readDateTimeField();
                this.read(35);
                return new DateTimeFunction(0, field, this.readSingleArgument(), null);
            }
            case "DATE_TRUNC": {
                return new DateTimeFunction(1, this.readDateTimeField(), this.readLastArgument(), null);
            }
            case "DATEADD": 
            case "TIMESTAMPADD": {
                return new DateTimeFunction(2, this.readDateTimeField(), this.readNextArgument(), this.readLastArgument());
            }
            case "DATEDIFF": 
            case "TIMESTAMPDIFF": {
                return new DateTimeFunction(3, this.readDateTimeField(), this.readNextArgument(), this.readLastArgument());
            }
            case "LAST_DAY": {
                return new DateTimeFunction(4, -1, this.readSingleArgument(), null);
            }
            case "FORMATDATETIME": {
                return this.readDateTimeFormatFunction(0);
            }
            case "PARSEDATETIME": {
                return this.readDateTimeFormatFunction(1);
            }
            case "DAYNAME": {
                return new DayMonthNameFunction(this.readSingleArgument(), 0);
            }
            case "MONTHNAME": {
                return new DayMonthNameFunction(this.readSingleArgument(), 1);
            }
            case "CARDINALITY": {
                return new CardinalityExpression(this.readSingleArgument(), false);
            }
            case "ARRAY_MAX_CARDINALITY": {
                return new CardinalityExpression(this.readSingleArgument(), true);
            }
            case "LOCATE": {
                return new StringFunction(this.readExpression(), this.readNextArgument(), this.readIfArgument(), 0);
            }
            case "INSERT": {
                return new StringFunction(this.readExpression(), this.readNextArgument(), this.readNextArgument(), this.readLastArgument(), 1);
            }
            case "REPLACE": {
                return new StringFunction(this.readExpression(), this.readNextArgument(), this.readIfArgument(), 2);
            }
            case "LPAD": {
                return new StringFunction(this.readExpression(), this.readNextArgument(), this.readIfArgument(), 3);
            }
            case "RPAD": {
                return new StringFunction(this.readExpression(), this.readNextArgument(), this.readIfArgument(), 4);
            }
            case "TRANSLATE": {
                return new StringFunction(this.readExpression(), this.readNextArgument(), this.readLastArgument(), 5);
            }
            case "UPPER": {
                return new StringFunction1(this.readSingleArgument(), 0);
            }
            case "LOWER": {
                return new StringFunction1(this.readSingleArgument(), 1);
            }
            case "ASCII": {
                return new StringFunction1(this.readSingleArgument(), 2);
            }
            case "CHR": 
            case "CHAR": {
                return new StringFunction1(this.readSingleArgument(), 3);
            }
            case "STRINGENCODE": {
                return new StringFunction1(this.readSingleArgument(), 4);
            }
            case "STRINGDECODE": {
                return new StringFunction1(this.readSingleArgument(), 5);
            }
            case "STRINGTOUTF8": {
                return new StringFunction1(this.readSingleArgument(), 6);
            }
            case "UTF8TOSTRING": {
                return new StringFunction1(this.readSingleArgument(), 7);
            }
            case "HEXTORAW": {
                return new StringFunction1(this.readSingleArgument(), 8);
            }
            case "RAWTOHEX": {
                return new StringFunction1(this.readSingleArgument(), 9);
            }
            case "SPACE": {
                return new StringFunction1(this.readSingleArgument(), 10);
            }
            case "QUOTE_IDENT": {
                return new StringFunction1(this.readSingleArgument(), 11);
            }
            case "SUBSTRING": {
                return this.readSubstringFunction();
            }
            case "TO_CHAR": {
                Expression arg3;
                Expression arg2;
                Expression arg1 = this.readExpression();
                if (this.readIf(109)) {
                    arg2 = this.readExpression();
                    arg3 = this.readIf(109) ? this.readExpression() : null;
                } else {
                    arg2 = null;
                    arg3 = null;
                }
                this.read(106);
                return new ToCharFunction(arg1, arg2, arg3);
            }
            case "REPEAT": {
                return new StringFunction2(this.readExpression(), this.readLastArgument(), 2);
            }
            case "LENGTH": 
            case "CHARACTER_LENGTH": 
            case "CHAR_LENGTH": {
                return new LengthFunction(this.readIfSingleArgument(), 0);
            }
            case "OCTET_LENGTH": {
                return new LengthFunction(this.readIfSingleArgument(), 1);
            }
            case "BIT_LENGTH": {
                return new LengthFunction(this.readIfSingleArgument(), 2);
            }
            case "TRIM": {
                return this.readTrimFunction();
            }
            case "LTRIM": {
                return new TrimFunction(this.readExpression(), this.readIfArgument(), 5);
            }
            case "RTRIM": {
                return new TrimFunction(this.readExpression(), this.readIfArgument(), 6);
            }
            case "BTRIM": {
                return new TrimFunction(this.readExpression(), this.readIfArgument(), 7);
            }
            case "REGEXP_LIKE": {
                return this.readParameters(new RegexpFunction(0));
            }
            case "REGEXP_REPLACE": {
                return this.readParameters(new RegexpFunction(1));
            }
            case "REGEXP_SUBSTR": {
                return this.readParameters(new RegexpFunction(2));
            }
            case "XMLATTR": {
                return this.readParameters(new XMLFunction(0));
            }
            case "XMLCDATA": {
                return this.readParameters(new XMLFunction(1));
            }
            case "XMLCOMMENT": {
                return this.readParameters(new XMLFunction(2));
            }
            case "XMLNODE": {
                return this.readParameters(new XMLFunction(3));
            }
            case "XMLSTARTDOC": {
                return this.readParameters(new XMLFunction(4));
            }
            case "XMLTEXT": {
                return this.readParameters(new XMLFunction(5));
            }
            case "TRIM_ARRAY": {
                return new ArrayFunction(this.readExpression(), this.readLastArgument(), null, 0);
            }
            case "ARRAY_CONTAINS": {
                return new ArrayFunction(this.readExpression(), this.readLastArgument(), null, 1);
            }
            case "ARRAY_SLICE": {
                return new ArrayFunction(this.readExpression(), this.readNextArgument(), this.readLastArgument(), 2);
            }
            case "COMPRESS": {
                return new CompressFunction(this.readExpression(), this.readIfArgument(), 0);
            }
            case "EXPAND": {
                return new CompressFunction(this.readSingleArgument(), null, 1);
            }
            case "SOUNDEX": {
                return new SoundexFunction(this.readSingleArgument(), null, 0);
            }
            case "DIFFERENCE": {
                return new SoundexFunction(this.readExpression(), this.readLastArgument(), 1);
            }
            case "JSON_OBJECT": {
                JsonConstructorFunction function = new JsonConstructorFunction(false);
                if (this.currentTokenType != 106 && !this.readJsonObjectFunctionFlags(function, false)) {
                    do {
                        boolean withKey = this.readIf(47);
                        function.addParameter(this.readExpression());
                        if (withKey) {
                            this.read(84);
                        } else if (!(this.readIf(84) || this.database.getMode().acceptsCommaAsJsonKeyValueSeparator && this.readIf(109))) {
                            this.read(116);
                        }
                        function.addParameter(this.readExpression());
                    } while (this.readIf(109));
                    this.readJsonObjectFunctionFlags(function, false);
                }
                this.read(106);
                function.doneWithParameters();
                return function;
            }
            case "JSON_ARRAY": {
                JsonConstructorFunction function = new JsonConstructorFunction(true);
                function.setFlags(1);
                if (this.currentTokenType != 106 && !this.readJsonObjectFunctionFlags(function, true)) {
                    do {
                        function.addParameter(this.readExpression());
                    } while (this.readIf(109));
                    this.readJsonObjectFunctionFlags(function, true);
                }
                this.read(106);
                function.doneWithParameters();
                return function;
            }
            case "ENCRYPT": {
                return new CryptFunction(this.readExpression(), this.readNextArgument(), this.readLastArgument(), 0);
            }
            case "DECRYPT": {
                return new CryptFunction(this.readExpression(), this.readNextArgument(), this.readLastArgument(), 1);
            }
            case "COALESCE": {
                return this.readCoalesceFunction(0);
            }
            case "GREATEST": {
                return this.readCoalesceFunction(1);
            }
            case "LEAST": {
                return this.readCoalesceFunction(2);
            }
            case "NULLIF": {
                return new NullIfFunction(this.readExpression(), this.readLastArgument());
            }
            case "CONCAT": {
                return this.readConcatFunction(0);
            }
            case "CONCAT_WS": {
                return this.readConcatFunction(1);
            }
            case "HASH": {
                return new HashFunction(this.readExpression(), this.readNextArgument(), this.readIfArgument(), 0);
            }
            case "ORA_HASH": {
                Expression arg1 = this.readExpression();
                if (this.readIfMore()) {
                    return new HashFunction(arg1, this.readExpression(), this.readIfArgument(), 1);
                }
                return new HashFunction(arg1, 1);
            }
            case "RANDOM": 
            case "RAND": {
                return new RandFunction(this.readIfSingleArgument(), 0);
            }
            case "SECURE_RAND": {
                return new RandFunction(this.readSingleArgument(), 1);
            }
            case "UUID": 
            case "RANDOM_UUID": {
                this.read(106);
                return new RandFunction(null, 2);
            }
            case "ABORT_SESSION": {
                return new SessionControlFunction(this.readIfSingleArgument(), 0);
            }
            case "CANCEL_SESSION": {
                return new SessionControlFunction(this.readIfSingleArgument(), 1);
            }
            case "AUTOCOMMIT": {
                this.read(106);
                return new SysInfoFunction(0);
            }
            case "DATABASE_PATH": {
                this.read(106);
                return new SysInfoFunction(1);
            }
            case "H2VERSION": {
                this.read(106);
                return new SysInfoFunction(2);
            }
            case "LOCK_MODE": {
                this.read(106);
                return new SysInfoFunction(3);
            }
            case "LOCK_TIMEOUT": {
                this.read(106);
                return new SysInfoFunction(4);
            }
            case "MEMORY_FREE": {
                this.read(106);
                return new SysInfoFunction(5);
            }
            case "MEMORY_USED": {
                this.read(106);
                return new SysInfoFunction(6);
            }
            case "READONLY": {
                this.read(106);
                return new SysInfoFunction(7);
            }
            case "SESSION_ID": {
                this.read(106);
                return new SysInfoFunction(8);
            }
            case "TRANSACTION_ID": {
                this.read(106);
                return new SysInfoFunction(9);
            }
            case "DISK_SPACE_USED": {
                return new TableInfoFunction(this.readIfSingleArgument(), null, 0);
            }
            case "ESTIMATED_ENVELOPE": {
                return new TableInfoFunction(this.readExpression(), this.readLastArgument(), 1);
            }
            case "FILE_READ": {
                return new FileFunction(this.readExpression(), this.readIfArgument(), 0);
            }
            case "FILE_WRITE": {
                return new FileFunction(this.readExpression(), this.readLastArgument(), 1);
            }
            case "DATA_TYPE_SQL": {
                return new DataTypeSQLFunction(this.readExpression(), this.readNextArgument(), this.readNextArgument(), this.readLastArgument());
            }
            case "DB_OBJECT_ID": {
                return this.readDbObjectFunction(0);
            }
            case "DB_OBJECT_SQL": {
                return this.readDbObjectFunction(1);
            }
            case "DB_OBJECT_SIZE": {
                return this.readDbObjectFunction(2);
            }
            case "DB_OBJECT_TOTAL_SIZE": {
                return this.readDbObjectFunction(3);
            }
            case "CSVWRITE": {
                return this.readParameters(new CSVWriteFunction());
            }
            case "SIGNAL": {
                return new SignalFunction(this.readExpression(), this.readLastArgument());
            }
            case "TRUNCATE_VALUE": {
                return new TruncateValueFunction(this.readExpression(), this.readNextArgument(), this.readLastArgument());
            }
            case "ZERO": {
                this.read(106);
                return ValueExpression.get(ValueInteger.get(0));
            }
            case "PI": {
                this.read(106);
                return ValueExpression.get(ValueDouble.get(Math.PI));
            }
        }
        ModeFunction function = ModeFunction.getFunction(this.database, upperName);
        return function != null ? (Expression)this.readParameters(function) : null;
    }

    private Expression readDateTimeFormatFunction(int function) {
        DateTimeFormatFunction f = new DateTimeFormatFunction(function);
        f.addParameter(this.readExpression());
        this.read(109);
        f.addParameter(this.readExpression());
        if (this.readIf(109)) {
            f.addParameter(this.readExpression());
            if (this.readIf(109)) {
                f.addParameter(this.readExpression());
            }
        }
        this.read(106);
        f.doneWithParameters();
        return f;
    }

    private Expression readTrimFunction() {
        Expression from;
        int flags;
        boolean needFrom = false;
        if (this.readIf("LEADING")) {
            flags = 1;
            needFrom = true;
        } else if (this.readIf("TRAILING")) {
            flags = 2;
            needFrom = true;
        } else {
            needFrom = this.readIf("BOTH");
            flags = 3;
        }
        Expression space = null;
        if (needFrom) {
            if (!this.readIf(35)) {
                space = this.readExpression();
                this.read(35);
            }
            from = this.readExpression();
        } else if (this.readIf(35)) {
            from = this.readExpression();
        } else {
            from = this.readExpression();
            if (this.readIf(35)) {
                space = from;
                from = this.readExpression();
            } else if (this.readIfCompat(109)) {
                space = this.readExpression();
            }
        }
        this.read(106);
        return new TrimFunction(from, space, flags);
    }

    private Expression readDbObjectFunction(int function) {
        return new DBObjectFunction(this.readExpression(), this.readNextArgument(), this.readIfArgument(), function);
    }

    private ArrayTableFunction readUnnestFunction() {
        ArrayTableFunction f = new ArrayTableFunction(0);
        ArrayList<Column> columns = Utils.newSmallArrayList();
        if (!this.readIf(106)) {
            int i = 0;
            do {
                Expression expr = this.readExpression();
                TypeInfo columnType = TypeInfo.TYPE_NULL;
                TypeInfo exprType = expr.getTypeIfStaticallyKnown(this.session);
                if (exprType != null) {
                    switch (exprType.getValueType()) {
                        case 38: {
                            columnType = TypeInfo.TYPE_JSON;
                            break;
                        }
                        case 40: {
                            columnType = (TypeInfo)exprType.getExtTypeInfo();
                        }
                    }
                }
                f.addParameter(expr);
                columns.add(new Column("C" + ++i, columnType));
            } while (this.readIfMore());
        }
        if (this.readIf(89, "ORDINALITY")) {
            columns.add(new Column("NORD", TypeInfo.TYPE_INTEGER));
        }
        f.setColumns(columns);
        f.doneWithParameters();
        return f;
    }

    private ArrayTableFunction readTableFunction(int functionType) {
        ArrayTableFunction f = new ArrayTableFunction(functionType);
        ArrayList<Column> columns = Utils.newSmallArrayList();
        do {
            columns.add(this.parseColumnWithType(this.readIdentifier()));
            this.read(95);
            f.addParameter(this.readExpression());
        } while (this.readIfMore());
        f.setColumns(columns);
        f.doneWithParameters();
        return f;
    }

    private Expression readSingleArgument() {
        Expression arg = this.readExpression();
        this.read(106);
        return arg;
    }

    private Expression readNextArgument() {
        this.read(109);
        return this.readExpression();
    }

    private Expression readLastArgument() {
        this.read(109);
        Expression arg = this.readExpression();
        this.read(106);
        return arg;
    }

    private Expression readIfSingleArgument() {
        Expression arg;
        if (this.readIf(106)) {
            arg = null;
        } else {
            arg = this.readExpression();
            this.read(106);
        }
        return arg;
    }

    private Expression readIfArgument() {
        Expression arg = this.readIf(109) ? this.readExpression() : null;
        this.read(106);
        return arg;
    }

    private Expression readCoalesceFunction(int function) {
        CoalesceFunction f = new CoalesceFunction(function);
        f.addParameter(this.readExpression());
        while (this.readIfMore()) {
            f.addParameter(this.readExpression());
        }
        if (function == 1 || function == 2) {
            f.setIgnoreNulls(this.readIgnoreNulls(this.database.getMode().greatestLeastIgnoreNulls));
        }
        f.doneWithParameters();
        return f;
    }

    private Expression readConcatFunction(int function) {
        ConcatFunction f = new ConcatFunction(function);
        f.addParameter(this.readExpression());
        f.addParameter(this.readNextArgument());
        if (function == 1) {
            f.addParameter(this.readNextArgument());
        }
        while (this.readIfMore()) {
            f.addParameter(this.readExpression());
        }
        f.doneWithParameters();
        return f;
    }

    private Expression readSubstringFunction() {
        SubstringFunction function = new SubstringFunction();
        function.addParameter(this.readExpression());
        if (this.readIf(35)) {
            function.addParameter(this.readExpression());
            if (this.readIf(33)) {
                function.addParameter(this.readExpression());
            }
        } else if (this.readIf(33)) {
            function.addParameter(ValueExpression.get(ValueInteger.get(1)));
            function.addParameter(this.readExpression());
        } else {
            this.readCompat(109);
            function.addParameter(this.readExpression());
            if (this.readIf(109)) {
                function.addParameter(this.readExpression());
            }
        }
        this.read(106);
        function.doneWithParameters();
        return function;
    }

    private int readDateTimeField() {
        int field = -1;
        switch (this.currentTokenType) {
            case 2: {
                if (this.token.isQuoted()) break;
                field = DateTimeFunction.getField(this.currentToken);
                break;
            }
            case 94: {
                if (this.token.value(this.session).getValueType() != 2) break;
                field = DateTimeFunction.getField(this.token.value(this.session).getString());
                break;
            }
            case 90: {
                field = 0;
                break;
            }
            case 55: {
                field = 1;
                break;
            }
            case 24: {
                field = 2;
                break;
            }
            case 39: {
                field = 3;
                break;
            }
            case 54: {
                field = 4;
                break;
            }
            case 68: {
                field = 5;
            }
        }
        if (field < 0) {
            this.addExpected("date-time field");
            throw this.getSyntaxError();
        }
        this.read();
        return field;
    }

    private WindowFunction readWindowFunction(String name) {
        WindowFunctionType type = WindowFunctionType.get(name);
        if (type == null) {
            return null;
        }
        if (this.currentSelect == null) {
            throw this.getSyntaxError();
        }
        int numArgs = WindowFunction.getMinArgumentCount(type);
        Expression[] args = null;
        if (numArgs > 0) {
            int numArgsMax = WindowFunction.getMaxArgumentCount(type);
            args = new Expression[numArgsMax];
            if (numArgs == numArgsMax) {
                int i = 0;
                while (i < numArgs) {
                    if (i > 0) {
                        this.read(109);
                    }
                    args[i] = this.readExpression();
                    ++i;
                }
            } else {
                int i = 0;
                while (i < numArgsMax) {
                    if (i > 0 && !this.readIf(109)) break;
                    args[i] = this.readExpression();
                    ++i;
                }
                if (i < numArgs) {
                    throw this.getSyntaxError();
                }
                if (i != numArgsMax) {
                    args = Arrays.copyOf(args, i);
                }
            }
        }
        this.read(106);
        WindowFunction function = new WindowFunction(type, this.currentSelect, args);
        switch (type) {
            case NTH_VALUE: {
                this.readFromFirstOrLast(function);
            }
            case LEAD: 
            case LAG: 
            case FIRST_VALUE: 
            case LAST_VALUE: {
                function.setIgnoreNulls(this.readIgnoreNulls(false));
            }
        }
        this.readOver(function);
        return function;
    }

    private void readFromFirstOrLast(WindowFunction function) {
        if (this.readIf(35, "LAST")) {
            function.setFromLast(true);
        } else {
            this.readIf(35, "FIRST");
        }
    }

    private boolean readIgnoreNulls(boolean ignoreNulls) {
        if (this.readIf("IGNORE", "NULLS")) {
            return true;
        }
        if (this.readIf("RESPECT", "NULLS")) {
            return false;
        }
        return ignoreNulls;
    }

    private boolean readJsonObjectFunctionFlags(ExpressionWithFlags function, boolean forArray) {
        boolean result = false;
        int flags = function.getFlags();
        if (this.readIf(58, 60, 58)) {
            flags &= 0xFFFFFFFE;
            result = true;
        } else if (this.readIf("ABSENT", 60, 58)) {
            flags |= 1;
            result = true;
        }
        if (!forArray) {
            if (this.readIf(89, 80, "KEYS")) {
                flags |= 2;
                result = true;
            } else if (this.readIf("WITHOUT", 80, "KEYS")) {
                flags &= 0xFFFFFFFD;
                result = true;
            }
        }
        if (result) {
            function.setFlags(flags);
        }
        return result;
    }

    private Expression readKeywordCompatibilityFunctionOrColumn() {
        boolean nonKeyword = this.nonKeywords != null && this.nonKeywords.get(this.currentTokenType);
        String name = this.currentToken;
        this.read();
        if (this.readIf(105)) {
            return this.readCompatibilityFunction(this.upperName(name));
        }
        if (nonKeyword) {
            return this.readIf(110) ? this.readTermObjectDot(name) : new ExpressionColumn(this.database, null, null, name);
        }
        throw this.getSyntaxError();
    }

    private Expression readCurrentDateTimeValueFunction(int function, boolean hasParen, String name) {
        FunctionAlias functionAlias;
        int scale = -1;
        if (hasParen) {
            if (function != 0 && this.currentTokenType != 106 && ((scale = this.readInt()) < 0 || scale > 9)) {
                throw DbException.get(90151, Integer.toString(scale), "0", "9");
            }
            this.read(106);
        }
        if (this.database.isAllowBuiltinAliasOverride() && (functionAlias = this.database.getSchema(this.session.getCurrentSchemaName()).findFunction(name != null ? name : CurrentDateTimeValueFunction.getName(function))) != null) {
            Expression[] expressionArray;
            if (scale >= 0) {
                Expression[] expressionArray2 = new Expression[1];
                expressionArray = expressionArray2;
                expressionArray2[0] = ValueExpression.get(ValueInteger.get(scale));
            } else {
                expressionArray = new Expression[]{};
            }
            return new JavaFunction(functionAlias, expressionArray);
        }
        return new CurrentDateTimeValueFunction(function, scale);
    }

    private Expression readIfWildcardRowidOrSequencePseudoColumn(String schema, String objectName) {
        if (this.readIf(108)) {
            return this.parseWildcard(schema, objectName);
        }
        if (this.readIf(91)) {
            return new ExpressionColumn(this.database, schema, objectName);
        }
        if (this.database.getMode().nextvalAndCurrvalPseudoColumns) {
            return this.readIfSequencePseudoColumn(schema, objectName);
        }
        return null;
    }

    private Wildcard parseWildcard(String schema, String objectName) {
        Wildcard wildcard = new Wildcard(schema, objectName);
        if (this.readIf(29, 105)) {
            ArrayList<ExpressionColumn> exceptColumns = Utils.newSmallArrayList();
            do {
                String s = null;
                String t = null;
                String name = this.readIdentifier();
                if (this.readIf(110)) {
                    t = name;
                    name = this.readIdentifier();
                    if (this.readIf(110)) {
                        s = t;
                        t = name;
                        name = this.readIdentifier();
                        if (this.readIf(110)) {
                            this.checkDatabaseName(s);
                            s = t;
                            t = name;
                            name = this.readIdentifier();
                        }
                    }
                }
                exceptColumns.add(new ExpressionColumn(this.database, s, t, name));
            } while (this.readIfMore());
            wildcard.setExceptColumns(exceptColumns);
        }
        return wildcard;
    }

    private SequenceValue readIfSequencePseudoColumn(String schema, String objectName) {
        Sequence sequence;
        if (schema == null) {
            schema = this.session.getCurrentSchemaName();
        }
        if (this.isTokenCompat("NEXTVAL")) {
            Sequence sequence2 = this.findSequence(schema, objectName);
            if (sequence2 != null) {
                this.read();
                return new SequenceValue(sequence2, this.getCurrentPreparedOrSelect());
            }
        } else if (this.isTokenCompat("CURRVAL") && (sequence = this.findSequence(schema, objectName)) != null) {
            this.read();
            return new SequenceValue(sequence);
        }
        return null;
    }

    private Expression readTermObjectDot(String objectName) {
        Expression expr = this.readIfWildcardRowidOrSequencePseudoColumn(null, objectName);
        if (expr != null) {
            return expr;
        }
        String name = this.readIdentifier();
        if (this.readIf(105)) {
            return this.readFunction(this.database.getSchema(objectName), name);
        }
        if (this.readIf(110)) {
            String schema = objectName;
            expr = this.readIfWildcardRowidOrSequencePseudoColumn(schema, objectName = name);
            if (expr != null) {
                return expr;
            }
            name = this.readIdentifier();
            if (this.readIf(105)) {
                this.checkDatabaseName(schema);
                return this.readFunction(this.database.getSchema(objectName), name);
            }
            if (this.readIf(110)) {
                this.checkDatabaseName(schema);
                schema = objectName;
                objectName = name;
                expr = this.readIfWildcardRowidOrSequencePseudoColumn(schema, objectName);
                if (expr != null) {
                    return expr;
                }
                name = this.readIdentifier();
            }
            return new ExpressionColumn(this.database, schema, objectName, name);
        }
        return new ExpressionColumn(this.database, null, objectName, name);
    }

    private void checkDatabaseName(String databaseName) {
        if (!this.database.getIgnoreCatalogs() && !this.equalsToken(this.database.getShortName(), databaseName)) {
            throw DbException.get(90013, databaseName);
        }
    }

    private Expression readTerm() {
        Expression r;
        block8: {
            int index;
            Expression expression = r = this.currentTokenType == 2 ? this.readTermWithIdentifier() : this.readTermWithoutIdentifier();
            while (true) {
                if (this.readIf(117)) {
                    r = new ArrayElementReference(r, this.readExpression());
                    this.read(118);
                    continue;
                }
                if (this.readIf(110)) {
                    r = new FieldReference(r, this.readIdentifier());
                    continue;
                }
                if (this.readIf(120)) {
                    r = this.readColonColonAfterTerm(r);
                    continue;
                }
                TypeInfo ti = this.readIntervalQualifier();
                if (ti != null) {
                    r = new CastSpecification(r, ti);
                    continue;
                }
                index = this.tokenIndex;
                if (this.readIf("AT")) {
                    if (this.readIf("TIME", "ZONE")) {
                        r = new TimeZoneOperation(r, this.readExpression());
                        continue;
                    }
                    if (this.readIf("LOCAL")) {
                        r = new TimeZoneOperation(r, null);
                        continue;
                    }
                    this.setTokenIndex(index);
                    break block8;
                }
                if (!this.readIf("FORMAT")) break block8;
                if (!this.readIf("JSON")) break;
                r = new Format(r, Format.FormatEnum.JSON);
            }
            this.setTokenIndex(index);
        }
        return r;
    }

    private Expression readTermWithoutIdentifier() {
        Expression r;
        switch (this.currentTokenType) {
            case 101: {
                this.read();
                r = new Variable(this.session, this.readIdentifier());
                if (!this.readIf(121)) break;
                r = new SetFunction(r, this.readExpression());
                break;
            }
            case 92: {
                r = this.readParameter();
                break;
            }
            case 69: 
            case 75: 
            case 89: {
                r = new Subquery(this.parseQuery());
                break;
            }
            case 102: {
                this.read();
                if (this.currentTokenType == 94) {
                    r = ValueExpression.get(this.token.value(this.session).negate());
                    int rType = r.getType().getValueType();
                    if (rType == 12 && r.getValue(this.session).getLong() == Integer.MIN_VALUE) {
                        r = ValueExpression.get(ValueInteger.get(Integer.MIN_VALUE));
                    } else if (rType == 13 && r.getValue(this.session).getBigDecimal().compareTo(Value.MIN_LONG_DECIMAL) == 0) {
                        r = ValueExpression.get(ValueBigint.MIN);
                    }
                    this.read();
                    break;
                }
                r = new UnaryOperation(this.readTerm());
                break;
            }
            case 103: {
                this.read();
                r = this.readTerm();
                break;
            }
            case 105: {
                TypeInfo ti;
                BinaryOperation binaryOperation;
                this.read();
                if (this.readIf(106)) {
                    r = ValueExpression.get(ValueRow.EMPTY);
                    break;
                }
                if (this.isQuery()) {
                    r = new Subquery(this.parseQuery());
                    this.read(106);
                    break;
                }
                r = this.readExpression();
                if (this.readIfMore()) {
                    ArrayList<Expression> list = Utils.newSmallArrayList();
                    list.add(r);
                    do {
                        list.add(this.readExpression());
                    } while (this.readIfMore());
                    r = new ExpressionList(list.toArray(new Expression[0]), false);
                    break;
                }
                if (!(r instanceof BinaryOperation) || (binaryOperation = (BinaryOperation)r).getOperationType() != BinaryOperation.OpType.MINUS || (ti = this.readIntervalQualifier()) == null) break;
                binaryOperation.setForcedType(ti);
                break;
            }
            case 6: {
                this.read();
                if (this.readIf(117)) {
                    if (this.readIf(118)) {
                        r = ValueExpression.get(ValueArray.EMPTY);
                        break;
                    }
                    ArrayList<Expression> list = Utils.newSmallArrayList();
                    do {
                        list.add(this.readExpression());
                    } while (this.readIf(109));
                    this.read(118);
                    r = new ExpressionList(list.toArray(new Expression[0]), true);
                    break;
                }
                this.read(105);
                Query q = this.parseQuery();
                this.read(106);
                r = new ArrayConstructorByQuery(q);
                break;
            }
            case 44: {
                this.read();
                r = this.readInterval();
                break;
            }
            case 66: {
                if (this.readIf(66, 105)) {
                    if (this.readIf(106)) {
                        r = ValueExpression.get(ValueRow.EMPTY);
                        break;
                    }
                    ArrayList<Expression> list = Utils.newSmallArrayList();
                    do {
                        list.add(this.readExpression());
                    } while (this.readIfMore());
                    r = new ExpressionList(list.toArray(new Expression[0]), false);
                    break;
                }
                r = this.readTermWithIdentifier();
                break;
            }
            case 77: {
                this.read();
                r = ValueExpression.TRUE;
                break;
            }
            case 31: {
                this.read();
                r = ValueExpression.FALSE;
                break;
            }
            case 81: {
                this.read();
                r = TypedValueExpression.UNKNOWN;
                break;
            }
            case 67: {
                this.read();
                if (this.readIf(105)) {
                    this.read(106);
                }
                if (this.currentSelect == null && this.currentPrepared == null) {
                    throw this.getSyntaxError();
                }
                r = new Rownum(this.getCurrentPreparedOrSelect());
                break;
            }
            case 58: {
                this.read();
                r = ValueExpression.NULL;
                break;
            }
            case 91: {
                this.read();
                r = new ExpressionColumn(this.database, null, null);
                break;
            }
            case 94: {
                r = ValueExpression.get(this.token.value(this.session));
                this.read();
                break;
            }
            case 85: {
                if (this.database.getMode().onDuplicateKeyUpdate) {
                    if (this.currentPrepared instanceof Insert) {
                        r = this.readOnDuplicateKeyValues(((Insert)this.currentPrepared).getTable(), null);
                        break;
                    }
                    if (this.currentPrepared instanceof Update) {
                        Update update = (Update)this.currentPrepared;
                        r = this.readOnDuplicateKeyValues(update.getTable(), update);
                        break;
                    }
                }
                r = new Subquery(this.parseQuery());
                break;
            }
            case 11: {
                this.read();
                r = this.readCase();
                break;
            }
            case 12: {
                this.read();
                this.read(105);
                Expression arg = this.readExpression();
                this.read(7);
                Column column = this.parseColumnWithType(null);
                Expression template = this.readIf("FORMAT") ? this.readExpression() : null;
                this.read(106);
                r = new CastSpecification(arg, column, template);
                break;
            }
            case 16: {
                r = this.readCurrentGeneralValueSpecification(0);
                break;
            }
            case 17: {
                this.read();
                r = this.readCurrentDateTimeValueFunction(0, this.readIf(105), null);
                break;
            }
            case 18: {
                r = this.readCurrentGeneralValueSpecification(1);
                break;
            }
            case 19: {
                r = this.readCurrentGeneralValueSpecification(2);
                break;
            }
            case 20: {
                r = this.readCurrentGeneralValueSpecification(3);
                break;
            }
            case 21: {
                this.read();
                r = this.readCurrentDateTimeValueFunction(1, this.readIf(105), null);
                break;
            }
            case 22: {
                this.read();
                r = this.readCurrentDateTimeValueFunction(3, this.readIf(105), null);
                break;
            }
            case 23: 
            case 82: {
                r = this.readCurrentGeneralValueSpecification(4);
                break;
            }
            case 70: {
                r = this.readCurrentGeneralValueSpecification(5);
                break;
            }
            case 74: {
                r = this.readCurrentGeneralValueSpecification(6);
                break;
            }
            case 5: 
            case 72: {
                this.read();
                this.read(105);
                r = this.readAggregate(AggregateType.ANY, "ANY");
                break;
            }
            case 24: 
            case 39: 
            case 54: 
            case 55: 
            case 68: 
            case 90: {
                r = this.readKeywordCompatibilityFunctionOrColumn();
                break;
            }
            case 48: {
                r = this.readColumnIfNotFunction();
                if (r != null) break;
                r = new StringFunction2(this.readExpression(), this.readLastArgument(), 0);
                break;
            }
            case 51: {
                this.read();
                r = this.readCurrentDateTimeValueFunction(2, this.readIf(105), null);
                break;
            }
            case 52: {
                this.read();
                r = this.readCurrentDateTimeValueFunction(4, this.readIf(105), null);
                break;
            }
            case 65: {
                r = this.readColumnIfNotFunction();
                if (r != null) break;
                r = new StringFunction2(this.readExpression(), this.readLastArgument(), 1);
                break;
            }
            case 71: {
                r = this.readColumnIfNotFunction();
                if (r != null) break;
                r = this.readSetFunction();
                break;
            }
            case 84: {
                if (this.parseDomainConstraint) {
                    this.read();
                    r = new DomainValueExpression();
                    break;
                }
            }
            default: {
                if (!this.isIdentifier()) {
                    throw this.getSyntaxError();
                }
                r = this.readTermWithIdentifier();
            }
        }
        return r;
    }

    private Expression readTermWithIdentifier() {
        String name = this.currentToken;
        boolean quoted = this.token.isQuoted();
        this.read();
        Expression r = this.readIf(105) ? this.readFunction(null, name) : (this.readIf(110) ? this.readTermObjectDot(name) : (quoted ? new ExpressionColumn(this.database, null, null, name) : this.readTermWithIdentifier(name, quoted)));
        return r;
    }

    private Expression readColonColonAfterTerm(Expression r) {
        if (this.database.getMode().getEnum() == Mode.ModeEnum.PostgreSQL) {
            if (this.readIfCompat("PG_CATALOG")) {
                this.read(110);
            }
            if (this.readIfCompat("REGCLASS")) {
                return new Regclass(r);
            }
        }
        return new CastSpecification(r, this.parseColumnWithType(null));
    }

    private Expression readCurrentGeneralValueSpecification(int specification) {
        this.read();
        if (this.readIf(105)) {
            this.read(106);
        }
        return new CurrentGeneralValueSpecification(specification);
    }

    private Expression readColumnIfNotFunction() {
        boolean nonKeyword = this.nonKeywords != null && this.nonKeywords.get(this.currentTokenType);
        String name = this.currentToken;
        this.read();
        if (this.readIf(105)) {
            return null;
        }
        if (nonKeyword) {
            return this.readIf(110) ? this.readTermObjectDot(name) : new ExpressionColumn(this.database, null, null, name);
        }
        throw this.getSyntaxError();
    }

    private Expression readSetFunction() {
        FunctionAlias functionAlias;
        SetFunction function = new SetFunction(this.readExpression(), this.readLastArgument());
        if (this.database.isAllowBuiltinAliasOverride() && (functionAlias = this.database.getSchema(this.session.getCurrentSchemaName()).findFunction(function.getName())) != null) {
            return new JavaFunction(functionAlias, new Expression[]{function.getSubexpression(0), function.getSubexpression(1)});
        }
        return function;
    }

    private Expression readOnDuplicateKeyValues(Table table, Update update) {
        this.read();
        this.read(105);
        Column c = this.readTableColumn(new TableFilter(this.session, table, null, this.rightsChecked, null, 0, null));
        this.read(106);
        return new OnDuplicateKeyValues(c, update);
    }

    private Expression readTermWithIdentifier(String name, boolean quoted) {
        switch (name.charAt(0) & 0xFFDF) {
            case 67: {
                if (!this.equalsToken("CURRENT", name)) break;
                if (this.readIf(84, 33)) {
                    return new SequenceValue(this.readSequence());
                }
                if (this.database.getMode().getEnum() != Mode.ModeEnum.DB2) break;
                return this.parseDB2SpecialRegisters(name);
            }
            case 68: {
                if (this.currentTokenType != 94 || this.token.value(this.session).getValueType() != 2 || !this.equalsToken("DATE", name) && !this.equalsToken("D", name)) break;
                String date = this.token.value(this.session).getString();
                this.read();
                return ValueExpression.get(ValueDate.parse(date));
            }
            case 69: {
                if (this.currentTokenType != 94 || this.token.value(this.session).getValueType() != 2 || !this.equalsToken("E", name)) break;
                String text = this.token.value(this.session).getString();
                text = StringUtils.replaceAll(text, "\\\\", "\\");
                this.read();
                return ValueExpression.get(ValueVarchar.get(text));
            }
            case 71: {
                if (this.currentTokenType != 94) break;
                int t = this.token.value(this.session).getValueType();
                if (t == 2 && this.equalsToken("GEOMETRY", name)) {
                    ValueExpression v = ValueExpression.get(ValueGeometry.get(this.token.value(this.session).getString()));
                    this.read();
                    return v;
                }
                if (t != 6 || !this.equalsToken("GEOMETRY", name)) break;
                ValueExpression v = ValueExpression.get(ValueGeometry.getFromEWKB(this.token.value(this.session).getBytesNoCopy()));
                this.read();
                return v;
            }
            case 74: {
                if (this.currentTokenType != 94) break;
                int t = this.token.value(this.session).getValueType();
                if (t == 2 && this.equalsToken("JSON", name)) {
                    ValueExpression v = ValueExpression.get(ValueJson.fromJson(this.token.value(this.session).getString()));
                    this.read();
                    return v;
                }
                if (t != 6 || !this.equalsToken("JSON", name)) break;
                ValueExpression v = ValueExpression.get(ValueJson.fromJson(this.token.value(this.session).getBytesNoCopy()));
                this.read();
                return v;
            }
            case 78: {
                if (!this.equalsToken("NEXT", name) || !this.readIf(84, 33)) break;
                return new SequenceValue(this.readSequence(), this.getCurrentPreparedOrSelect());
            }
            case 84: {
                if (this.equalsToken("TIME", name)) {
                    if (this.readIf(89, "TIME", "ZONE")) {
                        if (this.currentTokenType != 94 || this.token.value(this.session).getValueType() != 2) {
                            throw this.getSyntaxError();
                        }
                        String time = this.token.value(this.session).getString();
                        this.read();
                        return ValueExpression.get(ValueTimeTimeZone.parse(time, this.session));
                    }
                    boolean without = this.readIf("WITHOUT", "TIME", "ZONE");
                    if (this.currentTokenType == 94 && this.token.value(this.session).getValueType() == 2) {
                        String time = this.token.value(this.session).getString();
                        this.read();
                        return ValueExpression.get(ValueTime.parse(time, this.session));
                    }
                    if (!without) break;
                    throw this.getSyntaxError();
                }
                if (this.equalsToken("TIMESTAMP", name)) {
                    if (this.readIf(89, "TIME", "ZONE")) {
                        if (this.currentTokenType != 94 || this.token.value(this.session).getValueType() != 2) {
                            throw this.getSyntaxError();
                        }
                        String timestamp = this.token.value(this.session).getString();
                        this.read();
                        return ValueExpression.get(ValueTimestampTimeZone.parse(timestamp, this.session));
                    }
                    boolean without = this.readIf("WITHOUT", "TIME", "ZONE");
                    if (this.currentTokenType == 94 && this.token.value(this.session).getValueType() == 2) {
                        String timestamp = this.token.value(this.session).getString();
                        this.read();
                        return ValueExpression.get(ValueTimestamp.parse(timestamp, this.session));
                    }
                    if (!without) break;
                    throw this.getSyntaxError();
                }
                if (this.currentTokenType != 94 || this.token.value(this.session).getValueType() != 2) break;
                if (this.equalsToken("T", name)) {
                    String time = this.token.value(this.session).getString();
                    this.read();
                    return ValueExpression.get(ValueTime.parse(time, this.session));
                }
                if (!this.equalsToken("TS", name)) break;
                String timestamp = this.token.value(this.session).getString();
                this.read();
                return ValueExpression.get(ValueTimestamp.parse(timestamp, this.session));
            }
            case 85: {
                if (this.currentTokenType != 94 || this.token.value(this.session).getValueType() != 2 || !this.equalsToken("UUID", name)) break;
                String uuid = this.token.value(this.session).getString();
                this.read();
                return ValueExpression.get(ValueUuid.get(uuid));
            }
        }
        return new ExpressionColumn(this.database, null, null, name, quoted);
    }

    private Prepared getCurrentPreparedOrSelect() {
        Prepared p = this.currentPrepared;
        return p != null ? p : this.currentSelect;
    }

    private Expression readInterval() {
        boolean negative = this.readIf(102);
        if (!negative) {
            this.readIf(103);
        }
        if (this.currentTokenType != 94 || this.token.value(this.session).getValueType() != 2) {
            this.addExpected("string");
            throw this.getSyntaxError();
        }
        String s = this.token.value(this.session).getString();
        this.read();
        TypeInfo typeInfo = this.readIntervalQualifier();
        try {
            ValueInterval interval = IntervalUtils.parseInterval(IntervalQualifier.valueOf(typeInfo.getValueType() - 22), negative, s);
            if (typeInfo.getDeclaredPrecision() != -1L || typeInfo.getDeclaredScale() != -1) {
                return TypedValueExpression.get(interval.castTo(typeInfo, this.session), typeInfo);
            }
            return ValueExpression.get(interval);
        }
        catch (Exception e) {
            throw DbException.get(22007, e, "INTERVAL", s);
        }
    }

    private Expression parseDB2SpecialRegisters(String name) {
        if (this.readIfCompat("TIMESTAMP")) {
            if (this.readIf(89, "TIME", "ZONE")) {
                return this.readCurrentDateTimeValueFunction(3, this.readIf(105), null);
            }
            return this.readCurrentDateTimeValueFunction(4, this.readIf(105), null);
        }
        if (this.readIfCompat("TIME")) {
            return this.readCurrentDateTimeValueFunction(2, false, null);
        }
        if (this.readIfCompat("DATE")) {
            return this.readCurrentDateTimeValueFunction(0, false, null);
        }
        return new ExpressionColumn(this.database, null, null, name);
    }

    private Expression readCase() {
        Expression c;
        if (this.readIf(86)) {
            SearchedCase searched = new SearchedCase();
            do {
                Expression condition = this.readExpression();
                this.read("THEN");
                searched.addParameter(condition);
                searched.addParameter(this.readExpression());
            } while (this.readIf(86));
            if (this.readIf(27)) {
                searched.addParameter(this.readExpression());
            }
            searched.doneWithParameters();
            c = searched;
        } else {
            SimpleCase.SimpleWhen when;
            Expression caseOperand = this.readExpression();
            this.read(86);
            SimpleCase.SimpleWhen current = when = this.readSimpleWhenClause(caseOperand);
            while (this.readIf(86)) {
                SimpleCase.SimpleWhen next = this.readSimpleWhenClause(caseOperand);
                current.setWhen(next);
                current = next;
            }
            c = new SimpleCase(caseOperand, when, this.readIf(27) ? this.readExpression() : null);
        }
        this.read(28);
        return c;
    }

    private SimpleCase.SimpleWhen readSimpleWhenClause(Expression caseOperand) {
        Expression whenOperand = this.readWhenOperand(caseOperand);
        if (this.readIf(109)) {
            ArrayList<Expression> operands = Utils.newSmallArrayList();
            operands.add(whenOperand);
            do {
                operands.add(this.readWhenOperand(caseOperand));
            } while (this.readIf(109));
            this.read("THEN");
            return new SimpleCase.SimpleWhen(operands.toArray(new Expression[0]), this.readExpression());
        }
        this.read("THEN");
        return new SimpleCase.SimpleWhen(whenOperand, this.readExpression());
    }

    private Expression readWhenOperand(Expression caseOperand) {
        int backup = this.tokenIndex;
        boolean not = this.readIf(57);
        Expression whenOperand = this.readConditionRightHandSide(caseOperand, not, true);
        if (whenOperand == null) {
            if (not) {
                this.setTokenIndex(backup);
            }
            whenOperand = this.readExpression();
        }
        return whenOperand;
    }

    private String readString() {
        int sqlIndex = this.token.start();
        Expression expr = this.readExpression();
        try {
            String s = expr.optimize(this.session).getValue(this.session).getString();
            if (s == null || s.length() <= 1000000000) {
                return s;
            }
        }
        catch (DbException dbException) {
            // empty catch block
        }
        throw DbException.getSyntaxError(this.sqlCommand, sqlIndex, "character string");
    }

    private Expression readStringOrParameter() {
        int sqlIndex = this.token.start();
        Expression expr = this.readExpression();
        try {
            expr = expr.optimize(this.session);
            if (expr instanceof Parameter) {
                return expr;
            }
            Value v = expr.getValue(this.session);
            int valueType = v.getValueType();
            if ((valueType == 58 || valueType == 2) && expr instanceof ValueExpression) {
                return expr;
            }
            String s = v.getString();
            if (s == null || s.length() <= 1000000000) {
                return s == null ? ValueExpression.NULL : ValueExpression.get(ValueVarchar.get(s, this.database));
            }
        }
        catch (DbException dbException) {
            // empty catch block
        }
        throw DbException.getSyntaxError(this.sqlCommand, sqlIndex, "character string");
    }

    private String readIdentifierWithSchema(String defaultSchemaName) {
        String s = this.readIdentifier();
        this.schemaName = defaultSchemaName;
        if (this.readIf(110)) {
            s = this.readIdentifierWithSchema2(s);
        }
        return s;
    }

    private String readIdentifierWithSchema2(String s) {
        this.schemaName = s;
        if (this.database.getMode().allowEmptySchemaValuesAsDefaultSchema && this.readIf(110)) {
            if (this.equalsToken(this.schemaName, this.database.getShortName()) || this.database.getIgnoreCatalogs()) {
                this.schemaName = this.session.getCurrentSchemaName();
                s = this.readIdentifier();
            }
        } else {
            s = this.readIdentifier();
            if (this.currentTokenType == 110 && (this.equalsToken(this.schemaName, this.database.getShortName()) || this.database.getIgnoreCatalogs())) {
                this.read();
                this.schemaName = s;
                s = this.readIdentifier();
            }
        }
        return s;
    }

    private String readIdentifierWithSchema() {
        return this.readIdentifierWithSchema(this.session.getCurrentSchemaName());
    }

    private String readIdentifier() {
        if (!(this.isIdentifier() || this.session.isQuirksMode() && Parser.isKeyword(this.currentTokenType))) {
            throw DbException.getSyntaxError(this.sqlCommand, this.token.start(), "identifier");
        }
        String s = this.currentToken;
        this.read();
        return s;
    }

    private String readIdentifierOrKeyword() {
        if (this.currentTokenType < 2 || this.currentTokenType > 91) {
            this.addExpected("identifier or keyword");
            throw this.getSyntaxError();
        }
        String s = this.currentToken;
        this.read();
        return s;
    }

    /*
     * Unable to fully structure code
     */
    private Column parseColumnForTable(String columnName, boolean defaultNullable) {
        block33: {
            block35: {
                block36: {
                    block34: {
                        mode = this.database.getMode();
                        if (mode.identityDataType && this.readIfCompat("IDENTITY")) {
                            column = new Column(columnName, TypeInfo.TYPE_BIGINT);
                            this.parseCompatibilityIdentityOptions(column);
                            column.setPrimaryKey(true);
                        } else if (mode.serialDataTypes && this.readIfCompat("BIGSERIAL")) {
                            column = new Column(columnName, TypeInfo.TYPE_BIGINT);
                            column.setIdentityOptions(new SequenceOptions(), false);
                        } else if (mode.serialDataTypes && this.readIfCompat("SERIAL")) {
                            column = new Column(columnName, TypeInfo.TYPE_INTEGER);
                            column.setIdentityOptions(new SequenceOptions(), false);
                        } else {
                            column = this.parseColumnWithType(columnName);
                        }
                        if (this.readIf("INVISIBLE")) {
                            column.setVisible(false);
                        } else if (this.readIf("VISIBLE")) {
                            column.setVisible(true);
                        }
                        defaultOnNull = false;
                        nullConstraint = this.parseNotNullConstraint();
                        if (column.isIdentity()) break block33;
                        if (!this.readIfCompat(7)) break block34;
                        column.setGeneratedExpression(this.readExpression());
                        ** GOTO lbl53
                    }
                    if (!this.readIf(25)) break block35;
                    if (!this.readIf(60, 58)) break block36;
                    defaultOnNull = true;
                    break block33;
                }
                column.setDefaultExpression(this.session, this.readExpression());
                ** GOTO lbl53
            }
            if (!this.readIf("GENERATED")) ** GOTO lbl53
            always = this.readIf("ALWAYS");
            if (!always) {
                this.read("BY");
                this.read(25);
            }
            this.read(7);
            if (this.readIf("IDENTITY")) {
                options = new SequenceOptions();
                if (this.readIf(105)) {
                    this.parseSequenceOptions(options, null, false, false);
                    this.read(106);
                }
                column.setIdentityOptions(options, always);
            } else {
                if (!always) {
                    throw this.getSyntaxError();
                }
                column.setGeneratedExpression(this.readExpression());
lbl53:
                // 4 sources

                if (!column.isGenerated() && this.readIf(60, "UPDATE")) {
                    column.setOnUpdateExpression(this.session, this.readExpression());
                }
                nullConstraint = this.parseNotNullConstraint(nullConstraint);
                if (this.parseCompatibilityIdentity(column, mode)) {
                    nullConstraint = this.parseNotNullConstraint(nullConstraint);
                }
            }
        }
        switch (Parser.$SWITCH_TABLE$org$h2$command$Parser$NullConstraintType()[nullConstraint.ordinal()]) {
            case 1: {
                if (column.isIdentity()) {
                    throw DbException.get(90023, column.getName());
                }
                column.setNullable(true);
                break;
            }
            case 2: {
                column.setNullable(false);
                break;
            }
            case 3: {
                if (column.isIdentity()) break;
                column.setNullable(defaultNullable);
                break;
            }
            default: {
                throw DbException.get(90088, "Internal Error - unhandled case: " + nullConstraint.name());
            }
        }
        if (!defaultOnNull) {
            if (this.readIf(new Object[]{25, 60, 58})) {
                defaultOnNull = true;
            } else if (this.readIfCompat("NULL_TO_DEFAULT")) {
                defaultOnNull = true;
            }
        }
        if (defaultOnNull) {
            column.setDefaultOnNull(true);
        }
        if (!column.isGenerated() && this.readIf("SEQUENCE")) {
            column.setSequence(this.readSequence(), column.isGeneratedAlways());
        }
        if (this.readIf("SELECTIVITY")) {
            column.setSelectivity(this.readNonNegativeInt());
        }
        if (mode.mySqlTableOptions) {
            if (this.readIfCompat("CHARACTER")) {
                this.readIf(71);
                this.readMySQLCharset();
            }
            if (this.readIfCompat("COLLATE")) {
                this.readMySQLCharset();
            }
        }
        if ((comment = this.readCommentIf()) != null) {
            column.setComment(comment);
        }
        return column;
    }

    private void parseCompatibilityIdentityOptions(Column column) {
        SequenceOptions options = new SequenceOptions();
        if (this.readIf(105)) {
            options.setStartValue(ValueExpression.get(ValueBigint.get(this.readLong())));
            if (this.readIf(109)) {
                options.setIncrement(ValueExpression.get(ValueBigint.get(this.readLong())));
            }
            this.read(106);
        }
        column.setIdentityOptions(options, false);
    }

    private String readCommentIf() {
        if (this.readIf("COMMENT")) {
            this.readIf(45);
            return this.readString();
        }
        return null;
    }

    private Column parseColumnWithType(String columnName) {
        TypeInfo typeInfo = this.readIfDataType();
        if (typeInfo == null) {
            String domainName = this.readIdentifierWithSchema();
            return Parser.getColumnWithDomain(columnName, this.getSchema().getDomain(domainName));
        }
        return new Column(columnName, typeInfo);
    }

    private TypeInfo parseDataType() {
        TypeInfo typeInfo = this.readIfDataType();
        if (typeInfo == null) {
            this.addExpected("data type");
            throw this.getSyntaxError();
        }
        return typeInfo;
    }

    private TypeInfo readIfDataType() {
        TypeInfo typeInfo = this.readIfDataType1();
        if (typeInfo != null) {
            while (this.readIf(6)) {
                typeInfo = this.parseArrayType(typeInfo);
            }
        }
        return typeInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TypeInfo readIfDataType1() {
        int scale;
        long precision;
        Domain domain;
        String original;
        switch (this.currentTokenType) {
            case 2: {
                if (!this.token.isQuoted()) break;
                return null;
            }
            case 44: {
                this.read();
                TypeInfo typeInfo = this.readIntervalQualifier();
                if (typeInfo != null) return typeInfo;
                throw this.intervalQualifierError();
            }
            case 58: {
                this.read();
                return TypeInfo.TYPE_NULL;
            }
            case 66: {
                this.read();
                return this.parseRowType();
            }
            case 6: {
                if (this.session.isQuirksMode()) {
                    this.read();
                    return this.parseArrayType(TypeInfo.TYPE_VARCHAR);
                }
                this.addExpected("data type");
                throw this.getSyntaxError();
            }
            default: {
                if (Parser.isKeyword(this.currentTokenType)) break;
                this.addExpected("data type");
                throw this.getSyntaxError();
            }
        }
        int index = this.tokenIndex;
        String originalCase = this.currentToken;
        this.read();
        if (this.currentTokenType == 110) {
            this.setTokenIndex(index);
            return null;
        }
        switch (original = this.upperName(originalCase)) {
            case "BINARY": {
                if (this.readIf("VARYING")) {
                    original = "BINARY VARYING";
                    break;
                }
                if (this.readIf("LARGE")) {
                    this.read("OBJECT");
                    original = "BINARY LARGE OBJECT";
                    break;
                }
                if (!this.variableBinary) break;
                original = "VARBINARY";
                break;
            }
            case "CHAR": {
                if (this.readIf("VARYING")) {
                    original = "CHAR VARYING";
                    break;
                }
                if (!this.readIf("LARGE")) break;
                this.read("OBJECT");
                original = "CHAR LARGE OBJECT";
                break;
            }
            case "CHARACTER": {
                if (this.readIf("VARYING")) {
                    original = "CHARACTER VARYING";
                    break;
                }
                if (!this.readIf("LARGE")) break;
                this.read("OBJECT");
                original = "CHARACTER LARGE OBJECT";
                break;
            }
            case "DATE": {
                return this.database.getMode().dateIsTimestamp0 ? TypeInfo.getTypeInfo(20, -1L, 0, null) : TypeInfo.TYPE_DATE;
            }
            case "DATETIME2": 
            case "DATETIME": {
                return this.parseDateTimeType(false);
            }
            case "DECIMAL": 
            case "DEC": {
                return this.parseNumericType(true);
            }
            case "DECFLOAT": {
                return this.parseDecfloatType();
            }
            case "DOUBLE": {
                if (!this.readIf("PRECISION")) break;
                original = "DOUBLE PRECISION";
                break;
            }
            case "ENUM": {
                return this.parseEnumType();
            }
            case "FLOAT": {
                return this.parseFloatType();
            }
            case "GEOMETRY": {
                return this.parseGeometryType();
            }
            case "LONG": {
                if (!this.readIf("RAW")) break;
                original = "LONG RAW";
                break;
            }
            case "NATIONAL": {
                if (this.readIf("CHARACTER")) {
                    if (this.readIf("VARYING")) {
                        original = "NATIONAL CHARACTER VARYING";
                        break;
                    }
                    if (this.readIf("LARGE")) {
                        this.read("OBJECT");
                        original = "NATIONAL CHARACTER LARGE OBJECT";
                        break;
                    }
                    original = "NATIONAL CHARACTER";
                    break;
                }
                this.read("CHAR");
                if (this.readIf("VARYING")) {
                    original = "NATIONAL CHAR VARYING";
                    break;
                }
                original = "NATIONAL CHAR";
                break;
            }
            case "NCHAR": {
                if (this.readIf("VARYING")) {
                    original = "NCHAR VARYING";
                    break;
                }
                if (!this.readIf("LARGE")) break;
                this.read("OBJECT");
                original = "NCHAR LARGE OBJECT";
                break;
            }
            case "NUMBER": {
                if (this.database.getMode().disallowedTypes.contains("NUMBER")) {
                    throw DbException.get(50004, "NUMBER");
                }
                if (!this.isToken(105)) {
                    return TypeInfo.getTypeInfo(16, 40L, -1, null);
                }
            }
            case "NUMERIC": {
                return this.parseNumericType(false);
            }
            case "SMALLDATETIME": {
                return this.parseDateTimeType(true);
            }
            case "TIME": {
                return this.parseTimeType();
            }
            case "TIMESTAMP": {
                return this.parseTimestampType();
            }
        }
        if (originalCase.length() == original.length() && (domain = this.database.getSchema(this.session.getCurrentSchemaName()).findDomain(originalCase)) != null) {
            this.setTokenIndex(index);
            return null;
        }
        Mode mode = this.database.getMode();
        DataType dataType = DataType.getTypeByName(original, mode);
        if (dataType == null || mode.disallowedTypes.contains(original)) {
            throw DbException.get(50004, original);
        }
        if (dataType.specialPrecisionScale) {
            precision = dataType.defaultPrecision;
            scale = dataType.defaultScale;
        } else {
            precision = -1L;
            scale = -1;
        }
        int t = dataType.type;
        if (this.database.getIgnoreCase() && t == 2 && !this.equalsToken("VARCHAR_CASESENSITIVE", original)) {
            t = 4;
            dataType = DataType.getDataType(4);
        }
        if ((dataType.supportsPrecision || dataType.supportsScale) && this.readIf(105)) {
            if (!this.readIf("MAX")) {
                if (dataType.supportsPrecision) {
                    precision = this.readPrecision(t);
                    if (precision < dataType.minPrecision) {
                        throw Parser.getInvalidPrecisionException(dataType, precision);
                    }
                    if (precision > dataType.maxPrecision) {
                        if (!this.session.isQuirksMode() && !this.session.isTruncateLargeLength()) throw Parser.getInvalidPrecisionException(dataType, precision);
                        switch (dataType.type) {
                            case 1: 
                            case 2: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 35: 
                            case 38: {
                                precision = dataType.maxPrecision;
                                break;
                            }
                            default: {
                                throw Parser.getInvalidPrecisionException(dataType, precision);
                            }
                        }
                    }
                    if (dataType.supportsScale && this.readIf(109) && ((scale = this.readInt()) < dataType.minScale || scale > dataType.maxScale)) {
                        throw DbException.get(90151, Integer.toString(scale), Integer.toString(dataType.minScale), Integer.toString(dataType.maxScale));
                    }
                } else {
                    scale = this.readInt();
                    if (scale < dataType.minScale || scale > dataType.maxScale) {
                        throw DbException.get(90151, Integer.toString(scale), Integer.toString(dataType.minScale), Integer.toString(dataType.maxScale));
                    }
                }
            }
            this.read(106);
        }
        if (mode.allNumericTypesHavePrecision && (DataType.isNumericType(dataType.type) || dataType.type == 8)) {
            if (this.readIfCompat(105)) {
                this.readNonNegativeInt();
                this.read(106);
            }
            this.readIf("UNSIGNED");
        }
        if (!mode.forBitData || !DataType.isStringType(t) || !this.readIfCompat(33, "BIT", "DATA")) return TypeInfo.getTypeInfo(t, precision, scale, null);
        t = 6;
        dataType = DataType.getDataType(6);
        return TypeInfo.getTypeInfo(t, precision, scale, null);
    }

    private static DbException getInvalidPrecisionException(DataType dataType, long precision) {
        return DbException.get(90150, Long.toString(precision), Long.toString(dataType.minPrecision), Long.toString(dataType.maxPrecision));
    }

    private static Column getColumnWithDomain(String columnName, Domain domain) {
        Column column = new Column(columnName, domain.getDataType());
        column.setComment(domain.getComment());
        column.setDomain(domain);
        return column;
    }

    private TypeInfo parseFloatType() {
        int precision;
        int type = 15;
        if (this.readIf(105)) {
            precision = this.readNonNegativeInt();
            this.read(106);
            if (precision < 1 || precision > 53) {
                throw DbException.get(90150, Integer.toString(precision), "1", "53");
            }
            if (precision <= 24) {
                type = 14;
            }
        } else {
            precision = 0;
        }
        return TypeInfo.getTypeInfo(type, precision, -1, null);
    }

    private TypeInfo parseNumericType(boolean decimal) {
        long precision = -1L;
        int scale = -1;
        if (this.readIf(105)) {
            precision = this.readPrecision(13);
            if (precision < 1L) {
                throw Parser.getInvalidNumericPrecisionException(precision);
            }
            if (precision > 100000L) {
                if (this.session.isQuirksMode() || this.session.isTruncateLargeLength()) {
                    precision = 100000L;
                } else {
                    throw Parser.getInvalidNumericPrecisionException(precision);
                }
            }
            if (this.readIf(109) && ((scale = this.readInt()) < 0 || scale > 100000)) {
                throw DbException.get(90151, Integer.toString(scale), "0", "100000");
            }
            this.read(106);
        } else if (this.database.getMode().numericIsDecfloat) {
            return TypeInfo.TYPE_DECFLOAT;
        }
        return TypeInfo.getTypeInfo(13, precision, scale, decimal ? ExtTypeInfoNumeric.DECIMAL : null);
    }

    private TypeInfo parseDecfloatType() {
        long precision = -1L;
        if (this.readIf(105)) {
            precision = this.readPrecision(16);
            if (precision < 1L || precision > 100000L) {
                throw Parser.getInvalidNumericPrecisionException(precision);
            }
            this.read(106);
        }
        return TypeInfo.getTypeInfo(16, precision, -1, null);
    }

    private static DbException getInvalidNumericPrecisionException(long precision) {
        return DbException.get(90150, Long.toString(precision), "1", "100000");
    }

    private TypeInfo parseTimeType() {
        int scale = -1;
        if (this.readIf(105)) {
            scale = this.readNonNegativeInt();
            if (scale > 9) {
                throw DbException.get(90151, Integer.toString(scale), "0", "9");
            }
            this.read(106);
        }
        int type = 18;
        if (this.readIf(89, "TIME", "ZONE")) {
            type = 19;
        } else {
            this.readIf("WITHOUT", "TIME", "ZONE");
        }
        return TypeInfo.getTypeInfo(type, -1L, scale, null);
    }

    private TypeInfo parseTimestampType() {
        int scale = -1;
        if (this.readIf(105)) {
            scale = this.readNonNegativeInt();
            if (this.readIf(109)) {
                scale = this.readNonNegativeInt();
            }
            if (scale > 9) {
                throw DbException.get(90151, Integer.toString(scale), "0", "9");
            }
            this.read(106);
        }
        int type = 20;
        if (this.readIf(89, "TIME", "ZONE")) {
            type = 21;
        } else {
            this.readIf("WITHOUT", "TIME", "ZONE");
        }
        return TypeInfo.getTypeInfo(type, -1L, scale, null);
    }

    private TypeInfo parseDateTimeType(boolean smallDateTime) {
        int scale;
        if (smallDateTime) {
            scale = 0;
        } else {
            scale = -1;
            if (this.readIf(105)) {
                scale = this.readNonNegativeInt();
                if (scale > 9) {
                    throw DbException.get(90151, Integer.toString(scale), "0", "9");
                }
                this.read(106);
            }
        }
        return TypeInfo.getTypeInfo(20, -1L, scale, null);
    }

    private TypeInfo readIntervalQualifier() {
        IntervalQualifier qualifier;
        int precision = -1;
        int scale = -1;
        block0 : switch (this.currentTokenType) {
            case 90: {
                this.read();
                if (this.readIf(105)) {
                    precision = this.readNonNegativeInt();
                    this.read(106);
                }
                if (this.readIf(76, 55)) {
                    qualifier = IntervalQualifier.YEAR_TO_MONTH;
                    break;
                }
                qualifier = IntervalQualifier.YEAR;
                break;
            }
            case 55: {
                this.read();
                if (this.readIf(105)) {
                    precision = this.readNonNegativeInt();
                    this.read(106);
                }
                qualifier = IntervalQualifier.MONTH;
                break;
            }
            case 24: {
                this.read();
                if (this.readIf(105)) {
                    precision = this.readNonNegativeInt();
                    this.read(106);
                }
                if (this.readIf(76)) {
                    switch (this.currentTokenType) {
                        case 39: {
                            this.read();
                            qualifier = IntervalQualifier.DAY_TO_HOUR;
                            break block0;
                        }
                        case 54: {
                            this.read();
                            qualifier = IntervalQualifier.DAY_TO_MINUTE;
                            break block0;
                        }
                        case 68: {
                            this.read();
                            if (this.readIf(105)) {
                                scale = this.readNonNegativeInt();
                                this.read(106);
                            }
                            qualifier = IntervalQualifier.DAY_TO_SECOND;
                            break block0;
                        }
                    }
                    throw this.intervalDayError();
                }
                qualifier = IntervalQualifier.DAY;
                break;
            }
            case 39: {
                this.read();
                if (this.readIf(105)) {
                    precision = this.readNonNegativeInt();
                    this.read(106);
                }
                if (this.readIf(76)) {
                    switch (this.currentTokenType) {
                        case 54: {
                            this.read();
                            qualifier = IntervalQualifier.HOUR_TO_MINUTE;
                            break block0;
                        }
                        case 68: {
                            this.read();
                            if (this.readIf(105)) {
                                scale = this.readNonNegativeInt();
                                this.read(106);
                            }
                            qualifier = IntervalQualifier.HOUR_TO_SECOND;
                            break block0;
                        }
                    }
                    throw this.intervalHourError();
                }
                qualifier = IntervalQualifier.HOUR;
                break;
            }
            case 54: {
                this.read();
                if (this.readIf(105)) {
                    precision = this.readNonNegativeInt();
                    this.read(106);
                }
                if (this.readIf(76, 68)) {
                    if (this.readIf(105)) {
                        scale = this.readNonNegativeInt();
                        this.read(106);
                    }
                    qualifier = IntervalQualifier.MINUTE_TO_SECOND;
                    break;
                }
                qualifier = IntervalQualifier.MINUTE;
                break;
            }
            case 68: {
                this.read();
                if (this.readIf(105)) {
                    precision = this.readNonNegativeInt();
                    if (this.readIf(109)) {
                        scale = this.readNonNegativeInt();
                    }
                    this.read(106);
                }
                qualifier = IntervalQualifier.SECOND;
                break;
            }
            default: {
                return null;
            }
        }
        if (precision >= 0 && (precision == 0 || precision > 18)) {
            throw DbException.get(90150, Integer.toString(precision), "1", "18");
        }
        if (scale >= 0 && scale > 9) {
            throw DbException.get(90151, Integer.toString(scale), "0", "9");
        }
        return TypeInfo.getTypeInfo(qualifier.ordinal() + 22, precision, scale, null);
    }

    private DbException intervalQualifierError() {
        if (this.expectedList != null) {
            this.addMultipleExpected(90, 55, 24, 39, 54, 68);
        }
        return this.getSyntaxError();
    }

    private DbException intervalDayError() {
        if (this.expectedList != null) {
            this.addMultipleExpected(39, 54, 68);
        }
        return this.getSyntaxError();
    }

    private DbException intervalHourError() {
        if (this.expectedList != null) {
            this.addMultipleExpected(54, 68);
        }
        return this.getSyntaxError();
    }

    private TypeInfo parseArrayType(TypeInfo componentType) {
        int precision = -1;
        if (this.readIf(117)) {
            precision = this.readNonNegativeInt();
            if (precision > 65536) {
                throw DbException.get(90150, Integer.toString(precision), "0", "65536");
            }
            this.read(118);
        }
        return TypeInfo.getTypeInfo(40, precision, -1, componentType);
    }

    private TypeInfo parseEnumType() {
        this.read(105);
        ArrayList<String> enumeratorList = new ArrayList<String>();
        do {
            enumeratorList.add(this.readString());
        } while (this.readIfMore());
        return TypeInfo.getTypeInfo(36, -1L, -1, new ExtTypeInfoEnum(enumeratorList.toArray(new String[0])));
    }

    private TypeInfo parseGeometryType() {
        ExtTypeInfoGeometry extTypeInfo;
        if (this.readIf(105)) {
            int type = 0;
            if (this.currentTokenType != 2 || this.token.isQuoted()) {
                throw this.getSyntaxError();
            }
            if (!this.readIf("GEOMETRY")) {
                try {
                    type = EWKTUtils.parseGeometryType(this.currentToken);
                    this.read();
                    if (type / 1000 == 0 && this.currentTokenType == 2 && !this.token.isQuoted()) {
                        type += EWKTUtils.parseDimensionSystem(this.currentToken) * 1000;
                        this.read();
                    }
                }
                catch (IllegalArgumentException ex) {
                    throw this.getSyntaxError();
                }
            }
            Integer srid = null;
            if (this.readIf(109)) {
                srid = this.readInt();
            }
            this.read(106);
            extTypeInfo = new ExtTypeInfoGeometry(type, srid);
        } else {
            extTypeInfo = null;
        }
        return TypeInfo.getTypeInfo(37, -1L, -1, extTypeInfo);
    }

    private TypeInfo parseRowType() {
        this.read(105);
        LinkedHashMap<String, TypeInfo> fields = new LinkedHashMap<String, TypeInfo>();
        do {
            String name;
            if (fields.putIfAbsent(name = this.readIdentifier(), this.parseDataType()) == null) continue;
            throw DbException.get(42121, name);
        } while (this.readIfMore());
        return TypeInfo.getTypeInfo(41, -1L, -1, new ExtTypeInfoRow(fields));
    }

    private long readPrecision(int valueType) {
        long p = this.readPositiveLong();
        if (this.currentTokenType != 2 || this.token.isQuoted()) {
            return p;
        }
        if ((valueType == 7 || valueType == 3) && this.currentToken.length() == 1) {
            long mul;
            switch (this.currentToken.charAt(0) & 0xFFDF) {
                case 75: {
                    mul = 1024L;
                    break;
                }
                case 77: {
                    mul = 0x100000L;
                    break;
                }
                case 71: {
                    mul = 0x40000000L;
                    break;
                }
                case 84: {
                    mul = 0x10000000000L;
                    break;
                }
                case 80: {
                    mul = 0x4000000000000L;
                    break;
                }
                default: {
                    throw this.getSyntaxError();
                }
            }
            if (p > Long.MAX_VALUE / mul) {
                throw DbException.getInvalidValueException("precision", p + this.currentToken);
            }
            p *= mul;
            this.read();
            if (this.currentTokenType != 2 || this.token.isQuoted()) {
                return p;
            }
        }
        switch (valueType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                if (this.readIf("CHARACTERS") || this.readIf("OCTETS") || !this.database.getMode().charAndByteLengthUnits || this.readIfCompat("CHAR")) break;
                this.readIfCompat("BYTE");
            }
        }
        return p;
    }

    private Prepared parseCreate() {
        IndexColumn[] columns;
        boolean orReplace = false;
        if (this.readIf(61, "REPLACE")) {
            orReplace = true;
        }
        boolean force = this.readIf("FORCE");
        if (this.readIf("VIEW")) {
            return this.parseCreateView(force, orReplace);
        }
        if (this.readIf("MATERIALIZED")) {
            this.read("VIEW");
            return this.parseCreateMaterializedView(force, orReplace);
        }
        if (this.readIf("ALIAS")) {
            return this.parseCreateFunctionAlias(force);
        }
        if (this.readIf("SEQUENCE")) {
            return this.parseCreateSequence();
        }
        if (this.readIf(82)) {
            return this.parseCreateUser();
        }
        if (this.readIf("TRIGGER")) {
            return this.parseCreateTrigger(force);
        }
        if (this.readIf("ROLE")) {
            return this.parseCreateRole();
        }
        if (this.readIf("SCHEMA")) {
            return this.parseCreateSchema();
        }
        if (this.readIf("CONSTANT")) {
            return this.parseCreateConstant();
        }
        if (this.readIf("DOMAIN") || this.readIf("TYPE") || this.readIfCompat("DATATYPE")) {
            return this.parseCreateDomain();
        }
        if (this.readIf("AGGREGATE")) {
            return this.parseCreateAggregate(force);
        }
        if (this.readIf("LINKED")) {
            return this.parseCreateLinkedTable(false, false, force);
        }
        boolean memory = false;
        boolean cached = false;
        if (this.readIf("MEMORY")) {
            memory = true;
        } else if (this.readIf("CACHED")) {
            cached = true;
        }
        if (this.readIf("LOCAL", "TEMPORARY")) {
            if (this.readIf("LINKED")) {
                return this.parseCreateLinkedTable(true, false, force);
            }
            this.read(75);
            return this.parseCreateTable(true, false, cached);
        }
        if (this.readIf("GLOBAL", "TEMPORARY")) {
            if (this.readIf("LINKED")) {
                return this.parseCreateLinkedTable(true, true, force);
            }
            this.read(75);
            return this.parseCreateTable(true, true, cached);
        }
        if (this.readIfCompat("TEMP") || this.readIf("TEMPORARY")) {
            if (this.readIf("LINKED")) {
                return this.parseCreateLinkedTable(true, true, force);
            }
            this.read(75);
            return this.parseCreateTable(true, true, cached);
        }
        if (this.readIf(75)) {
            if (!cached && !memory) {
                cached = this.database.getDefaultTableType() == 0;
            }
            return this.parseCreateTable(false, false, cached);
        }
        if (this.readIf("SYNONYM")) {
            return this.parseCreateSynonym(orReplace);
        }
        boolean hash = false;
        boolean primaryKey = false;
        NullsDistinct nullsDistinct = null;
        boolean spatial = false;
        String indexName = null;
        Schema oldSchema = null;
        boolean ifNotExists = false;
        if (this.session.isQuirksMode() && this.readIf(63, 47)) {
            if (this.readIf("HASH")) {
                hash = true;
            }
            primaryKey = true;
            if (!this.isToken(60)) {
                ifNotExists = this.readIfNotExists();
                indexName = this.readIdentifierWithSchema(null);
                oldSchema = this.getSchema();
            }
        } else {
            if (this.readIf(80)) {
                nullsDistinct = this.readNullsDistinct(this.database.getMode().nullsDistinct);
            }
            if (this.readIfCompat("HASH")) {
                hash = true;
            } else if (nullsDistinct == null && this.readIf("SPATIAL")) {
                spatial = true;
            }
            this.read("INDEX");
            if (!this.isToken(60)) {
                ifNotExists = this.readIfNotExists();
                indexName = this.readIdentifierWithSchema(null);
                oldSchema = this.getSchema();
            }
        }
        this.read(60);
        String tableName = this.readIdentifierWithSchema();
        this.checkSchema(oldSchema);
        String comment = this.readCommentIf();
        if (!this.readIf(105)) {
            if (hash || spatial) {
                throw this.getSyntaxError();
            }
            this.readCompat(83);
            if (!this.readIf("BTREE")) {
                if (this.readIf("HASH")) {
                    hash = true;
                } else {
                    this.read("RTREE");
                    spatial = true;
                }
            }
            this.read(105);
        }
        CreateIndex command = new CreateIndex(this.session, this.getSchema());
        command.setIfNotExists(ifNotExists);
        command.setPrimaryKey(primaryKey);
        command.setTableName(tableName);
        command.setHash(hash);
        command.setSpatial(spatial);
        command.setIndexName(indexName);
        command.setComment(comment);
        int uniqueColumnCount = 0;
        if (spatial) {
            columns = new IndexColumn[]{new IndexColumn(this.readIdentifier())};
            if (nullsDistinct != null) {
                uniqueColumnCount = 1;
            }
            this.read(106);
        } else {
            columns = this.parseIndexColumnList();
            if (nullsDistinct != null) {
                uniqueColumnCount = columns.length;
                if (this.readIf("INCLUDE")) {
                    this.read(105);
                    IndexColumn[] columnsToInclude = this.parseIndexColumnList();
                    int nonUniqueCount = columnsToInclude.length;
                    columns = Arrays.copyOf(columns, uniqueColumnCount + nonUniqueCount);
                    System.arraycopy(columnsToInclude, 0, columns, uniqueColumnCount, nonUniqueCount);
                }
            } else if (primaryKey) {
                uniqueColumnCount = columns.length;
            }
        }
        command.setIndexColumns(columns);
        command.setUnique(nullsDistinct, uniqueColumnCount);
        return command;
    }

    private NullsDistinct readNullsDistinct(NullsDistinct defaultDistinct) {
        if (this.readIf("NULLS")) {
            if (this.readIf(26)) {
                return NullsDistinct.DISTINCT;
            }
            if (this.readIf(57, 26)) {
                return NullsDistinct.NOT_DISTINCT;
            }
            if (this.readIf(3, 26)) {
                return NullsDistinct.ALL_DISTINCT;
            }
            throw this.getSyntaxError();
        }
        return defaultDistinct;
    }

    private boolean addRoleOrRight(GrantRevoke command) {
        if (this.readIf(69)) {
            command.addRight(1);
            return true;
        }
        if (this.readIf("DELETE")) {
            command.addRight(2);
            return true;
        }
        if (this.readIf("INSERT")) {
            command.addRight(4);
            return true;
        }
        if (this.readIf("UPDATE")) {
            command.addRight(8);
            return true;
        }
        if (this.readIfCompat("CONNECT")) {
            return true;
        }
        if (this.readIfCompat("RESOURCE")) {
            return true;
        }
        command.addRoleName(this.readIdentifier());
        return false;
    }

    private GrantRevoke parseGrantRevoke(int operationType) {
        boolean tableClauseExpected;
        GrantRevoke command = new GrantRevoke(this.session);
        command.setOperationType(operationType);
        if (this.readIf(3)) {
            this.readIf("PRIVILEGES");
            command.addRight(15);
            tableClauseExpected = true;
        } else if (this.readIf("ALTER")) {
            this.read(5);
            this.read("SCHEMA");
            command.addRight(16);
            command.addTable(null);
            tableClauseExpected = false;
        } else {
            tableClauseExpected = this.addRoleOrRight(command);
            while (this.readIf(109)) {
                if (this.addRoleOrRight(command) == tableClauseExpected) continue;
                throw DbException.get(90072);
            }
        }
        if (tableClauseExpected && this.readIf(60)) {
            if (this.readIf("SCHEMA")) {
                command.setSchema(this.database.getSchema(this.readIdentifier()));
            } else {
                this.readIf(75);
                do {
                    Table table = this.readTableOrView();
                    command.addTable(table);
                } while (this.readIf(109));
            }
        }
        this.read(operationType == 49 ? 76 : 35);
        command.setGranteeName(this.readIdentifier());
        return command;
    }

    private TableValueConstructor parseValues() {
        ArrayList<ArrayList<Expression>> rows = Utils.newSmallArrayList();
        ArrayList<Expression> row = this.parseValuesRow(Utils.newSmallArrayList());
        rows.add(row);
        int columnCount = row.size();
        while (this.readIf(109)) {
            row = this.parseValuesRow(new ArrayList<Expression>(columnCount));
            if (row.size() != columnCount) {
                throw DbException.get(21002);
            }
            rows.add(row);
        }
        return new TableValueConstructor(this.session, rows);
    }

    private ArrayList<Expression> parseValuesRow(ArrayList<Expression> row) {
        if (!this.readIf(66, 105) && !this.readIf(105)) {
            row.add(this.readExpression());
            return row;
        }
        do {
            row.add(this.readExpression());
        } while (this.readIfMore());
        return row;
    }

    private Call parseCall() {
        Call command = new Call(this.session);
        this.currentPrepared = command;
        if (this.readIf(75, 105)) {
            command.setTableFunction(this.readTableFunction(1));
            return command;
        }
        int index = this.tokenIndex;
        boolean canBeFunction = this.isIdentifier();
        try {
            command.setExpression(this.readExpression());
        }
        catch (DbException e) {
            if (canBeFunction && e.getErrorCode() == 90022) {
                this.setTokenIndex(index);
                String schemaName = null;
                String name = this.readIdentifier();
                if (this.readIf(110)) {
                    schemaName = name;
                    name = this.readIdentifier();
                    if (this.readIf(110)) {
                        this.checkDatabaseName(schemaName);
                        schemaName = name;
                        name = this.readIdentifier();
                    }
                }
                this.read(105);
                Schema schema = schemaName != null ? this.database.getSchema(schemaName) : null;
                command.setTableFunction(this.readTableFunction(name, schema));
                return command;
            }
            throw e;
        }
        return command;
    }

    private CreateRole parseCreateRole() {
        CreateRole command = new CreateRole(this.session);
        command.setIfNotExists(this.readIfNotExists());
        command.setRoleName(this.readIdentifier());
        return command;
    }

    private CreateSchema parseCreateSchema() {
        String authorization;
        CreateSchema command = new CreateSchema(this.session);
        command.setIfNotExists(this.readIfNotExists());
        if (this.readIf(9)) {
            authorization = this.readIdentifier();
            command.setSchemaName(authorization);
            command.setAuthorization(authorization);
        } else {
            command.setSchemaName(this.readIdentifier());
            authorization = this.readIf(9) ? this.readIdentifier() : this.session.getUser().getName();
        }
        command.setAuthorization(authorization);
        if (this.readIf(89)) {
            command.setTableEngineParams(this.readTableEngineParams());
        }
        return command;
    }

    private ArrayList<String> readTableEngineParams() {
        ArrayList<String> tableEngineParams = Utils.newSmallArrayList();
        do {
            tableEngineParams.add(this.readIdentifier());
        } while (this.readIf(109));
        return tableEngineParams;
    }

    private CreateSequence parseCreateSequence() {
        boolean ifNotExists = this.readIfNotExists();
        String sequenceName = this.readIdentifierWithSchema();
        CreateSequence command = new CreateSequence(this.session, this.getSchema());
        command.setIfNotExists(ifNotExists);
        command.setSequenceName(sequenceName);
        SequenceOptions options = new SequenceOptions();
        this.parseSequenceOptions(options, command, true, false);
        command.setOptions(options);
        return command;
    }

    private boolean readIfNotExists() {
        return this.readIf(40, 57, 30);
    }

    private CreateConstant parseCreateConstant() {
        boolean ifNotExists = this.readIfNotExists();
        String constantName = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        if (this.isKeyword(constantName)) {
            throw DbException.get(90114, constantName);
        }
        this.read(84);
        Expression expr = this.readExpression();
        CreateConstant command = new CreateConstant(this.session, schema);
        command.setConstantName(constantName);
        command.setExpression(expr);
        command.setIfNotExists(ifNotExists);
        return command;
    }

    private CreateAggregate parseCreateAggregate(boolean force) {
        String upperName;
        boolean ifNotExists = this.readIfNotExists();
        String name = this.readIdentifierWithSchema();
        if (this.isKeyword(name) || BuiltinFunctions.isBuiltinFunction(this.database, upperName = this.upperName(name)) || Aggregate.getAggregateType(upperName) != null) {
            throw DbException.get(90076, name);
        }
        CreateAggregate command = new CreateAggregate(this.session, this.getSchema());
        command.setForce(force);
        command.setName(name);
        command.setIfNotExists(ifNotExists);
        this.read(33);
        command.setJavaClassMethod(this.readStringOrIdentifier());
        return command;
    }

    private CreateDomain parseCreateDomain() {
        String comment;
        boolean ifNotExists = this.readIfNotExists();
        String domainName = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        CreateDomain command = new CreateDomain(this.session, schema);
        command.setIfNotExists(ifNotExists);
        command.setTypeName(domainName);
        this.readIf(7);
        TypeInfo dataType = this.readIfDataType();
        if (dataType != null) {
            command.setDataType(dataType);
        } else {
            String parentDomainName = this.readIdentifierWithSchema();
            command.setParentDomain(this.getSchema().getDomain(parentDomainName));
        }
        if (this.readIf(25)) {
            command.setDefaultExpression(this.readExpression());
        }
        if (this.readIf(60, "UPDATE")) {
            command.setOnUpdateExpression(this.readExpression());
        }
        if (this.readIfCompat("SELECTIVITY")) {
            this.readNonNegativeInt();
        }
        if ((comment = this.readCommentIf()) != null) {
            command.setComment(comment);
        }
        while (true) {
            String constraintName;
            if (this.readIf(14)) {
                constraintName = this.readIdentifier();
                this.read(13);
            } else {
                if (!this.readIf(13)) break;
                constraintName = null;
            }
            AlterDomainAddConstraint constraint = new AlterDomainAddConstraint(this.session, schema, ifNotExists);
            constraint.setConstraintName(constraintName);
            constraint.setDomainName(domainName);
            this.parseDomainConstraint = true;
            try {
                constraint.setCheckExpression(this.readExpression());
            }
            finally {
                this.parseDomainConstraint = false;
            }
            command.addConstraintCommand(constraint);
        }
        return command;
    }

    private CreateTrigger parseCreateTrigger(boolean force) {
        boolean allowOr;
        boolean insteadOf;
        boolean isBefore;
        boolean ifNotExists = this.readIfNotExists();
        String triggerName = this.readIdentifierWithSchema(null);
        Schema schema = this.getSchema();
        if (this.readIf("INSTEAD", "OF")) {
            isBefore = true;
            insteadOf = true;
        } else if (this.readIf("BEFORE")) {
            insteadOf = false;
            isBefore = true;
        } else {
            this.read("AFTER");
            insteadOf = false;
            isBefore = false;
        }
        int typeMask = 0;
        boolean onRollback = false;
        boolean bl = allowOr = this.database.getMode().getEnum() == Mode.ModeEnum.PostgreSQL;
        do {
            if (this.readIf("INSERT")) {
                typeMask |= 1;
                continue;
            }
            if (this.readIf("UPDATE")) {
                typeMask |= 2;
                continue;
            }
            if (this.readIf("DELETE")) {
                typeMask |= 4;
                continue;
            }
            if (this.readIf(69)) {
                typeMask |= 8;
                continue;
            }
            if (this.readIf("ROLLBACK")) {
                onRollback = true;
                continue;
            }
            throw this.getSyntaxError();
        } while (this.readIf(109) || allowOr && this.readIf(61));
        this.read(60);
        String tableName = this.readIdentifierWithSchema();
        this.checkSchema(schema);
        CreateTrigger command = new CreateTrigger(this.session, this.getSchema());
        command.setForce(force);
        command.setTriggerName(triggerName);
        command.setIfNotExists(ifNotExists);
        command.setInsteadOf(insteadOf);
        command.setBefore(isBefore);
        command.setOnRollback(onRollback);
        command.setTypeMask(typeMask);
        command.setTableName(tableName);
        if (this.readIf(33, "EACH")) {
            if (this.readIf(66)) {
                command.setRowBased(true);
            } else {
                this.read("STATEMENT");
            }
        }
        if (this.readIf("QUEUE")) {
            command.setQueueSize(this.readNonNegativeInt());
        }
        command.setNoWait(this.readIf("NOWAIT"));
        if (this.readIf(7)) {
            command.setTriggerSource(this.readString());
        } else {
            this.read("CALL");
            command.setTriggerClassName(this.readStringOrIdentifier());
        }
        return command;
    }

    private CreateUser parseCreateUser() {
        CreateUser command = new CreateUser(this.session);
        command.setIfNotExists(this.readIfNotExists());
        command.setUserName(this.readIdentifier());
        command.setComment(this.readCommentIf());
        if (this.readIf("PASSWORD")) {
            command.setPassword(this.readExpression());
        } else if (this.readIf("SALT")) {
            command.setSalt(this.readExpression());
            this.read("HASH");
            command.setHash(this.readExpression());
        } else if (this.readIf("IDENTIFIED")) {
            this.read("BY");
            command.setPassword(ValueExpression.get(ValueVarchar.get(this.readIdentifier())));
        } else {
            throw this.getSyntaxError();
        }
        if (this.readIf("ADMIN")) {
            command.setAdmin(true);
        }
        return command;
    }

    private CreateFunctionAlias parseCreateFunctionAlias(boolean force) {
        String aliasName;
        boolean ifNotExists = this.readIfNotExists();
        if (this.currentTokenType == 2) {
            aliasName = this.readIdentifierWithSchema();
        } else if (Parser.isKeyword(this.currentTokenType)) {
            aliasName = this.currentToken;
            this.read();
            this.schemaName = this.session.getCurrentSchemaName();
        } else {
            this.addExpected("identifier");
            throw this.getSyntaxError();
        }
        String upperName = this.upperName(aliasName);
        if (this.isReservedFunctionName(upperName)) {
            throw DbException.get(90076, aliasName);
        }
        CreateFunctionAlias command = new CreateFunctionAlias(this.session, this.getSchema());
        command.setForce(force);
        command.setAliasName(aliasName);
        command.setIfNotExists(ifNotExists);
        command.setDeterministic(this.readIf("DETERMINISTIC"));
        this.readIfCompat("NOBUFFER");
        if (this.readIf(7)) {
            command.setSource(this.readString());
        } else {
            this.read(33);
            command.setJavaClassMethod(this.readStringOrIdentifier());
        }
        return command;
    }

    private String readStringOrIdentifier() {
        return this.currentTokenType != 2 ? this.readString() : this.readIdentifier();
    }

    private boolean isReservedFunctionName(String name) {
        int tokenType = ParserUtil.getTokenType(name, false, false);
        if (tokenType != 2) {
            if (this.database.isAllowBuiltinAliasOverride()) {
                switch (tokenType) {
                    case 17: 
                    case 21: 
                    case 22: 
                    case 24: 
                    case 39: 
                    case 51: 
                    case 52: 
                    case 54: 
                    case 55: 
                    case 68: 
                    case 90: {
                        return false;
                    }
                }
            }
            return true;
        }
        return Aggregate.getAggregateType(name) != null || BuiltinFunctions.isBuiltinFunction(this.database, name) && !this.database.isAllowBuiltinAliasOverride();
    }

    private void parseSingleCommonTableExpression(boolean isPotentiallyRecursive) {
        String sql;
        List<Column> columnTemplateList;
        ArrayList<Parameter> queryParameters;
        Query withQuery;
        String[] cols;
        ArrayList<Column> columns;
        String cteName;
        block20: {
            block19: {
                block18: {
                    cteName = this.readIdentifier();
                    columns = Utils.newSmallArrayList();
                    cols = null;
                    if (!isPotentiallyRecursive) break block18;
                    this.read(105);
                    break block19;
                }
                if (!this.readIf(105)) break block20;
            }
            String[] stringArray = cols = this.parseColumnList();
            int n = cols.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                columns.add(new Column(c, TypeInfo.TYPE_VARCHAR));
                ++n2;
            }
        }
        Table oldViewFound = this.getWithSubquery(cteName);
        if (oldViewFound != null) {
            throw DbException.get(42101, cteName);
        }
        this.read(7);
        this.read(105);
        int index = this.tokenIndex;
        this.setTokenIndex(index);
        if (isPotentiallyRecursive) {
            ShadowTable recursiveTable = new ShadowTable(this.database.getMainSchema(), cteName, columns.toArray(new Column[0]));
            BitSet outerUsedParameters = this.openParametersScope();
            this.queryScope.tableSubqueries.put(cteName, recursiveTable);
            try {
                withQuery = this.parseQuery();
            }
            finally {
                queryParameters = this.closeParametersScope(outerUsedParameters);
                this.queryScope.tableSubqueries.remove(cteName);
            }
            columnTemplateList = QueryExpressionTable.createQueryColumnTemplateList(cols, withQuery);
            sql = withQuery.getPlanSQL(0);
            try {
                withQuery = (Query)this.session.prepare(sql, false, true, this.queryScope);
                columnTemplateList = QueryExpressionTable.createQueryColumnTemplateList(cols, withQuery);
                sql = withQuery.getPlanSQL(0);
                isPotentiallyRecursive = false;
            }
            catch (DbException dbException) {}
        } else {
            BitSet outerUsedParameters = this.openParametersScope();
            try {
                withQuery = this.parseQuery();
            }
            finally {
                queryParameters = this.closeParametersScope(outerUsedParameters);
            }
            columnTemplateList = QueryExpressionTable.createQueryColumnTemplateList(cols, withQuery);
            sql = withQuery.getPlanSQL(0);
        }
        this.read(106);
        this.queryScope.tableSubqueries.put(cteName, new CTE(cteName, withQuery, StringUtils.cache(sql), queryParameters, columnTemplateList.toArray(new Column[0]), this.session, isPotentiallyRecursive, this.queryScope));
    }

    /*
     * Unable to fully structure code
     */
    private CreateView parseCreateView(boolean force, boolean orReplace) {
        block8: {
            block9: {
                ifNotExists = this.readIfNotExists();
                viewName = this.readIdentifierWithSchema();
                this.createView = command = new CreateView(this.session, this.getSchema());
                command.setViewName(viewName);
                command.setIfNotExists(ifNotExists);
                command.setComment(this.readCommentIf());
                command.setOrReplace(orReplace);
                command.setForce(force);
                if (this.readIf(105)) {
                    cols = this.parseColumnList();
                    command.setColumnNames(cols);
                }
                this.read(7);
                select = StringUtils.cache(this.sqlCommand.substring(this.token.start()));
                try {
                    this.session.setParsingCreateView(true);
                    try {
                        query = this.parseQuery();
                        query.prepare();
                    }
                    finally {
                        this.session.setParsingCreateView(false);
                    }
                    command.setQuery(query);
                    break block8;
                }
                catch (DbException e) {
                    if (!force) break block9;
                    command.setSelectSQL(select);
                    ** while (this.currentTokenType != 93)
                }
lbl-1000:
                // 1 sources

                {
                    this.read();
                    continue;
lbl32:
                    // 1 sources

                    break block8;
                }
            }
            throw e;
        }
        return command;
    }

    private CreateMaterializedView parseCreateMaterializedView(boolean force, boolean orReplace) {
        Query query;
        boolean ifNotExists = this.readIfNotExists();
        String viewName = this.readIdentifierWithSchema();
        this.read(7);
        CreateMaterializedView command = new CreateMaterializedView(this.session, this.getSchema());
        command.setViewName(viewName);
        command.setIfNotExists(ifNotExists);
        command.setComment(this.readCommentIf());
        command.setOrReplace(orReplace);
        if (force) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        String select = StringUtils.cache(this.sqlCommand.substring(this.token.start()));
        this.session.setParsingCreateView(true);
        try {
            query = this.parseQuery();
        }
        finally {
            this.session.setParsingCreateView(false);
        }
        command.setSelect(query);
        command.setSelectSQL(select);
        return command;
    }

    private TransactionCommand parseCheckpoint() {
        TransactionCommand command = this.readIf("SYNC") ? new TransactionCommand(this.session, 76) : new TransactionCommand(this.session, 73);
        return command;
    }

    private Prepared parseAlter() {
        if (this.readIf(75)) {
            return this.parseAlterTable();
        }
        if (this.readIf(82)) {
            return this.parseAlterUser();
        }
        if (this.readIf("INDEX")) {
            return this.parseAlterIndex();
        }
        if (this.readIf("SCHEMA")) {
            return this.parseAlterSchema();
        }
        if (this.readIf("SEQUENCE")) {
            return this.parseAlterSequence();
        }
        if (this.readIf("VIEW")) {
            return this.parseAlterView();
        }
        if (this.readIf("DOMAIN")) {
            return this.parseAlterDomain();
        }
        throw this.getSyntaxError();
    }

    private void checkSchema(Schema old) {
        if (old != null && this.getSchema() != old) {
            throw DbException.get(90080);
        }
    }

    private AlterIndexRename parseAlterIndex() {
        boolean ifExists = this.readIfExists(false);
        String indexName = this.readIdentifierWithSchema();
        Schema old = this.getSchema();
        AlterIndexRename command = new AlterIndexRename(this.session);
        command.setOldSchema(old);
        command.setOldName(indexName);
        command.setIfExists(ifExists);
        this.read("RENAME");
        this.read(76);
        String newName = this.readIdentifierWithSchema(old.getName());
        this.checkSchema(old);
        command.setNewName(newName);
        return command;
    }

    private DefineCommand parseAlterDomain() {
        boolean ifDomainExists = this.readIfExists(false);
        String domainName = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        if (this.readIf("ADD")) {
            boolean ifNotExists = false;
            String constraintName = null;
            String comment = null;
            if (this.readIf(14)) {
                ifNotExists = this.readIfNotExists();
                constraintName = this.readIdentifierWithSchema(schema.getName());
                this.checkSchema(schema);
                comment = this.readCommentIf();
            }
            this.read(13);
            AlterDomainAddConstraint command = new AlterDomainAddConstraint(this.session, schema, ifNotExists);
            command.setDomainName(domainName);
            command.setConstraintName(constraintName);
            this.parseDomainConstraint = true;
            try {
                command.setCheckExpression(this.readExpression());
            }
            finally {
                this.parseDomainConstraint = false;
            }
            command.setIfDomainExists(ifDomainExists);
            command.setComment(comment);
            if (this.readIf("NOCHECK")) {
                command.setCheckExisting(false);
            } else {
                this.readIf(13);
                command.setCheckExisting(true);
            }
            return command;
        }
        if (this.readIf("DROP")) {
            if (this.readIf(14)) {
                boolean ifConstraintExists = this.readIfExists(false);
                String constraintName = this.readIdentifierWithSchema(schema.getName());
                this.checkSchema(schema);
                AlterDomainDropConstraint command = new AlterDomainDropConstraint(this.session, this.getSchema(), ifConstraintExists);
                command.setConstraintName(constraintName);
                command.setDomainName(domainName);
                command.setIfDomainExists(ifDomainExists);
                return command;
            }
            if (this.readIf(25)) {
                AlterDomainExpressions command = new AlterDomainExpressions(this.session, schema, 94);
                command.setDomainName(domainName);
                command.setIfDomainExists(ifDomainExists);
                command.setExpression(null);
                return command;
            }
            if (this.readIf(60, "UPDATE")) {
                AlterDomainExpressions command = new AlterDomainExpressions(this.session, schema, 95);
                command.setDomainName(domainName);
                command.setIfDomainExists(ifDomainExists);
                command.setExpression(null);
                return command;
            }
        } else {
            if (this.readIf("RENAME")) {
                if (this.readIf(14)) {
                    String constraintName = this.readIdentifierWithSchema(schema.getName());
                    this.checkSchema(schema);
                    this.read(76);
                    AlterDomainRenameConstraint command = new AlterDomainRenameConstraint(this.session, schema);
                    command.setDomainName(domainName);
                    command.setIfDomainExists(ifDomainExists);
                    command.setConstraintName(constraintName);
                    command.setNewConstraintName(this.readIdentifier());
                    return command;
                }
                this.read(76);
                String newName = this.readIdentifierWithSchema(schema.getName());
                this.checkSchema(schema);
                AlterDomainRename command = new AlterDomainRename(this.session, this.getSchema());
                command.setDomainName(domainName);
                command.setIfDomainExists(ifDomainExists);
                command.setNewDomainName(newName);
                return command;
            }
            this.read(71);
            if (this.readIf(25)) {
                AlterDomainExpressions command = new AlterDomainExpressions(this.session, schema, 94);
                command.setDomainName(domainName);
                command.setIfDomainExists(ifDomainExists);
                command.setExpression(this.readExpression());
                return command;
            }
            if (this.readIf(60, "UPDATE")) {
                AlterDomainExpressions command = new AlterDomainExpressions(this.session, schema, 95);
                command.setDomainName(domainName);
                command.setIfDomainExists(ifDomainExists);
                command.setExpression(this.readExpression());
                return command;
            }
        }
        throw this.getSyntaxError();
    }

    private DefineCommand parseAlterView() {
        boolean ifExists = this.readIfExists(false);
        String viewName = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        Table tableView = schema.findTableOrView(this.session, viewName);
        if (!(tableView instanceof TableView) && !ifExists) {
            throw DbException.get(90037, viewName);
        }
        if (this.readIf("RENAME", 76)) {
            String newName = this.readIdentifierWithSchema(schema.getName());
            this.checkSchema(schema);
            AlterTableRename command = new AlterTableRename(this.session, this.getSchema());
            command.setTableName(viewName);
            command.setNewTableName(newName);
            command.setIfTableExists(ifExists);
            return command;
        }
        this.read("RECOMPILE");
        TableView view = (TableView)tableView;
        AlterView command = new AlterView(this.session);
        command.setIfExists(ifExists);
        command.setView(view);
        return command;
    }

    private Prepared parseAlterSchema() {
        boolean ifExists = this.readIfExists(false);
        String schemaName = this.readIdentifierWithSchema();
        Schema old = this.getSchema();
        this.read("RENAME");
        this.read(76);
        String newName = this.readIdentifierWithSchema(old.getName());
        Schema schema = this.findSchema(schemaName);
        if (schema == null) {
            if (ifExists) {
                return new NoOperation(this.session);
            }
            throw DbException.get(90079, schemaName);
        }
        AlterSchemaRename command = new AlterSchemaRename(this.session);
        command.setOldSchema(schema);
        this.checkSchema(old);
        command.setNewName(newName);
        return command;
    }

    private AlterSequence parseAlterSequence() {
        boolean ifExists = this.readIfExists(false);
        String sequenceName = this.readIdentifierWithSchema();
        AlterSequence command = new AlterSequence(this.session, this.getSchema());
        command.setSequenceName(sequenceName);
        command.setIfExists(ifExists);
        SequenceOptions options = new SequenceOptions();
        this.parseSequenceOptions(options, null, false, false);
        command.setOptions(options);
        return command;
    }

    private boolean parseSequenceOptions(SequenceOptions options, CreateSequence command, boolean allowDataType, boolean forAlterColumn) {
        boolean result = false;
        while (true) {
            if (allowDataType && this.readIf(7)) {
                TypeInfo dataType = this.parseDataType();
                if (!DataType.isNumericType(dataType.getValueType())) {
                    throw DbException.getUnsupportedException(dataType.getSQL(new StringBuilder("CREATE SEQUENCE AS "), 3).toString());
                }
                options.setDataType(dataType);
            } else if (this.readIf("START", 89) || this.database.getMode().getEnum() == Mode.ModeEnum.PostgreSQL && this.readIfCompat("START")) {
                options.setStartValue(this.readExpression());
            } else if (this.readIf("RESTART")) {
                options.setRestartValue(this.readIf(89) ? this.readExpression() : ValueExpression.DEFAULT);
            } else if (command == null || !this.parseCreateSequenceOption(command)) {
                if (forAlterColumn) {
                    int index = this.tokenIndex;
                    if (!this.readIf(71)) break;
                    if (!this.parseBasicSequenceOption(options)) {
                        this.setTokenIndex(index);
                        break;
                    }
                } else if (!this.parseBasicSequenceOption(options)) break;
            }
            result = true;
        }
        return result;
    }

    private boolean parseCreateSequenceOption(CreateSequence command) {
        if (this.readIf("BELONGS_TO_TABLE")) {
            command.setBelongsToTable(true);
        } else if (!this.readIfCompat(62)) {
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseBasicSequenceOption(SequenceOptions options) {
        if (this.readIf("INCREMENT")) {
            this.readIf("BY");
            options.setIncrement(this.readExpression());
            return true;
        } else if (this.readIf("MINVALUE")) {
            options.setMinValue(this.readExpression());
            return true;
        } else if (this.readIf("MAXVALUE")) {
            options.setMaxValue(this.readExpression());
            return true;
        } else if (this.readIf("CYCLE")) {
            options.setCycle(Sequence.Cycle.CYCLE);
            return true;
        } else if (this.readIf("NO")) {
            if (this.readIf("MINVALUE")) {
                options.setMinValue(ValueExpression.NULL);
                return true;
            } else if (this.readIf("MAXVALUE")) {
                options.setMaxValue(ValueExpression.NULL);
                return true;
            } else if (this.readIf("CYCLE")) {
                options.setCycle(Sequence.Cycle.NO_CYCLE);
                return true;
            } else {
                if (!this.readIf("CACHE")) throw this.getSyntaxError();
                options.setCacheSize(ValueExpression.get(ValueBigint.get(1L)));
            }
            return true;
        } else if (this.readIf("EXHAUSTED")) {
            options.setCycle(Sequence.Cycle.EXHAUSTED);
            return true;
        } else if (this.readIf("CACHE")) {
            options.setCacheSize(this.readExpression());
            return true;
        } else if (this.readIfCompat("NOMINVALUE")) {
            options.setMinValue(ValueExpression.NULL);
            return true;
        } else if (this.readIfCompat("NOMAXVALUE")) {
            options.setMaxValue(ValueExpression.NULL);
            return true;
        } else if (this.readIfCompat("NOCYCLE")) {
            options.setCycle(Sequence.Cycle.NO_CYCLE);
            return true;
        } else {
            if (!this.readIfCompat("NOCACHE")) return false;
            options.setCacheSize(ValueExpression.get(ValueBigint.get(1L)));
        }
        return true;
    }

    private AlterUser parseAlterUser() {
        String userName = this.readIdentifier();
        if (this.readIf(71)) {
            AlterUser command = new AlterUser(this.session);
            command.setType(19);
            command.setUser(this.database.getUser(userName));
            if (this.readIf("PASSWORD")) {
                command.setPassword(this.readExpression());
            } else if (this.readIf("SALT")) {
                command.setSalt(this.readExpression());
                this.read("HASH");
                command.setHash(this.readExpression());
            } else {
                throw this.getSyntaxError();
            }
            return command;
        }
        if (this.readIf("RENAME", 76)) {
            AlterUser command = new AlterUser(this.session);
            command.setType(18);
            command.setUser(this.database.getUser(userName));
            command.setNewName(this.readIdentifier());
            return command;
        }
        if (this.readIf("ADMIN")) {
            AlterUser command = new AlterUser(this.session);
            command.setType(17);
            User user = this.database.getUser(userName);
            command.setUser(user);
            if (this.readIf(77)) {
                command.setAdmin(true);
            } else if (this.readIf(31)) {
                command.setAdmin(false);
            } else {
                throw this.getSyntaxError();
            }
            return command;
        }
        throw this.getSyntaxError();
    }

    private void readIfEqualOrTo() {
        if (!this.readIf(95)) {
            this.readIf(76);
        }
    }

    private Prepared parseSet() {
        block40: {
            Prepared command;
            if (this.readIf(101)) {
                Set command2 = new Set(this.session, 29);
                command2.setString(this.readIdentifier());
                this.readIfEqualOrTo();
                command2.setExpression(this.readExpression());
                return command2;
            }
            if (this.readIf("AUTOCOMMIT")) {
                this.readIfEqualOrTo();
                return new TransactionCommand(this.session, this.readBooleanSetting() ? 69 : 70);
            }
            if (this.readIf("EXCLUSIVE")) {
                this.readIfEqualOrTo();
                Set command3 = new Set(this.session, 27);
                command3.setExpression(this.readExpression());
                return command3;
            }
            if (this.readIf("IGNORECASE")) {
                this.readIfEqualOrTo();
                Set command4 = new Set(this.session, 0);
                command4.setInt(this.readBooleanSetting() ? 1 : 0);
                return command4;
            }
            if (this.readIf("PASSWORD")) {
                this.readIfEqualOrTo();
                AlterUser command5 = new AlterUser(this.session);
                command5.setType(19);
                command5.setUser(this.session.getUser());
                command5.setPassword(this.readExpression());
                return command5;
            }
            if (this.readIf("SALT")) {
                this.readIfEqualOrTo();
                AlterUser command6 = new AlterUser(this.session);
                command6.setType(19);
                command6.setUser(this.session.getUser());
                command6.setSalt(this.readExpression());
                this.read("HASH");
                command6.setHash(this.readExpression());
                return command6;
            }
            if (this.readIf("MODE")) {
                this.readIfEqualOrTo();
                Set command7 = new Set(this.session, 2);
                command7.setString(this.readIdentifier());
                return command7;
            }
            if (this.readIf("DATABASE")) {
                this.readIfEqualOrTo();
                this.read("COLLATION");
                return this.parseSetCollation();
            }
            if (this.readIf("COLLATION")) {
                this.readIfEqualOrTo();
                return this.parseSetCollation();
            }
            if (this.readIf("CLUSTER")) {
                this.readIfEqualOrTo();
                Set command8 = new Set(this.session, 12);
                command8.setString(this.readString());
                return command8;
            }
            if (this.readIf("DATABASE_EVENT_LISTENER")) {
                this.readIfEqualOrTo();
                Set command9 = new Set(this.session, 14);
                command9.setString(this.readString());
                return command9;
            }
            if (this.readIf("ALLOW_LITERALS")) {
                this.readIfEqualOrTo();
                Set command10 = new Set(this.session, 21);
                int v = this.readIf(3) ? 2 : (this.readIf("NONE") ? 0 : (this.readIf("NUMBERS") ? 1 : this.readNonNegativeInt()));
                command10.setInt(v);
                return command10;
            }
            if (this.readIf("DEFAULT_TABLE_TYPE")) {
                this.readIfEqualOrTo();
                Set command11 = new Set(this.session, 6);
                int v = this.readIf("MEMORY") ? 1 : (this.readIf("CACHED") ? 0 : this.readNonNegativeInt());
                command11.setInt(v);
                return command11;
            }
            if (this.readIf("SCHEMA")) {
                this.readIfEqualOrTo();
                Set command12 = new Set(this.session, 22);
                command12.setExpression(this.readExpressionOrIdentifier());
                return command12;
            }
            if (this.readIf("CATALOG")) {
                this.readIfEqualOrTo();
                Set command13 = new Set(this.session, 40);
                command13.setExpression(this.readExpressionOrIdentifier());
                return command13;
            }
            if (this.readIf(SetTypes.getTypeName(24))) {
                this.readIfEqualOrTo();
                Set command14 = new Set(this.session, 24);
                ArrayList<String> list = Utils.newSmallArrayList();
                do {
                    list.add(this.readIdentifier());
                } while (this.readIf(109));
                command14.setStringArray(list.toArray(new String[0]));
                return command14;
            }
            if (this.readIf("JAVA_OBJECT_SERIALIZER")) {
                this.readIfEqualOrTo();
                Set command15 = new Set(this.session, 32);
                command15.setString(this.readString());
                return command15;
            }
            if (this.readIf("IGNORE_CATALOGS")) {
                this.readIfEqualOrTo();
                Set command16 = new Set(this.session, 39);
                command16.setInt(this.readBooleanSetting() ? 1 : 0);
                return command16;
            }
            if (this.readIf("SESSION")) {
                this.read("CHARACTERISTICS");
                this.read(7);
                this.read("TRANSACTION");
                return this.parseSetTransactionMode();
            }
            if (this.readIf("TRANSACTION")) {
                return this.parseSetTransactionMode();
            }
            if (this.readIf("TIME")) {
                this.read("ZONE");
                Set command17 = new Set(this.session, 42);
                if (!this.readIf("LOCAL")) {
                    command17.setExpression(this.readExpression());
                }
                return command17;
            }
            if (this.readIf("NON_KEYWORDS")) {
                this.readIfEqualOrTo();
                Set command18 = new Set(this.session, 41);
                ArrayList<String> list = Utils.newSmallArrayList();
                if (this.currentTokenType != 93 && this.currentTokenType != 115) {
                    do {
                        list.add(StringUtils.toUpperEnglish(this.readIdentifierOrKeyword()));
                    } while (this.readIf(109));
                }
                command18.setStringArray(list.toArray(new String[0]));
                return command18;
            }
            if (this.readIf("DEFAULT_NULL_ORDERING")) {
                this.readIfEqualOrTo();
                Set command19 = new Set(this.session, 44);
                command19.setString(this.readIdentifier());
                return command19;
            }
            if (this.readIfCompat("LOG")) {
                throw DbException.getUnsupportedException("LOG");
            }
            String upperName = this.upperName(this.currentToken);
            if (ConnectionInfo.isIgnoredByParser(upperName)) {
                this.read();
                this.readIfEqualOrTo();
                this.read();
                return new NoOperation(this.session);
            }
            int type = SetTypes.getType(upperName);
            if (type >= 0) {
                this.read();
                this.readIfEqualOrTo();
                Set command20 = new Set(this.session, type);
                command20.setExpression(this.readExpression());
                return command20;
            }
            Mode.ModeEnum modeEnum = this.database.getMode().getEnum();
            if (modeEnum != Mode.ModeEnum.REGULAR && (command = this.readSetCompatibility(modeEnum)) != null) {
                return command;
            }
            if (!this.session.isQuirksMode()) break block40;
            switch (upperName) {
                case "UUID_COLLATION": 
                case "BINARY_COLLATION": {
                    this.read();
                    this.readIfEqualOrTo();
                    this.readIdentifier();
                    return new NoOperation(this.session);
                }
            }
        }
        throw this.getSyntaxError();
    }

    private Prepared parseSetTransactionMode() {
        IsolationLevel isolationLevel;
        this.read("ISOLATION");
        this.read("LEVEL");
        if (this.readIf("READ")) {
            if (this.readIf("UNCOMMITTED")) {
                isolationLevel = IsolationLevel.READ_UNCOMMITTED;
            } else {
                this.read("COMMITTED");
                isolationLevel = IsolationLevel.READ_COMMITTED;
            }
        } else if (this.readIf("REPEATABLE")) {
            this.read("READ");
            isolationLevel = IsolationLevel.REPEATABLE_READ;
        } else if (this.readIf("SNAPSHOT")) {
            isolationLevel = IsolationLevel.SNAPSHOT;
        } else {
            this.read("SERIALIZABLE");
            isolationLevel = IsolationLevel.SERIALIZABLE;
        }
        return new SetSessionCharacteristics(this.session, isolationLevel);
    }

    private Expression readExpressionOrIdentifier() {
        if (this.isIdentifier()) {
            return ValueExpression.get(ValueVarchar.get(this.readIdentifier()));
        }
        return this.readExpression();
    }

    private Prepared parseUse() {
        this.readIfEqualOrTo();
        Set command = new Set(this.session, 22);
        command.setExpression(ValueExpression.get(ValueVarchar.get(this.readIdentifier())));
        return command;
    }

    private Set parseSetCollation() {
        Set command = new Set(this.session, 11);
        String name = this.readIdentifier();
        command.setString(name);
        if (this.equalsToken(name, "OFF")) {
            return command;
        }
        Collator coll = CompareMode.getCollator(name);
        if (coll == null) {
            throw DbException.getInvalidValueException("collation", name);
        }
        if (this.readIf("STRENGTH")) {
            if (this.readIf(63)) {
                command.setInt(0);
            } else if (this.readIf("SECONDARY")) {
                command.setInt(1);
            } else if (this.readIf("TERTIARY")) {
                command.setInt(2);
            } else if (this.readIf("IDENTICAL")) {
                command.setInt(3);
            }
        } else {
            command.setInt(coll.getStrength());
        }
        return command;
    }

    private Prepared readSetCompatibility(Mode.ModeEnum modeEnum) {
        switch (modeEnum) {
            case Derby: {
                if (!this.readIfCompat("CREATE")) break;
                this.readIfEqualOrTo();
                this.read();
                return new NoOperation(this.session);
            }
            case HSQLDB: {
                if (!this.readIfCompat("LOGSIZE")) break;
                this.readIfEqualOrTo();
                Set command = new Set(this.session, 1);
                command.setExpression(this.readExpression());
                return command;
            }
            case MariaDB: 
            case MySQL: {
                if (this.readIfCompat("FOREIGN_KEY_CHECKS")) {
                    this.readIfEqualOrTo();
                    Set command = new Set(this.session, 25);
                    command.setExpression(this.readExpression());
                    return command;
                }
                if (!this.readIfCompat("NAMES")) break;
                this.readIfEqualOrTo();
                this.read();
                return new NoOperation(this.session);
            }
            case PostgreSQL: {
                if (this.readIfCompat("STATEMENT_TIMEOUT")) {
                    this.readIfEqualOrTo();
                    Set command = new Set(this.session, 30);
                    command.setInt(this.readNonNegativeInt());
                    return command;
                }
                if (this.readIfCompat("CLIENT_ENCODING") || this.readIfCompat("CLIENT_MIN_MESSAGES") || this.readIfCompat("JOIN_COLLAPSE_LIMIT")) {
                    this.readIfEqualOrTo();
                    this.read();
                    return new NoOperation(this.session);
                }
                if (this.readIfCompat("DATESTYLE")) {
                    String s;
                    this.readIfEqualOrTo();
                    if (!this.readIf("ISO") && !this.equalsToken(s = this.readString(), "ISO")) {
                        throw this.getSyntaxError();
                    }
                    return new NoOperation(this.session);
                }
                if (!this.readIfCompat("SEARCH_PATH")) break;
                this.readIfEqualOrTo();
                Set command = new Set(this.session, 24);
                ArrayList<String> list = Utils.newSmallArrayList();
                String pgCatalog = this.database.sysIdentifier("PG_CATALOG");
                boolean hasPgCatalog = false;
                do {
                    String s;
                    String string = s = this.currentTokenType == 94 ? this.readString() : this.readIdentifier();
                    if ("$user".equals(s)) continue;
                    if (pgCatalog.equals(s)) {
                        hasPgCatalog = true;
                    }
                    list.add(s);
                } while (this.readIf(109));
                if (!hasPgCatalog && this.database.findSchema(pgCatalog) != null) {
                    list.add(0, pgCatalog);
                }
                command.setStringArray(list.toArray(new String[0]));
                return command;
            }
        }
        return null;
    }

    private RunScriptCommand parseRunScript() {
        RunScriptCommand command = new RunScriptCommand(this.session);
        this.read(35);
        command.setFileNameExpr(this.readExpression());
        if (this.readIf("COMPRESSION")) {
            command.setCompressionAlgorithm(this.readIdentifier());
        }
        if (this.readIf("CIPHER")) {
            command.setCipher(this.readIdentifier());
            if (this.readIf("PASSWORD")) {
                command.setPassword(this.readExpression());
            }
        }
        if (this.readIf("CHARSET")) {
            command.setCharset(Charset.forName(this.readString()));
        }
        if (this.readIf("FROM_1X")) {
            command.setFrom1X();
        } else {
            if (this.readIf("QUIRKS_MODE")) {
                command.setQuirksMode(true);
            }
            if (this.readIf("VARIABLE_BINARY")) {
                command.setVariableBinary(true);
            }
        }
        return command;
    }

    private ScriptCommand parseScript() {
        ScriptCommand command = new ScriptCommand(this.session);
        boolean data = true;
        boolean passwords = true;
        boolean settings = true;
        boolean version = true;
        boolean dropTables = false;
        boolean simple = false;
        boolean withColumns = false;
        if (this.readIf("NODATA")) {
            data = false;
        } else {
            if (this.readIf("SIMPLE")) {
                simple = true;
            }
            if (this.readIf("COLUMNS")) {
                withColumns = true;
            }
        }
        if (this.readIf("NOPASSWORDS")) {
            passwords = false;
        }
        if (this.readIf("NOSETTINGS")) {
            settings = false;
        }
        if (this.readIf("NOVERSION")) {
            version = false;
        }
        if (this.readIf("DROP")) {
            dropTables = true;
        }
        if (this.readIf("BLOCKSIZE")) {
            long blockSize = this.readLong();
            command.setLobBlockSize(blockSize);
        }
        command.setData(data);
        command.setPasswords(passwords);
        command.setSettings(settings);
        command.setVersion(version);
        command.setDrop(dropTables);
        command.setSimple(simple);
        command.setWithColumns(withColumns);
        if (this.readIf(76)) {
            command.setFileNameExpr(this.readExpression());
            if (this.readIf("COMPRESSION")) {
                command.setCompressionAlgorithm(this.readIdentifier());
            }
            if (this.readIf("CIPHER")) {
                command.setCipher(this.readIdentifier());
                if (this.readIf("PASSWORD")) {
                    command.setPassword(this.readExpression());
                }
            }
            if (this.readIf("CHARSET")) {
                command.setCharset(Charset.forName(this.readString()));
            }
        }
        if (this.readIf("SCHEMA")) {
            HashSet<String> schemaNames = new HashSet<String>();
            do {
                schemaNames.add(this.readIdentifier());
            } while (this.readIf(109));
            command.setSchemaNames(schemaNames);
        } else if (this.readIf(75)) {
            ArrayList<Table> tables = Utils.newSmallArrayList();
            do {
                tables.add(this.readTableOrView());
            } while (this.readIf(109));
            command.setTables(tables);
        }
        return command;
    }

    private boolean isDualTable(String tableName) {
        return (this.schemaName == null || this.equalsToken(this.schemaName, "SYS")) && this.equalsToken("DUAL", tableName) || this.database.getMode().sysDummy1 && (this.schemaName == null || this.equalsToken(this.schemaName, "SYSIBM")) && this.equalsToken("SYSDUMMY1", tableName);
    }

    private Table readTableOrView() {
        return this.readTableOrView(this.readIdentifierWithSchema(null), true);
    }

    private Table readTableOrView(boolean resolveMaterializedView) {
        return this.readTableOrView(this.readIdentifierWithSchema(null), resolveMaterializedView);
    }

    private Table readTableOrView(String tableName, boolean resolveMaterializedView) {
        if (this.schemaName != null) {
            Table table = this.getSchema().resolveTableOrView(this.session, tableName, resolveMaterializedView);
            if (table != null) {
                return table;
            }
        } else {
            Table table = this.database.getSchema(this.session.getCurrentSchemaName()).resolveTableOrView(this.session, tableName, resolveMaterializedView);
            if (table != null) {
                return table;
            }
            table = this.getWithSubquery(tableName);
            if (table != null) {
                return table;
            }
            String[] schemaNames = this.session.getSchemaSearchPath();
            if (schemaNames != null) {
                String[] stringArray = schemaNames;
                int n = schemaNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    Schema s = this.database.getSchema(name);
                    table = s.resolveTableOrView(this.session, tableName, resolveMaterializedView);
                    if (table != null) {
                        return table;
                    }
                    ++n2;
                }
            }
        }
        if (this.isDualTable(tableName)) {
            return new DualTable(this.database);
        }
        throw this.getTableOrViewNotFoundDbException(tableName);
    }

    private Table getWithSubquery(String name) {
        QueryScope queryScope = this.queryScope;
        while (queryScope != null) {
            Table tableSubquery = queryScope.tableSubqueries.get(name);
            if (tableSubquery != null) {
                return tableSubquery;
            }
            queryScope = queryScope.parent;
        }
        return null;
    }

    private DbException getTableOrViewNotFoundDbException(String tableName) {
        if (this.schemaName != null) {
            return this.getTableOrViewNotFoundDbException(this.schemaName, tableName);
        }
        String currentSchemaName = this.session.getCurrentSchemaName();
        String[] schemaSearchPath = this.session.getSchemaSearchPath();
        if (schemaSearchPath == null) {
            return this.getTableOrViewNotFoundDbException(Collections.singleton(currentSchemaName), tableName);
        }
        LinkedHashSet<String> schemaNames = new LinkedHashSet<String>();
        schemaNames.add(currentSchemaName);
        schemaNames.addAll(Arrays.asList(schemaSearchPath));
        return this.getTableOrViewNotFoundDbException(schemaNames, tableName);
    }

    private DbException getTableOrViewNotFoundDbException(String schemaName, String tableName) {
        return this.getTableOrViewNotFoundDbException(Collections.singleton(schemaName), tableName);
    }

    private DbException getTableOrViewNotFoundDbException(java.util.Set<String> schemaNames, String tableName) {
        if (this.database == null || this.database.getFirstUserTable() == null) {
            return DbException.get(42104, tableName);
        }
        if (this.database.getSettings().caseInsensitiveIdentifiers) {
            return DbException.get(42102, tableName);
        }
        TreeSet<String> candidates = new TreeSet<String>();
        for (String schemaName : schemaNames) {
            this.findTableNameCandidates(schemaName, tableName, candidates);
        }
        if (candidates.isEmpty()) {
            return DbException.get(42102, tableName);
        }
        return DbException.get(42103, tableName, String.join((CharSequence)", ", candidates));
    }

    private void findTableNameCandidates(String schemaName, String tableName, java.util.Set<String> candidates) {
        Schema schema = this.database.getSchema(schemaName);
        String ucTableName = StringUtils.toUpperEnglish(tableName);
        Collection<Table> allTablesAndViews = schema.getAllTablesAndViews(this.session);
        for (Table candidate : allTablesAndViews) {
            String candidateName = candidate.getName();
            if (!ucTableName.equals(StringUtils.toUpperEnglish(candidateName))) continue;
            candidates.add(candidateName);
        }
    }

    private UserDefinedFunction findUserDefinedFunctionWithinPath(Schema schema, String name) {
        if (schema != null) {
            return schema.findFunctionOrAggregate(name);
        }
        schema = this.database.getSchema(this.session.getCurrentSchemaName());
        UserDefinedFunction userDefinedFunction = schema.findFunctionOrAggregate(name);
        if (userDefinedFunction != null) {
            return userDefinedFunction;
        }
        String[] schemaNames = this.session.getSchemaSearchPath();
        if (schemaNames != null) {
            String[] stringArray = schemaNames;
            int n = schemaNames.length;
            int n2 = 0;
            while (n2 < n) {
                String schemaName = stringArray[n2];
                Schema schemaFromPath = this.database.getSchema(schemaName);
                if (schemaFromPath != schema && (userDefinedFunction = schemaFromPath.findFunctionOrAggregate(name)) != null) {
                    return userDefinedFunction;
                }
                ++n2;
            }
        }
        return null;
    }

    private Sequence findSequence(String schema, String sequenceName) {
        Sequence sequence = this.database.getSchema(schema).findSequence(sequenceName);
        if (sequence != null) {
            return sequence;
        }
        String[] schemaNames = this.session.getSchemaSearchPath();
        if (schemaNames != null) {
            String[] stringArray = schemaNames;
            int n = schemaNames.length;
            int n2 = 0;
            while (n2 < n) {
                String n3 = stringArray[n2];
                sequence = this.database.getSchema(n3).findSequence(sequenceName);
                if (sequence != null) {
                    return sequence;
                }
                ++n2;
            }
        }
        return null;
    }

    private Sequence readSequence() {
        String sequenceName = this.readIdentifierWithSchema(null);
        if (this.schemaName != null) {
            return this.getSchema().getSequence(sequenceName);
        }
        Sequence sequence = this.findSequence(this.session.getCurrentSchemaName(), sequenceName);
        if (sequence != null) {
            return sequence;
        }
        throw DbException.get(90036, sequenceName);
    }

    private Prepared parseAlterTable() {
        boolean ifTableExists = this.readIfExists(false);
        String tableName = this.readIdentifierWithSchema();
        Schema schema = this.getSchema();
        if (this.readIf("ADD")) {
            DefineCommand command = this.parseTableConstraintIf(tableName, schema, ifTableExists);
            if (command != null) {
                return command;
            }
            return this.parseAlterTableAddColumn(tableName, schema, ifTableExists);
        }
        if (this.readIf(71)) {
            return this.parseAlterTableSet(schema, tableName, ifTableExists);
        }
        if (this.readIf("RENAME")) {
            return this.parseAlterTableRename(schema, tableName, ifTableExists);
        }
        if (this.readIf("DROP")) {
            return this.parseAlterTableDrop(schema, tableName, ifTableExists);
        }
        if (this.readIf("ALTER")) {
            return this.parseAlterTableAlter(schema, tableName, ifTableExists);
        }
        Mode mode = this.database.getMode();
        if (mode.alterTableExtensionsMySQL || mode.alterTableModifyColumn) {
            return this.parseAlterTableCompatibility(schema, tableName, ifTableExists, mode);
        }
        throw this.getSyntaxError();
    }

    private Prepared parseAlterTableAlter(Schema schema, String tableName, boolean ifTableExists) {
        this.readIf("COLUMN");
        boolean ifExists = this.readIfExists(false);
        String columnName = this.readIdentifier();
        Column column = this.columnIfTableExists(schema, tableName, columnName, ifTableExists, ifExists);
        if (this.readIf("RENAME")) {
            this.read(76);
            AlterTableRenameColumn command = new AlterTableRenameColumn(this.session, schema);
            command.setTableName(tableName);
            command.setIfTableExists(ifTableExists);
            command.setIfExists(ifExists);
            command.setOldColumnName(columnName);
            String newName = this.readIdentifier();
            command.setNewColumnName(newName);
            return command;
        }
        if (this.readIf("DROP")) {
            if (this.readIf(25)) {
                if (this.readIf(60, 58)) {
                    AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, schema);
                    command.setTableName(tableName);
                    command.setIfTableExists(ifTableExists);
                    command.setOldColumn(column);
                    command.setType(100);
                    command.setBooleanFlag(false);
                    return command;
                }
                return this.getAlterTableAlterColumnDropDefaultExpression(schema, tableName, ifTableExists, column, 10);
            }
            if (this.readIf("EXPRESSION")) {
                return this.getAlterTableAlterColumnDropDefaultExpression(schema, tableName, ifTableExists, column, 98);
            }
            if (this.readIf("IDENTITY")) {
                return this.getAlterTableAlterColumnDropDefaultExpression(schema, tableName, ifTableExists, column, 99);
            }
            if (this.readIf(60, "UPDATE")) {
                AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, schema);
                command.setTableName(tableName);
                command.setIfTableExists(ifTableExists);
                command.setOldColumn(column);
                command.setType(90);
                command.setDefaultExpression(null);
                return command;
            }
            this.read(57);
            this.read(58);
            AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, schema);
            command.setTableName(tableName);
            command.setIfTableExists(ifTableExists);
            command.setOldColumn(column);
            command.setType(9);
            return command;
        }
        if (this.readIfCompat("TYPE")) {
            return this.parseAlterTableAlterColumnDataType(schema, tableName, columnName, ifTableExists, ifExists);
        }
        if (this.readIf("SELECTIVITY")) {
            AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, schema);
            command.setTableName(tableName);
            command.setIfTableExists(ifTableExists);
            command.setType(13);
            command.setOldColumn(column);
            command.setSelectivity(this.readExpression());
            return command;
        }
        Prepared command = this.parseAlterTableAlterColumnIdentity(schema, tableName, ifTableExists, column);
        if (command != null) {
            return command;
        }
        if (this.readIf(71)) {
            return this.parseAlterTableAlterColumnSet(schema, tableName, ifTableExists, ifExists, columnName, column);
        }
        return this.parseAlterTableAlterColumnType(schema, tableName, columnName, ifTableExists, ifExists, true);
    }

    private Prepared getAlterTableAlterColumnDropDefaultExpression(Schema schema, String tableName, boolean ifTableExists, Column column, int type) {
        AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, schema);
        command.setTableName(tableName);
        command.setIfTableExists(ifTableExists);
        command.setOldColumn(column);
        command.setType(type);
        command.setDefaultExpression(null);
        return command;
    }

    private Prepared parseAlterTableAlterColumnIdentity(Schema schema, String tableName, boolean ifTableExists, Column column) {
        SequenceOptions options;
        Boolean always = null;
        if (this.readIf(71, "GENERATED")) {
            if (this.readIf("ALWAYS")) {
                always = true;
            } else {
                this.read("BY");
                this.read(25);
                always = false;
            }
        }
        if (!this.parseSequenceOptions(options = new SequenceOptions(), null, false, true) && always == null) {
            return null;
        }
        if (column == null) {
            return new NoOperation(this.session);
        }
        if (!column.isIdentity()) {
            AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, schema);
            this.parseAlterColumnUsingIf(command);
            command.setTableName(tableName);
            command.setIfTableExists(ifTableExists);
            command.setType(11);
            command.setOldColumn(column);
            Column newColumn = column.getClone();
            newColumn.setIdentityOptions(options, always != null && always != false);
            command.setNewColumn(newColumn);
            return command;
        }
        AlterSequence command = new AlterSequence(this.session, schema);
        command.setColumn(column, always);
        command.setOptions(options);
        return this.commandIfTableExists(schema, tableName, ifTableExists, command);
    }

    private Prepared parseAlterTableAlterColumnSet(Schema schema, String tableName, boolean ifTableExists, boolean ifExists, String columnName, Column column) {
        if (this.readIf("DATA", "TYPE")) {
            return this.parseAlterTableAlterColumnDataType(schema, tableName, columnName, ifTableExists, ifExists);
        }
        AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, schema);
        command.setTableName(tableName);
        command.setIfTableExists(ifTableExists);
        command.setOldColumn(column);
        NullConstraintType nullConstraint = this.parseNotNullConstraint();
        switch (nullConstraint) {
            case NULL_IS_ALLOWED: {
                command.setType(9);
                break;
            }
            case NULL_IS_NOT_ALLOWED: {
                command.setType(8);
                break;
            }
            case NO_NULL_CONSTRAINT_FOUND: {
                if (this.readIf(25)) {
                    if (this.readIf(60, 58)) {
                        command.setType(100);
                        command.setBooleanFlag(true);
                        break;
                    }
                    Expression defaultExpression = this.readExpression();
                    command.setType(10);
                    command.setDefaultExpression(defaultExpression);
                    break;
                }
                if (this.readIf(60, "UPDATE")) {
                    Expression onUpdateExpression = this.readExpression();
                    command.setType(90);
                    command.setDefaultExpression(onUpdateExpression);
                    break;
                }
                if (this.readIf("INVISIBLE")) {
                    command.setType(87);
                    command.setBooleanFlag(false);
                    break;
                }
                if (!this.readIf("VISIBLE")) break;
                command.setType(87);
                command.setBooleanFlag(true);
                break;
            }
            default: {
                throw DbException.get(90088, "Internal Error - unhandled case: " + nullConstraint.name());
            }
        }
        return command;
    }

    private Prepared parseAlterTableDrop(Schema schema, String tableName, boolean ifTableExists) {
        Prepared command;
        if (this.readIf(14)) {
            boolean ifExists = this.readIfExists(false);
            String constraintName = this.readIdentifierWithSchema(schema.getName());
            ifExists = this.readIfExists(ifExists);
            this.checkSchema(schema);
            AlterTableDropConstraint command2 = new AlterTableDropConstraint(this.session, this.getSchema(), ifExists);
            command2.setTableName(tableName);
            command2.setIfTableExists(ifTableExists);
            command2.setConstraintName(constraintName);
            ConstraintActionType dropAction = this.parseCascadeOrRestrict();
            if (dropAction != null) {
                command2.setDropAction(dropAction);
            }
            return command2;
        }
        if (this.readIf(63, 47)) {
            Table table = this.tableIfTableExists(schema, tableName, ifTableExists);
            if (table == null) {
                return new NoOperation(this.session);
            }
            Index idx = table.getPrimaryKey();
            DropIndex command3 = new DropIndex(this.session, schema);
            command3.setIndexName(idx.getName());
            return command3;
        }
        if (this.database.getMode().alterTableExtensionsMySQL && (command = this.parseAlterTableDropCompatibility(schema, tableName, ifTableExists)) != null) {
            return command;
        }
        this.readIf("COLUMN");
        boolean ifExists = this.readIfExists(false);
        ArrayList<Column> columnsToRemove = new ArrayList<Column>();
        Table table = this.tableIfTableExists(schema, tableName, ifTableExists);
        boolean openingBracketDetected = this.readIf(105);
        do {
            Column column;
            String columnName = this.readIdentifier();
            if (table == null || (column = table.getColumn(columnName, ifExists)) == null) continue;
            columnsToRemove.add(column);
        } while (this.readIf(109));
        if (openingBracketDetected) {
            this.read(106);
        }
        if (table == null || columnsToRemove.isEmpty()) {
            return new NoOperation(this.session);
        }
        AlterTableAlterColumn command4 = new AlterTableAlterColumn(this.session, schema);
        command4.setType(12);
        command4.setTableName(tableName);
        command4.setIfTableExists(ifTableExists);
        command4.setColumnsToRemove(columnsToRemove);
        return command4;
    }

    private Prepared parseAlterTableDropCompatibility(Schema schema, String tableName, boolean ifTableExists) {
        if (this.readIfCompat(34, 47)) {
            boolean ifExists = this.readIfExists(false);
            String constraintName = this.readIdentifierWithSchema(schema.getName());
            this.checkSchema(schema);
            AlterTableDropConstraint command = new AlterTableDropConstraint(this.session, this.getSchema(), ifExists);
            command.setTableName(tableName);
            command.setIfTableExists(ifTableExists);
            command.setConstraintName(constraintName);
            return command;
        }
        if (this.readIfCompat("INDEX")) {
            boolean ifExists = this.readIfExists(false);
            String indexOrConstraintName = this.readIdentifierWithSchema(schema.getName());
            if (schema.findIndex(this.session, indexOrConstraintName) != null) {
                DropIndex dropIndexCommand = new DropIndex(this.session, this.getSchema());
                dropIndexCommand.setIndexName(indexOrConstraintName);
                return this.commandIfTableExists(schema, tableName, ifTableExists, dropIndexCommand);
            }
            AlterTableDropConstraint dropCommand = new AlterTableDropConstraint(this.session, this.getSchema(), ifExists);
            dropCommand.setTableName(tableName);
            dropCommand.setIfTableExists(ifTableExists);
            dropCommand.setConstraintName(indexOrConstraintName);
            return dropCommand;
        }
        return null;
    }

    private Prepared parseAlterTableRename(Schema schema, String tableName, boolean ifTableExists) {
        if (this.readIf("COLUMN")) {
            String columnName = this.readIdentifier();
            this.read(76);
            AlterTableRenameColumn command = new AlterTableRenameColumn(this.session, schema);
            command.setTableName(tableName);
            command.setIfTableExists(ifTableExists);
            command.setOldColumnName(columnName);
            command.setNewColumnName(this.readIdentifier());
            return command;
        }
        if (this.readIf(14)) {
            String constraintName = this.readIdentifierWithSchema(schema.getName());
            this.checkSchema(schema);
            this.read(76);
            AlterTableRenameConstraint command = new AlterTableRenameConstraint(this.session, schema);
            command.setTableName(tableName);
            command.setIfTableExists(ifTableExists);
            command.setConstraintName(constraintName);
            command.setNewConstraintName(this.readIdentifier());
            return command;
        }
        this.read(76);
        String newName = this.readIdentifierWithSchema(schema.getName());
        this.checkSchema(schema);
        AlterTableRename command = new AlterTableRename(this.session, this.getSchema());
        command.setTableName(tableName);
        command.setNewTableName(newName);
        command.setIfTableExists(ifTableExists);
        return command;
    }

    private Prepared parseAlterTableSet(Schema schema, String tableName, boolean ifTableExists) {
        this.read("REFERENTIAL_INTEGRITY");
        int type = 55;
        boolean value = this.readBooleanSetting();
        AlterTableSet command = new AlterTableSet(this.session, schema, type, value);
        command.setTableName(tableName);
        command.setIfTableExists(ifTableExists);
        if (this.readIf(13)) {
            command.setCheckExisting(true);
        } else if (this.readIf("NOCHECK")) {
            command.setCheckExisting(false);
        }
        return command;
    }

    private Prepared parseAlterTableCompatibility(Schema schema, String tableName, boolean ifTableExists, Mode mode) {
        if (mode.alterTableExtensionsMySQL) {
            if (this.readIfCompat("AUTO_INCREMENT")) {
                this.readIf(95);
                Expression restart = this.readExpression();
                Table table = this.tableIfTableExists(schema, tableName, ifTableExists);
                if (table == null) {
                    return new NoOperation(this.session);
                }
                Index idx = table.findPrimaryKey();
                if (idx != null) {
                    IndexColumn[] indexColumnArray = idx.getIndexColumns();
                    int n = indexColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IndexColumn ic = indexColumnArray[n2];
                        Column column = ic.column;
                        if (column.isIdentity()) {
                            AlterSequence command = new AlterSequence(this.session, schema);
                            command.setColumn(column, null);
                            SequenceOptions options = new SequenceOptions();
                            options.setRestartValue(restart);
                            command.setOptions(options);
                            return command;
                        }
                        ++n2;
                    }
                }
                throw DbException.get(42122, "AUTO_INCREMENT PRIMARY KEY");
            }
            if (this.readIfCompat("CHANGE")) {
                this.readIf("COLUMN");
                String columnName = this.readIdentifier();
                String newColumnName = this.readIdentifier();
                Column column = this.columnIfTableExists(schema, tableName, columnName, ifTableExists, false);
                boolean nullable = column == null ? true : column.isNullable();
                this.parseColumnForTable(newColumnName, nullable);
                AlterTableRenameColumn command = new AlterTableRenameColumn(this.session, schema);
                command.setTableName(tableName);
                command.setIfTableExists(ifTableExists);
                command.setOldColumnName(columnName);
                command.setNewColumnName(newColumnName);
                return command;
            }
            if (this.readIfCompat("CONVERT")) {
                this.readIf(76);
                this.readIf("CHARACTER");
                this.readIf(71);
                this.readMySQLCharset();
                if (this.readIf("COLLATE")) {
                    this.readMySQLCharset();
                }
                return new NoOperation(this.session);
            }
        }
        if (mode.alterTableModifyColumn && this.readIfCompat("MODIFY")) {
            AlterTableAlterColumn command;
            this.readIf("COLUMN");
            boolean hasOpeningBracket = this.readIf(105);
            String columnName = this.readIdentifier();
            NullConstraintType nullConstraint = this.parseNotNullConstraint();
            switch (nullConstraint) {
                case NULL_IS_ALLOWED: 
                case NULL_IS_NOT_ALLOWED: {
                    command = new AlterTableAlterColumn(this.session, schema);
                    command.setTableName(tableName);
                    command.setIfTableExists(ifTableExists);
                    Column column = this.columnIfTableExists(schema, tableName, columnName, ifTableExists, false);
                    command.setOldColumn(column);
                    if (nullConstraint == NullConstraintType.NULL_IS_ALLOWED) {
                        command.setType(9);
                        break;
                    }
                    command.setType(8);
                    break;
                }
                case NO_NULL_CONSTRAINT_FOUND: {
                    command = this.parseAlterTableAlterColumnType(schema, tableName, columnName, ifTableExists, false, mode.alterTableModifyColumnPreserveNullability);
                    break;
                }
                default: {
                    throw DbException.get(90088, "Internal Error - unhandled case: " + nullConstraint.name());
                }
            }
            if (hasOpeningBracket) {
                this.read(106);
            }
            return command;
        }
        throw this.getSyntaxError();
    }

    private Table tableIfTableExists(Schema schema, String tableName, boolean ifTableExists) {
        Table table = schema.resolveTableOrView(this.session, tableName);
        if (table == null && !ifTableExists) {
            throw this.getTableOrViewNotFoundDbException(schema.getName(), tableName);
        }
        return table;
    }

    private Column columnIfTableExists(Schema schema, String tableName, String columnName, boolean ifTableExists, boolean ifExists) {
        Table table = this.tableIfTableExists(schema, tableName, ifTableExists);
        if (table == null) {
            return null;
        }
        return table.getColumn(columnName, ifExists);
    }

    private Prepared commandIfTableExists(Schema schema, String tableName, boolean ifTableExists, Prepared commandIfTableExists) {
        return this.tableIfTableExists(schema, tableName, ifTableExists) == null ? new NoOperation(this.session) : commandIfTableExists;
    }

    private AlterTableAlterColumn parseAlterTableAlterColumnType(Schema schema, String tableName, String columnName, boolean ifTableExists, boolean ifExists, boolean preserveNotNull) {
        Column oldColumn = this.columnIfTableExists(schema, tableName, columnName, ifTableExists, ifExists);
        Column newColumn = this.parseColumnForTable(columnName, !preserveNotNull || oldColumn == null || oldColumn.isNullable());
        AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, schema);
        this.parseAlterColumnUsingIf(command);
        command.setTableName(tableName);
        command.setIfTableExists(ifTableExists);
        command.setType(11);
        command.setOldColumn(oldColumn);
        command.setNewColumn(newColumn);
        return command;
    }

    private AlterTableAlterColumn parseAlterTableAlterColumnDataType(Schema schema, String tableName, String columnName, boolean ifTableExists, boolean ifExists) {
        Column oldColumn = this.columnIfTableExists(schema, tableName, columnName, ifTableExists, ifExists);
        Column newColumn = this.parseColumnWithType(columnName);
        if (oldColumn != null) {
            String c;
            Sequence s;
            Expression e;
            if (!oldColumn.isNullable()) {
                newColumn.setNullable(false);
            }
            if (!oldColumn.getVisible()) {
                newColumn.setVisible(false);
            }
            if ((e = oldColumn.getDefaultExpression()) != null) {
                if (oldColumn.isGenerated()) {
                    newColumn.setGeneratedExpression(e);
                } else {
                    newColumn.setDefaultExpression(this.session, e);
                }
            }
            if ((e = oldColumn.getOnUpdateExpression()) != null) {
                newColumn.setOnUpdateExpression(this.session, e);
            }
            if ((s = oldColumn.getSequence()) != null) {
                newColumn.setIdentityOptions(new SequenceOptions(s, newColumn.getType()), oldColumn.isGeneratedAlways());
            }
            if ((c = oldColumn.getComment()) != null) {
                newColumn.setComment(c);
            }
        }
        AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, schema);
        this.parseAlterColumnUsingIf(command);
        command.setTableName(tableName);
        command.setIfTableExists(ifTableExists);
        command.setType(11);
        command.setOldColumn(oldColumn);
        command.setNewColumn(newColumn);
        return command;
    }

    private AlterTableAlterColumn parseAlterTableAddColumn(String tableName, Schema schema, boolean ifTableExists) {
        this.readIf("COLUMN");
        AlterTableAlterColumn command = new AlterTableAlterColumn(this.session, schema);
        command.setType(7);
        command.setTableName(tableName);
        command.setIfTableExists(ifTableExists);
        if (this.readIf(105)) {
            command.setIfNotExists(false);
            do {
                this.parseTableColumnDefinition(command, schema, tableName, false);
            } while (this.readIfMore());
        } else {
            boolean ifNotExists = this.readIfNotExists();
            command.setIfNotExists(ifNotExists);
            this.parseTableColumnDefinition(command, schema, tableName, false);
            this.parseAlterColumnUsingIf(command);
        }
        if (this.readIf("BEFORE")) {
            command.setAddBefore(this.readIdentifier());
        } else if (this.readIf("AFTER")) {
            command.setAddAfter(this.readIdentifier());
        } else if (this.readIf("FIRST")) {
            command.setAddFirst();
        }
        return command;
    }

    private void parseAlterColumnUsingIf(AlterTableAlterColumn command) {
        if (this.readIf(83)) {
            command.setUsingExpression(this.readExpression());
        }
    }

    private ConstraintActionType parseAction() {
        ConstraintActionType result = this.parseCascadeOrRestrict();
        if (result != null) {
            return result;
        }
        if (this.readIf("NO", "ACTION")) {
            return ConstraintActionType.RESTRICT;
        }
        this.read(71);
        if (this.readIf(58)) {
            return ConstraintActionType.SET_NULL;
        }
        this.read(25);
        return ConstraintActionType.SET_DEFAULT;
    }

    private ConstraintActionType parseCascadeOrRestrict() {
        if (this.readIf("CASCADE")) {
            return ConstraintActionType.CASCADE;
        }
        if (this.readIf("RESTRICT")) {
            return ConstraintActionType.RESTRICT;
        }
        return null;
    }

    private DefineCommand parseTableConstraintIf(String tableName, Schema schema, boolean ifTableExists) {
        AlterTableAddConstraint command;
        String constraintName = null;
        String comment = null;
        boolean ifNotExists = false;
        if (this.readIf(14)) {
            ifNotExists = this.readIfNotExists();
            constraintName = this.readIdentifierWithSchema(schema.getName());
            this.checkSchema(schema);
            comment = this.readCommentIf();
        }
        switch (this.currentTokenType) {
            case 63: {
                this.read();
                this.read(47);
                command = new AlterTableAddConstraint(this.session, schema, 6, ifNotExists);
                if (this.readIf("HASH")) {
                    command.setPrimaryKeyHash(true);
                }
                this.read(105);
                command.setIndexColumns(this.parseIndexColumnList());
                if (!this.readIf("INDEX")) break;
                String indexName = this.readIdentifierWithSchema();
                command.setIndex(this.getSchema().findIndex(this.session, indexName));
                break;
            }
            case 80: {
                this.read();
                NullsDistinct nullsDistinct = this.readNullsDistinct(this.database.getMode().nullsDistinct);
                boolean compatibility = this.database.getMode().indexDefinitionInCreateTable;
                if (compatibility) {
                    if (!this.readIfCompat(47)) {
                        this.readIfCompat("INDEX");
                    }
                    if (!this.isToken(105)) {
                        constraintName = this.readIdentifier();
                    }
                }
                this.read(105);
                command = new AlterTableAddConstraint(this.session, schema, 4, ifNotExists);
                command.setNullsDistinct(nullsDistinct);
                if (this.readIf(84, 106)) {
                    command.setIndexColumns(null);
                } else {
                    command.setIndexColumns(this.parseIndexColumnList());
                }
                if (this.readIf("INDEX")) {
                    String indexName = this.readIdentifierWithSchema();
                    command.setIndex(this.getSchema().findIndex(this.session, indexName));
                }
                if (!compatibility) break;
                this.readIfCompat(83, "BTREE");
                break;
            }
            case 34: {
                this.read();
                this.read(47);
                this.read(105);
                command = new AlterTableAddConstraint(this.session, schema, 5, ifNotExists);
                command.setIndexColumns(this.parseIndexColumnList());
                if (this.readIf("INDEX")) {
                    String indexName = this.readIdentifierWithSchema();
                    command.setIndex(schema.findIndex(this.session, indexName));
                }
                this.read("REFERENCES");
                this.parseReferences(command, schema, tableName);
                break;
            }
            case 13: {
                this.read();
                command = new AlterTableAddConstraint(this.session, schema, 3, ifNotExists);
                command.setCheckExpression(this.readExpression());
                break;
            }
            default: {
                if (constraintName == null) {
                    Mode mode = this.database.getMode();
                    if (mode.indexDefinitionInCreateTable) {
                        int start = this.tokenIndex;
                        if (this.readIfCompat(47) || this.readIfCompat("INDEX")) {
                            if (DataType.getTypeByName(this.currentToken, mode) == null) {
                                CreateIndex createIndex = new CreateIndex(this.session, schema);
                                createIndex.setComment(comment);
                                createIndex.setTableName(tableName);
                                createIndex.setIfTableExists(ifTableExists);
                                if (!this.readIf(105)) {
                                    createIndex.setIndexName(this.readIdentifier());
                                    this.read(105);
                                }
                                createIndex.setIndexColumns(this.parseIndexColumnList());
                                if (this.readIf(83)) {
                                    this.read("BTREE");
                                }
                                return createIndex;
                            }
                            this.setTokenIndex(start);
                        }
                    }
                    return null;
                }
                if (this.expectedList != null) {
                    this.addMultipleExpected(63, 80, 34, 13);
                }
                throw this.getSyntaxError();
            }
        }
        if (command.getType() != 6) {
            if (this.readIf("NOCHECK")) {
                command.setCheckExisting(false);
            } else {
                this.readIf(13);
                command.setCheckExisting(true);
            }
        }
        command.setTableName(tableName);
        command.setIfTableExists(ifTableExists);
        command.setConstraintName(constraintName);
        command.setComment(comment);
        return command;
    }

    private void parseReferences(AlterTableAddConstraint command, Schema schema, String tableName) {
        if (this.readIf(105)) {
            command.setRefTableName(schema, tableName);
            command.setRefIndexColumns(this.parseIndexColumnList());
        } else {
            String refTableName = this.readIdentifierWithSchema(schema.getName());
            command.setRefTableName(this.getSchema(), refTableName);
            if (this.readIf(105)) {
                command.setRefIndexColumns(this.parseIndexColumnList());
            }
        }
        if (this.readIf("INDEX")) {
            String indexName = this.readIdentifierWithSchema();
            command.setRefIndex(this.getSchema().findIndex(this.session, indexName));
        }
        while (this.readIf(60)) {
            if (this.readIf("DELETE")) {
                command.setDeleteAction(this.parseAction());
                continue;
            }
            this.read("UPDATE");
            command.setUpdateAction(this.parseAction());
        }
        if (!this.readIf(57, "DEFERRABLE")) {
            this.readIf("DEFERRABLE");
        }
    }

    private CreateLinkedTable parseCreateLinkedTable(boolean temp, boolean globalTemp, boolean force) {
        this.read(75);
        boolean ifNotExists = this.readIfNotExists();
        String tableName = this.readIdentifierWithSchema();
        CreateLinkedTable command = new CreateLinkedTable(this.session, this.getSchema());
        command.setTemporary(temp);
        command.setGlobalTemporary(globalTemp);
        command.setForce(force);
        command.setIfNotExists(ifNotExists);
        command.setTableName(tableName);
        command.setComment(this.readCommentIf());
        this.read(105);
        command.setDriver(this.readString());
        this.read(109);
        command.setUrl(this.readString());
        this.read(109);
        command.setUser(this.readString());
        this.read(109);
        command.setPassword(this.readString());
        this.read(109);
        String originalTable = this.readString();
        if (this.readIf(109)) {
            command.setOriginalSchema(originalTable);
            originalTable = this.readString();
        }
        command.setOriginalTable(originalTable);
        this.read(106);
        if (this.readIf("EMIT", "UPDATES")) {
            command.setEmitUpdates(true);
        } else if (this.readIf("READONLY")) {
            command.setReadOnly(true);
        }
        if (this.readIf("FETCH_SIZE")) {
            command.setFetchSize(this.readNonNegativeInt());
        }
        if (this.readIf("AUTOCOMMIT")) {
            if (this.readIf("ON")) {
                command.setAutoCommit(true);
            } else if (this.readIf("OFF")) {
                command.setAutoCommit(false);
            }
        }
        return command;
    }

    private CreateTable parseCreateTable(boolean temp, boolean globalTemp, boolean persistIndexes) {
        boolean ifNotExists = this.readIfNotExists();
        String tableName = this.readIdentifierWithSchema();
        if (temp && globalTemp && this.equalsToken("SESSION", this.schemaName)) {
            this.schemaName = this.session.getCurrentSchemaName();
            globalTemp = false;
        }
        Schema schema = this.getSchema();
        CreateTable command = new CreateTable(this.session, schema);
        command.setPersistIndexes(persistIndexes);
        command.setTemporary(temp);
        command.setGlobalTemporary(globalTemp);
        command.setIfNotExists(ifNotExists);
        command.setTableName(tableName);
        command.setComment(this.readCommentIf());
        if (this.readIf(105) && !this.readIf(106)) {
            do {
                this.parseTableColumnDefinition(command, schema, tableName, true);
            } while (this.readIfMore());
        }
        if (this.database.getMode().mySqlTableOptions) {
            this.parseCreateTableMySQLTableOptions(command);
        }
        if (this.readIf("ENGINE")) {
            command.setTableEngine(this.readIdentifier());
        }
        if (this.readIf(89)) {
            command.setTableEngineParams(this.readTableEngineParams());
        }
        if (temp) {
            if (this.readIf(60, "COMMIT")) {
                if (this.readIf("DROP")) {
                    command.setOnCommitDrop();
                } else if (this.readIf("DELETE")) {
                    this.read("ROWS");
                    command.setOnCommitTruncate();
                }
            } else if (this.readIf(57)) {
                if (this.readIf("PERSISTENT")) {
                    command.setPersistData(false);
                } else {
                    this.read("LOGGED");
                }
            }
            if (this.readIf("TRANSACTIONAL")) {
                command.setTransactional(true);
            }
        } else if (!persistIndexes && this.readIf(57, "PERSISTENT")) {
            command.setPersistData(false);
        }
        if (this.readIf(7)) {
            this.readIf("SORTED");
            command.setQuery(this.parseQuery());
            if (this.readIf(89)) {
                command.setWithNoData(this.readIf("NO"));
                this.read("DATA");
            }
        }
        return command;
    }

    private void parseTableColumnDefinition(CommandWithColumns command, Schema schema, String tableName, boolean forCreateTable) {
        DefineCommand c = this.parseTableConstraintIf(tableName, schema, false);
        if (c != null) {
            command.addConstraintCommand(c);
            return;
        }
        String columnName = this.readIdentifier();
        if (forCreateTable && (this.currentTokenType == 109 || this.currentTokenType == 106)) {
            command.addColumn(new Column(columnName, TypeInfo.TYPE_UNKNOWN));
            return;
        }
        Column column = this.parseColumnForTable(columnName, true);
        if (column.hasIdentityOptions() && column.isPrimaryKey()) {
            command.addConstraintCommand(Parser.newPrimaryKeyConstraintCommand(this.session, schema, tableName, column));
        }
        command.addColumn(column);
        this.readColumnConstraints(command, schema, tableName, column);
    }

    public static AlterTableAddConstraint newPrimaryKeyConstraintCommand(SessionLocal session, Schema schema, String tableName, Column column) {
        column.setPrimaryKey(false);
        AlterTableAddConstraint pk = new AlterTableAddConstraint(session, schema, 6, false);
        pk.setTableName(tableName);
        pk.setIndexColumns(new IndexColumn[]{new IndexColumn(column.getName())});
        return pk;
    }

    private void readColumnConstraints(CommandWithColumns command, Schema schema, String tableName, Column column) {
        block11: {
            String comment = column.getComment();
            boolean hasPrimaryKey = false;
            boolean hasNotNull = false;
            Mode mode = this.database.getMode();
            while (true) {
                NullConstraintType nullType;
                String constraintName;
                if (this.readIf(14)) {
                    constraintName = this.readIdentifier();
                } else {
                    if (comment == null && (comment = this.readCommentIf()) != null) {
                        column.setComment(comment);
                        continue;
                    }
                    constraintName = null;
                }
                if (!hasPrimaryKey && this.readIf(63, 47)) {
                    hasPrimaryKey = true;
                    boolean hash = this.readIf("HASH");
                    AlterTableAddConstraint pk = new AlterTableAddConstraint(this.session, schema, 6, false);
                    pk.setConstraintName(constraintName);
                    pk.setPrimaryKeyHash(hash);
                    pk.setTableName(tableName);
                    pk.setIndexColumns(new IndexColumn[]{new IndexColumn(column.getName())});
                    command.addConstraintCommand(pk);
                    continue;
                }
                if (this.readIf(80)) {
                    NullsDistinct nullsDistinct = this.readNullsDistinct(this.database.getMode().nullsDistinct);
                    AlterTableAddConstraint unique = new AlterTableAddConstraint(this.session, schema, 4, false);
                    unique.setConstraintName(constraintName);
                    unique.setNullsDistinct(nullsDistinct);
                    unique.setIndexColumns(new IndexColumn[]{new IndexColumn(column.getName())});
                    unique.setTableName(tableName);
                    command.addConstraintCommand(unique);
                    continue;
                }
                if (!hasNotNull && (nullType = this.parseNotNullConstraint()) != NullConstraintType.NO_NULL_CONSTRAINT_FOUND) {
                    hasNotNull = true;
                    if (nullType == NullConstraintType.NULL_IS_NOT_ALLOWED) {
                        column.setNullable(false);
                        continue;
                    }
                    if (nullType != NullConstraintType.NULL_IS_ALLOWED) continue;
                    if (column.isIdentity()) {
                        throw DbException.get(90023, column.getName());
                    }
                    column.setNullable(true);
                    continue;
                }
                if (this.readIf(13)) {
                    AlterTableAddConstraint check = new AlterTableAddConstraint(this.session, schema, 3, false);
                    check.setConstraintName(constraintName);
                    check.setTableName(tableName);
                    check.setCheckExpression(this.readExpression());
                    command.addConstraintCommand(check);
                    continue;
                }
                if (this.readIf("REFERENCES")) {
                    AlterTableAddConstraint ref = new AlterTableAddConstraint(this.session, schema, 5, false);
                    ref.setConstraintName(constraintName);
                    ref.setIndexColumns(new IndexColumn[]{new IndexColumn(column.getName())});
                    ref.setTableName(tableName);
                    this.parseReferences(ref, schema, tableName);
                    command.addConstraintCommand(ref);
                    continue;
                }
                if (constraintName != null) break block11;
                if (column.getIdentityOptions() != null || !this.parseCompatibilityIdentity(column, mode)) break;
            }
            return;
        }
        throw this.getSyntaxError();
    }

    private boolean parseCompatibilityIdentity(Column column, Mode mode) {
        if (mode.autoIncrementClause && this.readIfCompat("AUTO_INCREMENT")) {
            this.parseCompatibilityIdentityOptions(column);
            return true;
        }
        if (mode.identityClause && this.readIfCompat("IDENTITY")) {
            this.parseCompatibilityIdentityOptions(column);
            return true;
        }
        return false;
    }

    private void parseCreateTableMySQLTableOptions(CreateTable command) {
        boolean requireNext = false;
        while (true) {
            block20: {
                if (this.readIfCompat("AUTO_INCREMENT")) {
                    this.readIf(95);
                    Expression value = this.readExpression();
                    AlterTableAddConstraint primaryKey = command.getPrimaryKey();
                    if (primaryKey != null) {
                        IndexColumn[] indexColumnArray = primaryKey.getIndexColumns();
                        int n = indexColumnArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IndexColumn ic = indexColumnArray[n2];
                            String columnName = ic.columnName;
                            for (Column column : command.getColumns()) {
                                SequenceOptions options;
                                if (!this.database.equalsIdentifiers(column.getName(), columnName) || (options = column.getIdentityOptions()) == null) continue;
                                options.setStartValue(value);
                                break block20;
                            }
                            ++n2;
                        }
                    }
                    throw DbException.get(42122, "AUTO_INCREMENT PRIMARY KEY");
                }
                if (this.readIfCompat(25)) {
                    if (!this.readIf("CHARACTER", 71)) {
                        this.readIf("CHARSET");
                        this.readIf("COLLATE");
                    }
                    this.readMySQLCharset();
                } else if (this.readIfCompat("CHARACTER")) {
                    this.read(71);
                    this.readMySQLCharset();
                } else if (this.readIfCompat("COLLATE")) {
                    this.readMySQLCharset();
                } else if (this.readIfCompat("CHARSET")) {
                    this.readMySQLCharset();
                } else if (this.readIfCompat("COMMENT")) {
                    this.readIf(95);
                    command.setComment(this.readString());
                } else if (this.readIfCompat("ENGINE")) {
                    this.readIf(95);
                    this.readIdentifier();
                } else if (this.readIfCompat("ROW_FORMAT")) {
                    this.readIf(95);
                    this.readIdentifier();
                } else {
                    if (!requireNext) break;
                    throw this.getSyntaxError();
                }
            }
            requireNext = this.readIf(109);
        }
    }

    private void readMySQLCharset() {
        this.readIf(95);
        this.readIdentifier();
    }

    private NullConstraintType parseNotNullConstraint(NullConstraintType nullConstraint) {
        if (nullConstraint == NullConstraintType.NO_NULL_CONSTRAINT_FOUND) {
            nullConstraint = this.parseNotNullConstraint();
        }
        return nullConstraint;
    }

    private NullConstraintType parseNotNullConstraint() {
        NullConstraintType nullConstraint;
        if (this.readIf(57, 58)) {
            nullConstraint = NullConstraintType.NULL_IS_NOT_ALLOWED;
        } else if (this.readIfCompat(58)) {
            nullConstraint = NullConstraintType.NULL_IS_ALLOWED;
        } else {
            return NullConstraintType.NO_NULL_CONSTRAINT_FOUND;
        }
        if (this.database.getMode().getEnum() == Mode.ModeEnum.Oracle) {
            nullConstraint = this.parseNotNullCompatibility(nullConstraint);
        }
        return nullConstraint;
    }

    private NullConstraintType parseNotNullCompatibility(NullConstraintType nullConstraint) {
        if (this.readIfCompat("ENABLE")) {
            if (!this.readIf("VALIDATE") && this.readIf("NOVALIDATE")) {
                nullConstraint = NullConstraintType.NULL_IS_ALLOWED;
            }
        } else if (this.readIfCompat("DISABLE")) {
            nullConstraint = NullConstraintType.NULL_IS_ALLOWED;
            if (!this.readIf("VALIDATE")) {
                this.readIf("NOVALIDATE");
            }
        }
        return nullConstraint;
    }

    private CreateSynonym parseCreateSynonym(boolean orReplace) {
        boolean ifNotExists = this.readIfNotExists();
        String name = this.readIdentifierWithSchema();
        Schema synonymSchema = this.getSchema();
        this.read(33);
        String tableName = this.readIdentifierWithSchema();
        Schema targetSchema = this.getSchema();
        CreateSynonym command = new CreateSynonym(this.session, synonymSchema);
        command.setName(name);
        command.setSynonymFor(tableName);
        command.setSynonymForSchema(targetSchema);
        command.setComment(this.readCommentIf());
        command.setIfNotExists(ifNotExists);
        command.setOrReplace(orReplace);
        return command;
    }

    private static int getCompareType(int tokenType) {
        switch (tokenType) {
            case 95: {
                return 0;
            }
            case 96: {
                return 5;
            }
            case 97: {
                return 3;
            }
            case 98: {
                return 2;
            }
            case 99: {
                return 4;
            }
            case 100: {
                return 1;
            }
            case 107: {
                return 8;
            }
        }
        return -1;
    }

    public void setRightsChecked(boolean rightsChecked) {
        this.rightsChecked = rightsChecked;
    }

    public void setQueryScope(QueryScope queryScope) {
        this.queryScope = queryScope;
    }

    public Expression parseExpression(String sql) {
        this.initialize(sql, null, false);
        this.read();
        return this.readExpression();
    }

    public Expression parseDomainConstraintExpression(String sql) {
        this.initialize(sql, null, false);
        this.read();
        try {
            this.parseDomainConstraint = true;
            Expression expression = this.readExpression();
            return expression;
        }
        finally {
            this.parseDomainConstraint = false;
        }
    }

    public Table parseTableName(String sql) {
        this.initialize(sql, null, false);
        this.read();
        return this.readTableOrView();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static enum NullConstraintType {
        NULL_IS_ALLOWED,
        NULL_IS_NOT_ALLOWED,
        NO_NULL_CONSTRAINT_FOUND;

    }
}

