/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import org.h2.engine.CastDataProvider;
import org.h2.message.DbException;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueInteger;
import org.h2.value.ValueVarbinary;
import org.h2.value.ValueVarchar;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class Token
implements Cloneable {
    static final int PARAMETER = 92;
    static final int END_OF_INPUT = 93;
    static final int LITERAL = 94;
    static final int EQUAL = 95;
    static final int BIGGER_EQUAL = 96;
    static final int BIGGER = 97;
    static final int SMALLER = 98;
    static final int SMALLER_EQUAL = 99;
    static final int NOT_EQUAL = 100;
    static final int AT = 101;
    static final int MINUS_SIGN = 102;
    static final int PLUS_SIGN = 103;
    static final int CONCATENATION = 104;
    static final int OPEN_PAREN = 105;
    static final int CLOSE_PAREN = 106;
    static final int SPATIAL_INTERSECTS = 107;
    static final int ASTERISK = 108;
    static final int COMMA = 109;
    static final int DOT = 110;
    static final int OPEN_BRACE = 111;
    static final int CLOSE_BRACE = 112;
    static final int SLASH = 113;
    static final int PERCENT = 114;
    static final int SEMICOLON = 115;
    static final int COLON = 116;
    static final int OPEN_BRACKET = 117;
    static final int CLOSE_BRACKET = 118;
    static final int TILDE = 119;
    static final int COLON_COLON = 120;
    static final int COLON_EQ = 121;
    static final int NOT_TILDE = 122;
    static final String[] TOKENS;
    private int start;

    static {
        String[] stringArray = new String[123];
        stringArray[3] = "ALL";
        stringArray[4] = "AND";
        stringArray[5] = "ANY";
        stringArray[6] = "ARRAY";
        stringArray[7] = "AS";
        stringArray[8] = "ASYMMETRIC";
        stringArray[9] = "AUTHORIZATION";
        stringArray[10] = "BETWEEN";
        stringArray[11] = "CASE";
        stringArray[12] = "CAST";
        stringArray[13] = "CHECK";
        stringArray[14] = "CONSTRAINT";
        stringArray[15] = "CROSS";
        stringArray[16] = "CURRENT_CATALOG";
        stringArray[17] = "CURRENT_DATE";
        stringArray[18] = "CURRENT_PATH";
        stringArray[19] = "CURRENT_ROLE";
        stringArray[20] = "CURRENT_SCHEMA";
        stringArray[21] = "CURRENT_TIME";
        stringArray[22] = "CURRENT_TIMESTAMP";
        stringArray[23] = "CURRENT_USER";
        stringArray[24] = "DAY";
        stringArray[25] = "DEFAULT";
        stringArray[26] = "DISTINCT";
        stringArray[27] = "ELSE";
        stringArray[28] = "END";
        stringArray[29] = "EXCEPT";
        stringArray[30] = "EXISTS";
        stringArray[31] = "FALSE";
        stringArray[32] = "FETCH";
        stringArray[33] = "FOR";
        stringArray[34] = "FOREIGN";
        stringArray[35] = "FROM";
        stringArray[36] = "FULL";
        stringArray[37] = "GROUP";
        stringArray[38] = "HAVING";
        stringArray[39] = "HOUR";
        stringArray[40] = "IF";
        stringArray[41] = "IN";
        stringArray[42] = "INNER";
        stringArray[43] = "INTERSECT";
        stringArray[44] = "INTERVAL";
        stringArray[45] = "IS";
        stringArray[46] = "JOIN";
        stringArray[47] = "KEY";
        stringArray[48] = "LEFT";
        stringArray[49] = "LIKE";
        stringArray[50] = "LIMIT";
        stringArray[51] = "LOCALTIME";
        stringArray[52] = "LOCALTIMESTAMP";
        stringArray[53] = "MINUS";
        stringArray[54] = "MINUTE";
        stringArray[55] = "MONTH";
        stringArray[56] = "NATURAL";
        stringArray[57] = "NOT";
        stringArray[58] = "NULL";
        stringArray[59] = "OFFSET";
        stringArray[60] = "ON";
        stringArray[61] = "OR";
        stringArray[62] = "ORDER";
        stringArray[63] = "PRIMARY";
        stringArray[64] = "QUALIFY";
        stringArray[65] = "RIGHT";
        stringArray[66] = "ROW";
        stringArray[67] = "ROWNUM";
        stringArray[68] = "SECOND";
        stringArray[69] = "SELECT";
        stringArray[70] = "SESSION_USER";
        stringArray[71] = "SET";
        stringArray[72] = "SOME";
        stringArray[73] = "SYMMETRIC";
        stringArray[74] = "SYSTEM_USER";
        stringArray[75] = "TABLE";
        stringArray[76] = "TO";
        stringArray[77] = "TRUE";
        stringArray[78] = "UESCAPE";
        stringArray[79] = "UNION";
        stringArray[80] = "UNIQUE";
        stringArray[81] = "UNKNOWN";
        stringArray[82] = "USER";
        stringArray[83] = "USING";
        stringArray[84] = "VALUE";
        stringArray[85] = "VALUES";
        stringArray[86] = "WHEN";
        stringArray[87] = "WHERE";
        stringArray[88] = "WINDOW";
        stringArray[89] = "WITH";
        stringArray[90] = "YEAR";
        stringArray[91] = "_ROWID_";
        stringArray[92] = "?";
        stringArray[95] = "=";
        stringArray[96] = ">=";
        stringArray[97] = ">";
        stringArray[98] = "<";
        stringArray[99] = "<=";
        stringArray[100] = "<>";
        stringArray[101] = "@";
        stringArray[102] = "-";
        stringArray[103] = "+";
        stringArray[104] = "||";
        stringArray[105] = "(";
        stringArray[106] = ")";
        stringArray[107] = "&&";
        stringArray[108] = "*";
        stringArray[109] = ",";
        stringArray[110] = ".";
        stringArray[111] = "{";
        stringArray[112] = "}";
        stringArray[113] = "/";
        stringArray[114] = "%";
        stringArray[115] = ";";
        stringArray[116] = ":";
        stringArray[117] = "[";
        stringArray[118] = "]";
        stringArray[119] = "~";
        stringArray[120] = "::";
        stringArray[121] = ":=";
        stringArray[122] = "!~";
        TOKENS = stringArray;
    }

    Token(int start) {
        this.start = start;
    }

    final int start() {
        return this.start;
    }

    final void setStart(int offset) {
        this.start = offset;
    }

    final void subtractFromStart(int offset) {
        this.start -= offset;
    }

    abstract int tokenType();

    String asIdentifier() {
        return null;
    }

    boolean isQuoted() {
        return false;
    }

    Value value(CastDataProvider provider) {
        return null;
    }

    boolean needsUnicodeConversion() {
        return false;
    }

    void convertUnicode(int uescape) {
        throw DbException.getInternalError();
    }

    protected Token clone() {
        try {
            return (Token)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw DbException.getInternalError();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class BigintToken
    extends LiteralToken {
        private final long number;

        BigintToken(int start, long number) {
            super(start);
            this.number = number;
        }

        @Override
        Value value(CastDataProvider provider) {
            if (this.value == null) {
                this.value = ValueBigint.get(this.number);
            }
            return this.value;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class BinaryStringToken
    extends LiteralToken {
        private final byte[] string;

        BinaryStringToken(int start, byte[] string) {
            super(start);
            this.string = string;
        }

        @Override
        Value value(CastDataProvider provider) {
            if (this.value == null) {
                this.value = ValueVarbinary.getNoCopy(this.string);
            }
            return this.value;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class CharacterStringToken
    extends LiteralToken {
        String string;
        private boolean unicode;

        CharacterStringToken(int start, String string, boolean unicode) {
            super(start);
            this.string = string;
            this.unicode = unicode;
        }

        @Override
        Value value(CastDataProvider provider) {
            if (this.value == null) {
                this.value = ValueVarchar.get(this.string, provider);
            }
            return this.value;
        }

        @Override
        boolean needsUnicodeConversion() {
            return this.unicode;
        }

        @Override
        void convertUnicode(int uescape) {
            if (!this.unicode) {
                throw DbException.getInternalError();
            }
            this.string = StringUtils.decodeUnicodeStringSQL(this.string, uescape);
            this.unicode = false;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class EndOfInputToken
    extends Token {
        EndOfInputToken(int start) {
            super(start);
        }

        @Override
        int tokenType() {
            return 93;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class IdentifierToken
    extends Token {
        private String identifier;
        private final boolean quoted;
        private boolean unicode;

        IdentifierToken(int start, String identifier, boolean quoted, boolean unicode) {
            super(start);
            this.identifier = identifier;
            this.quoted = quoted;
            this.unicode = unicode;
        }

        @Override
        int tokenType() {
            return 2;
        }

        @Override
        String asIdentifier() {
            return this.identifier;
        }

        @Override
        boolean isQuoted() {
            return this.quoted;
        }

        @Override
        boolean needsUnicodeConversion() {
            return this.unicode;
        }

        @Override
        void convertUnicode(int uescape) {
            if (!this.unicode) {
                throw DbException.getInternalError();
            }
            this.identifier = StringUtils.decodeUnicodeStringSQL(this.identifier, uescape);
            this.unicode = false;
        }

        public String toString() {
            return this.quoted ? StringUtils.quoteIdentifier(this.identifier) : this.identifier;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class IntegerToken
    extends LiteralToken {
        private final int number;

        IntegerToken(int start, int number) {
            super(start);
            this.number = number;
        }

        @Override
        Value value(CastDataProvider provider) {
            if (this.value == null) {
                this.value = ValueInteger.get(this.number);
            }
            return this.value;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class KeywordOrIdentifierToken
    extends Token {
        private final int type;
        private final String identifier;

        KeywordOrIdentifierToken(int start, int type, String identifier) {
            super(start);
            this.type = type;
            this.identifier = identifier;
        }

        @Override
        int tokenType() {
            return this.type;
        }

        @Override
        String asIdentifier() {
            return this.identifier;
        }

        public String toString() {
            return this.identifier;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class KeywordToken
    extends Token {
        private final int type;

        KeywordToken(int start, int type) {
            super(start);
            this.type = type;
        }

        @Override
        int tokenType() {
            return this.type;
        }

        @Override
        String asIdentifier() {
            return TOKENS[this.type];
        }

        public String toString() {
            return TOKENS[this.type];
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static abstract class LiteralToken
    extends Token {
        Value value;

        LiteralToken(int start) {
            super(start);
        }

        @Override
        final int tokenType() {
            return 94;
        }

        public final String toString() {
            return this.value(null).getTraceSQL();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class ParameterToken
    extends Token {
        int index;

        ParameterToken(int start, int index) {
            super(start);
            this.index = index;
        }

        @Override
        int tokenType() {
            return 92;
        }

        @Override
        String asIdentifier() {
            return "?";
        }

        int index() {
            return this.index;
        }

        public String toString() {
            return this.index == 0 ? "?" : "?" + this.index;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class ValueToken
    extends LiteralToken {
        ValueToken(int start, Value value) {
            super(start);
            this.value = value;
        }

        @Override
        Value value(CastDataProvider provider) {
            return this.value;
        }
    }
}

