/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.AlterTable;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Table;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AlterTableRename
extends AlterTable {
    private String newTableName;

    public AlterTableRename(SessionLocal session, Schema schema) {
        super(session, schema);
    }

    public void setNewTableName(String name) {
        this.newTableName = name;
    }

    @Override
    public long update(Table table) {
        Database db = this.getDatabase();
        Table t = this.getSchema().findTableOrView(this.session, this.newTableName);
        if (t != null || this.newTableName.equals(table.getName())) {
            throw DbException.get(42101, this.newTableName);
        }
        if (table.isTemporary()) {
            throw DbException.getUnsupportedException("temp table");
        }
        db.renameSchemaObject(this.session, table, this.newTableName);
        return 0L;
    }

    @Override
    public int getType() {
        return 15;
    }
}

