/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.DefineCommand;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.table.TableView;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AlterView
extends DefineCommand {
    private boolean ifExists;
    private TableView view;

    public AlterView(SessionLocal session) {
        super(session);
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
    }

    public void setView(TableView view) {
        this.view = view;
    }

    @Override
    public long update() {
        if (this.view == null && this.ifExists) {
            return 0L;
        }
        this.session.getUser().checkSchemaOwner(this.view.getSchema());
        DbException e = this.view.recompile(this.session, false, true);
        if (e != null) {
            throw e;
        }
        return 0L;
    }

    @Override
    public int getType() {
        return 20;
    }
}

