/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.CreateTable;
import org.h2.command.ddl.SchemaOwnerCommand;
import org.h2.command.query.Query;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.MaterializedView;
import org.h2.table.Table;
import org.h2.table.TableType;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CreateMaterializedView
extends SchemaOwnerCommand {
    private final CreateTable createTable;
    private boolean orReplace;
    private boolean ifNotExists;
    private String viewName;
    private String comment;
    private Query select;
    private String selectSQL;

    public CreateMaterializedView(SessionLocal session, Schema schema) {
        super(session, schema);
        this.createTable = new CreateTable(session, schema);
    }

    public void setViewName(String name) {
        this.viewName = name;
        this.createTable.setTableName(name + "$1");
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setSelectSQL(String selectSQL) {
        this.selectSQL = selectSQL;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
        this.createTable.setIfNotExists(ifNotExists);
    }

    public void setSelect(Query query) {
        this.select = query;
        this.createTable.setQuery(query);
    }

    public void setOrReplace(boolean orReplace) {
        this.orReplace = orReplace;
    }

    @Override
    long update(Schema schema) {
        Database db = this.getDatabase();
        Table old = schema.findTableOrView(this.session, this.viewName);
        MaterializedView view = null;
        if (old != null) {
            if (this.ifNotExists) {
                return 0L;
            }
            if (!this.orReplace || TableType.MATERIALIZED_VIEW != old.getTableType()) {
                throw DbException.get(90038, this.viewName);
            }
            view = (MaterializedView)old;
        }
        int id = this.getObjectId();
        this.createTable.update();
        Table underlyingTable = schema.getTableOrView(this.session, this.viewName + "$1");
        if (view == null) {
            view = new MaterializedView(schema, id, this.viewName, underlyingTable, this.select, this.selectSQL);
        } else {
            view.replace(underlyingTable, this.select, this.selectSQL);
            view.setModified();
        }
        if (this.comment != null) {
            view.setComment(this.comment);
        }
        for (Table table : this.select.getTables()) {
            table.addDependentMaterializedView(view);
        }
        if (old == null) {
            db.addSchemaObject(this.session, view);
            db.unlockMeta(this.session);
        } else {
            db.updateMeta(this.session, view);
        }
        return 0L;
    }

    @Override
    public int getType() {
        return 102;
    }
}

