/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.command.ddl.CreateSynonymData;
import org.h2.command.ddl.SchemaOwnerCommand;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.TableSynonym;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CreateSynonym
extends SchemaOwnerCommand {
    private final CreateSynonymData data = new CreateSynonymData();
    private boolean ifNotExists;
    private boolean orReplace;
    private String comment;

    public CreateSynonym(SessionLocal session, Schema schema) {
        super(session, schema);
    }

    public void setName(String name) {
        this.data.synonymName = name;
    }

    public void setSynonymFor(String tableName) {
        this.data.synonymFor = tableName;
    }

    public void setSynonymForSchema(Schema synonymForSchema) {
        this.data.synonymForSchema = synonymForSchema;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setOrReplace(boolean orReplace) {
        this.orReplace = orReplace;
    }

    @Override
    long update(Schema schema) {
        Database db = this.getDatabase();
        this.data.session = this.session;
        db.lockMeta(this.session);
        if (schema.findTableOrView(this.session, this.data.synonymName) != null) {
            throw DbException.get(42101, this.data.synonymName);
        }
        if (this.data.synonymForSchema.findTableOrView(this.session, this.data.synonymFor) != null) {
            return this.createTableSynonym(db);
        }
        throw DbException.get(42102, this.data.synonymForSchema.getName() + "." + this.data.synonymFor);
    }

    private int createTableSynonym(Database db) {
        TableSynonym table;
        TableSynonym old = this.getSchema().getSynonym(this.data.synonymName);
        if (old != null && !this.orReplace) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(42101, this.data.synonymName);
        }
        if (old != null) {
            table = old;
            this.data.schema = table.getSchema();
            table.updateData(this.data);
            table.setComment(this.comment);
            table.setModified();
            db.updateMeta(this.session, table);
        } else {
            this.data.id = this.getObjectId();
            table = this.getSchema().createSynonym(this.data);
            table.setComment(this.comment);
            db.addSchemaObject(this.session, table);
        }
        table.updateSynonymFor();
        return 0;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public int getType() {
        return 88;
    }
}

