/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.ddl.SchemaOwnerCommand;
import org.h2.command.query.Query;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.expression.Parameter;
import org.h2.message.DbException;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.table.TableView;
import org.h2.value.TypeInfo;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class CreateView
extends SchemaOwnerCommand {
    private Query query;
    private String viewName;
    private boolean ifNotExists;
    private String selectSQL;
    private String[] columnNames;
    private String comment;
    private boolean orReplace;
    private boolean force;

    public CreateView(SessionLocal session, Schema schema) {
        super(session, schema);
    }

    public void setViewName(String name) {
        this.viewName = name;
    }

    public void setQuery(Query select) {
        this.query = select;
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public void setSelectSQL(String selectSQL) {
        this.selectSQL = selectSQL;
    }

    public void setColumnNames(String[] cols) {
        this.columnNames = cols;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setOrReplace(boolean orReplace) {
        this.orReplace = orReplace;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    @Override
    long update(Schema schema) {
        String querySQL;
        Database db = this.getDatabase();
        TableView view = null;
        Table old = schema.findTableOrView(this.session, this.viewName);
        if (old != null) {
            if (this.ifNotExists) {
                return 0L;
            }
            if (!this.orReplace || TableType.VIEW != old.getTableType()) {
                throw DbException.get(90038, this.viewName);
            }
            view = (TableView)old;
        }
        int id = this.getObjectId();
        if (this.query == null) {
            querySQL = this.selectSQL;
        } else {
            ArrayList<Parameter> params = this.query.getParameters();
            if (params != null && !params.isEmpty()) {
                throw DbException.getUnsupportedException("parameters in views");
            }
            querySQL = this.query.getPlanSQL(0);
        }
        Column[] columnTemplatesAsUnknowns = null;
        Column[] columnTemplatesAsStrings = null;
        if (this.columnNames != null) {
            columnTemplatesAsUnknowns = new Column[this.columnNames.length];
            columnTemplatesAsStrings = new Column[this.columnNames.length];
            int i = 0;
            while (i < this.columnNames.length) {
                columnTemplatesAsUnknowns[i] = new Column(this.columnNames[i], TypeInfo.TYPE_UNKNOWN);
                columnTemplatesAsStrings[i] = new Column(this.columnNames[i], TypeInfo.TYPE_VARCHAR);
                ++i;
            }
        }
        if (view == null) {
            view = new TableView(schema, id, this.viewName, querySQL, columnTemplatesAsUnknowns, this.session);
        } else {
            view.replace(querySQL, columnTemplatesAsUnknowns, this.session, this.force);
            view.setModified();
        }
        if (this.comment != null) {
            view.setComment(this.comment);
        }
        if (old == null) {
            db.addSchemaObject(this.session, view);
            db.unlockMeta(this.session);
        } else {
            db.updateMeta(this.session, view);
        }
        return 0L;
    }

    @Override
    public int getType() {
        return 34;
    }
}

