/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.ddl.AlterDomain;
import org.h2.command.ddl.AlterDomainAddConstraint;
import org.h2.command.ddl.AlterTableAddConstraint;
import org.h2.constraint.ConstraintActionType;
import org.h2.constraint.ConstraintDomain;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.schema.Domain;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.ColumnTemplate;
import org.h2.table.Table;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DropDomain
extends AlterDomain {
    private ConstraintActionType dropAction;

    public DropDomain(SessionLocal session, Schema schema) {
        super(session, schema);
        this.dropAction = this.getDatabase().getSettings().dropRestrict ? ConstraintActionType.RESTRICT : ConstraintActionType.CASCADE;
    }

    public void setDropAction(ConstraintActionType dropAction) {
        this.dropAction = dropAction;
    }

    @Override
    long update(Schema schema, Domain domain) {
        DropDomain.forAllDependencies(this.session, domain, this::copyColumn, this::copyDomain, true);
        this.getDatabase().removeSchemaObject(this.session, domain);
        return 0L;
    }

    private boolean copyColumn(Domain domain, Column targetColumn) {
        Table targetTable = targetColumn.getTable();
        if (this.dropAction == ConstraintActionType.RESTRICT) {
            throw DbException.get(90107, this.domainName, targetTable.getCreateSQL());
        }
        String columnName = targetColumn.getName();
        ArrayList<ConstraintDomain> constraints = domain.getConstraints();
        if (constraints != null && !constraints.isEmpty()) {
            for (ConstraintDomain constraint : constraints) {
                Expression checkCondition = constraint.getCheckConstraint(this.session, columnName);
                AlterTableAddConstraint check = new AlterTableAddConstraint(this.session, targetTable.getSchema(), 3, false);
                check.setTableName(targetTable.getName());
                check.setCheckExpression(checkCondition);
                check.update();
            }
        }
        DropDomain.copyExpressions(this.session, domain, targetColumn);
        return true;
    }

    private boolean copyDomain(Domain domain, Domain targetDomain) {
        if (this.dropAction == ConstraintActionType.RESTRICT) {
            throw DbException.get(90107, this.domainName, targetDomain.getTraceSQL());
        }
        ArrayList<ConstraintDomain> constraints = domain.getConstraints();
        if (constraints != null && !constraints.isEmpty()) {
            for (ConstraintDomain constraint : constraints) {
                Expression checkCondition = constraint.getCheckConstraint(this.session, null);
                AlterDomainAddConstraint check = new AlterDomainAddConstraint(this.session, targetDomain.getSchema(), false);
                check.setDomainName(targetDomain.getName());
                check.setCheckExpression(checkCondition);
                check.update();
            }
        }
        DropDomain.copyExpressions(this.session, domain, targetDomain);
        return true;
    }

    private static boolean copyExpressions(SessionLocal session, Domain domain, ColumnTemplate targetColumn) {
        targetColumn.setDomain(domain.getDomain());
        Expression e = domain.getDefaultExpression();
        boolean modified = false;
        if (e != null && targetColumn.getDefaultExpression() == null) {
            targetColumn.setDefaultExpression(session, e);
            modified = true;
        }
        if ((e = domain.getOnUpdateExpression()) != null && targetColumn.getOnUpdateExpression() == null) {
            targetColumn.setOnUpdateExpression(session, e);
            modified = true;
        }
        return modified;
    }

    @Override
    public int getType() {
        return 47;
    }
}

