/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.schema.Sequence;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBigint;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class SequenceOptions {
    private TypeInfo dataType;
    private Expression start;
    private Expression restart;
    private Expression increment;
    private Expression maxValue;
    private Expression minValue;
    private Sequence.Cycle cycle;
    private Expression cacheSize;
    private long[] bounds;
    private final Sequence oldSequence;

    private static Long getLong(SessionLocal session, Expression expr) {
        Value value;
        if (expr != null && (value = expr.optimize(session).getValue(session)) != ValueNull.INSTANCE) {
            return value.getLong();
        }
        return null;
    }

    public SequenceOptions() {
        this.oldSequence = null;
    }

    public SequenceOptions(Sequence oldSequence, TypeInfo dataType) {
        this.oldSequence = oldSequence;
        this.dataType = dataType;
        this.getBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeInfo getDataType() {
        if (this.oldSequence != null) {
            Sequence sequence = this.oldSequence;
            synchronized (sequence) {
                this.copyFromOldSequence();
            }
        }
        return this.dataType;
    }

    private void copyFromOldSequence() {
        long[] bounds = this.getBounds();
        long min = Math.max(this.oldSequence.getMinValue(), bounds[0]);
        long max = Math.min(this.oldSequence.getMaxValue(), bounds[1]);
        if (max < min) {
            min = bounds[0];
            max = bounds[1];
        }
        this.minValue = ValueExpression.get(ValueBigint.get(min));
        this.maxValue = ValueExpression.get(ValueBigint.get(max));
        long v = this.oldSequence.getStartValue();
        if (v >= min && v <= max) {
            this.start = ValueExpression.get(ValueBigint.get(v));
        }
        if ((v = this.oldSequence.getBaseValue()) >= min && v <= max) {
            this.restart = ValueExpression.get(ValueBigint.get(v));
        }
        this.increment = ValueExpression.get(ValueBigint.get(this.oldSequence.getIncrement()));
        this.cycle = this.oldSequence.getCycle();
        this.cacheSize = ValueExpression.get(ValueBigint.get(this.oldSequence.getCacheSize()));
    }

    public void setDataType(TypeInfo dataType) {
        this.dataType = dataType;
    }

    public Long getStartValue(SessionLocal session) {
        return this.check(SequenceOptions.getLong(session, this.start));
    }

    public void setStartValue(Expression start) {
        this.start = start;
    }

    public Long getRestartValue(SessionLocal session, long startValue) {
        return this.check(this.restart == ValueExpression.DEFAULT ? Long.valueOf(startValue) : SequenceOptions.getLong(session, this.restart));
    }

    public void setRestartValue(Expression restart) {
        this.restart = restart;
    }

    public Long getIncrement(SessionLocal session) {
        return this.check(SequenceOptions.getLong(session, this.increment));
    }

    public void setIncrement(Expression increment) {
        this.increment = increment;
    }

    public Long getMaxValue(Sequence sequence, SessionLocal session) {
        Long v = this.maxValue == ValueExpression.NULL && sequence != null ? Long.valueOf(Sequence.getDefaultMaxValue(this.getCurrentStart(sequence, session), this.increment != null ? this.getIncrement(session).longValue() : sequence.getIncrement(), this.getBounds())) : SequenceOptions.getLong(session, this.maxValue);
        return this.check(v);
    }

    public void setMaxValue(Expression maxValue) {
        this.maxValue = maxValue;
    }

    public Long getMinValue(Sequence sequence, SessionLocal session) {
        Long v = this.minValue == ValueExpression.NULL && sequence != null ? Long.valueOf(Sequence.getDefaultMinValue(this.getCurrentStart(sequence, session), this.increment != null ? this.getIncrement(session).longValue() : sequence.getIncrement(), this.getBounds())) : SequenceOptions.getLong(session, this.minValue);
        return this.check(v);
    }

    public void setMinValue(Expression minValue) {
        this.minValue = minValue;
    }

    private Long check(Long value) {
        if (value == null) {
            return null;
        }
        long[] bounds = this.getBounds();
        long v = value;
        if (v < bounds[0] || v > bounds[1]) {
            throw DbException.get(22003, Long.toString(v));
        }
        return value;
    }

    public long[] getBounds() {
        long[] bounds = this.bounds;
        if (bounds == null) {
            this.bounds = bounds = SequenceOptions.getBounds(this.dataType);
        }
        return bounds;
    }

    public static long[] getBounds(TypeInfo dataType) {
        long max;
        long min;
        switch (dataType.getValueType()) {
            case 9: {
                min = -128L;
                max = 127L;
                break;
            }
            case 10: {
                min = -32768L;
                max = 32767L;
                break;
            }
            case 11: {
                min = Integer.MIN_VALUE;
                max = Integer.MAX_VALUE;
                break;
            }
            case 12: {
                min = Long.MIN_VALUE;
                max = Long.MAX_VALUE;
                break;
            }
            case 14: {
                min = -16777216L;
                max = 0x1000000L;
                break;
            }
            case 15: {
                min = -9007199254740992L;
                max = 0x20000000000000L;
                break;
            }
            case 13: {
                if (dataType.getScale() != 0) {
                    throw DbException.getUnsupportedException(dataType.getTraceSQL());
                }
                long p = dataType.getPrecision() - (long)dataType.getScale();
                if (p <= 0L) {
                    throw DbException.getUnsupportedException(dataType.getTraceSQL());
                }
                if (p > 18L) {
                    min = Long.MIN_VALUE;
                    max = Long.MAX_VALUE;
                    break;
                }
                max = 10L;
                int i = 1;
                while ((long)i < p) {
                    max *= 10L;
                    ++i;
                }
                min = -(--max);
                break;
            }
            case 16: {
                long p = dataType.getPrecision();
                if (p > 18L) {
                    min = Long.MIN_VALUE;
                    max = Long.MAX_VALUE;
                    break;
                }
                max = 10L;
                int i = 1;
                while ((long)i < p) {
                    max *= 10L;
                    ++i;
                }
                min = -max;
                break;
            }
            default: {
                throw DbException.getUnsupportedException(dataType.getTraceSQL());
            }
        }
        long[] bounds = new long[]{min, max};
        return bounds;
    }

    public Sequence.Cycle getCycle() {
        return this.cycle;
    }

    public void setCycle(Sequence.Cycle cycle) {
        this.cycle = cycle;
    }

    public Long getCacheSize(SessionLocal session) {
        return SequenceOptions.getLong(session, this.cacheSize);
    }

    public void setCacheSize(Expression cacheSize) {
        this.cacheSize = cacheSize;
    }

    private long getCurrentStart(Sequence sequence, SessionLocal session) {
        return this.start != null ? this.getStartValue(session).longValue() : sequence.getBaseValue();
    }
}

