/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.zip.ZipOutputStream;
import org.h2.command.Prepared;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.mvstore.db.Store;
import org.h2.result.ResultInterface;
import org.h2.store.FileLister;
import org.h2.store.fs.FileUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class BackupCommand
extends Prepared {
    private Expression fileNameExpr;

    public BackupCommand(SessionLocal session) {
        super(session);
    }

    public void setFileName(Expression fileName) {
        this.fileNameExpr = fileName;
    }

    @Override
    public long update() {
        String name = this.fileNameExpr.getValue(this.session).getString();
        this.session.getUser().checkAdmin();
        this.backupTo(name);
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupTo(String fileName) {
        Database db = this.getDatabase();
        if (!db.isPersistent()) {
            throw DbException.get(90126);
        }
        try {
            Store store = db.getStore();
            store.flush();
            String name = db.getName();
            name = FileUtils.getName(name);
            Throwable throwable = null;
            Object var6_8 = null;
            try (OutputStream zip = FileUtils.newOutputStream(fileName, false);){
                ZipOutputStream out = new ZipOutputStream(zip);
                db.flush();
                Object object = db.getLobSyncObject();
                synchronized (object) {
                    String prefix = db.getDatabasePath();
                    String dir = FileUtils.getParent(prefix);
                    dir = FileLister.getDir(dir);
                    ArrayList<String> fileList = FileLister.getDatabaseFiles(dir, name, true);
                    for (String n : fileList) {
                        if (!n.endsWith(".mv.db")) continue;
                        store.getMvStore().getFileStore().backup(out);
                    }
                }
                out.close();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, fileName);
        }
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public static String correctFileName(String f) {
        if ((f = f.replace('\\', '/')).startsWith("/")) {
            f = f.substring(1);
        }
        return f;
    }

    @Override
    public boolean needRecompile() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 56;
    }
}

