/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import org.h2.command.dml.DataChangeStatement;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.table.Table;
import org.h2.table.TableFilter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class FilteredDataChangeStatement
extends DataChangeStatement {
    Expression condition;
    TableFilter targetTableFilter;
    Expression fetchExpr;

    FilteredDataChangeStatement(SessionLocal session) {
        super(session);
    }

    @Override
    public final Table getTable() {
        return this.targetTableFilter.getTable();
    }

    public final void setTableFilter(TableFilter tableFilter) {
        this.targetTableFilter = tableFilter;
    }

    public final TableFilter getTableFilter() {
        return this.targetTableFilter;
    }

    public final void setCondition(Expression condition) {
        this.condition = condition;
    }

    public final Expression getCondition() {
        return this.condition;
    }

    public void setFetch(Expression fetch) {
        this.fetchExpr = fetch;
    }

    final boolean nextRow(long limitRows, long count) {
        if (limitRows < 0L || count < limitRows) {
            while (this.targetTableFilter.next()) {
                this.setCurrentRowNumber(count + 1L);
                if (this.condition != null && !this.condition.getBooleanValue(this.session)) continue;
                return true;
            }
        }
        return false;
    }

    final StringBuilder appendFilterCondition(StringBuilder builder, int sqlFlags) {
        if (this.condition != null) {
            builder.append("\nWHERE ");
            this.condition.getUnenclosedSQL(builder, sqlFlags);
        }
        if (this.fetchExpr != null) {
            builder.append("\nFETCH FIRST ");
            String count = this.fetchExpr.getSQL(sqlFlags, 2);
            if ("1".equals(count)) {
                builder.append("ROW ONLY");
            } else {
                builder.append(count).append(" ROWS ONLY");
            }
        }
        return builder;
    }
}

