/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.h2.command.CommandContainer;
import org.h2.command.Prepared;
import org.h2.command.dml.ScriptBase;
import org.h2.engine.SessionLocal;
import org.h2.message.DbException;
import org.h2.result.ResultInterface;
import org.h2.util.ScriptReader;
import org.h2.util.StringUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class RunScriptCommand
extends ScriptBase {
    private static final char UTF8_BOM = '\ufeff';
    private Charset charset = StandardCharsets.UTF_8;
    private boolean quirksMode;
    private boolean variableBinary;
    private boolean from1X;

    public RunScriptCommand(SessionLocal session) {
        super(session);
    }

    @Override
    public long update() {
        this.session.getUser().checkAdmin();
        int count = 0;
        boolean oldQuirksMode = this.session.isQuirksMode();
        boolean oldVariableBinary = this.session.isVariableBinary();
        try {
            try {
                String sql;
                this.openInput(this.charset);
                this.reader.mark(1);
                if (this.reader.read() != 65279) {
                    this.reader.reset();
                }
                if (this.quirksMode) {
                    this.session.setQuirksMode(true);
                }
                if (this.variableBinary) {
                    this.session.setVariableBinary(true);
                }
                ScriptReader r = new ScriptReader(this.reader);
                while ((sql = r.readStatement()) != null) {
                    this.execute(sql);
                    if ((++count & 0x7F) != 0) continue;
                    this.checkCanceled();
                }
                r.close();
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, null);
            }
        }
        finally {
            if (this.quirksMode) {
                this.session.setQuirksMode(oldQuirksMode);
            }
            if (this.variableBinary) {
                this.session.setVariableBinary(oldVariableBinary);
            }
            this.closeIO();
        }
        return count;
    }

    private void execute(String sql) {
        if (this.from1X) {
            int idx;
            if ((sql = sql.trim()).startsWith("--")) {
                char c;
                int i = 2;
                int l = sql.length();
                do {
                    if (i < l) continue;
                    return;
                } while ((c = sql.charAt(i++)) != '\n' && c != '\r');
                sql = StringUtils.trimSubstring(sql, i);
            }
            if (sql.startsWith("INSERT INTO SYSTEM_LOB_STREAM VALUES(") && (idx = sql.indexOf(", NULL, '")) >= 0) {
                sql = new StringBuilder(sql.length() + 1).append(sql, 0, idx + 8).append("X'").append(sql, idx + 9, sql.length()).toString();
            }
        }
        try {
            Prepared command = this.session.prepare(sql);
            CommandContainer commandContainer = new CommandContainer(this.session, sql, command);
            if (commandContainer.isQuery()) {
                commandContainer.executeQuery(0L, false);
            } else {
                commandContainer.executeUpdate(null);
            }
        }
        catch (DbException e) {
            throw e.addSQL(sql);
        }
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setQuirksMode(boolean quirksMode) {
        this.quirksMode = quirksMode;
    }

    public void setVariableBinary(boolean variableBinary) {
        this.variableBinary = variableBinary;
    }

    public void setFrom1X() {
        this.from1X = true;
        this.quirksMode = true;
        this.variableBinary = true;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    @Override
    public int getType() {
        return 64;
    }
}

