/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.h2.command.Prepared;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.engine.SysProperties;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.security.SHA256;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.FileStoreOutputStream;
import org.h2.store.fs.FileUtils;
import org.h2.tools.CompressTool;
import org.h2.util.IOUtils;
import org.h2.util.StringUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class ScriptBase
extends Prepared {
    private static final String SCRIPT_SQL = "script.sql";
    protected OutputStream out;
    protected BufferedReader reader;
    private Expression fileNameExpr;
    private Expression password;
    private String fileName;
    private String cipher;
    private FileStore store;
    private String compressionAlgorithm;

    ScriptBase(SessionLocal session) {
        super(session);
    }

    public void setCipher(String c) {
        this.cipher = c;
    }

    private boolean isEncrypted() {
        return this.cipher != null;
    }

    public void setPassword(Expression password) {
        this.password = password;
    }

    public void setFileNameExpr(Expression file) {
        this.fileNameExpr = file;
    }

    protected String getFileName() {
        if (this.fileNameExpr != null && this.fileName == null) {
            this.fileName = this.fileNameExpr.optimize(this.session).getValue(this.session).getString();
            if (this.fileName == null || StringUtils.isWhitespaceOrEmpty(this.fileName)) {
                this.fileName = SCRIPT_SQL;
            }
            this.fileName = SysProperties.getScriptDirectory() + this.fileName;
        }
        return this.fileName;
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    void deleteStore() {
        String file = this.getFileName();
        if (file != null && FileUtils.isRegularFile(file)) {
            FileUtils.delete(file);
        }
    }

    private void initStore() {
        Database db = this.getDatabase();
        byte[] key = null;
        if (this.cipher != null && this.password != null) {
            char[] pass = this.password.optimize(this.session).getValue(this.session).getString().toCharArray();
            key = SHA256.getKeyPasswordHash("script", pass);
        }
        String file = this.getFileName();
        this.store = FileStore.open(db, file, "rw", this.cipher, key);
        this.store.setCheckedWriting(false);
        this.store.init();
    }

    void openOutput() {
        String file = this.getFileName();
        if (file == null) {
            return;
        }
        if (this.isEncrypted()) {
            this.initStore();
            this.out = new FileStoreOutputStream(this.store, this.compressionAlgorithm);
            this.out = new BufferedOutputStream(this.out, 131072);
        } else {
            OutputStream o;
            try {
                o = FileUtils.newOutputStream(file, false);
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, null);
            }
            this.out = new BufferedOutputStream(o, 4096);
            this.out = CompressTool.wrapOutputStream(this.out, this.compressionAlgorithm, SCRIPT_SQL);
        }
    }

    void openInput(Charset charset) {
        InputStream in;
        String file = this.getFileName();
        if (file == null) {
            return;
        }
        if (this.isEncrypted()) {
            this.initStore();
            in = new FileStoreInputStream(this.store, this.compressionAlgorithm != null, false);
        } else {
            try {
                in = FileUtils.newInputStream(file);
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, file);
            }
            in = CompressTool.wrapInputStream(in, this.compressionAlgorithm, SCRIPT_SQL);
            if (in == null) {
                throw DbException.get(90124, "script.sql in " + file);
            }
        }
        this.reader = new BufferedReader(new InputStreamReader(in, charset), 4096);
    }

    void closeIO() {
        IOUtils.closeSilently(this.out);
        this.out = null;
        IOUtils.closeSilently(this.reader);
        this.reader = null;
        if (this.store != null) {
            this.store.closeSilently();
            this.store = null;
        }
    }

    @Override
    public boolean needRecompile() {
        return false;
    }

    public void setCompressionAlgorithm(String algorithm) {
        this.compressionAlgorithm = algorithm;
    }
}

