/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.h2.command.dml.ScriptBase;
import org.h2.command.dml.SetTypes;
import org.h2.constraint.Constraint;
import org.h2.engine.Comment;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Right;
import org.h2.engine.RightOwner;
import org.h2.engine.Role;
import org.h2.engine.SessionLocal;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.message.DbException;
import org.h2.mvstore.DataUtils;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.Row;
import org.h2.schema.Constant;
import org.h2.schema.Domain;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.schema.UserDefinedFunction;
import org.h2.table.Column;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.table.TableType;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueVarchar;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ScriptCommand
extends ScriptBase {
    private static final Comparator<? super DbObject> BY_NAME_COMPARATOR = (o1, o2) -> {
        int cmp;
        if (o1 instanceof SchemaObject && o2 instanceof SchemaObject && (cmp = ((SchemaObject)o1).getSchema().getName().compareTo(((SchemaObject)o2).getSchema().getName())) != 0) {
            return cmp;
        }
        return o1.getName().compareTo(o2.getName());
    };
    private Charset charset = StandardCharsets.UTF_8;
    private Set<String> schemaNames;
    private Collection<Table> tables;
    private boolean passwords;
    private boolean data;
    private boolean settings;
    private boolean drop;
    private boolean simple;
    private boolean withColumns;
    private boolean version = true;
    private LocalResult result;
    private String lineSeparatorString;
    private byte[] lineSeparator;
    private byte[] buffer;
    private boolean tempLobTableCreated;
    private int nextLobId;
    private int lobBlockSize = 4096;

    public ScriptCommand(SessionLocal session) {
        super(session);
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    public void setSchemaNames(Set<String> schemaNames) {
        this.schemaNames = schemaNames;
    }

    public void setTables(Collection<Table> tables) {
        this.tables = tables;
    }

    public void setData(boolean data) {
        this.data = data;
    }

    public void setPasswords(boolean passwords) {
        this.passwords = passwords;
    }

    public void setSettings(boolean settings) {
        this.settings = settings;
    }

    public void setLobBlockSize(long blockSize) {
        this.lobBlockSize = MathUtils.convertLongToInt(blockSize);
    }

    public void setDrop(boolean drop) {
        this.drop = drop;
    }

    @Override
    public ResultInterface queryMeta() {
        LocalResult r = this.createResult();
        r.done();
        return r;
    }

    private LocalResult createResult() {
        return new LocalResult(this.session, new Expression[]{new ExpressionColumn(this.getDatabase(), new Column("SCRIPT", TypeInfo.TYPE_VARCHAR))}, 1, 1);
    }

    @Override
    public ResultInterface query(long maxrows) {
        this.session.getUser().checkAdmin();
        this.reset();
        Database db = this.getDatabase();
        if (this.schemaNames != null) {
            for (String schemaName : this.schemaNames) {
                Schema schema = db.findSchema(schemaName);
                if (schema != null) continue;
                throw DbException.get(90079, schemaName);
            }
        }
        try {
            try {
                Object object;
                int n;
                this.result = this.createResult();
                this.deleteStore();
                this.openOutput();
                if (this.out != null) {
                    this.buffer = new byte[4096];
                }
                if (this.version) {
                    this.add("-- H2 " + Constants.VERSION, true);
                }
                if (this.settings) {
                    for (Setting setting : db.getAllSettings()) {
                        if (setting.getName().equals(SetTypes.getTypeName(28))) continue;
                        this.add(setting.getCreateSQL(), false);
                    }
                }
                if (this.out != null) {
                    this.add("", true);
                }
                RightOwner[] rightOwners = db.getAllUsersAndRoles().toArray(new RightOwner[0]);
                Arrays.sort(rightOwners, (o1, o2) -> {
                    boolean b = o1 instanceof User;
                    if (b != o2 instanceof User) {
                        return b ? -1 : 1;
                    }
                    if (b && (b = ((User)o1).isAdmin()) != ((User)o2).isAdmin()) {
                        return b ? -1 : 1;
                    }
                    return o1.getName().compareTo(o2.getName());
                });
                RightOwner[] rightOwnerArray = rightOwners;
                int n2 = rightOwners.length;
                int schema = 0;
                while (schema < n2) {
                    RightOwner rightOwner = rightOwnerArray[schema];
                    if (rightOwner instanceof User) {
                        this.add(((User)rightOwner).getCreateSQL(this.passwords), false);
                    } else {
                        this.add(((Role)rightOwner).getCreateSQL(true), false);
                    }
                    ++schema;
                }
                ArrayList<Schema> schemas = new ArrayList<Schema>();
                for (Schema schema2 : db.getAllSchemas()) {
                    if (this.excludeSchema(schema2)) continue;
                    schemas.add(schema2);
                    this.add(schema2.getCreateSQL(), false);
                }
                this.dumpDomains(schemas);
                for (Schema schema3 : schemas) {
                    Constant[] constantArray = (Constant[])ScriptCommand.sorted(schema3.getAllConstants(), Constant.class);
                    n = constantArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Iterator<Schema> constant = constantArray[n3];
                        this.add(((Constant)((Object)constant)).getCreateSQL(), false);
                        ++n3;
                    }
                }
                ArrayList<Table> tables = db.getAllTablesAndViews();
                tables.sort(Comparator.comparingInt(DbObject::getId));
                for (Table table : tables) {
                    if (this.excludeSchema(table.getSchema()) || this.excludeTable(table)) continue;
                    table.lock(this.session, 0);
                    String sql = table.getCreateSQL();
                    if (sql == null || !this.drop) continue;
                    this.add(table.getDropSQL(), false);
                }
                for (Schema schema4 : schemas) {
                    object = (UserDefinedFunction[])ScriptCommand.sorted(schema4.getAllFunctionsAndAggregates(), UserDefinedFunction.class);
                    int n4 = ((UserDefinedFunction[])object).length;
                    n = 0;
                    while (n < n4) {
                        SchemaObject userDefinedFunction = object[n];
                        if (this.drop) {
                            this.add(userDefinedFunction.getDropSQL(), false);
                        }
                        this.add(userDefinedFunction.getCreateSQL(), false);
                        ++n;
                    }
                }
                for (Schema schema4 : schemas) {
                    object = (Sequence[])ScriptCommand.sorted(schema4.getAllSequences(), Sequence.class);
                    int n5 = ((Sequence[])object).length;
                    n = 0;
                    while (n < n5) {
                        SchemaObject sequence = object[n];
                        if (!((Sequence)sequence).getBelongsToTable()) {
                            if (this.drop) {
                                this.add(((Sequence)sequence).getDropSQL(), false);
                            }
                            this.add(((Sequence)sequence).getCreateSQL(), false);
                        }
                        ++n;
                    }
                }
                int count = 0;
                for (Table table : tables) {
                    if (this.excludeSchema(table.getSchema()) || this.excludeTable(table)) continue;
                    table.lock(this.session, 0);
                    String createTableSql = table.getCreateSQL();
                    if (createTableSql == null) continue;
                    TableType tableType = table.getTableType();
                    this.add(createTableSql, false);
                    ArrayList<Constraint> constraints = table.getConstraints();
                    if (constraints != null) {
                        for (Constraint constraint : constraints) {
                            if (Constraint.Type.PRIMARY_KEY != constraint.getConstraintType()) continue;
                            this.add(constraint.getCreateSQLWithoutIndexes(), false);
                        }
                    }
                    if (TableType.TABLE == tableType) {
                        if (table.canGetRowCount(this.session)) {
                            StringBuilder builder = new StringBuilder("-- ").append(table.getRowCountApproximation(this.session)).append(" +/- SELECT COUNT(*) FROM ");
                            table.getSQL(builder, 3);
                            this.add(builder.toString(), false);
                        }
                        if (this.data) {
                            count = this.generateInsertValues(count, table);
                        }
                    }
                    ArrayList<Index> indexes = table.getIndexes();
                    int j = 0;
                    while (indexes != null && j < indexes.size()) {
                        Index index = indexes.get(j);
                        if (!index.getIndexType().getBelongsToConstraint()) {
                            this.add(index.getCreateSQL(), false);
                        }
                        ++j;
                    }
                }
                if (this.tempLobTableCreated) {
                    this.add("DROP TABLE IF EXISTS SYSTEM_LOB_STREAM", true);
                    this.add("DROP ALIAS IF EXISTS SYSTEM_COMBINE_CLOB", true);
                    this.add("DROP ALIAS IF EXISTS SYSTEM_COMBINE_BLOB", true);
                    this.tempLobTableCreated = false;
                }
                ArrayList<Constraint> constraints = new ArrayList<Constraint>();
                for (Schema schema5 : schemas) {
                    for (Constraint constraint : schema5.getAllConstraints()) {
                        if (this.excludeTable(constraint.getTable()) || constraint.getConstraintType() == Constraint.Type.PRIMARY_KEY) continue;
                        constraints.add(constraint);
                    }
                }
                constraints.sort(null);
                for (Constraint constraint : constraints) {
                    this.add(constraint.getCreateSQLWithoutIndexes(), false);
                }
                for (Schema schema5 : schemas) {
                    for (TriggerObject trigger : schema5.getAllTriggers()) {
                        if (this.excludeTable(trigger.getTable())) continue;
                        this.add(trigger.getCreateSQL(), false);
                    }
                }
                this.dumpRights(db);
                for (Comment comment : db.getAllComments()) {
                    this.add(comment.getCreateSQL(), false);
                }
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, this.getFileName());
            }
        }
        finally {
            this.closeIO();
        }
        this.result.done();
        LocalResult r = this.result;
        this.reset();
        return r;
    }

    private void dumpDomains(ArrayList<Schema> schemas) throws IOException {
        TreeMap<DbObject, TreeSet<? super DbObject>> referencingDomains = new TreeMap<DbObject, TreeSet<? super DbObject>>(BY_NAME_COMPARATOR);
        TreeSet<? super DbObject> known = new TreeSet<DbObject>(BY_NAME_COMPARATOR);
        for (Schema schema : schemas) {
            Domain[] domainArray = (Domain[])ScriptCommand.sorted(schema.getAllDomains(), Domain.class);
            int n = domainArray.length;
            int n2 = 0;
            while (n2 < n) {
                Domain domain = domainArray[n2];
                Domain parent = domain.getDomain();
                if (parent == null) {
                    this.addDomain(domain);
                } else {
                    TreeSet<? super DbObject> set = (TreeSet<? super DbObject>)referencingDomains.get(parent);
                    if (set == null) {
                        set = new TreeSet<DbObject>(BY_NAME_COMPARATOR);
                        referencingDomains.put(parent, set);
                    }
                    set.add(domain);
                    if (parent.getDomain() == null || !schemas.contains(parent.getSchema())) {
                        known.add(parent);
                    }
                }
                ++n2;
            }
        }
        while (!referencingDomains.isEmpty()) {
            TreeSet<? super DbObject> known2 = new TreeSet<DbObject>(BY_NAME_COMPARATOR);
            for (Domain domain : known) {
                TreeSet set = (TreeSet)referencingDomains.remove(domain);
                if (set == null) continue;
                for (Domain d2 : set) {
                    this.addDomain(d2);
                    known2.add(d2);
                }
            }
            known = known2;
        }
    }

    private void dumpRights(Database db) throws IOException {
        Right[] rights = db.getAllRights().toArray(new Right[0]);
        Arrays.sort(rights, (o1, o2) -> {
            Role r2;
            Role r1 = o1.getGrantedRole();
            if (r1 == null != ((r2 = o2.getGrantedRole()) == null)) {
                return r1 == null ? -1 : 1;
            }
            if (r1 == null) {
                DbObject g2;
                DbObject g1 = o1.getGrantedObject();
                if (g1 == null != ((g2 = o2.getGrantedObject()) == null)) {
                    return g1 == null ? -1 : 1;
                }
                if (g1 != null) {
                    if (g1 instanceof Schema != g2 instanceof Schema) {
                        return g1 instanceof Schema ? -1 : 1;
                    }
                    int cmp = g1.getName().compareTo(g2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                }
            } else {
                int cmp = r1.getName().compareTo(r2.getName());
                if (cmp != 0) {
                    return cmp;
                }
            }
            return o1.getGrantee().getName().compareTo(o2.getGrantee().getName());
        });
        Right[] rightArray = rights;
        int n = rights.length;
        int n2 = 0;
        while (n2 < n) {
            Table table;
            Right right = rightArray[n2];
            DbObject object = right.getGrantedObject();
            if (object == null || !(object instanceof Schema ? this.excludeSchema((Schema)object) : object instanceof Table && (this.excludeSchema((table = (Table)object).getSchema()) || this.excludeTable(table)))) {
                this.add(right.getCreateSQL(), false);
            }
            ++n2;
        }
    }

    private void addDomain(Domain domain) throws IOException {
        if (this.drop) {
            this.add(domain.getDropSQL(), false);
        }
        this.add(domain.getCreateSQL(), false);
    }

    private static <T extends DbObject> T[] sorted(Collection<T> collection, Class<T> clazz) {
        DbObject[] array = collection.toArray((DbObject[])Array.newInstance(clazz, 0));
        Arrays.sort(array, BY_NAME_COMPARATOR);
        return array;
    }

    private int generateInsertValues(int count, Table table) throws IOException {
        PlanItem plan = table.getBestPlanItem(this.session, null, null, -1, null, null);
        Index index = plan.getIndex();
        Cursor cursor = index.find(this.session, null, null, false);
        Column[] columns = table.getColumns();
        boolean withGenerated = false;
        boolean withGeneratedAlwaysAsIdentity = false;
        Column[] columnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            Column c = columnArray[n2];
            if (c.isGeneratedAlways()) {
                if (c.isIdentity()) {
                    withGeneratedAlwaysAsIdentity = true;
                } else {
                    withGenerated = true;
                }
            }
            ++n2;
        }
        StringBuilder builder = new StringBuilder("INSERT INTO ");
        table.getSQL(builder, 0);
        if (withGenerated || withGeneratedAlwaysAsIdentity || this.withColumns) {
            builder.append('(');
            boolean needComma = false;
            Column[] columnArray2 = columns;
            int n3 = columns.length;
            int n4 = 0;
            while (n4 < n3) {
                Column column = columnArray2[n4];
                if (!column.isGenerated()) {
                    if (needComma) {
                        builder.append(", ");
                    }
                    needComma = true;
                    column.getSQL(builder, 0);
                }
                ++n4;
            }
            builder.append(')');
            if (withGeneratedAlwaysAsIdentity) {
                builder.append(" OVERRIDING SYSTEM VALUE");
            }
        }
        builder.append(" VALUES");
        if (!this.simple) {
            builder.append('\n');
        }
        builder.append('(');
        String ins = builder.toString();
        builder = null;
        int columnCount = columns.length;
        while (cursor.next()) {
            Row row = cursor.get();
            if (builder == null) {
                builder = new StringBuilder(ins);
            } else {
                builder.append(",\n(");
            }
            boolean needComma = false;
            int i = 0;
            while (i < columnCount) {
                if (!columns[i].isGenerated()) {
                    if (needComma) {
                        builder.append(", ");
                    }
                    needComma = true;
                    Value v = row.getValue(i);
                    if (v.getType().getPrecision() > (long)this.lobBlockSize) {
                        int id;
                        if (v.getValueType() == 3) {
                            id = this.writeLobStream(v);
                            builder.append("SYSTEM_COMBINE_CLOB(").append(id).append(')');
                        } else if (v.getValueType() == 7) {
                            id = this.writeLobStream(v);
                            builder.append("SYSTEM_COMBINE_BLOB(").append(id).append(')');
                        } else {
                            v.getSQL(builder, 4);
                        }
                    } else {
                        v.getSQL(builder, 4);
                    }
                }
                ++i;
            }
            builder.append(')');
            if ((++count & 0x7F) == 0) {
                this.checkCanceled();
            }
            if (!this.simple && builder.length() <= 4096) continue;
            this.add(builder.toString(), true);
            builder = null;
        }
        if (builder != null) {
            this.add(builder.toString(), true);
        }
        return count;
    }

    private int writeLobStream(Value v) throws IOException {
        if (!this.tempLobTableCreated) {
            this.add("CREATE CACHED LOCAL TEMPORARY TABLE IF NOT EXISTS SYSTEM_LOB_STREAM(ID INT NOT NULL, PART INT NOT NULL, CDATA VARCHAR, BDATA VARBINARY)", true);
            this.add("ALTER TABLE SYSTEM_LOB_STREAM ADD CONSTRAINT SYSTEM_LOB_STREAM_PRIMARY_KEY PRIMARY KEY(ID, PART)", true);
            String className = this.getClass().getName();
            this.add("CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_CLOB FOR '" + className + ".combineClob'", true);
            this.add("CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_BLOB FOR '" + className + ".combineBlob'", true);
            this.tempLobTableCreated = true;
        }
        int id = this.nextLobId++;
        block4 : switch (v.getValueType()) {
            case 7: {
                byte[] bytes = new byte[this.lobBlockSize];
                Throwable throwable = null;
                Object var5_10 = null;
                try (InputStream input = v.getInputStream();){
                    int i = 0;
                    while (true) {
                        StringBuilder buff = new StringBuilder(this.lobBlockSize * 2);
                        buff.append("INSERT INTO SYSTEM_LOB_STREAM VALUES(").append(id).append(", ").append(i).append(", NULL, X'");
                        int len = IOUtils.readFully(input, bytes, this.lobBlockSize);
                        if (len <= 0) {
                            break block4;
                        }
                        StringUtils.convertBytesToHex(buff, bytes, len).append("')");
                        String sql = buff.toString();
                        this.add(sql, true);
                        ++i;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            case 3: {
                char[] chars = new char[this.lobBlockSize];
                Throwable throwable = null;
                Object var5_12 = null;
                try (Reader reader = v.getReader();){
                    int i = 0;
                    while (true) {
                        StringBuilder buff = new StringBuilder(this.lobBlockSize * 2);
                        buff.append("INSERT INTO SYSTEM_LOB_STREAM VALUES(").append(id).append(", ").append(i).append(", ");
                        int len = IOUtils.readFully(reader, chars, this.lobBlockSize);
                        if (len == 0) {
                            break block4;
                        }
                        StringUtils.quoteStringSQL(buff, new String(chars, 0, len)).append(", NULL)");
                        String sql = buff.toString();
                        this.add(sql, true);
                        ++i;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            default: {
                throw DbException.getInternalError("type:" + v.getValueType());
            }
        }
        return id;
    }

    public static InputStream combineBlob(Connection conn, int id) throws SQLException {
        if (id < 0) {
            return null;
        }
        final ResultSet rs = ScriptCommand.getLobStream(conn, "BDATA", id);
        return new InputStream(){
            private InputStream current;
            private boolean closed;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int read() throws IOException {
                try {
                    while (true) {
                        int x;
                        if (this.current == null) {
                            if (this.closed) {
                                return -1;
                            }
                            if (!rs.next()) {
                                this.close();
                                return -1;
                            }
                            this.current = rs.getBinaryStream(1);
                            this.current = new BufferedInputStream(this.current);
                        }
                        if ((x = this.current.read()) >= 0) {
                            return x;
                        }
                        this.current = null;
                    }
                }
                catch (SQLException e) {
                    throw DataUtils.convertToIOException(e);
                }
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    throw DataUtils.convertToIOException(e);
                }
            }
        };
    }

    public static Reader combineClob(Connection conn, int id) throws SQLException {
        if (id < 0) {
            return null;
        }
        final ResultSet rs = ScriptCommand.getLobStream(conn, "CDATA", id);
        return new Reader(){
            private Reader current;
            private boolean closed;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int read() throws IOException {
                try {
                    while (true) {
                        int x;
                        if (this.current == null) {
                            if (this.closed) {
                                return -1;
                            }
                            if (!rs.next()) {
                                this.close();
                                return -1;
                            }
                            this.current = rs.getCharacterStream(1);
                            this.current = new BufferedReader(this.current);
                        }
                        if ((x = this.current.read()) >= 0) {
                            return x;
                        }
                        this.current = null;
                    }
                }
                catch (SQLException e) {
                    throw DataUtils.convertToIOException(e);
                }
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    throw DataUtils.convertToIOException(e);
                }
            }

            @Override
            public int read(char[] buffer, int off, int len) throws IOException {
                if (len == 0) {
                    return 0;
                }
                int c = this.read();
                if (c == -1) {
                    return -1;
                }
                buffer[off] = (char)c;
                int i = 1;
                while (i < len) {
                    c = this.read();
                    if (c == -1) break;
                    buffer[off + i] = (char)c;
                    ++i;
                }
                return i;
            }
        };
    }

    private static ResultSet getLobStream(Connection conn, String column, int id) throws SQLException {
        PreparedStatement prep = conn.prepareStatement("SELECT " + column + " FROM SYSTEM_LOB_STREAM WHERE ID=? ORDER BY PART");
        prep.setInt(1, id);
        return prep.executeQuery();
    }

    private void reset() {
        this.result = null;
        this.buffer = null;
        this.lineSeparatorString = System.lineSeparator();
        this.lineSeparator = this.lineSeparatorString.getBytes(this.charset);
    }

    private boolean excludeSchema(Schema schema) {
        if (this.schemaNames != null && !this.schemaNames.contains(schema.getName())) {
            return true;
        }
        if (this.tables != null) {
            for (Table table : schema.getAllTablesAndViews(this.session)) {
                if (!this.tables.contains(table)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean excludeTable(Table table) {
        return this.tables != null && !this.tables.contains(table);
    }

    private void add(String s, boolean insert) throws IOException {
        if (s == null) {
            return;
        }
        if (this.lineSeparator.length > 1 || this.lineSeparator[0] != 10) {
            s = StringUtils.replaceAll((String)s, "\n", this.lineSeparatorString);
        }
        s = (String)s + ";";
        if (this.out != null) {
            byte[] buff = ((String)s).getBytes(this.charset);
            int len = MathUtils.roundUpInt(buff.length + this.lineSeparator.length, 16);
            this.buffer = Utils.copy(buff, this.buffer);
            if (len > this.buffer.length) {
                this.buffer = new byte[len];
            }
            System.arraycopy(buff, 0, this.buffer, 0, buff.length);
            int i = buff.length;
            while (i < len - this.lineSeparator.length) {
                this.buffer[i] = 32;
                ++i;
            }
            int j = 0;
            int i2 = len - this.lineSeparator.length;
            while (i2 < len) {
                this.buffer[i2] = this.lineSeparator[j];
                ++i2;
                ++j;
            }
            this.out.write(this.buffer, 0, len);
            if (!insert) {
                this.result.addRow(ValueVarchar.get((String)s));
            }
        } else {
            this.result.addRow(ValueVarchar.get((String)s));
        }
    }

    public void setSimple(boolean simple) {
        this.simple = simple;
    }

    public void setWithColumns(boolean withColumns) {
        this.withColumns = withColumns;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    @Override
    public int getType() {
        return 65;
    }
}

