/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import org.h2.command.ParserBase;
import org.h2.command.Prepared;
import org.h2.command.dml.SetTypes;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.SessionLocal;
import org.h2.engine.Setting;
import org.h2.expression.Expression;
import org.h2.expression.TimeZoneOperation;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.mode.DefaultNullOrdering;
import org.h2.result.ResultInterface;
import org.h2.security.auth.AuthenticatorFactory;
import org.h2.util.DateTimeUtils;
import org.h2.util.StringUtils;
import org.h2.util.TimeZoneProvider;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Set
extends Prepared {
    private final int type;
    private Expression expression;
    private String stringValue;
    private String[] stringValueList;

    public Set(SessionLocal session, int type) {
        super(session);
        this.type = type;
    }

    public void setString(String v) {
        this.stringValue = v;
    }

    @Override
    public boolean isTransactional() {
        switch (this.type) {
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 18: 
            case 22: 
            case 24: 
            case 29: 
            case 30: 
            case 33: 
            case 36: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public long update() {
        database = this.getDatabase();
        name = SetTypes.getTypeName(this.type);
        block42 : switch (this.type) {
            case 21: {
                this.session.getUser().checkAdmin();
                value = this.getIntValue();
                if (value < 0) throw DbException.getInvalidValueException("ALLOW_LITERALS", value);
                if (value > 2) {
                    throw DbException.getInvalidValueException("ALLOW_LITERALS", value);
                }
                var4_38 = database;
                // MONITORENTER : var4_38
                database.setAllowLiterals(value);
                this.addOrUpdateSetting(name, null, value);
                // MONITOREXIT : var4_38
                break;
            }
            case 7: {
                this.session.getUser().checkAdmin();
                value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("CACHE_SIZE", value);
                }
                var4_39 = database;
                // MONITORENTER : var4_39
                database.setCacheSize(value);
                this.addOrUpdateSetting(name, null, value);
                // MONITOREXIT : var4_39
                break;
            }
            case 12: {
                if ("TRUE".equals(this.stringValue) || (value = StringUtils.quoteStringSQL(this.stringValue)).equals(database.getCluster())) break;
                if (!value.equals("''")) {
                    this.session.getUser().checkAdmin();
                }
                database.setCluster(value);
                var5_60 = sysSession = database.getSystemSession();
                // MONITORENTER : var5_60
                var6_64 = database;
                // MONITORENTER : var6_64
                this.addOrUpdateSetting(sysSession, name, value, 0);
                sysSession.commit(true);
                // MONITOREXIT : var6_64
                break;
            }
            case 11: {
                this.session.getUser().checkAdmin();
                buff = new StringBuilder(this.stringValue);
                if (this.stringValue.equals("OFF")) {
                    compareMode = CompareMode.getInstance(null, 0);
                } else {
                    strength = this.getIntValue();
                    buff.append(" STRENGTH ");
                    if (strength == 3) {
                        buff.append("IDENTICAL");
                    } else if (strength == 0) {
                        buff.append("PRIMARY");
                    } else if (strength == 1) {
                        buff.append("SECONDARY");
                    } else if (strength == 2) {
                        buff.append("TERTIARY");
                    }
                    compareMode = CompareMode.getInstance(this.stringValue, strength);
                }
                var5_62 = database;
                // MONITORENTER : var5_62
                old = database.getCompareMode();
                if (old.equals(compareMode)) {
                    // MONITOREXIT : var5_62
                    break;
                }
                table = database.getFirstUserTable();
                if (table != null) {
                    throw DbException.get(90089, table.getTraceSQL());
                }
                this.addOrUpdateSetting(name, buff.toString(), 0);
                database.setCompareMode(compareMode);
                // MONITOREXIT : var5_62
                break;
            }
            case 28: {
                this.session.getUser().checkAdmin();
                if (!database.isStarting()) break;
                value = this.getIntValue();
                buff = database;
                // MONITORENTER : buff
                this.addOrUpdateSetting(name, null, value);
                // MONITOREXIT : buff
                break;
            }
            case 14: {
                this.session.getUser().checkAdmin();
                database.setEventListenerClass(this.stringValue);
                break;
            }
            case 17: {
                this.session.getUser().checkAdmin();
                value = this.getIntValue();
                if (value != -1 && value < 0) {
                    throw DbException.getInvalidValueException("DB_CLOSE_DELAY", value);
                }
                buff = database;
                // MONITORENTER : buff
                database.setCloseDelay(value);
                this.addOrUpdateSetting(name, null, value);
                // MONITOREXIT : buff
                break;
            }
            case 5: {
                this.session.getUser().checkAdmin();
                value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("DEFAULT_LOCK_TIMEOUT", value);
                }
                buff = database;
                // MONITORENTER : buff
                this.addOrUpdateSetting(name, null, value);
                // MONITOREXIT : buff
                break;
            }
            case 6: {
                this.session.getUser().checkAdmin();
                value = this.getIntValue();
                buff = database;
                // MONITORENTER : buff
                database.setDefaultTableType(value);
                this.addOrUpdateSetting(name, null, value);
                // MONITOREXIT : buff
                break;
            }
            case 27: {
                this.session.getUser().checkAdmin();
                value = this.getIntValue();
                switch (value) {
                    case 0: {
                        if (database.unsetExclusiveSession(this.session)) break block42;
                        throw DbException.get(90135);
                    }
                    case 1: {
                        if (database.setExclusiveSession(this.session, false)) break block42;
                        throw DbException.get(90135);
                    }
                    case 2: {
                        if (database.setExclusiveSession(this.session, true)) break block42;
                        throw DbException.get(90135);
                    }
                    default: {
                        throw DbException.getInvalidValueException("EXCLUSIVE", value);
                    }
                }
            }
            case 32: {
                this.session.getUser().checkAdmin();
                value = database;
                // MONITORENTER : value
                table = database.getFirstUserTable();
                if (table != null) {
                    throw DbException.get(90141, table.getTraceSQL());
                }
                database.setJavaObjectSerializerName(this.stringValue);
                this.addOrUpdateSetting(name, this.stringValue, 0);
                // MONITOREXIT : value
                break;
            }
            case 0: {
                this.session.getUser().checkAdmin();
                value = this.getIntValue();
                table = database;
                // MONITORENTER : table
                database.setIgnoreCase(value == 1);
                this.addOrUpdateSetting(name, null, value);
                // MONITOREXIT : table
                break;
            }
            case 16: {
                this.session.getUser().checkAdmin();
                value = this.getIntValue();
                table = database;
                // MONITORENTER : table
                database.setLockMode(value);
                this.addOrUpdateSetting(name, null, value);
                // MONITOREXIT : table
                break;
            }
            case 4: {
                value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("LOCK_TIMEOUT", value);
                }
                this.session.setLockTimeout(value);
                break;
            }
            case 20: {
                this.session.getUser().checkAdmin();
                value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("MAX_LENGTH_INPLACE_LOB", value);
                }
                table = database;
                // MONITORENTER : table
                database.setMaxLengthInplaceLob(value);
                this.addOrUpdateSetting(name, null, value);
                // MONITOREXIT : table
                break;
            }
            case 1: {
                this.session.getUser().checkAdmin();
                value = this.getIntValue();
                if (value >= 0) break;
                throw DbException.getInvalidValueException("MAX_LOG_SIZE", value);
            }
            case 15: {
                this.session.getUser().checkAdmin();
                value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("MAX_MEMORY_ROWS", value);
                }
                table = database;
                // MONITORENTER : table
                database.setMaxMemoryRows(value);
                this.addOrUpdateSetting(name, null, value);
                // MONITOREXIT : table
                break;
            }
            case 19: {
                this.session.getUser().checkAdmin();
                value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("MAX_MEMORY_UNDO", value);
                }
                table = database;
                // MONITORENTER : table
                this.addOrUpdateSetting(name, null, value);
                // MONITOREXIT : table
                break;
            }
            case 26: {
                this.session.getUser().checkAdmin();
                value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("MAX_OPERATION_MEMORY", value);
                }
                database.setMaxOperationMemory(value);
                break;
            }
            case 2: {
                mode = Mode.getInstance(this.stringValue);
                if (mode == null) {
                    throw DbException.get(90088, this.stringValue);
                }
                if (database.getMode() == mode) break;
                this.session.getUser().checkAdmin();
                database.setMode(mode);
                break;
            }
            case 23: {
                this.session.getUser().checkAdmin();
                database.setOptimizeReuseResults(this.getIntValue() != 0);
                break;
            }
            case 30: {
                value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("QUERY_TIMEOUT", value);
                }
                this.session.setQueryTimeout(value);
                break;
            }
            case 31: {
                DbException.getUnsupportedException("MV_STORE + SET REDO_LOG_BINARY");
                break;
            }
            case 25: {
                this.session.getUser().checkAdmin();
                value = this.getIntValue();
                if (value < 0) throw DbException.getInvalidValueException("REFERENTIAL_INTEGRITY", value);
                if (value > 1) {
                    throw DbException.getInvalidValueException("REFERENTIAL_INTEGRITY", value);
                }
                database.setReferentialIntegrity(value == 1);
                break;
            }
            case 34: {
                this.session.getUser().checkAdmin();
                value = this.getIntValue();
                if (value < 0) throw DbException.getInvalidValueException("QUERY_STATISTICS", value);
                if (value > 1) {
                    throw DbException.getInvalidValueException("QUERY_STATISTICS", value);
                }
                database.setQueryStatistics(value == 1);
                break;
            }
            case 35: {
                this.session.getUser().checkAdmin();
                value = this.getIntValue();
                if (value < 1) {
                    throw DbException.getInvalidValueException("QUERY_STATISTICS_MAX_ENTRIES", value);
                }
                database.setQueryStatisticsMaxEntries(value);
                break;
            }
            case 22: {
                schema = database.getSchema(this.expression.optimize(this.session).getValue(this.session).getString());
                this.session.setCurrentSchema(schema);
                break;
            }
            case 24: {
                this.session.setSchemaSearchPath(this.stringValueList);
                break;
            }
            case 40: {
                shortName = database.getShortName();
                value = this.expression.optimize(this.session).getValue(this.session).getString();
                if (value == null) throw DbException.get(90013, this.stringValue);
                if (database.equalsIdentifiers(shortName, value) || database.equalsIdentifiers(shortName, value.trim())) break;
                throw DbException.get(90013, this.stringValue);
            }
            case 9: {
                this.session.getUser().checkAdmin();
                if (this.getPersistedObjectId() != 0) break;
                database.getTraceSystem().setLevelFile(this.getIntValue());
                break;
            }
            case 8: {
                this.session.getUser().checkAdmin();
                if (this.getPersistedObjectId() != 0) break;
                database.getTraceSystem().setLevelSystemOut(this.getIntValue());
                break;
            }
            case 10: {
                this.session.getUser().checkAdmin();
                value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("TRACE_MAX_FILE_SIZE", value);
                }
                size = value * 0x100000;
                var5_63 = database;
                // MONITORENTER : var5_63
                database.getTraceSystem().setMaxFileSize(size);
                this.addOrUpdateSetting(name, null, value);
                // MONITOREXIT : var5_63
                break;
            }
            case 18: {
                value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("THROTTLE", value);
                }
                this.session.setThrottle(value);
                break;
            }
            case 29: {
                expr = this.expression.optimize(this.session);
                this.session.setVariable(this.stringValue, expr.getValue(this.session));
                break;
            }
            case 13: {
                this.session.getUser().checkAdmin();
                value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("WRITE_DELAY", value);
                }
                size = database;
                // MONITORENTER : size
                database.setWriteDelay(value);
                this.addOrUpdateSetting(name, null, value);
                // MONITOREXIT : size
                break;
            }
            case 33: {
                this.session.getUser().checkAdmin();
                value = this.getIntValue();
                if (value < 0) {
                    throw DbException.getInvalidValueException("RETENTION_TIME", value);
                }
                size = database;
                // MONITORENTER : size
                database.setRetentionTime(value);
                this.addOrUpdateSetting(name, null, value);
                // MONITOREXIT : size
                break;
            }
            case 36: {
                value = this.getIntValue();
                if (value != 0 && value != 1) {
                    throw DbException.getInvalidValueException("LAZY_QUERY_EXECUTION", value);
                }
                this.session.setLazyQueryExecution(value == 1);
                break;
            }
            case 37: {
                this.session.getUser().checkAdmin();
                value = this.getIntValue();
                if (value != 0 && value != 1) {
                    throw DbException.getInvalidValueException("BUILTIN_ALIAS_OVERRIDE", value);
                }
                database.setAllowBuiltinAliasOverride(value == 1);
                break;
            }
            case 38: {
                this.session.getUser().checkAdmin();
                value = this.expression.optimize(this.session).getBooleanValue(this.session);
                try {
                    size = database;
                    // MONITORENTER : size
                    if (value) {
                        database.setAuthenticator(AuthenticatorFactory.createAuthenticator());
                    } else {
                        database.setAuthenticator(null);
                    }
                    this.addOrUpdateSetting(name, value != false ? "TRUE" : "FALSE", 0);
                    // MONITOREXIT : size
                    ** break;
                }
                catch (Exception e) {
                    if (database.isStarting() == false) throw DbException.convert(e);
                    database.getTrace(2).error(e, "{0}: failed to set authenticator during database start ", new Object[]{this.expression.toString()});
                }
                break;
            }
            case 39: {
                this.session.getUser().checkAdmin();
                value = this.getIntValue();
                e = database;
                // MONITORENTER : e
                database.setIgnoreCatalogs(value == 1);
                this.addOrUpdateSetting(name, null, value);
                // MONITOREXIT : e
                break;
            }
            case 41: {
                this.session.setNonKeywords(ParserBase.parseNonKeywords(this.stringValueList));
                break;
            }
            case 42: {
                this.session.setTimeZone(this.expression == null ? DateTimeUtils.getTimeZone() : Set.parseTimeZone(this.expression.getValue(this.session)));
                break;
            }
            case 43: {
                this.session.setVariableBinary(this.expression.getBooleanValue(this.session));
                break;
            }
            case 44: {
                try {
                    defaultNullOrdering = DefaultNullOrdering.valueOf(StringUtils.toUpperEnglish(this.stringValue));
                }
                catch (RuntimeException e) {
                    throw DbException.getInvalidValueException("DEFAULT_NULL_ORDERING", this.stringValue);
                }
                if (database.getDefaultNullOrdering() == defaultNullOrdering) break;
                this.session.getUser().checkAdmin();
                database.setDefaultNullOrdering(defaultNullOrdering);
                break;
            }
            case 45: {
                this.session.setTruncateLargeLength(this.expression.getBooleanValue(this.session));
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + this.type);
            }
        }
        database.getNextModificationDataId();
        database.getNextModificationMetaId();
        return 0L;
    }

    private static TimeZoneProvider parseTimeZone(Value v) {
        if (DataType.isCharacterStringType(v.getValueType())) {
            TimeZoneProvider timeZone;
            try {
                timeZone = TimeZoneProvider.ofId(v.getString());
            }
            catch (RuntimeException ex) {
                throw DbException.getInvalidValueException("TIME ZONE", v.getTraceSQL());
            }
            return timeZone;
        }
        if (v == ValueNull.INSTANCE) {
            throw DbException.getInvalidValueException("TIME ZONE", v);
        }
        return TimeZoneProvider.ofOffset(TimeZoneOperation.parseInterval(v));
    }

    private int getIntValue() {
        this.expression = this.expression.optimize(this.session);
        return this.expression.getValue(this.session).getInt();
    }

    public void setInt(int value) {
        this.expression = ValueExpression.get(ValueInteger.get(value));
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    private void addOrUpdateSetting(String name, String s, int v) {
        this.addOrUpdateSetting(this.session, name, s, v);
    }

    private void addOrUpdateSetting(SessionLocal session, String name, String s, int v) {
        Database database = session.getDatabase();
        assert (Thread.holdsLock(database));
        if (database.isReadOnly()) {
            return;
        }
        Setting setting = database.findSetting(name);
        boolean addNew = false;
        if (setting == null) {
            addNew = true;
            int id = this.getObjectId();
            setting = new Setting(database, id, name);
        }
        if (s != null) {
            if (!addNew && setting.getStringValue().equals(s)) {
                return;
            }
            setting.setStringValue(s);
        } else {
            if (!addNew && setting.getIntValue() == v) {
                return;
            }
            setting.setIntValue(v);
        }
        if (addNew) {
            database.addDatabaseObject(session, setting);
        } else {
            database.updateMeta(session, setting);
        }
    }

    @Override
    public boolean needRecompile() {
        return false;
    }

    @Override
    public ResultInterface queryMeta() {
        return null;
    }

    public void setStringArray(String[] list) {
        this.stringValueList = list;
    }

    @Override
    public int getType() {
        return 67;
    }
}

