/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.util.ArrayList;
import java.util.Arrays;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionList;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultTarget;
import org.h2.result.Row;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.DataChangeDeltaTable;
import org.h2.table.Table;
import org.h2.util.HasSQL;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SetClauseList
implements HasSQL {
    private final Table table;
    private final UpdateAction[] actions;
    private boolean onUpdate;

    public SetClauseList(Table table) {
        this.table = table;
        this.actions = new UpdateAction[table.getColumns().length];
    }

    public void addSingle(Column column, Expression[] arrayIndexes, Expression expression) {
        int id = column.getColumnId();
        if (this.actions[id] != null) {
            throw DbException.get(42121, column.getName());
        }
        if (expression != ValueExpression.DEFAULT) {
            this.actions[id] = new SetSimple(arrayIndexes, expression);
            if (expression instanceof Parameter) {
                ((Parameter)expression).setColumn(column);
            }
        } else {
            this.actions[id] = UpdateAction.SET_DEFAULT;
        }
    }

    public void addMultiple(ArrayList<Column> columns, ArrayList<Expression[]> allIndexes, Expression expression) {
        ExpressionList expressions;
        int columnCount = columns.size();
        if (expression instanceof ExpressionList && !(expressions = (ExpressionList)expression).isArray()) {
            if (columnCount != expressions.getSubexpressionCount()) {
                throw DbException.get(21002);
            }
            int i = 0;
            while (i < columnCount) {
                this.addSingle(columns.get(i), allIndexes.get(i), expressions.getSubexpression(i));
                ++i;
            }
            return;
        }
        if (columnCount == 1) {
            this.addSingle(columns.get(0), allIndexes.get(0), expression);
        } else {
            int[] cols = new int[columnCount];
            RowExpression row = new RowExpression(expression, cols);
            int minId = this.table.getColumns().length - 1;
            int maxId = 0;
            int i = 0;
            while (i < columnCount) {
                int id = columns.get(i).getColumnId();
                if (id < minId) {
                    minId = id;
                }
                if (id > maxId) {
                    maxId = id;
                }
                ++i;
            }
            i = 0;
            while (i < columnCount) {
                int id;
                Column column = columns.get(i);
                cols[i] = id = column.getColumnId();
                if (this.actions[id] != null) {
                    throw DbException.get(42121, column.getName());
                }
                this.actions[id] = new SetMultiple(allIndexes.get(i), row, i, id == minId, id == maxId);
                ++i;
            }
        }
    }

    boolean prepareUpdate(Table table, SessionLocal session, ResultTarget deltaChangeCollector, DataChangeDeltaTable.ResultOption deltaChangeCollectionMode, LocalResult rows, Row oldRow, boolean updateToCurrentValuesReturnsZero) {
        Column[] columns = table.getColumns();
        int columnCount = columns.length;
        Row newRow = table.getTemplateRow();
        int i = 0;
        while (i < columnCount) {
            Value newValue;
            UpdateAction action = this.actions[i];
            Column column = columns[i];
            Value oldValue = oldRow.getValue(i);
            if (action == null || action == UpdateAction.ON_UPDATE) {
                newValue = column.isGenerated() ? null : oldValue;
            } else if (action == UpdateAction.SET_DEFAULT) {
                newValue = !column.isIdentity() ? null : oldValue;
            } else {
                newValue = action.update(session, oldValue);
                if (newValue == ValueNull.INSTANCE && column.isDefaultOnNull()) {
                    newValue = !column.isIdentity() ? null : oldValue;
                } else if (column.isGeneratedAlways()) {
                    throw DbException.get(90154, column.getSQLWithTable(new StringBuilder(), 3).toString());
                }
            }
            newRow.setValue(i, newValue);
            ++i;
        }
        newRow.setKey(oldRow.getKey());
        table.convertUpdateRow(session, newRow, false);
        boolean result = true;
        if (this.onUpdate) {
            if (!oldRow.hasSameValues(newRow)) {
                int i2 = 0;
                while (i2 < columnCount) {
                    if (this.actions[i2] == UpdateAction.ON_UPDATE) {
                        newRow.setValue(i2, columns[i2].getEffectiveOnUpdateExpression().getValue(session));
                    } else if (columns[i2].isGenerated()) {
                        newRow.setValue(i2, null);
                    }
                    ++i2;
                }
                table.convertUpdateRow(session, newRow, false);
            } else if (updateToCurrentValuesReturnsZero) {
                result = false;
            }
        } else if (updateToCurrentValuesReturnsZero && oldRow.hasSameValues(newRow)) {
            result = false;
        }
        if (deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.OLD) {
            deltaChangeCollector.addRow(oldRow.getValueList());
        } else if (deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.NEW) {
            deltaChangeCollector.addRow((Value[])newRow.getValueList().clone());
        }
        if (!table.fireRow() || !table.fireBeforeRow(session, oldRow, newRow)) {
            rows.addRowForTable(oldRow);
            rows.addRowForTable(newRow);
        }
        if (deltaChangeCollectionMode == DataChangeDeltaTable.ResultOption.FINAL) {
            deltaChangeCollector.addRow(newRow.getValueList());
        }
        return result;
    }

    boolean isEverything(ExpressionVisitor visitor) {
        UpdateAction[] updateActionArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            UpdateAction action = updateActionArray[n2];
            if (action != null && !action.isEverything(visitor)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    void mapAndOptimize(SessionLocal session, ColumnResolver resolver1, ColumnResolver resolver2) {
        Column[] columns = this.table.getColumns();
        boolean onUpdate = false;
        int i = 0;
        while (i < this.actions.length) {
            UpdateAction action = this.actions[i];
            if (action != null) {
                action.mapAndOptimize(session, resolver1, resolver2);
            } else {
                Column column = columns[i];
                if (column.getEffectiveOnUpdateExpression() != null) {
                    this.actions[i] = UpdateAction.ON_UPDATE;
                    onUpdate = true;
                }
            }
            ++i;
        }
        this.onUpdate = onUpdate;
    }

    @Override
    public StringBuilder getSQL(StringBuilder builder, int sqlFlags) {
        Column[] columns = this.table.getColumns();
        builder.append("\nSET\n    ");
        boolean f = false;
        int i = 0;
        while (i < this.actions.length) {
            UpdateAction action = this.actions[i];
            if (action != null && action != UpdateAction.ON_UPDATE) {
                if (action.getClass() == SetMultiple.class) {
                    SetMultiple multiple = (SetMultiple)action;
                    if (multiple.first) {
                        if (f) {
                            builder.append(",\n    ");
                        }
                        f = true;
                        RowExpression r = multiple.row;
                        builder.append('(');
                        int[] cols = r.columns;
                        int j = 0;
                        int l = cols.length;
                        while (j < l) {
                            if (j > 0) {
                                builder.append(", ");
                            }
                            columns[cols[j]].getSQL(builder, sqlFlags);
                            ++j;
                        }
                        r.expression.getUnenclosedSQL(builder.append(") = "), sqlFlags);
                    }
                } else {
                    if (f) {
                        builder.append(",\n    ");
                    }
                    f = true;
                    Column column = columns[i];
                    if (action != UpdateAction.SET_DEFAULT) {
                        action.getSQL(builder, sqlFlags, column);
                    } else {
                        column.getSQL(builder, sqlFlags).append(" = DEFAULT");
                    }
                }
            }
            ++i;
        }
        return builder;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class RowExpression {
        Expression expression;
        final int[] columns;
        Value[] values;

        RowExpression(Expression expression, int[] columns) {
            this.expression = expression;
            this.columns = columns;
        }

        boolean isEverything(ExpressionVisitor visitor) {
            return this.expression.isEverything(visitor);
        }

        void mapAndOptimize(SessionLocal session, ColumnResolver resolver1, ColumnResolver resolver2) {
            this.expression.mapColumns(resolver1, 0, 0);
            if (resolver2 != null) {
                this.expression.mapColumns(resolver2, 0, 0);
            }
            this.expression = this.expression.optimize(session);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static abstract class SetAction
    extends UpdateAction {
        private final Expression[] arrayIndexes;

        SetAction(Expression[] arrayIndexes) {
            this.arrayIndexes = arrayIndexes;
        }

        @Override
        boolean isEverything(ExpressionVisitor visitor) {
            if (this.arrayIndexes != null) {
                Expression[] expressionArray = this.arrayIndexes;
                int n = this.arrayIndexes.length;
                int n2 = 0;
                while (n2 < n) {
                    Expression e = expressionArray[n2];
                    if (!e.isEverything(visitor)) {
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }

        @Override
        void mapAndOptimize(SessionLocal session, ColumnResolver resolver1, ColumnResolver resolver2) {
            if (this.arrayIndexes != null) {
                int i = 0;
                int l = this.arrayIndexes.length;
                while (i < l) {
                    Expression e = this.arrayIndexes[i];
                    e.mapColumns(resolver1, 0, 0);
                    if (resolver2 != null) {
                        e.mapColumns(resolver2, 0, 0);
                    }
                    this.arrayIndexes[i] = e.optimize(session);
                    ++i;
                }
            }
        }

        @Override
        final Value update(SessionLocal session, Value oldValue) {
            Value newValue = this.update(session);
            if (this.arrayIndexes != null) {
                newValue = this.updateArray(session, oldValue, newValue, 0);
            }
            return newValue;
        }

        private Value updateArray(SessionLocal session, Value oldValue, Value newValue, int indexNumber) {
            Value[] values;
            int index = this.arrayIndexes[indexNumber++].getValue(session).getInt();
            int cardinality = 65536;
            if (index < 0 || index > cardinality) {
                throw DbException.get(22034, Integer.toString(index), "1.." + cardinality);
            }
            if (oldValue == null) {
                values = new Value[index];
                int i = 0;
                while (i < index - 1) {
                    values[i] = ValueNull.INSTANCE;
                    ++i;
                }
            } else {
                if (oldValue == ValueNull.INSTANCE) {
                    throw DbException.get(22035);
                }
                if (oldValue.getValueType() != 40) {
                    throw DbException.get(22034, oldValue.getType().getTraceSQL(), "ARRAY");
                }
                values = ((ValueArray)oldValue).getList();
                int length = values.length;
                if (index <= length) {
                    values = (Value[])values.clone();
                } else {
                    values = Arrays.copyOf(values, index);
                    int i = length;
                    while (i < index - 1) {
                        values[i] = ValueNull.INSTANCE;
                        ++i;
                    }
                }
            }
            values[index - 1] = indexNumber == this.arrayIndexes.length ? newValue : this.updateArray(session, values[index - 1], newValue, indexNumber);
            return ValueArray.get(values, session);
        }

        abstract Value update(SessionLocal var1);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class SetMultiple
    extends SetAction {
        final RowExpression row;
        private final int position;
        boolean first;
        private boolean last;

        SetMultiple(Expression[] arrayIndexes, RowExpression row, int position, boolean first, boolean last) {
            super(arrayIndexes);
            this.row = row;
            this.position = position;
            this.first = first;
            this.last = last;
        }

        @Override
        Value update(SessionLocal session) {
            Value[] v;
            if (this.first) {
                Value value = this.row.expression.getValue(session);
                if (value == ValueNull.INSTANCE) {
                    throw DbException.get(22018, "NULL to assigned row value");
                }
                this.row.values = v = value.convertToAnyRow().getList();
                if (v.length != this.row.columns.length) {
                    throw DbException.get(21002);
                }
            } else {
                v = this.row.values;
                if (this.last) {
                    this.row.values = null;
                }
            }
            return v[this.position];
        }

        @Override
        boolean isEverything(ExpressionVisitor visitor) {
            return super.isEverything(visitor) && (!this.first || this.row.isEverything(visitor));
        }

        @Override
        void mapAndOptimize(SessionLocal session, ColumnResolver resolver1, ColumnResolver resolver2) {
            super.mapAndOptimize(session, resolver1, resolver2);
            if (this.first) {
                this.row.mapAndOptimize(session, resolver1, resolver2);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class SetSimple
    extends SetAction {
        private Expression expression;

        SetSimple(Expression[] arrayIndexes, Expression expression) {
            super(arrayIndexes);
            this.expression = expression;
        }

        @Override
        Value update(SessionLocal session) {
            return this.expression.getValue(session);
        }

        @Override
        boolean isEverything(ExpressionVisitor visitor) {
            return super.isEverything(visitor) && this.expression.isEverything(visitor);
        }

        @Override
        void mapAndOptimize(SessionLocal session, ColumnResolver resolver1, ColumnResolver resolver2) {
            super.mapAndOptimize(session, resolver1, resolver2);
            this.expression.mapColumns(resolver1, 0, 0);
            if (resolver2 != null) {
                this.expression.mapColumns(resolver2, 0, 0);
            }
            this.expression = this.expression.optimize(session);
        }

        @Override
        void getSQL(StringBuilder builder, int sqlFlags, Column column) {
            this.expression.getUnenclosedSQL(column.getSQL(builder, sqlFlags).append(" = "), sqlFlags);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class UpdateAction {
        static UpdateAction ON_UPDATE = new UpdateAction();
        static UpdateAction SET_DEFAULT = new UpdateAction();

        UpdateAction() {
        }

        Value update(SessionLocal session, Value oldValue) {
            throw DbException.getInternalError();
        }

        boolean isEverything(ExpressionVisitor visitor) {
            return true;
        }

        void mapAndOptimize(SessionLocal session, ColumnResolver resolver1, ColumnResolver resolver2) {
        }

        void getSQL(StringBuilder builder, int sqlFlags, Column column) {
            throw DbException.getInternalError();
        }
    }
}

