/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.h2.command.Prepared;
import org.h2.command.QueryScope;
import org.h2.command.query.ForUpdate;
import org.h2.command.query.QueryOrderBy;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.SessionLocal;
import org.h2.expression.Alias;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Parameter;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.result.LocalResult;
import org.h2.result.ResultInterface;
import org.h2.result.ResultTarget;
import org.h2.result.SortOrder;
import org.h2.table.CTE;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.DerivedTable;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.util.StringUtils;
import org.h2.util.Utils;
import org.h2.value.ExtTypeInfoRow;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueInteger;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class Query
extends Prepared {
    ArrayList<Expression> expressions;
    Expression[] expressionArray;
    ArrayList<QueryOrderBy> orderList;
    SortOrder sort;
    Expression fetchExpr;
    boolean fetchPercent;
    boolean withTies;
    Expression offsetExpr;
    boolean distinct;
    boolean randomAccessResult;
    int visibleColumnCount;
    int resultColumnCount;
    private boolean noCache;
    private long lastLimit;
    private long lastEvaluated;
    private ResultInterface lastResult;
    private Boolean lastExists;
    private Value[] lastParameters;
    private boolean cacheableChecked;
    private boolean neverLazy;
    boolean checkInit;
    boolean isPrepared;
    private QueryScope outerQueryScope;
    private LinkedHashMap<String, Table> withClause;

    Query(SessionLocal session) {
        super(session);
    }

    public void setNeverLazy(boolean b) {
        this.neverLazy = b;
    }

    public boolean isNeverLazy() {
        return this.neverLazy;
    }

    public abstract boolean isUnion();

    @Override
    public ResultInterface queryMeta() {
        LocalResult result = new LocalResult(this.session, this.expressionArray, this.visibleColumnCount, this.resultColumnCount);
        result.done();
        return result;
    }

    protected abstract ResultInterface queryWithoutCache(long var1, ResultTarget var3);

    private ResultInterface queryWithoutCacheLazyCheck(long limit, ResultTarget target) {
        boolean disableLazy;
        boolean bl = disableLazy = this.neverLazy && this.session.isLazyQueryExecution();
        if (disableLazy) {
            this.session.setLazyQueryExecution(false);
        }
        try {
            ResultInterface resultInterface = this.queryWithoutCache(limit, target);
            return resultInterface;
        }
        finally {
            if (disableLazy) {
                this.session.setLazyQueryExecution(true);
            }
        }
    }

    public abstract void init();

    @Override
    public final void prepare() {
        if (!this.checkInit) {
            throw DbException.getInternalError("not initialized");
        }
        if (this.isPrepared) {
            return;
        }
        this.prepareExpressions();
        this.preparePlan();
    }

    public abstract void prepareExpressions();

    public abstract void preparePlan();

    public ArrayList<Expression> getExpressions() {
        return this.expressions;
    }

    public abstract double getCost();

    public int getCostAsExpression() {
        return (int)Math.min(1000000.0, 10.0 + 10.0 * this.getCost());
    }

    public abstract HashSet<Table> getTables();

    public void setOrder(ArrayList<QueryOrderBy> order) {
        this.orderList = order;
    }

    public boolean hasOrder() {
        return this.orderList != null || this.sort != null;
    }

    public ForUpdate getForUpdate() {
        return null;
    }

    public abstract void setForUpdate(ForUpdate var1);

    public int getColumnCount() {
        return this.visibleColumnCount;
    }

    public TypeInfo getRowDataType() {
        if (this.visibleColumnCount == 1) {
            return this.expressionArray[0].getType();
        }
        return TypeInfo.getTypeInfo(41, -1L, -1, new ExtTypeInfoRow(this.expressionArray, this.visibleColumnCount));
    }

    public abstract void mapColumns(ColumnResolver var1, int var2);

    public abstract void setEvaluatable(TableFilter var1, boolean var2);

    public abstract void addGlobalCondition(Parameter var1, int var2, int var3);

    public abstract boolean allowGlobalConditions();

    public abstract boolean isEverything(ExpressionVisitor var1);

    @Override
    public boolean isReadOnly() {
        return this.isEverything(ExpressionVisitor.READONLY_VISITOR);
    }

    public abstract void updateAggregate(SessionLocal var1, int var2);

    public abstract void fireBeforeSelectTriggers();

    public void setDistinctIfPossible() {
        if (!this.isAnyDistinct() && this.offsetExpr == null && this.fetchExpr == null) {
            this.distinct = true;
        }
    }

    public boolean isStandardDistinct() {
        return this.distinct;
    }

    public boolean isAnyDistinct() {
        return this.distinct;
    }

    public boolean isRandomAccessResult() {
        return this.randomAccessResult;
    }

    public void setRandomAccessResult(boolean b) {
        this.randomAccessResult = b;
    }

    @Override
    public boolean isQuery() {
        return true;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    public void disableCache() {
        this.noCache = true;
    }

    private boolean sameResultAsLast(Value[] params, Value[] lastParams, long lastEval) {
        if (!this.cacheableChecked) {
            long max = this.getMaxDataModificationId();
            boolean bl = this.noCache = max == Long.MAX_VALUE;
            if (!this.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR) || !this.isEverything(ExpressionVisitor.INDEPENDENT_VISITOR)) {
                this.noCache = true;
            }
            this.cacheableChecked = true;
        }
        if (this.noCache) {
            return false;
        }
        int i = 0;
        while (i < params.length) {
            Value a = lastParams[i];
            Value b = params[i];
            if (a != null && !a.equals(b)) {
                return false;
            }
            ++i;
        }
        return this.getMaxDataModificationId() <= lastEval;
    }

    private Value[] getParameterValues() {
        ArrayList<Parameter> list = this.getParameters();
        if (list == null) {
            return Value.EMPTY_VALUES;
        }
        int size = list.size();
        Value[] params = new Value[size];
        int i = 0;
        while (i < size) {
            Parameter parameter = list.get(i);
            params[i] = parameter != null ? parameter.getParamValue() : null;
            ++i;
        }
        return params;
    }

    @Override
    public final ResultInterface query(long maxrows) {
        return this.query(maxrows, null);
    }

    public final ResultInterface query(long limit, ResultTarget target) {
        ResultInterface r;
        if (this.isUnion()) {
            return this.queryWithoutCacheLazyCheck(limit, target);
        }
        this.fireBeforeSelectTriggers();
        if (this.noCache || !this.getDatabase().getOptimizeReuseResults() || this.session.isLazyQueryExecution() && !this.neverLazy) {
            return this.queryWithoutCacheLazyCheck(limit, target);
        }
        Value[] params = this.getParameterValues();
        long now = this.getDatabase().getModificationDataId();
        if (this.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR) && this.lastResult != null && !this.lastResult.isClosed() && limit == this.lastLimit && this.sameResultAsLast(params, this.lastParameters, this.lastEvaluated)) {
            this.lastResult = this.lastResult.createShallowCopy(this.session);
            if (this.lastResult != null) {
                this.lastResult.reset();
                return this.lastResult;
            }
        }
        this.lastParameters = params;
        this.closeLastResult();
        this.lastResult = r = this.queryWithoutCacheLazyCheck(limit, target);
        this.lastExists = null;
        this.lastEvaluated = now;
        this.lastLimit = limit;
        return r;
    }

    private void closeLastResult() {
        if (this.lastResult != null) {
            this.lastResult.close();
        }
    }

    public final boolean exists() {
        if (this.isUnion()) {
            return this.executeExists();
        }
        this.fireBeforeSelectTriggers();
        if (this.noCache || !this.getDatabase().getOptimizeReuseResults()) {
            return this.executeExists();
        }
        Value[] params = this.getParameterValues();
        long now = this.getDatabase().getModificationDataId();
        if (this.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR) && this.lastExists != null && this.sameResultAsLast(params, this.lastParameters, this.lastEvaluated)) {
            return this.lastExists;
        }
        this.lastParameters = params;
        boolean exists = this.executeExists();
        this.lastExists = exists;
        this.lastResult = null;
        this.lastEvaluated = now;
        return exists;
    }

    private boolean executeExists() {
        ResultInterface r = this.queryWithoutCacheLazyCheck(1L, null);
        boolean exists = r.hasNext();
        r.close();
        return exists;
    }

    boolean initOrder(ArrayList<String> expressionSQL, boolean mustBeInResult, ArrayList<TableFilter> filters) {
        Iterator<QueryOrderBy> i = this.orderList.iterator();
        while (i.hasNext()) {
            QueryOrderBy o = i.next();
            Expression e = o.expression;
            if (e == null) continue;
            if (e.isConstant()) {
                i.remove();
                continue;
            }
            int idx = this.initExpression(expressionSQL, e, mustBeInResult, filters);
            o.columnIndexExpr = ValueExpression.get(ValueInteger.get(idx + 1));
            o.expression = this.expressions.get(idx).getNonAliasExpression();
        }
        if (this.orderList.isEmpty()) {
            this.orderList = null;
            return false;
        }
        return true;
    }

    int initExpression(ArrayList<String> expressionSQL, Expression e, boolean mustBeInResult, ArrayList<TableFilter> filters) {
        Database db = this.getDatabase();
        if (e instanceof ExpressionColumn) {
            ExpressionColumn exprCol = (ExpressionColumn)e;
            String tableAlias = exprCol.getOriginalTableAliasName();
            String col = exprCol.getOriginalColumnName();
            int j = 0;
            int visible = this.getColumnCount();
            while (j < visible) {
                Expression ec = this.expressions.get(j);
                if (ec instanceof ExpressionColumn) {
                    ExpressionColumn c = (ExpressionColumn)ec;
                    if (db.equalsIdentifiers(col, c.getColumnName(this.session, j))) {
                        if (tableAlias == null) {
                            return j;
                        }
                        String ca = c.getOriginalTableAliasName();
                        if (ca != null) {
                            if (db.equalsIdentifiers(ca, tableAlias)) {
                                return j;
                            }
                        } else if (filters != null) {
                            for (TableFilter f : filters) {
                                if (!db.equalsIdentifiers(f.getTableAlias(), tableAlias)) continue;
                                return j;
                            }
                        }
                    }
                } else if (ec instanceof Alias) {
                    if (tableAlias == null && db.equalsIdentifiers(col, ec.getAlias(this.session, j))) {
                        return j;
                    }
                    Expression ec2 = ec.getNonAliasExpression();
                    if (ec2 instanceof ExpressionColumn) {
                        ExpressionColumn c2 = (ExpressionColumn)ec2;
                        String ta = exprCol.getSQL(0, 2);
                        String tb = c2.getSQL(0, 2);
                        String s2 = c2.getColumnName(this.session, j);
                        if (db.equalsIdentifiers(col, s2) && db.equalsIdentifiers(ta, tb)) {
                            return j;
                        }
                    }
                }
                ++j;
            }
        } else if (expressionSQL != null) {
            String s = e.getSQL(0, 2);
            int j = 0;
            int size = expressionSQL.size();
            while (j < size) {
                if (db.equalsIdentifiers(expressionSQL.get(j), s)) {
                    return j;
                }
                ++j;
            }
        }
        if (expressionSQL == null || mustBeInResult && !db.getMode().allowUnrelatedOrderByExpressionsInDistinctQueries && !Query.checkOrderOther(this.session, e, expressionSQL)) {
            throw DbException.get(90068, e.getTraceSQL());
        }
        int idx = this.expressions.size();
        this.expressions.add(e);
        expressionSQL.add(e.getSQL(0, 2));
        return idx;
    }

    private static boolean checkOrderOther(SessionLocal session, Expression expr, ArrayList<String> expressionSQL) {
        if (expr == null || expr.isConstant()) {
            return true;
        }
        String exprSQL = expr.getSQL(0, 2);
        for (String sql : expressionSQL) {
            if (!session.getDatabase().equalsIdentifiers(exprSQL, sql)) continue;
            return true;
        }
        int count = expr.getSubexpressionCount();
        if (!expr.isEverything(ExpressionVisitor.DETERMINISTIC_VISITOR)) {
            return false;
        }
        if (count <= 0) {
            return false;
        }
        int i = 0;
        while (i < count) {
            if (!Query.checkOrderOther(session, expr.getSubexpression(i), expressionSQL)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    void prepareOrder(ArrayList<QueryOrderBy> orderList, int expressionCount) {
        int size = orderList.size();
        int[] index = new int[size];
        int[] sortType = new int[size];
        int i = 0;
        while (i < size) {
            int idx;
            QueryOrderBy o = orderList.get(i);
            boolean reverse = false;
            Value v = o.columnIndexExpr.getValue(null);
            if (v == ValueNull.INSTANCE) {
                idx = 0;
            } else {
                idx = v.getInt();
                if (idx < 0) {
                    reverse = true;
                    idx = -idx;
                }
                if (--idx < 0 || idx >= expressionCount) {
                    throw DbException.get(90068, Integer.toString(idx + 1));
                }
            }
            index[i] = idx;
            int type = o.sortType;
            if (reverse) {
                type ^= 1;
            }
            sortType[i] = type;
            ++i;
        }
        this.sort = new SortOrder(this.session, index, sortType, orderList);
        this.orderList = null;
    }

    void cleanupOrder() {
        int[] sourceIndexes = this.sort.getQueryColumnIndexes();
        int count = sourceIndexes.length;
        int constants = 0;
        int i = 0;
        while (i < count) {
            if (this.expressions.get(sourceIndexes[i]).isConstant()) {
                ++constants;
            }
            ++i;
        }
        if (constants == 0) {
            return;
        }
        if (constants == count) {
            this.sort = null;
            return;
        }
        int size = count - constants;
        int[] indexes = new int[size];
        int[] sortTypes = new int[size];
        int[] sourceSortTypes = this.sort.getSortTypes();
        ArrayList<QueryOrderBy> orderList = this.sort.getOrderList();
        int i2 = 0;
        int j = 0;
        while (j < size) {
            if (!this.expressions.get(sourceIndexes[i2]).isConstant()) {
                indexes[j] = sourceIndexes[i2];
                sortTypes[j] = sourceSortTypes[i2];
                ++j;
            } else {
                orderList.remove(j);
            }
            ++i2;
        }
        this.sort = new SortOrder(this.session, indexes, sortTypes, orderList);
    }

    @Override
    public int getType() {
        return 66;
    }

    public void setOffset(Expression offset) {
        this.offsetExpr = offset;
    }

    public Expression getOffset() {
        return this.offsetExpr;
    }

    public void setFetch(Expression fetch) {
        this.fetchExpr = fetch;
    }

    public Expression getFetch() {
        return this.fetchExpr;
    }

    public void setFetchPercent(boolean fetchPercent) {
        this.fetchPercent = fetchPercent;
    }

    public boolean isFetchPercent() {
        return this.fetchPercent;
    }

    public void setWithTies(boolean withTies) {
        this.withTies = withTies;
    }

    public boolean isWithTies() {
        return this.withTies;
    }

    void addParameter(Parameter param) {
        if (this.parameters == null) {
            this.parameters = Utils.newSmallArrayList();
        }
        this.parameters.add(param);
    }

    public final long getMaxDataModificationId() {
        ExpressionVisitor visitor = ExpressionVisitor.getMaxModificationIdVisitor();
        this.isEverything(visitor);
        return Math.max(visitor.getMaxDataModificationId(), this.session.getSnapshotDataModificationId());
    }

    public QueryScope getOuterQueryScope() {
        return this.outerQueryScope;
    }

    public void setOuterQueryScope(QueryScope outerQueryScope) {
        this.outerQueryScope = outerQueryScope;
    }

    public void setWithClause(LinkedHashMap<String, Table> withClause) {
        this.withClause = withClause;
    }

    protected void writeWithList(StringBuilder builder, int sqlFlags) {
        if (this.withClause != null) {
            boolean recursive = false;
            for (Table t : this.withClause.values()) {
                if (!((CTE)t).isRecursive()) continue;
                recursive = true;
                break;
            }
            builder.append("WITH ");
            if (recursive) {
                builder.append(" RECURSIVE ");
            }
            boolean f = false;
            for (Table table : this.withClause.values()) {
                if (!f) {
                    f = true;
                } else {
                    builder.append(",\n");
                }
                table.getSQL(builder, sqlFlags).append('(');
                Column.writeColumns(builder, table.getColumns(), sqlFlags).append(") AS (\n");
                StringUtils.indent(builder, ((CTE)table).getQuerySQL(), 4, true).append(')');
            }
            builder.append('\n');
        }
    }

    void appendEndOfQueryToSQL(StringBuilder builder, int sqlFlags, Expression[] expressions) {
        if (this.sort != null) {
            this.sort.getSQL(builder.append("\nORDER BY "), expressions, this.visibleColumnCount, sqlFlags);
        } else if (this.orderList != null) {
            builder.append("\nORDER BY ");
            int i = 0;
            int l = this.orderList.size();
            while (i < l) {
                if (i > 0) {
                    builder.append(", ");
                }
                this.orderList.get(i).getSQL(builder, sqlFlags);
                ++i;
            }
        }
        if (this.offsetExpr != null) {
            String count = this.offsetExpr.getSQL(sqlFlags, 2);
            builder.append("\nOFFSET ").append(count).append("1".equals(count) ? " ROW" : " ROWS");
        }
        if (this.fetchExpr != null) {
            boolean withCount;
            builder.append("\nFETCH ").append(this.offsetExpr != null ? "NEXT" : "FIRST");
            String count = this.fetchExpr.getSQL(sqlFlags, 2);
            boolean bl = withCount = this.fetchPercent || !"1".equals(count);
            if (withCount) {
                builder.append(' ').append(count);
                if (this.fetchPercent) {
                    builder.append(" PERCENT");
                }
            }
            builder.append(!withCount ? " ROW" : " ROWS").append(this.withTies ? " WITH TIES" : " ONLY");
        }
    }

    OffsetFetch getOffsetFetch(long maxRows) {
        boolean fetchPercent;
        long fetch;
        long offset;
        if (this.offsetExpr != null) {
            Value v = this.offsetExpr.getValue(this.session);
            if (v == ValueNull.INSTANCE || (offset = v.getLong()) < 0L) {
                throw DbException.getInvalidValueException("result OFFSET", v);
            }
        } else {
            offset = 0L;
        }
        long l = fetch = maxRows == 0L ? -1L : maxRows;
        if (this.fetchExpr != null) {
            long l2;
            Value v = this.fetchExpr.getValue(this.session);
            if (v == ValueNull.INSTANCE || (l2 = v.getLong()) < 0L) {
                throw DbException.getInvalidValueException("result FETCH", v);
            }
            long l3 = fetch = fetch < 0L ? l2 : Math.min(l2, fetch);
        }
        if (fetchPercent = this.fetchPercent) {
            if (fetch > 100L) {
                throw DbException.getInvalidValueException("result FETCH PERCENT", fetch);
            }
            if (fetch == 0L) {
                fetchPercent = false;
            }
        }
        return new OffsetFetch(offset, fetch, fetchPercent);
    }

    LocalResult finishResult(LocalResult result, long offset, long fetch, boolean fetchPercent, ResultTarget target) {
        if (offset != 0L) {
            result.setOffset(offset);
        }
        if (fetch >= 0L) {
            result.setLimit(fetch);
            result.setFetchPercent(fetchPercent);
            if (this.withTies) {
                result.setWithTies(this.sort);
            }
        }
        result.done();
        if (this.randomAccessResult && !this.distinct) {
            result = this.convertToDistinct(result);
        }
        if (target != null) {
            while (result.next()) {
                target.addRow(result.currentRow());
            }
            result.close();
            return null;
        }
        return result;
    }

    LocalResult convertToDistinct(ResultInterface result) {
        LocalResult distinctResult = new LocalResult(this.session, this.expressionArray, this.visibleColumnCount, this.resultColumnCount);
        distinctResult.setDistinct();
        result.reset();
        while (result.next()) {
            distinctResult.addRow(result.currentRow());
        }
        result.close();
        distinctResult.done();
        return distinctResult;
    }

    public Table toTable(String alias, Column[] columnTemplates, ArrayList<Parameter> parameters, boolean forCreateView, Query topQuery) {
        this.setParameterList(new ArrayList<Parameter>(parameters));
        if (!this.checkInit) {
            this.init();
        }
        return new DerivedTable(forCreateView ? this.getDatabase().getSystemSession() : this.session, alias, columnTemplates, this, topQuery);
    }

    @Override
    public void collectDependencies(HashSet<DbObject> dependencies) {
        ExpressionVisitor visitor = ExpressionVisitor.getDependenciesVisitor(dependencies);
        this.isEverything(visitor);
    }

    public boolean isConstantQuery() {
        return !(this.hasOrder() || this.offsetExpr != null && !this.offsetExpr.isConstant() || this.fetchExpr != null && !this.fetchExpr.isConstant());
    }

    public Expression getIfSingleRow() {
        return null;
    }

    @Override
    public boolean isRetryable() {
        ForUpdate forUpdate = this.getForUpdate();
        return forUpdate == null || forUpdate.getType() == ForUpdate.Type.SKIP_LOCKED;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class OffsetFetch {
        final long offset;
        final long fetch;
        final boolean fetchPercent;

        OffsetFetch(long offset, long fetch, boolean fetchPercent) {
            this.offset = offset;
            this.fetch = fetch;
            this.fetchPercent = fetchPercent;
        }
    }
}

