/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.analysis.DataAnalysisOperation;
import org.h2.expression.analysis.PartitionData;
import org.h2.value.Value;
import org.h2.value.ValueRow;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class SelectGroups {
    final SessionLocal session;
    final ArrayList<Expression> expressions;
    Object[] currentGroupByExprData;
    private final HashMap<Expression, Integer> exprToIndexInGroupByData = new HashMap();
    private final HashMap<DataAnalysisOperation, PartitionData> windowData = new HashMap();
    private final HashMap<DataAnalysisOperation, TreeMap<Value, PartitionData>> windowPartitionData = new HashMap();
    int currentGroupRowId;

    public static SelectGroups getInstance(SessionLocal session, ArrayList<Expression> expressions, boolean isGroupQuery, int[] groupIndex) {
        return isGroupQuery ? new Grouped(session, expressions, groupIndex) : new Plain(session, expressions);
    }

    SelectGroups(SessionLocal session, ArrayList<Expression> expressions) {
        this.session = session;
        this.expressions = expressions;
    }

    public boolean isCurrentGroup() {
        return this.currentGroupByExprData != null;
    }

    public final Object getCurrentGroupExprData(Expression expr) {
        Integer index = this.exprToIndexInGroupByData.get(expr);
        if (index == null) {
            return null;
        }
        return this.currentGroupByExprData[index];
    }

    public final void setCurrentGroupExprData(Expression expr, Object obj) {
        Integer index = this.exprToIndexInGroupByData.get(expr);
        if (index != null) {
            assert (this.currentGroupByExprData[index] == null);
            this.currentGroupByExprData[index.intValue()] = obj;
            return;
        }
        index = this.exprToIndexInGroupByData.size();
        this.exprToIndexInGroupByData.put(expr, index);
        if (index >= this.currentGroupByExprData.length) {
            this.currentGroupByExprData = Arrays.copyOf(this.currentGroupByExprData, this.currentGroupByExprData.length * 2);
            this.updateCurrentGroupExprData();
        }
        this.currentGroupByExprData[index.intValue()] = obj;
    }

    final Object[] createRow() {
        return new Object[Math.max(this.exprToIndexInGroupByData.size(), this.expressions.size())];
    }

    public final PartitionData getWindowExprData(DataAnalysisOperation expr, Value partitionKey) {
        if (partitionKey == null) {
            return this.windowData.get(expr);
        }
        TreeMap<Value, PartitionData> map = this.windowPartitionData.get(expr);
        return map != null ? map.get(partitionKey) : null;
    }

    public final void setWindowExprData(DataAnalysisOperation expr, Value partitionKey, PartitionData obj) {
        if (partitionKey == null) {
            PartitionData old = this.windowData.put(expr, obj);
            assert (old == null);
        } else {
            TreeMap<Value, PartitionData> map = this.windowPartitionData.get(expr);
            if (map == null) {
                map = new TreeMap(this.session.getDatabase().getCompareMode());
                this.windowPartitionData.put(expr, map);
            }
            map.put(partitionKey, obj);
        }
    }

    abstract void updateCurrentGroupExprData();

    public int getCurrentGroupRowId() {
        return this.currentGroupRowId;
    }

    public void reset() {
        this.currentGroupByExprData = null;
        this.exprToIndexInGroupByData.clear();
        this.windowData.clear();
        this.windowPartitionData.clear();
        this.currentGroupRowId = 0;
    }

    public abstract void nextSource();

    public void done() {
        this.currentGroupRowId = 0;
    }

    public abstract ValueRow next();

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void resetLazy() {
        this.currentGroupByExprData = null;
        this.currentGroupRowId = 0;
    }

    public void nextLazyGroup() {
        this.currentGroupByExprData = new Object[Math.max(this.exprToIndexInGroupByData.size(), this.expressions.size())];
    }

    public void nextLazyRow() {
        ++this.currentGroupRowId;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Grouped
    extends SelectGroups {
        private final int[] groupIndex;
        private TreeMap<ValueRow, Object[]> groupByData;
        private ValueRow currentGroupsKey;
        private Iterator<Map.Entry<ValueRow, Object[]>> cursor;

        Grouped(SessionLocal session, ArrayList<Expression> expressions, int[] groupIndex) {
            super(session, expressions);
            this.groupIndex = groupIndex;
        }

        @Override
        public void reset() {
            super.reset();
            this.groupByData = new TreeMap(this.session.getDatabase().getCompareMode());
            this.currentGroupsKey = null;
            this.cursor = null;
        }

        @Override
        public void nextSource() {
            if (this.groupIndex == null) {
                this.currentGroupsKey = ValueRow.EMPTY;
            } else {
                Value[] keyValues = new Value[this.groupIndex.length];
                int i = 0;
                while (i < this.groupIndex.length) {
                    int idx = this.groupIndex[i];
                    Expression expr = (Expression)this.expressions.get(idx);
                    keyValues[i] = expr.getValue(this.session);
                    ++i;
                }
                this.currentGroupsKey = ValueRow.get(keyValues);
            }
            Object[] values = this.groupByData.get(this.currentGroupsKey);
            if (values == null) {
                values = this.createRow();
                this.groupByData.put(this.currentGroupsKey, values);
            }
            this.currentGroupByExprData = values;
            ++this.currentGroupRowId;
        }

        @Override
        void updateCurrentGroupExprData() {
            if (this.currentGroupsKey != null) {
                this.groupByData.put(this.currentGroupsKey, this.currentGroupByExprData);
            }
        }

        @Override
        public void done() {
            super.done();
            if (this.groupIndex == null && this.groupByData.size() == 0) {
                this.groupByData.put(ValueRow.EMPTY, this.createRow());
            }
            this.cursor = this.groupByData.entrySet().iterator();
        }

        @Override
        public ValueRow next() {
            if (this.cursor.hasNext()) {
                Map.Entry<ValueRow, Object[]> entry = this.cursor.next();
                this.currentGroupByExprData = entry.getValue();
                ++this.currentGroupRowId;
                return entry.getKey();
            }
            return null;
        }

        @Override
        public void remove() {
            this.cursor.remove();
            this.currentGroupByExprData = null;
            --this.currentGroupRowId;
        }

        @Override
        public void resetLazy() {
            super.resetLazy();
            this.currentGroupsKey = null;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class Plain
    extends SelectGroups {
        private ArrayList<Object[]> rows;
        private Iterator<Object[]> cursor;

        Plain(SessionLocal session, ArrayList<Expression> expressions) {
            super(session, expressions);
        }

        @Override
        public void reset() {
            super.reset();
            this.rows = new ArrayList();
            this.cursor = null;
        }

        @Override
        public void nextSource() {
            Object[] values = this.createRow();
            this.rows.add(values);
            this.currentGroupByExprData = values;
            ++this.currentGroupRowId;
        }

        @Override
        void updateCurrentGroupExprData() {
            this.rows.set(this.rows.size() - 1, this.currentGroupByExprData);
        }

        @Override
        public void done() {
            super.done();
            this.cursor = this.rows.iterator();
        }

        @Override
        public ValueRow next() {
            if (this.cursor.hasNext()) {
                this.currentGroupByExprData = this.cursor.next();
                ++this.currentGroupRowId;
                return ValueRow.EMPTY;
            }
            return null;
        }
    }
}

