/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.fs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class ArchiveTool {
    private static final byte[] HEADER = new byte[]{72, 50, 65, 49};
    private static final int MB = 1000000;

    public static void main(String ... args) throws Exception {
        String arg;
        String fromFile;
        File f;
        Log log = new Log();
        int level = Integer.getInteger("level", 1);
        if (args.length == 1 && (f = new File(args[0])).exists()) {
            if (f.isDirectory()) {
                String fromDir = f.getAbsolutePath();
                String toFile = fromDir + ".at";
                ArchiveTool.compress(fromDir, toFile, level);
                return;
            }
            fromFile = f.getAbsolutePath();
            int dot = fromFile.lastIndexOf(46);
            if (dot > 0 && dot > fromFile.replace('\\', '/').lastIndexOf(47)) {
                String toDir = fromFile.substring(0, dot);
                ArchiveTool.extract(fromFile, toDir);
                return;
            }
        }
        String string = arg = args.length != 3 ? null : args[0];
        if ("-compress".equals(arg)) {
            String toFile = args[1];
            String fromDir = args[2];
            ArchiveTool.compress(fromDir, toFile, level);
        } else if ("-extract".equals(arg)) {
            fromFile = args[1];
            String toDir = args[2];
            ArchiveTool.extract(fromFile, toDir);
        } else {
            log.println("An archive tool to efficiently compress large directories");
            log.println("Command line options:");
            log.println("<sourceDir>");
            log.println("<compressedFile>");
            log.println("-compress <compressedFile> <sourceDir>");
            log.println("-extract <compressedFile> <targetDir>");
        }
    }

    private static void compress(String fromDir, String toFile, int level) throws IOException {
        final Log log = new Log();
        long start = System.nanoTime();
        long startMs = System.currentTimeMillis();
        final AtomicBoolean title = new AtomicBoolean();
        long size = ArchiveTool.getSize(new File(fromDir), new Runnable(start){
            int count;
            long lastTime;
            {
                this.lastTime = l;
            }

            @Override
            public void run() {
                long now;
                ++this.count;
                if (this.count % 1000 == 0 && (now = System.nanoTime()) - this.lastTime > TimeUnit.SECONDS.toNanos(3L)) {
                    if (!title.getAndSet(true)) {
                        log.println("Counting files");
                    }
                    log.print(this.count + " ");
                    this.lastTime = now;
                }
            }
        });
        if (title.get()) {
            log.println();
        }
        log.println("Compressing " + size / 1000000L + " MB at " + new Time(startMs).toString());
        InputStream in = ArchiveTool.getDirectoryInputStream(fromDir);
        String temp = toFile + ".temp";
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(toFile), 0x100000);
        Deflater def = new Deflater();
        def.setLevel(level);
        out = new BufferedOutputStream(new DeflaterOutputStream((OutputStream)out, def), 0x100000);
        ArchiveTool.sort(log, in, out, temp, size);
        in.close();
        ((OutputStream)out).close();
        log.println();
        log.println("Compressed to " + new File(toFile).length() / 1000000L + " MB in " + TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start) + " seconds");
        log.println();
    }

    private static void extract(String fromFile, String toDir) throws IOException {
        Log log = new Log();
        long start = System.nanoTime();
        long startMs = System.currentTimeMillis();
        long size = new File(fromFile).length();
        log.println("Extracting " + size / 1000000L + " MB at " + new Time(startMs).toString());
        FilterInputStream in = new BufferedInputStream(new FileInputStream(fromFile), 0x100000);
        String temp = fromFile + ".temp";
        Inflater inflater = new Inflater();
        in = new InflaterInputStream(in, inflater, 0x100000);
        OutputStream out = ArchiveTool.getDirectoryOutputStream(toDir);
        ArchiveTool.combine(log, in, out, temp);
        inflater.end();
        ((InputStream)in).close();
        out.close();
        log.println();
        log.println("Extracted in " + TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start) + " seconds");
    }

    private static long getSize(File f, Runnable r) {
        long size = 40L;
        if (f.isDirectory()) {
            File[] list = f.listFiles();
            if (list != null) {
                File[] fileArray = list;
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    File c = fileArray[n2];
                    size += ArchiveTool.getSize(c, r);
                    ++n2;
                }
            }
        } else {
            size += f.length();
        }
        r.run();
        return size;
    }

    private static InputStream getDirectoryInputStream(String dir) {
        File f = new File(dir);
        if (!f.isDirectory() || !f.exists()) {
            throw new IllegalArgumentException("Not an existing directory: " + dir);
        }
        return new InputStream(dir){
            private final String baseDir;
            private final ArrayList<String> files = new ArrayList();
            private String current;
            private ByteArrayInputStream meta;
            private DataInputStream fileIn;
            private long remaining;
            {
                File f = new File(string);
                this.baseDir = f.getAbsolutePath();
                this.addDirectory(f);
            }

            private void addDirectory(File f) {
                File[] list = f.listFiles();
                if (list != null) {
                    File c;
                    File[] fileArray = list;
                    int n = list.length;
                    int n2 = 0;
                    while (n2 < n) {
                        c = fileArray[n2];
                        if (c.isDirectory()) {
                            this.files.add(c.getAbsolutePath());
                        }
                        ++n2;
                    }
                    fileArray = list;
                    n = list.length;
                    n2 = 0;
                    while (n2 < n) {
                        c = fileArray[n2];
                        if (c.isFile()) {
                            this.files.add(c.getAbsolutePath());
                        }
                        ++n2;
                    }
                }
            }

            @Override
            public int read() throws IOException {
                int x;
                if (this.meta != null) {
                    x = this.meta.read();
                    if (x >= 0) {
                        return x;
                    }
                    this.meta = null;
                }
                if (this.fileIn != null) {
                    if (this.remaining > 0L) {
                        x = this.fileIn.read();
                        --this.remaining;
                        if (x < 0) {
                            throw new EOFException();
                        }
                        return x;
                    }
                    this.fileIn.close();
                    this.fileIn = null;
                }
                if (this.files.isEmpty()) {
                    return -1;
                }
                this.current = this.files.remove(this.files.size() - 1);
                File f = new File(this.current);
                if (f.isDirectory()) {
                    this.addDirectory(f);
                }
                ByteArrayOutputStream metaOut = new ByteArrayOutputStream();
                DataOutputStream out = new DataOutputStream(metaOut);
                boolean isFile = f.isFile();
                out.writeInt(0);
                out.write(isFile ? 1 : 0);
                out.write(!f.canWrite() ? 1 : 0);
                ArchiveTool.writeVarLong(out, f.lastModified());
                if (isFile) {
                    this.remaining = f.length();
                    ArchiveTool.writeVarLong(out, this.remaining);
                    this.fileIn = new DataInputStream(new BufferedInputStream(new FileInputStream(this.current), 0x100000));
                }
                if (!this.current.startsWith(this.baseDir)) {
                    throw new IOException("File " + this.current + " does not start with " + this.baseDir);
                }
                String n = this.current.substring(this.baseDir.length() + 1);
                out.writeUTF(n);
                out.writeInt(metaOut.size());
                out.flush();
                byte[] bytes = metaOut.toByteArray();
                System.arraycopy(bytes, bytes.length - 4, bytes, 0, 4);
                bytes = Arrays.copyOf(bytes, bytes.length - 4);
                this.meta = new ByteArrayInputStream(bytes);
                return this.meta.read();
            }

            @Override
            public int read(byte[] buff, int offset, int length) throws IOException {
                if (this.meta != null || this.fileIn == null || this.remaining == 0L) {
                    return super.read(buff, offset, length);
                }
                int l = (int)Math.min((long)length, this.remaining);
                this.fileIn.readFully(buff, offset, l);
                this.remaining -= (long)l;
                return l;
            }
        };
    }

    private static OutputStream getDirectoryOutputStream(final String dir) {
        new File(dir).mkdirs();
        return new OutputStream(){
            private ByteArrayOutputStream meta = new ByteArrayOutputStream();
            private OutputStream fileOut;
            private File file;
            private long remaining = 4L;
            private long modified;
            private boolean readOnly;

            @Override
            public void write(byte[] buff, int offset, int length) throws IOException {
                while (length > 0) {
                    if (this.fileOut == null || this.remaining <= 1L) {
                        this.write(buff[offset] & 0xFF);
                        ++offset;
                        --length;
                        continue;
                    }
                    int l = (int)Math.min((long)length, this.remaining - 1L);
                    this.fileOut.write(buff, offset, l);
                    this.remaining -= (long)l;
                    offset += l;
                    length -= l;
                }
            }

            @Override
            public void write(int b) throws IOException {
                if (this.fileOut != null) {
                    this.fileOut.write(b);
                    if (--this.remaining > 0L) {
                        return;
                    }
                    this.fileOut.close();
                    this.fileOut = null;
                    this.file.setLastModified(this.modified);
                    if (this.readOnly) {
                        this.file.setReadOnly();
                    }
                    this.remaining = 4L;
                    return;
                }
                this.meta.write(b);
                if (--this.remaining > 0L) {
                    return;
                }
                DataInputStream in = new DataInputStream(new ByteArrayInputStream(this.meta.toByteArray()));
                if (this.meta.size() == 4) {
                    this.remaining = in.readInt() - 4;
                    if (this.remaining > 16384L) {
                        throw new IOException("Illegal directory stream");
                    }
                    return;
                }
                in.readInt();
                boolean isFile = in.read() == 1;
                this.readOnly = in.read() == 1;
                this.modified = ArchiveTool.readVarLong(in);
                this.remaining = isFile ? ArchiveTool.readVarLong(in) : 4L;
                String name = dir + "/" + in.readUTF();
                this.file = new File(name);
                if (isFile) {
                    if (this.remaining == 0L) {
                        new File(name).createNewFile();
                        this.remaining = 4L;
                    } else {
                        this.fileOut = new BufferedOutputStream(new FileOutputStream(name), 0x100000);
                    }
                } else {
                    this.file.mkdirs();
                    this.file.setLastModified(this.modified);
                    if (this.readOnly) {
                        this.file.setReadOnly();
                    }
                }
                this.meta.reset();
            }
        };
    }

    private static void sort(Log log, InputStream in, OutputStream out, String tempFileName, long size) throws IOException {
        int len;
        int bufferSize = 0x2000000;
        DataOutputStream tempOut = new DataOutputStream(new BufferedOutputStream(new FileOutputStream((String)tempFileName), 0x100000));
        byte[] bytes = new byte[bufferSize];
        List<Long> segmentStart = new ArrayList<Long>();
        long outPos = 0L;
        long id = 1L;
        log.setRange(0, 30, size);
        while ((len = ArchiveTool.readFully(in, bytes, bytes.length)) != 0) {
            Object key;
            log.printProgress(len);
            TreeMap<Chunk, Chunk> map = new TreeMap<Chunk, Chunk>();
            int pos = 0;
            while (pos < len) {
                key = ArchiveTool.getKey(bytes, pos, len);
                int l = key[3];
                byte[] buff = Arrays.copyOfRange(bytes, pos, pos + l);
                pos += l;
                Chunk c = new Chunk(null, (int[])key, buff);
                Chunk old = (Chunk)map.get(c);
                if (old == null) {
                    c.idList = new ArrayList();
                    c.idList.add(id);
                    map.put(c, c);
                } else {
                    old.idList.add(id);
                }
                ++id;
            }
            segmentStart.add(outPos);
            key = map.keySet().iterator();
            while (key.hasNext()) {
                Chunk c = (Chunk)key.next();
                outPos += (long)c.write(tempOut, true);
            }
            outPos += (long)ArchiveTool.writeVarLong(tempOut, 0L);
        }
        tempOut.close();
        long tempSize = new File((String)tempFileName).length();
        int blockSize = 64;
        boolean merge = false;
        while (segmentStart.size() > blockSize) {
            merge = true;
            log.setRange(30, 50, tempSize);
            log.println();
            log.println("Merging " + segmentStart.size() + " segments " + blockSize + ":1");
            ArrayList<Long> segmentStart2 = new ArrayList<Long>();
            outPos = 0L;
            DataOutputStream tempOut2 = new DataOutputStream(new BufferedOutputStream(new FileOutputStream((String)tempFileName + ".b"), 0x100000));
            while (segmentStart.size() > 0) {
                segmentStart2.add(outPos);
                int s = Math.min(segmentStart.size(), blockSize);
                List<Long> start = segmentStart.subList(0, s);
                TreeSet<ChunkStream> segmentIn = new TreeSet<ChunkStream>();
                long read = ArchiveTool.openSegments(start, segmentIn, (String)tempFileName, true);
                log.printProgress(read);
                Chunk last = null;
                Iterator<Chunk> it = ArchiveTool.merge(segmentIn, log);
                while (it.hasNext()) {
                    Chunk c = it.next();
                    if (last == null) {
                        last = c;
                        continue;
                    }
                    if (last.compareTo(c) == 0) {
                        last.idList.addAll(c.idList);
                        continue;
                    }
                    outPos += (long)last.write(tempOut2, true);
                    last = c;
                }
                if (last != null) {
                    outPos += (long)last.write(tempOut2, true);
                }
                outPos += (long)ArchiveTool.writeVarLong(tempOut2, 0L);
                segmentStart = segmentStart.subList(s, segmentStart.size());
            }
            segmentStart = segmentStart2;
            tempOut2.close();
            tempSize = new File((String)tempFileName).length();
            new File((String)tempFileName).delete();
            tempFileName = (String)tempFileName + ".b";
        }
        if (merge) {
            log.println();
            log.println("Combining " + segmentStart.size() + " segments");
        }
        TreeSet<ChunkStream> segmentIn = new TreeSet<ChunkStream>();
        long read = ArchiveTool.openSegments(segmentStart, segmentIn, (String)tempFileName, true);
        log.printProgress(read);
        DataOutputStream dataOut = new DataOutputStream(out);
        dataOut.write(HEADER);
        ArchiveTool.writeVarLong(dataOut, size);
        log.setRange(50, 100, tempSize);
        Chunk last = null;
        Iterator<Chunk> it = ArchiveTool.merge(segmentIn, log);
        while (it.hasNext()) {
            Chunk c = it.next();
            if (last == null) {
                last = c;
                continue;
            }
            if (last.compareTo(c) == 0) {
                last.idList.addAll(c.idList);
                continue;
            }
            last.write(dataOut, false);
            last = c;
        }
        if (last != null) {
            last.write(dataOut, false);
        }
        new File((String)tempFileName).delete();
        ArchiveTool.writeVarLong(dataOut, 0L);
        dataOut.flush();
    }

    private static long openSegments(List<Long> segmentStart, TreeSet<ChunkStream> segmentIn, String tempFileName, boolean readKey) throws IOException {
        long inPos = 0L;
        int bufferTotal = 0x4000000;
        int bufferPerStream = bufferTotal / segmentStart.size();
        int i = 0;
        while (i < segmentStart.size()) {
            FileInputStream in = new FileInputStream(tempFileName);
            ((InputStream)in).skip(segmentStart.get(i));
            ChunkStream s = new ChunkStream(i);
            s.readKey = readKey;
            s.in = new DataInputStream(new BufferedInputStream(in, bufferPerStream));
            inPos += (long)s.readNext();
            if (s.current != null) {
                segmentIn.add(s);
            }
            ++i;
        }
        return inPos;
    }

    private static Iterator<Chunk> merge(final TreeSet<ChunkStream> segmentIn, final Log log) {
        return new Iterator<Chunk>(){

            @Override
            public boolean hasNext() {
                return !segmentIn.isEmpty();
            }

            @Override
            public Chunk next() {
                ChunkStream s = (ChunkStream)segmentIn.first();
                segmentIn.remove(s);
                Chunk c = s.current;
                int len = s.readNext();
                log.printProgress(len);
                if (s.current != null) {
                    segmentIn.add(s);
                }
                return c;
            }
        };
    }

    private static int readFully(InputStream in, byte[] buffer, int max) throws IOException {
        int result = 0;
        int len = Math.min(max, buffer.length);
        while (len > 0) {
            int l = in.read(buffer, result, len);
            if (l < 0) break;
            result += l;
            len -= l;
        }
        return result;
    }

    private static int[] getKey(byte[] data, int start, int maxPos) {
        int minLen = 4096;
        int mask = 4095;
        long min = Long.MAX_VALUE;
        int pos = start;
        int j = 0;
        while (pos < maxPos) {
            if (pos > start + 10) {
                long hash = ArchiveTool.getSipHash24(data, pos - 10, pos, 111L, 11224L);
                if (hash < min) {
                    min = hash;
                }
                if (j > minLen && ((hash & (long)mask) == 1L || j > minLen * 4 && (hash & (long)(mask >> 1)) == 1L || j > minLen * 16)) break;
            }
            ++pos;
            ++j;
        }
        int len = pos - start;
        int[] counts = new int[8];
        int i = start;
        while (i < pos) {
            int x = data[i] & 0xFF;
            int n = x >> 5;
            counts[n] = counts[n] + 1;
            ++i;
        }
        int cs = 0;
        int i2 = 0;
        while (i2 < 8) {
            cs *= 2;
            if (counts[i2] > len / 32) {
                ++cs;
            }
            ++i2;
        }
        int[] key = new int[]{(int)(min >>> 32), (int)min, cs, len};
        return key;
    }

    private static long getSipHash24(byte[] b, int start, int end, long k0, long k1) {
        long v0 = k0 ^ 0x736F6D6570736575L;
        long v1 = k1 ^ 0x646F72616E646F6DL;
        long v2 = k0 ^ 0x6C7967656E657261L;
        long v3 = k1 ^ 0x7465646279746573L;
        int off = start;
        while (off <= end + 8) {
            int repeat;
            int i;
            long m;
            if (off <= end) {
                m = 0L;
                i = 0;
                while (i < 8 && off + i < end) {
                    m |= ((long)b[off + i] & 0xFFL) << 8 * i;
                    ++i;
                }
                if (i < 8) {
                    m |= (long)end - (long)start << 56;
                }
                v3 ^= m;
                repeat = 2;
            } else {
                m = 0L;
                v2 ^= 0xFFL;
                repeat = 4;
            }
            i = 0;
            while (i < repeat) {
                v0 += v1;
                v2 += v3;
                v1 = Long.rotateLeft(v1, 13);
                v3 = Long.rotateLeft(v3, 16);
                v1 ^= v0;
                v3 ^= v2;
                v0 = Long.rotateLeft(v0, 32);
                v2 += v1;
                v0 += v3;
                v1 = Long.rotateLeft(v1, 17);
                v3 = Long.rotateLeft(v3, 21);
                v1 ^= v2;
                v3 ^= v0;
                v2 = Long.rotateLeft(v2, 32);
                ++i;
            }
            v0 ^= m;
            off += 8;
        }
        return v0 ^ v1 ^ v2 ^ v3;
    }

    private static int[] getKeyOld(byte[] data, int start, int maxPos) {
        int minLen = 4096;
        int mask = 4095;
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int pos = start;
        long bytes = 0L;
        int j = 0;
        while (pos < maxPos) {
            int hash = ArchiveTool.getHash(bytes = bytes << 8 | (long)(data[pos] & 0xFF));
            if (hash < min) {
                min = hash;
            }
            if (hash > max) {
                max = hash;
            }
            if (j > minLen && ((hash & mask) == 1 || j > minLen * 4 && (hash & mask >> 1) == 1 || j > minLen * 16)) break;
            ++pos;
            ++j;
        }
        int len = pos - start;
        int[] counts = new int[8];
        int i = start;
        while (i < pos) {
            int x = data[i] & 0xFF;
            int n = x >> 5;
            counts[n] = counts[n] + 1;
            ++i;
        }
        int cs = 0;
        int i2 = 0;
        while (i2 < 8) {
            cs *= 2;
            if (counts[i2] > len / 32) {
                ++cs;
            }
            ++i2;
        }
        int[] key = new int[]{cs, min, max, len};
        return key;
    }

    private static int getHash(long key) {
        int hash = (int)(key >>> 32 ^ key);
        hash = (hash >>> 16 ^ hash) * 73244475;
        hash = (hash >>> 16 ^ hash) * 73244475;
        hash = hash >>> 16 ^ hash;
        return hash;
    }

    private static void combine(Log log, InputStream in, OutputStream out, String tempFileName) throws IOException {
        int bufferSize = 0x1000000;
        DataOutputStream tempOut = new DataOutputStream(new BufferedOutputStream(new FileOutputStream((String)tempFileName), 0x100000));
        DataInputStream dataIn = new DataInputStream(in);
        byte[] header = new byte[4];
        dataIn.readFully(header);
        if (!Arrays.equals(header, HEADER)) {
            tempOut.close();
            throw new IOException("Invalid header");
        }
        long size = ArchiveTool.readVarLong(dataIn);
        long outPos = 0L;
        List<Long> segmentStart = new ArrayList<Long>();
        boolean end = false;
        log.setRange(0, 30, size);
        while (!end) {
            int segmentSize = 0;
            TreeMap<Long, byte[]> map = new TreeMap<Long, byte[]>();
            while (segmentSize < bufferSize) {
                Chunk c = Chunk.read(dataIn, false);
                if (c == null) {
                    end = true;
                    break;
                }
                int length = c.value.length;
                log.printProgress(length);
                segmentSize += length;
                for (long x : c.idList) {
                    map.put(x, c.value);
                }
            }
            if (map.size() == 0) break;
            segmentStart.add(outPos);
            for (Long x : map.keySet()) {
                outPos += (long)ArchiveTool.writeVarLong(tempOut, x);
                outPos += (long)ArchiveTool.writeVarLong(tempOut, 0L);
                byte[] v = (byte[])map.get(x);
                outPos += (long)ArchiveTool.writeVarLong(tempOut, v.length);
                tempOut.write(v);
                outPos += (long)v.length;
            }
            outPos += (long)ArchiveTool.writeVarLong(tempOut, 0L);
        }
        tempOut.close();
        long tempSize = new File((String)tempFileName).length();
        size = outPos;
        int blockSize = 64;
        boolean merge = false;
        while (segmentStart.size() > blockSize) {
            merge = true;
            log.setRange(30, 50, tempSize);
            log.println();
            log.println("Merging " + segmentStart.size() + " segments " + blockSize + ":1");
            ArrayList<Long> segmentStart2 = new ArrayList<Long>();
            outPos = 0L;
            DataOutputStream tempOut2 = new DataOutputStream(new BufferedOutputStream(new FileOutputStream((String)tempFileName + ".b"), 0x100000));
            while (segmentStart.size() > 0) {
                segmentStart2.add(outPos);
                int s = Math.min(segmentStart.size(), blockSize);
                List<Long> start = segmentStart.subList(0, s);
                TreeSet<ChunkStream> segmentIn = new TreeSet<ChunkStream>();
                long read = ArchiveTool.openSegments(start, segmentIn, (String)tempFileName, false);
                log.printProgress(read);
                Iterator<Chunk> it = ArchiveTool.merge(segmentIn, log);
                while (it.hasNext()) {
                    Chunk c = it.next();
                    outPos += (long)ArchiveTool.writeVarLong(tempOut2, c.idList.get(0));
                    outPos += (long)ArchiveTool.writeVarLong(tempOut2, 0L);
                    outPos += (long)ArchiveTool.writeVarLong(tempOut2, c.value.length);
                    tempOut2.write(c.value);
                    outPos += (long)c.value.length;
                }
                outPos += (long)ArchiveTool.writeVarLong(tempOut2, 0L);
                segmentStart = segmentStart.subList(s, segmentStart.size());
            }
            segmentStart = segmentStart2;
            tempOut2.close();
            tempSize = new File((String)tempFileName).length();
            new File((String)tempFileName).delete();
            tempFileName = (String)tempFileName + ".b";
        }
        if (merge) {
            log.println();
            log.println("Combining " + segmentStart.size() + " segments");
        }
        TreeSet<ChunkStream> segmentIn = new TreeSet<ChunkStream>();
        DataOutputStream dataOut = new DataOutputStream(out);
        log.setRange(50, 100, size);
        long read = ArchiveTool.openSegments(segmentStart, segmentIn, (String)tempFileName, false);
        log.printProgress(read);
        Iterator<Chunk> it = ArchiveTool.merge(segmentIn, log);
        while (it.hasNext()) {
            dataOut.write(it.next().value);
        }
        new File((String)tempFileName).delete();
        dataOut.flush();
    }

    static int writeVarLong(OutputStream out, long x) throws IOException {
        int len = 0;
        while ((x & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.write((byte)(0x80L | x & 0x7FL));
            x >>>= 7;
            ++len;
        }
        out.write((byte)x);
        return ++len;
    }

    static long readVarLong(InputStream in) throws IOException {
        long x = in.read();
        if (x < 0L) {
            throw new EOFException();
        }
        if ((x = (long)((byte)x)) >= 0L) {
            return x;
        }
        x &= 0x7FL;
        int s = 7;
        while (s < 64) {
            long b = in.read();
            if (b < 0L) {
                throw new EOFException();
            }
            b = (byte)b;
            x |= (b & 0x7FL) << s;
            if (b >= 0L) break;
            s += 7;
        }
        return x;
    }

    static class Chunk
    implements Comparable<Chunk> {
        ArrayList<Long> idList;
        final byte[] value;
        private final int[] sortKey;

        Chunk(ArrayList<Long> idList, int[] sortKey, byte[] value) {
            this.idList = idList;
            this.sortKey = sortKey;
            this.value = value;
        }

        public static Chunk read(DataInputStream in, boolean readKey) {
            ArrayList<Long> idList;
            block6: {
                long x;
                idList = new ArrayList<Long>();
                while ((x = ArchiveTool.readVarLong(in)) != 0L) {
                    idList.add(x);
                }
                if (!idList.isEmpty()) break block6;
                in.close();
                return null;
            }
            try {
                int[] key = null;
                if (readKey) {
                    key = new int[4];
                    int i = 0;
                    while (i < key.length) {
                        key[i] = in.readInt();
                        ++i;
                    }
                }
                int len = (int)ArchiveTool.readVarLong(in);
                byte[] value = new byte[len];
                in.readFully(value);
                return new Chunk(idList, key, value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        int write(DataOutputStream out, boolean writeKey) throws IOException {
            int len = 0;
            for (long x : this.idList) {
                len += ArchiveTool.writeVarLong(out, x);
            }
            len += ArchiveTool.writeVarLong(out, 0L);
            if (writeKey) {
                int i = 0;
                while (i < this.sortKey.length) {
                    out.writeInt(this.sortKey[i]);
                    len += 4;
                    ++i;
                }
            }
            len += ArchiveTool.writeVarLong(out, this.value.length);
            out.write(this.value);
            return len += this.value.length;
        }

        @Override
        public int compareTo(Chunk o) {
            if (this.sortKey == null) {
                long b;
                long a = this.idList.get(0);
                if (a < (b = o.idList.get(0).longValue())) {
                    return -1;
                }
                if (a > b) {
                    return 1;
                }
                return 0;
            }
            int i = 0;
            while (i < this.sortKey.length) {
                if (this.sortKey[i] < o.sortKey[i]) {
                    return -1;
                }
                if (this.sortKey[i] > o.sortKey[i]) {
                    return 1;
                }
                ++i;
            }
            if (this.value.length < o.value.length) {
                return -1;
            }
            if (this.value.length > o.value.length) {
                return 1;
            }
            i = 0;
            while (i < this.value.length) {
                int a = this.value[i] & 0xFF;
                int b = o.value[i] & 0xFF;
                if (a < b) {
                    return -1;
                }
                if (a > b) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }
    }

    static class ChunkStream
    implements Comparable<ChunkStream> {
        final int id;
        Chunk current;
        DataInputStream in;
        boolean readKey;

        ChunkStream(int id) {
            this.id = id;
        }

        int readNext() {
            this.current = null;
            this.current = Chunk.read(this.in, this.readKey);
            if (this.current == null) {
                return 0;
            }
            return this.current.value.length;
        }

        @Override
        public int compareTo(ChunkStream o) {
            int comp = this.current.compareTo(o.current);
            if (comp != 0) {
                return comp;
            }
            return Integer.signum(this.id - o.id);
        }
    }

    static class Log {
        private long lastTime;
        private long current;
        private int pos;
        private int low;
        private int high;
        private long total;

        Log() {
        }

        void println() {
            System.out.println();
            this.pos = 0;
        }

        void print(String msg) {
            System.out.print(msg);
        }

        void println(String msg) {
            System.out.println(msg);
            this.pos = 0;
        }

        void setRange(int low, int high, long total) {
            this.low = low;
            this.high = high;
            this.current = 0L;
            this.total = total;
        }

        void printProgress(long offset) {
            this.current += offset;
            long now = System.nanoTime();
            if (now - this.lastTime > TimeUnit.SECONDS.toNanos(3L)) {
                String msg = (long)this.low + (long)(this.high - this.low) * this.current / this.total + "% ";
                if (this.pos > 80) {
                    System.out.println();
                    this.pos = 0;
                }
                System.out.print(msg);
                this.pos += msg.length();
                this.lastTime = now;
            }
        }
    }

    static class SharedInputStream
    extends InputStream {
        private final FileChannel channel;
        private final long endPosition;
        private long position;

        SharedInputStream(FileChannel channel, long position, long endPosition) {
            this.channel = channel;
            this.position = position;
            this.endPosition = endPosition;
        }

        @Override
        public int read() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            if ((len = (int)Math.min((long)len, this.endPosition - this.position)) <= 0) {
                return -1;
            }
            ByteBuffer buff = ByteBuffer.wrap(b, off, len);
            len = this.channel.read(buff, this.position);
            this.position += (long)len;
            return len;
        }
    }
}

