/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.h2.command.dml.BackupCommand;
import org.h2.engine.Constants;
import org.h2.message.DbException;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.StringUtils;
import org.h2.util.Tool;

public class FileShell
extends Tool {
    private boolean verbose;
    private BufferedReader reader;
    private PrintStream err = System.err;
    private InputStream in = System.in;
    private String currentWorkingDirectory;

    public static void main(String ... args) throws SQLException {
        new FileShell().runTool(args);
    }

    public void setErr(PrintStream err) {
        this.err = err;
    }

    public void setIn(InputStream in) {
        this.in = in;
    }

    public void setInReader(BufferedReader reader) {
        this.reader = reader;
    }

    @Override
    public void runTool(String ... args) throws SQLException {
        try {
            this.currentWorkingDirectory = new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            throw DbException.convertIOException(e, "cwd");
        }
        int i = 0;
        while (args != null && i < args.length) {
            String arg = args[i];
            if (arg.equals("-run")) {
                try {
                    this.execute(args[++i]);
                }
                catch (Exception e) {
                    throw DbException.convert(e);
                }
            } else if (arg.equals("-verbose")) {
                this.verbose = true;
            } else {
                if (arg.equals("-help") || arg.equals("-?")) {
                    this.showUsage();
                    return;
                }
                this.showUsageAndThrowUnsupportedOption(arg);
            }
            ++i;
        }
        this.promptLoop();
    }

    private void promptLoop() {
        this.println("");
        this.println("Welcome to H2 File Shell " + Constants.FULL_VERSION);
        this.println("Exit with Ctrl+C");
        this.showHelp();
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader(this.in));
        }
        this.println(FileUtils.toRealPath(this.currentWorkingDirectory));
        try {
            while (true) {
                this.print("> ");
                String line = this.readLine();
                if (line != null) {
                    if ((line = line.trim()).length() == 0) continue;
                    try {
                        this.execute(line);
                    }
                    catch (Exception e) {
                        this.error(e);
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    private void execute(String line) throws IOException {
        String[] commands;
        String[] stringArray = commands = StringUtils.arraySplit(line, ';', true);
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String command = stringArray[n2];
            String[] list = StringUtils.arraySplit(command, ' ', true);
            if (!this.execute(list)) break;
            ++n2;
        }
    }

    private boolean execute(String[] list) throws IOException {
        String c;
        int i = 0;
        if ("exit".equals(c = list[i++]) || "quit".equals(c)) {
            FileShell.end(list, i);
            return false;
        }
        if ("help".equals(c) || "?".equals(c)) {
            this.showHelp();
            FileShell.end(list, i);
        } else if ("cat".equals(c)) {
            String file = this.getFile(list[i++]);
            FileShell.end(list, i);
            this.cat(file, Long.MAX_VALUE);
        } else if ("cd".equals(c)) {
            String dir = this.getFile(list[i++]);
            FileShell.end(list, i);
            if (FileUtils.isDirectory(dir)) {
                this.currentWorkingDirectory = dir;
                this.println(dir);
            } else {
                this.println("Not a directory: " + dir);
            }
        } else if ("chmod".equals(c)) {
            String mode = list[i++];
            String file = this.getFile(list[i++]);
            FileShell.end(list, i);
            if ("-w".equals(mode)) {
                boolean success = FileUtils.setReadOnly(file);
                this.println(success ? "Success" : "Failed");
            } else {
                this.println("Unsupported mode: " + mode);
            }
        } else if ("cp".equals(c)) {
            String source = this.getFile(list[i++]);
            String target = this.getFile(list[i++]);
            FileShell.end(list, i);
            IOUtils.copyFiles(source, target);
        } else if ("head".equals(c)) {
            String file = this.getFile(list[i++]);
            FileShell.end(list, i);
            this.cat(file, 1024L);
        } else if ("ls".equals(c)) {
            String dir = this.currentWorkingDirectory;
            if (i < list.length) {
                dir = this.getFile(list[i++]);
            }
            FileShell.end(list, i);
            this.println(dir);
            for (String file : FileUtils.newDirectoryStream(dir)) {
                StringBuilder buff = new StringBuilder();
                buff.append(FileUtils.isDirectory(file) ? "d" : "-");
                buff.append(FileUtils.canWrite(file) ? "rw" : "r-");
                buff.append(' ');
                buff.append(String.format("%10d", FileUtils.size(file)));
                buff.append(' ');
                long lastMod = FileUtils.lastModified(file);
                buff.append(new Timestamp(lastMod).toString());
                buff.append(' ');
                buff.append(FileUtils.getName(file));
                this.println(buff.toString());
            }
        } else if ("mkdir".equals(c)) {
            String dir = this.getFile(list[i++]);
            FileShell.end(list, i);
            FileUtils.createDirectories(dir);
        } else if ("mv".equals(c)) {
            String source = this.getFile(list[i++]);
            String target = this.getFile(list[i++]);
            FileShell.end(list, i);
            FileUtils.move(source, target);
        } else if ("pwd".equals(c)) {
            FileShell.end(list, i);
            this.println(FileUtils.toRealPath(this.currentWorkingDirectory));
        } else if ("rm".equals(c)) {
            if ("-r".equals(list[i])) {
                int n = ++i;
                String dir = this.getFile(list[n]);
                FileShell.end(list, ++i);
                FileUtils.deleteRecursive(dir, true);
            } else if ("-rf".equals(list[i])) {
                int n = ++i;
                String dir = this.getFile(list[n]);
                FileShell.end(list, ++i);
                FileUtils.deleteRecursive(dir, false);
            } else {
                String file = this.getFile(list[i++]);
                FileShell.end(list, i);
                FileUtils.delete(file);
            }
        } else if ("touch".equals(c)) {
            String file = this.getFile(list[i++]);
            FileShell.end(list, i);
            this.truncate(file, FileUtils.size(file));
        } else if ("truncate".equals(c)) {
            if ("-s".equals(list[i])) {
                int n = ++i;
                long length = Long.decode(list[n]);
                int n2 = ++i;
                String file = this.getFile(list[n2]);
                FileShell.end(list, ++i);
                this.truncate(file, length);
            } else {
                this.println("Unsupported option");
            }
        } else if ("unzip".equals(c)) {
            String file = this.getFile(list[i++]);
            FileShell.end(list, i);
            this.unzip(file, this.currentWorkingDirectory);
        } else if ("zip".equals(c)) {
            boolean recursive = false;
            if ("-r".equals(list[i])) {
                recursive = true;
            }
            int n = ++i;
            String target = this.getFile(list[n]);
            ArrayList<String> source = new ArrayList<String>();
            this.readFileList(list, ++i, source, recursive);
            FileShell.zip(target, this.currentWorkingDirectory, source);
        }
        return true;
    }

    private static void end(String[] list, int index) throws IOException {
        if (list.length != index) {
            throw new IOException("End of command expected, got: " + list[index]);
        }
    }

    private void cat(String fileName, long length) {
        block7: {
            if (!FileUtils.exists(fileName)) {
                this.print("No such file: " + fileName);
            }
            if (FileUtils.isDirectory(fileName)) {
                this.print("Is a directory: " + fileName);
            }
            InputStream inFile = null;
            try {
                try {
                    inFile = FileUtils.newInputStream(fileName);
                    IOUtils.copy(inFile, (OutputStream)this.out, length);
                }
                catch (IOException e) {
                    this.error(e);
                    IOUtils.closeSilently(inFile);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(inFile);
                throw throwable;
            }
            IOUtils.closeSilently(inFile);
        }
        this.println("");
    }

    private void truncate(String fileName, long length) {
        FileChannel f = null;
        try {
            try {
                f = FileUtils.open(fileName, "rw");
                f.truncate(length);
            }
            catch (IOException e) {
                this.error(e);
                try {
                    f.close();
                }
                catch (IOException e2) {
                    this.error(e2);
                }
            }
        }
        finally {
            try {
                f.close();
            }
            catch (IOException e) {
                this.error(e);
            }
        }
    }

    private void error(Exception e) {
        this.println("Exception: " + e.getMessage());
        if (this.verbose) {
            e.printStackTrace(this.err);
        }
    }

    private static void zip(String zipFileName, String base, ArrayList<String> source) {
        FileUtils.delete(zipFileName);
        OutputStream fileOut = null;
        try {
            try {
                fileOut = FileUtils.newOutputStream(zipFileName, false);
                ZipOutputStream zipOut = new ZipOutputStream(fileOut);
                for (String fileName : source) {
                    block11: {
                        String f = FileUtils.toRealPath(fileName);
                        if (!f.startsWith(base)) {
                            throw DbException.getInternalError(f + " does not start with " + base);
                        }
                        if (f.endsWith(zipFileName) || FileUtils.isDirectory(fileName)) continue;
                        f = f.substring(base.length());
                        f = BackupCommand.correctFileName(f);
                        ZipEntry entry = new ZipEntry(f);
                        zipOut.putNextEntry(entry);
                        InputStream in = null;
                        try {
                            try {
                                in = FileUtils.newInputStream(fileName);
                                IOUtils.copyAndCloseInput(in, zipOut);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                IOUtils.closeSilently(in);
                                break block11;
                            }
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeSilently(in);
                            throw throwable;
                        }
                        IOUtils.closeSilently(in);
                    }
                    zipOut.closeEntry();
                }
                zipOut.closeEntry();
                zipOut.close();
            }
            catch (IOException e) {
                throw DbException.convertIOException(e, zipFileName);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeSilently(fileOut);
            throw throwable;
        }
        IOUtils.closeSilently(fileOut);
    }

    private void unzip(String zipFileName, String targetDir) {
        InputStream inFile = null;
        try {
            try {
                ZipEntry entry;
                inFile = FileUtils.newInputStream(zipFileName);
                ZipInputStream zipIn = new ZipInputStream(inFile);
                while ((entry = zipIn.getNextEntry()) != null) {
                    String fileName = entry.getName();
                    if ((fileName = IOUtils.nameSeparatorsToNative(fileName)).startsWith(File.separator)) {
                        fileName = fileName.substring(1);
                    }
                    OutputStream o = null;
                    try {
                        o = FileUtils.newOutputStream(targetDir + File.separatorChar + fileName, false);
                        IOUtils.copy(zipIn, o);
                        o.close();
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeSilently(o);
                        throw throwable;
                    }
                    IOUtils.closeSilently(o);
                    zipIn.closeEntry();
                }
                zipIn.closeEntry();
                zipIn.close();
            }
            catch (IOException e) {
                this.error(e);
                IOUtils.closeSilently(inFile);
            }
        }
        finally {
            IOUtils.closeSilently(inFile);
        }
    }

    private int readFileList(String[] list, int i, ArrayList<String> target, boolean recursive) throws IOException {
        while (i < list.length) {
            String c;
            if (";".equals(c = list[i++])) break;
            if (!FileUtils.exists(c = this.getFile(c))) {
                throw new IOException("File not found: " + c);
            }
            if (recursive) {
                this.addFilesRecursive(c, target);
                continue;
            }
            target.add(c);
        }
        return i;
    }

    private void addFilesRecursive(String f, ArrayList<String> target) {
        if (FileUtils.isDirectory(f)) {
            for (String c : FileUtils.newDirectoryStream(f)) {
                this.addFilesRecursive(c, target);
            }
        } else {
            target.add(this.getFile(f));
        }
    }

    private String getFile(String f) {
        if (FileUtils.isAbsolute((String)f)) {
            return f;
        }
        String unwrapped = FileUtils.unwrap((String)f);
        String prefix = ((String)f).substring(0, ((String)f).length() - unwrapped.length());
        f = prefix + this.currentWorkingDirectory + File.separatorChar + unwrapped;
        return FileUtils.toRealPath((String)f);
    }

    private void showHelp() {
        this.println("Commands are case sensitive");
        this.println("? or help                  Display this help");
        this.println("cat <file>                 Print the contents of the file");
        this.println("cd <dir>                   Change the directory");
        this.println("chmod -w <file>            Make the file read-only");
        this.println("cp <source> <target>       Copy a file");
        this.println("head <file>                Print the first few lines of the contents");
        this.println("ls [<dir>]                 Print the directory contents");
        this.println("mkdir <dir>                Create a directory (including parent directories)");
        this.println("mv <source> <target>       Rename a file or directory");
        this.println("pwd                        Print the current working directory");
        this.println("rm <file>                  Remove a file");
        this.println("rm -r <dir>                Remove a directory, recursively");
        this.println("rm -rf <dir>               Remove a directory, recursively; force");
        this.println("touch <file>               Update the last modified date (creates the file)");
        this.println("truncate -s <size> <file>  Set the file length");
        this.println("unzip <zip>                Extract all files from the zip file");
        this.println("zip [-r] <zip> <files..>   Create a zip file (-r to recurse directories)");
        this.println("exit                       Exit");
        this.println("");
    }

    private String readLine() throws IOException {
        String line = this.reader.readLine();
        if (line == null) {
            throw new IOException("Aborted");
        }
        return line;
    }

    private void print(String s) {
        this.out.print(s);
        this.out.flush();
    }

    private void println(String s) {
        this.out.println(s);
        this.out.flush();
    }
}

