/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.fs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.zip.ZipInputStream;
import org.h2.store.fs.FakeFileChannel;
import org.h2.store.fs.FileBase;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;

class FileZip2
extends FileBase {
    private static final byte[] SKIP_BUFFER = new byte[1024];
    private final String fullName;
    private final String name;
    private final long length;
    private long pos;
    private InputStream in;
    private long inPos;
    private boolean skipUsingRead;

    FileZip2(String fullName, String name, ZipInputStream in, long length) {
        this.fullName = fullName;
        this.name = name;
        this.length = length;
        this.in = in;
    }

    @Override
    public void implCloseChannel() throws IOException {
        this.in.close();
    }

    @Override
    public long position() {
        return this.pos;
    }

    @Override
    public long size() {
        return this.length;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        this.seek();
        int len = this.in.read(dst.array(), dst.arrayOffset() + dst.position(), dst.remaining());
        if (len > 0) {
            dst.position(dst.position() + len);
            this.pos += (long)len;
            this.inPos += (long)len;
        }
        return len;
    }

    private void seek() throws IOException {
        if (this.inPos > this.pos) {
            if (this.in != null) {
                this.in.close();
            }
            this.in = null;
        }
        if (this.in == null) {
            this.in = FileUtils.newInputStream(this.fullName);
            this.inPos = 0L;
        }
        if (this.inPos < this.pos) {
            long skip = this.pos - this.inPos;
            if (!this.skipUsingRead) {
                try {
                    IOUtils.skipFully(this.in, skip);
                }
                catch (NullPointerException e) {
                    this.skipUsingRead = true;
                }
            }
            if (this.skipUsingRead) {
                while (skip > 0L) {
                    int s = (int)Math.min((long)SKIP_BUFFER.length, skip);
                    s = this.in.read(SKIP_BUFFER, 0, s);
                    skip -= (long)s;
                }
            }
            this.inPos = this.pos;
        }
    }

    @Override
    public FileChannel position(long newPos) {
        this.pos = newPos;
        return this;
    }

    @Override
    public FileChannel truncate(long newLength) throws IOException {
        throw new IOException("File is read-only");
    }

    @Override
    public void force(boolean metaData) throws IOException {
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        throw new IOException("File is read-only");
    }

    @Override
    public synchronized FileLock tryLock(long position, long size, boolean shared) throws IOException {
        if (shared) {
            return new FileLock(FakeFileChannel.INSTANCE, position, size, shared){

                @Override
                public boolean isValid() {
                    return true;
                }

                @Override
                public void release() throws IOException {
                }
            };
        }
        return null;
    }

    public String toString() {
        return "zip2:" + this.name;
    }
}

