/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.ftp;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.h2.util.IOUtils;
import org.h2.util.NetUtils;
import org.h2.util.StringUtils;

public class FtpClient {
    private Socket socket;
    private BufferedReader reader;
    private PrintWriter writer;
    private int code;
    private String message;
    private InputStream inData;
    private OutputStream outData;

    private FtpClient() {
    }

    public static FtpClient open(String url) throws IOException {
        FtpClient client = new FtpClient();
        client.connect(url);
        return client;
    }

    private void connect(String url) throws IOException {
        this.socket = NetUtils.createSocket(url, 21, false);
        InputStream in = this.socket.getInputStream();
        OutputStream out = this.socket.getOutputStream();
        this.reader = new BufferedReader(new InputStreamReader(in));
        this.writer = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        this.readCode(220);
    }

    private void readLine() throws IOException {
        this.message = this.reader.readLine();
        if (this.message != null) {
            int idx;
            int idxSpace = this.message.indexOf(32);
            int idxMinus = this.message.indexOf(45);
            int n = idxSpace < 0 ? idxMinus : (idx = idxMinus < 0 ? idxSpace : Math.min(idxSpace, idxMinus));
            if (idx < 0) {
                this.code = 0;
            } else {
                this.code = Integer.parseInt(this.message.substring(0, idx));
                this.message = this.message.substring(idx + 1);
            }
        }
    }

    private void readCode(int optional, int expected) throws IOException {
        this.readLine();
        if (this.code == optional) {
            this.readLine();
        }
        if (this.code != expected) {
            throw new IOException("Expected: " + expected + " got: " + this.code + " " + this.message);
        }
    }

    private void readCode(int expected) throws IOException {
        this.readCode(-1, expected);
    }

    private void send(String command) {
        this.writer.println(command);
        this.writer.flush();
    }

    public void login(String userName, String password) throws IOException {
        this.send("USER " + userName);
        this.readCode(331);
        this.send("PASS " + password);
        this.readCode(230);
        this.send("SYST");
        this.readCode(215);
        this.send("SITE");
        this.readCode(500);
        this.send("STRU F");
        this.readCode(200);
        this.send("TYPE I");
        this.readCode(200);
    }

    public void close() throws IOException {
        if (this.socket != null) {
            this.send("QUIT");
            this.readCode(221);
            this.socket.close();
        }
    }

    public void changeWorkingDirectory(String dir) throws IOException {
        this.send("CWD " + dir);
        this.readCode(250);
    }

    public void changeDirectoryUp() throws IOException {
        this.send("CDUP");
        this.readCode(250);
    }

    void delete(String fileName) throws IOException {
        this.send("DELE " + fileName);
        this.readCode(226, 250);
    }

    public void makeDirectory(String dir) throws IOException {
        this.send("MKD " + dir);
        this.readCode(226, 257);
    }

    void mode(String mode) throws IOException {
        this.send("MODE " + mode);
        this.readCode(200);
    }

    void modificationTime(String fileName) throws IOException {
        this.send("MDTM " + fileName);
        this.readCode(213);
    }

    void noOperation() throws IOException {
        this.send("NOOP");
        this.readCode(200);
    }

    String printWorkingDirectory() throws IOException {
        this.send("PWD");
        this.readCode(257);
        return this.removeQuotes();
    }

    private String removeQuotes() {
        int first = this.message.indexOf(34) + 1;
        int last = this.message.lastIndexOf(34);
        StringBuilder buff = new StringBuilder();
        int i = first;
        while (i < last) {
            char ch = this.message.charAt(i);
            buff.append(ch);
            if (ch == '\"') {
                ++i;
            }
            ++i;
        }
        return buff.toString();
    }

    private void passive() throws IOException {
        this.send("PASV");
        this.readCode(226, 227);
        int first = this.message.indexOf(40) + 1;
        int last = this.message.indexOf(41);
        String[] address = StringUtils.arraySplit(this.message.substring(first, last), ',', true);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < 4) {
            if (i > 0) {
                builder.append('.');
            }
            builder.append(address[i]);
            ++i;
        }
        String ip = builder.toString();
        InetAddress addr = InetAddress.getByName(ip);
        int port = Integer.parseInt(address[4]) << 8 | Integer.parseInt(address[5]);
        Socket socketData = NetUtils.createSocket(addr, port, false);
        this.inData = socketData.getInputStream();
        this.outData = socketData.getOutputStream();
    }

    void rename(String fromFileName, String toFileName) throws IOException {
        this.send("RNFR " + fromFileName);
        this.readCode(350);
        this.send("RNTO " + toFileName);
        this.readCode(250);
    }

    public byte[] retrieve(String fileName) throws IOException {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        this.retrieve(fileName, buff, 0L);
        return buff.toByteArray();
    }

    void retrieve(String fileName, OutputStream out, long restartAt) throws IOException {
        this.passive();
        if (restartAt > 0L) {
            this.send("REST " + restartAt);
            this.readCode(350);
        }
        this.send("RETR " + fileName);
        IOUtils.copyAndClose(this.inData, out);
        this.readCode(150, 226);
    }

    public void removeDirectory(String dir) throws IOException {
        this.send("RMD " + dir);
        this.readCode(226, 250);
    }

    public void removeDirectoryRecursive(String dir) throws IOException {
        File[] fileArray = this.listFiles(dir);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String name = f.getName();
            if (f.isDirectory()) {
                if (!name.equals(".") && !name.equals("..")) {
                    this.removeDirectoryRecursive(dir + "/" + name);
                }
            } else {
                this.delete(dir + "/" + name);
            }
            ++n2;
        }
        this.removeDirectory(dir);
    }

    long size(String fileName) throws IOException {
        this.send("SIZE " + fileName);
        this.readCode(250);
        long size = Long.parseLong(this.message);
        return size;
    }

    public void store(String fileName, InputStream in) throws IOException {
        this.passive();
        this.send("STOR " + fileName);
        this.readCode(150);
        IOUtils.copyAndClose(in, this.outData);
        this.readCode(226);
    }

    public void storeRecursive(File file) throws IOException {
        if (file.isDirectory()) {
            this.makeDirectory(file.getName());
            this.changeWorkingDirectory(file.getName());
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.storeRecursive(f);
                ++n2;
            }
            this.changeWorkingDirectory("..");
        } else {
            FileInputStream in = new FileInputStream(file);
            this.store(file.getName(), in);
        }
    }

    public String nameList(String dir) throws IOException {
        this.passive();
        this.send("NLST " + dir);
        this.readCode(150);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyAndClose(this.inData, out);
        this.readCode(226);
        return out.toString();
    }

    public String list(String dir) throws IOException {
        this.passive();
        this.send("LIST " + dir);
        this.readCode(150);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyAndClose(this.inData, out);
        this.readCode(226);
        return out.toString();
    }

    public boolean exists(String dir, String name) throws IOException {
        File[] fileArray = this.listFiles(dir);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getName().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public File[] listFiles(String dir) throws IOException {
        String content = this.list(dir);
        String[] list = StringUtils.arraySplit(content.trim(), '\n', true);
        File[] files = new File[list.length];
        int i = 0;
        while (i < files.length) {
            String s2;
            String s = list[i];
            while (!(s2 = StringUtils.replaceAll(s, "  ", " ")).equals(s)) {
                s = s2;
            }
            String[] tokens = StringUtils.arraySplit(s, ' ', true);
            boolean directory = tokens[0].charAt(0) == 'd';
            long length = Long.parseLong(tokens[4]);
            String name = tokens[8];
            FtpFile f = new FtpFile(name, directory, length);
            files[i] = f;
            ++i;
        }
        return files;
    }

    static class FtpFile
    extends File {
        private static final long serialVersionUID = 1L;
        private final boolean dir;
        private final long length;

        FtpFile(String name, boolean dir, long length) {
            super(name);
            this.dir = dir;
            this.length = length;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public boolean isFile() {
            return !this.dir;
        }

        @Override
        public boolean isDirectory() {
            return this.dir;
        }

        @Override
        public boolean exists() {
            return true;
        }
    }
}

