/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.ftp.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.h2.dev.ftp.server.FtpServer;
import org.h2.store.fs.FileUtils;
import org.h2.util.IOUtils;

public class FtpData
extends Thread {
    private final FtpServer server;
    private final InetAddress address;
    private ServerSocket serverSocket;
    private volatile Socket socket;
    private final boolean active;
    private final int port;

    FtpData(FtpServer server, InetAddress address, ServerSocket serverSocket) {
        this.server = server;
        this.address = address;
        this.serverSocket = serverSocket;
        this.port = 0;
        this.active = false;
    }

    FtpData(FtpServer server, InetAddress address, int port) {
        this.server = server;
        this.address = address;
        this.port = port;
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            FtpData ftpData = this;
            synchronized (ftpData) {
                Socket s = this.serverSocket.accept();
                if (s.getInetAddress().equals(this.address)) {
                    this.server.trace("Data connected:" + String.valueOf(s.getInetAddress()) + " expected:" + String.valueOf(this.address));
                    this.socket = s;
                    this.notifyAll();
                } else {
                    this.server.trace("Data REJECTED:" + String.valueOf(s.getInetAddress()) + " expected:" + String.valueOf(this.address));
                    this.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void connect() throws IOException {
        if (this.active) {
            this.socket = new Socket(this.address, this.port);
        } else {
            this.waitUntilConnected();
        }
    }

    private void waitUntilConnected() {
        while (this.serverSocket != null && this.socket == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.server.trace("connected");
    }

    void close() {
        this.serverSocket = null;
        this.socket = null;
    }

    synchronized void receive(String fileName) throws IOException {
        this.connect();
        try {
            InputStream in = this.socket.getInputStream();
            OutputStream out = FileUtils.newOutputStream(fileName, false);
            IOUtils.copy(in, out);
            out.close();
        }
        finally {
            this.socket.close();
        }
        this.server.trace("closed");
    }

    synchronized void send(String fileName, long skip) throws IOException {
        this.connect();
        try {
            OutputStream out = this.socket.getOutputStream();
            InputStream in = FileUtils.newInputStream(fileName);
            IOUtils.skipFully(in, skip);
            IOUtils.copy(in, out);
            in.close();
        }
        finally {
            this.socket.close();
        }
        this.server.trace("closed");
    }

    synchronized void send(byte[] data) throws IOException {
        this.connect();
        try {
            OutputStream out = this.socket.getOutputStream();
            out.write(data);
        }
        finally {
            this.socket.close();
        }
        this.server.trace("closed");
    }
}

