/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.ftp.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.h2.dev.ftp.server.FtpControl;
import org.h2.dev.ftp.server.FtpEventListener;
import org.h2.server.Service;
import org.h2.store.fs.FileUtils;
import org.h2.tools.Server;
import org.h2.util.IOUtils;
import org.h2.util.NetUtils;
import org.h2.util.SortedProperties;
import org.h2.util.Tool;

public class FtpServer
extends Tool
implements Service {
    public static final int DEFAULT_PORT = 8021;
    public static final String DEFAULT_ROOT = "ftp";
    public static final String DEFAULT_READ = "guest";
    public static final String DEFAULT_WRITE = "sa";
    public static final String DEFAULT_WRITE_PASSWORD = "sa";
    static final String TASK_SUFFIX = ".task";
    private static final int MAX_CONNECTION_COUNT = 100;
    private ServerSocket serverSocket;
    private int port = 8021;
    private int openConnectionCount;
    private final SimpleDateFormat dateFormatNew = new SimpleDateFormat("MMM dd HH:mm", Locale.ENGLISH);
    private final SimpleDateFormat dateFormatOld = new SimpleDateFormat("MMM dd  yyyy", Locale.ENGLISH);
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private String root = "ftp";
    private String writeUserName = "sa";
    private String writePassword = "sa";
    private String readUserName = "guest";
    private final HashMap<String, Process> tasks = new HashMap();
    private boolean trace;
    private boolean allowTask;
    private FtpEventListener eventListener;

    public static void main(String ... args) throws SQLException {
        new FtpServer().runTool(args);
    }

    @Override
    public void runTool(String ... args) throws SQLException {
        int i = 0;
        while (args != null && i < args.length) {
            String arg = args[i];
            if (arg != null) {
                if ("-?".equals(arg) || "-help".equals(arg)) {
                    this.showUsage();
                    return;
                }
                if (arg.startsWith("-ftp")) {
                    if ("-ftpPort".equals(arg)) {
                        ++i;
                    } else if ("-ftpDir".equals(arg)) {
                        ++i;
                    } else if ("-ftpRead".equals(arg)) {
                        ++i;
                    } else if ("-ftpWrite".equals(arg)) {
                        ++i;
                    } else if ("-ftpWritePassword".equals(arg)) {
                        ++i;
                    } else if (!"-ftpTask".equals(arg)) {
                        this.showUsageAndThrowUnsupportedOption(arg);
                    }
                } else if (!"-trace".equals(arg)) {
                    this.showUsageAndThrowUnsupportedOption(arg);
                }
            }
            ++i;
        }
        Server server = new Server(this, args);
        server.start();
        this.out.println(server.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void listen() {
        try {
            while (this.serverSocket != null) {
                boolean stop;
                Socket s = this.serverSocket.accept();
                FtpServer ftpServer = this;
                synchronized (ftpServer) {
                    ++this.openConnectionCount;
                    stop = this.openConnectionCount > 100;
                }
                FtpControl c = new FtpControl(s, this, stop);
                c.start();
            }
        }
        catch (Exception e) {
            this.traceError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeConnection() {
        FtpServer ftpServer = this;
        synchronized (ftpServer) {
            --this.openConnectionCount;
        }
    }

    static ServerSocket createDataSocket() {
        return NetUtils.createServerSocket(0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendFile(StringBuilder buff, String fileName) {
        String date;
        buff.append(FileUtils.isDirectory(fileName) ? (char)'d' : '-');
        buff.append('r');
        buff.append(FileUtils.canWrite(fileName) ? (char)'w' : '-');
        buff.append("------- 1 owner group ");
        String size = Long.toString(FileUtils.size(fileName));
        int i = size.length();
        while (i < 15) {
            buff.append(' ');
            ++i;
        }
        buff.append(size);
        buff.append(' ');
        Date now = new Date();
        Date mod = new Date(FileUtils.lastModified(fileName));
        if (mod.after(now) || Math.abs((now.getTime() - mod.getTime()) / 1000L / 60L / 60L / 24L) > 180L) {
            SimpleDateFormat simpleDateFormat = this.dateFormatOld;
            synchronized (simpleDateFormat) {
                date = this.dateFormatOld.format(mod);
            }
        }
        SimpleDateFormat simpleDateFormat = this.dateFormatNew;
        synchronized (simpleDateFormat) {
            date = this.dateFormatNew.format(mod);
        }
        buff.append(date);
        buff.append(' ');
        buff.append(FileUtils.getName(fileName));
        buff.append("\r\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String formatLastModified(String fileName) {
        SimpleDateFormat simpleDateFormat = this.dateFormat;
        synchronized (simpleDateFormat) {
            return this.dateFormat.format(new Date(FileUtils.lastModified(fileName)));
        }
    }

    String getFileName(String path) {
        return this.root + this.getPath(path);
    }

    private String getPath(String path) {
        if (path.indexOf("..") > 0) {
            path = "/";
        }
        while (path.startsWith("/") && this.root.endsWith("/")) {
            path = path.substring(1);
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        this.trace("path: " + path);
        return path;
    }

    String getDirectoryListing(String directory, boolean listDirectories) {
        StringBuilder buff = new StringBuilder();
        for (String fileName : FileUtils.newDirectoryStream(directory)) {
            if (FileUtils.isDirectory(fileName) && (!FileUtils.isDirectory(fileName) || !listDirectories)) continue;
            this.appendFile(buff, fileName);
        }
        return buff.toString();
    }

    boolean checkUserPasswordWrite(String userName, String password) {
        return userName.equals(this.writeUserName) && password.equals(this.writePassword);
    }

    boolean checkUserPasswordReadOnly(String userName) {
        return userName.equals(this.readUserName);
    }

    @Override
    public void init(String ... args) {
        int i = 0;
        while (args != null && i < args.length) {
            String a = args[i];
            if ("-ftpPort".equals(a)) {
                this.port = Integer.decode(args[++i]);
            } else if ("-ftpDir".equals(a)) {
                this.root = FileUtils.toRealPath(args[++i]);
            } else if ("-ftpRead".equals(a)) {
                this.readUserName = args[++i];
            } else if ("-ftpWrite".equals(a)) {
                this.writeUserName = args[++i];
            } else if ("-ftpWritePassword".equals(a)) {
                this.writePassword = args[++i];
            } else if ("-trace".equals(a)) {
                this.trace = true;
            } else if ("-ftpTask".equals(a)) {
                this.allowTask = true;
            }
            ++i;
        }
    }

    @Override
    public String getURL() {
        return "ftp://" + NetUtils.getLocalAddress() + ":" + this.port;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void start() {
        this.root = FileUtils.toRealPath(this.root);
        FileUtils.createDirectories(this.root);
        this.serverSocket = NetUtils.createServerSocket(this.port, false);
        this.port = this.serverSocket.getLocalPort();
    }

    @Override
    public void stop() {
        if (this.serverSocket == null) {
            return;
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            this.traceError(e);
        }
        this.serverSocket = null;
    }

    @Override
    public boolean isRunning(boolean traceError) {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket s = NetUtils.createLoopbackSocket(this.port, false);
            s.close();
            return true;
        }
        catch (IOException e) {
            if (traceError) {
                this.traceError(e);
            }
            return false;
        }
    }

    @Override
    public boolean getAllowOthers() {
        return true;
    }

    @Override
    public String getType() {
        return "FTP";
    }

    @Override
    public String getName() {
        return "H2 FTP Server";
    }

    void trace(String s) {
        if (this.trace) {
            System.out.println(s);
        }
    }

    void traceError(Throwable e) {
        if (this.trace) {
            e.printStackTrace();
        }
    }

    boolean getAllowTask() {
        return this.allowTask;
    }

    void startTask(String path) throws IOException {
        this.stopTask(path);
        if (path.endsWith(".zip.task")) {
            this.trace("expand: " + path);
            Process p = Runtime.getRuntime().exec("jar -xf " + path, null, new File(this.root));
            new StreamRedirect(path, p.getInputStream(), null).start();
            return;
        }
        SortedProperties prop = SortedProperties.loadProperties(path);
        String command = prop.getProperty("command");
        String outFile = path.substring(0, path.length() - TASK_SUFFIX.length());
        String errorFile = this.root + "/" + prop.getProperty("error", outFile + ".err.txt");
        String outputFile = this.root + "/" + prop.getProperty("output", outFile + ".out.txt");
        this.trace("start process: " + path + " / " + command);
        Process p = Runtime.getRuntime().exec(command, null, new File(this.root));
        new StreamRedirect(path, p.getErrorStream(), errorFile).start();
        new StreamRedirect(path, p.getInputStream(), outputFile).start();
        this.tasks.put(path, p);
    }

    void stopTask(String processName) {
        this.trace("kill process: " + processName);
        Process p = this.tasks.remove(processName);
        if (p == null) {
            return;
        }
        p.destroy();
    }

    public void setEventListener(FtpEventListener eventListener) {
        this.eventListener = eventListener;
    }

    FtpEventListener getEventListener() {
        return this.eventListener;
    }

    public static Server createFtpServer(String ... args) throws SQLException {
        return new Server(new FtpServer(), args);
    }

    @Override
    public boolean isDaemon() {
        return false;
    }

    private static class StreamRedirect
    extends Thread {
        private final InputStream in;
        private OutputStream out;
        private String outFile;
        private final String processFile;

        StreamRedirect(String processFile, InputStream in, String outFile) {
            this.processFile = processFile;
            this.in = in;
            this.outFile = outFile;
        }

        private void openOutput() {
            if (this.outFile != null) {
                try {
                    this.out = FileUtils.newOutputStream(this.outFile, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.outFile = null;
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    int x;
                    while ((x = this.in.read()) >= 0) {
                        this.openOutput();
                        if (this.out == null) continue;
                        this.out.write(x);
                    }
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
            IOUtils.closeSilently(this.out);
            IOUtils.closeSilently(this.in);
            new File(this.processFile).delete();
        }
    }
}

