/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.hash;

import java.util.ArrayList;
import java.util.Arrays;

public class IntPerfectHash {
    private static final int DIVIDE = 6;
    private static final int MAX_SIZE = 12;
    private static final int[] MAX_OFFSETS;
    private static final int SPLIT_MANY = 3;
    private static final int[] SIZE_OFFSETS;
    private final byte[] data;

    static {
        int[] nArray = new int[13];
        nArray[2] = 8;
        nArray[3] = 18;
        nArray[4] = 47;
        nArray[5] = 123;
        nArray[6] = 319;
        nArray[7] = 831;
        nArray[8] = 2162;
        nArray[9] = 5622;
        nArray[10] = 14617;
        nArray[11] = 38006;
        nArray[12] = 98815;
        MAX_OFFSETS = nArray;
        SIZE_OFFSETS = new int[MAX_OFFSETS.length + 1];
        int last = 4;
        int i = 0;
        while (i < MAX_OFFSETS.length) {
            IntPerfectHash.SIZE_OFFSETS[i] = last;
            last += MAX_OFFSETS[i];
            ++i;
        }
        IntPerfectHash.SIZE_OFFSETS[IntPerfectHash.SIZE_OFFSETS.length - 1] = last;
    }

    public IntPerfectHash(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public int get(int x) {
        return this.get(0, x, 0);
    }

    private int get(int pos, int x, int level) {
        int split;
        int n = IntPerfectHash.readVarInt(this.data, pos);
        if (n < 2) {
            return 0;
        }
        if (n > 3) {
            int size = IntPerfectHash.getSize(n);
            int offset = IntPerfectHash.getOffset(n, size);
            return IntPerfectHash.hash(x, level, offset, size);
        }
        ++pos;
        if (n == 3) {
            split = IntPerfectHash.readVarInt(this.data, pos);
            pos += IntPerfectHash.getVarIntLength(this.data, pos);
        } else {
            split = n;
        }
        int h = IntPerfectHash.hash(x, level, 0, split);
        int start = pos;
        int i = 0;
        while (i < h) {
            pos = this.getNextPos(pos);
            ++i;
        }
        int s = this.getSizeSum(start, pos);
        return s + this.get(pos, x, level + 1);
    }

    private int getNextPos(int pos) {
        int split;
        int n = IntPerfectHash.readVarInt(this.data, pos);
        pos += IntPerfectHash.getVarIntLength(this.data, pos);
        if (n < 2 || n > 3) {
            return pos;
        }
        if (n == 3) {
            split = IntPerfectHash.readVarInt(this.data, pos);
            pos += IntPerfectHash.getVarIntLength(this.data, pos);
        } else {
            split = n;
        }
        int i = 0;
        while (i < split) {
            pos = this.getNextPos(pos);
            ++i;
        }
        return pos;
    }

    private int getSizeSum(int start, int end) {
        int s = 0;
        int pos = start;
        while (pos < end) {
            int n = IntPerfectHash.readVarInt(this.data, pos);
            pos += IntPerfectHash.getVarIntLength(this.data, pos);
            if (n < 2) {
                s += n;
                continue;
            }
            if (n > 3) {
                s += IntPerfectHash.getSize(n);
                continue;
            }
            if (n != 3) continue;
            pos += IntPerfectHash.getVarIntLength(this.data, pos);
        }
        return s;
    }

    private static void writeSizeOffset(ByteStream out, int size, int offset) {
        IntPerfectHash.writeVarInt(out, SIZE_OFFSETS[size] + offset);
    }

    private static int getOffset(int n, int size) {
        return n - SIZE_OFFSETS[size];
    }

    private static int getSize(int n) {
        int i = 0;
        while (i < SIZE_OFFSETS.length) {
            if (n < SIZE_OFFSETS[i]) {
                return i - 1;
            }
            ++i;
        }
        return 0;
    }

    public static byte[] generate(ArrayList<Integer> list) {
        ByteStream out = new ByteStream();
        IntPerfectHash.generate(list, 0, out);
        return out.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    private static void generate(ArrayList<Integer> list, int level, ByteStream out) {
        void var6_10;
        int size = list.size();
        if (size <= 1) {
            out.write((byte)size);
            return;
        }
        if (level > 32) {
            throw new IllegalStateException("Too many recursions;  incorrect universal hash function?");
        }
        if (size <= 12) {
            void var6_8;
            int maxOffset = MAX_OFFSETS[size];
            int testSize = size;
            boolean bl = false;
            while (var6_8 < maxOffset) {
                block10: {
                    int bits = 0;
                    int i = 0;
                    while (i < size) {
                        int x = list.get(i);
                        int h = IntPerfectHash.hash(x, level, (int)var6_8, testSize);
                        if ((bits & 1 << h) == 0) {
                            bits |= 1 << h;
                            ++i;
                            continue;
                        }
                        break block10;
                    }
                    IntPerfectHash.writeSizeOffset(out, size, (int)var6_8);
                    return;
                }
                ++var6_8;
            }
        }
        int split = size > 342 ? size / 216 : (size - 47) / 6;
        split = Math.max(2, split);
        ArrayList lists = new ArrayList(split);
        boolean bl = false;
        while (var6_10 < split) {
            lists.add(new ArrayList(size / split));
            ++var6_10;
        }
        for (int n : list) {
            ArrayList l = (ArrayList)lists.get(IntPerfectHash.hash(n, level, 0, split));
            l.add(n);
        }
        if (split >= 3) {
            out.write((byte)3);
        }
        IntPerfectHash.writeVarInt(out, split);
        list.clear();
        list.trimToSize();
        for (ArrayList arrayList : lists) {
            IntPerfectHash.generate(arrayList, level + 1, out);
        }
    }

    private static int hash(int x, int level, int offset, int size) {
        x += level + offset * 32;
        x = (x >>> 16 ^ x) * 73244475;
        x = (x >>> 16 ^ x) * 73244475;
        x = x >>> 16 ^ x;
        return Math.abs(x % size);
    }

    private static int writeVarInt(ByteStream out, int x) {
        int len = 0;
        while ((x & 0xFFFFFF80) != 0) {
            out.write((byte)(0x80 | x & 0x7F));
            x >>>= 7;
            ++len;
        }
        out.write((byte)x);
        return ++len;
    }

    private static int readVarInt(byte[] d, int pos) {
        int x;
        if ((x = d[pos++]) >= 0) {
            return x;
        }
        x &= 0x7F;
        int s = 7;
        while (s < 64) {
            byte b = d[pos++];
            x |= (b & 0x7F) << s;
            if (b >= 0) break;
            s += 7;
        }
        return x;
    }

    private static int getVarIntLength(byte[] d, int pos) {
        byte x;
        if ((x = d[pos++]) >= 0) {
            return 1;
        }
        int len = 2;
        int s = 7;
        while (s < 64) {
            byte b;
            if ((b = d[pos++]) >= 0) break;
            ++len;
            s += 7;
        }
        return len;
    }

    public static class BitArray {
        public static byte[] setBit(byte[] data, int x, boolean value) {
            int pos = x / 8;
            if (pos >= data.length) {
                data = Arrays.copyOf(data, pos + 1);
            }
            if (value) {
                int n = pos;
                data[n] = (byte)(data[n] | 1 << (x & 7));
            } else {
                int n = pos;
                data[n] = (byte)(data[n] & 255 - (1 << (x & 7)));
            }
            return data;
        }

        public static boolean getBit(byte[] data, int x) {
            return (data[x / 8] & 1 << (x & 7)) != 0;
        }

        public static int countBits(byte[] data) {
            int count = 0;
            byte[] byArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                byte x = byArray[n2];
                count += Integer.bitCount(x & 0xFF);
                ++n2;
            }
            return count;
        }
    }

    static class ByteStream {
        private byte[] data;
        private int pos;

        ByteStream() {
            this.data = new byte[16];
        }

        ByteStream(byte[] data) {
            this.data = data;
        }

        int read() {
            return this.pos < this.data.length ? this.data[this.pos++] & 0xFF : -1;
        }

        void write(byte value) {
            if (this.pos >= this.data.length) {
                this.data = Arrays.copyOf(this.data, this.data.length * 2);
            }
            this.data[this.pos++] = value;
        }

        byte[] toByteArray() {
            return Arrays.copyOf(this.data, this.pos);
        }
    }
}

