/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.hash;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class MinimalPerfectHash<K> {
    private static final int DIVIDE = 6;
    private static final int SPEEDUP = 11;
    private static final int MAX_SIZE = 14;
    private static final int[] MAX_OFFSETS;
    private static final int SPLIT_MANY = 3;
    private static final int[] SIZE_OFFSETS;
    private static final SecureRandom RANDOM;
    private final UniversalHash<K> hash;
    private final byte[] data;
    private final int seed;
    private final int[] rootSize;
    private final int[] rootPos;
    private final int rootLevel;

    static {
        int[] nArray = new int[15];
        nArray[2] = 8;
        nArray[3] = 18;
        nArray[4] = 47;
        nArray[5] = 123;
        nArray[6] = 319;
        nArray[7] = 831;
        nArray[8] = 2162;
        nArray[9] = 5622;
        nArray[10] = 14617;
        nArray[11] = 38006;
        nArray[12] = 98815;
        nArray[13] = 256920;
        nArray[14] = 667993;
        MAX_OFFSETS = nArray;
        SIZE_OFFSETS = new int[MAX_OFFSETS.length + 1];
        RANDOM = new SecureRandom();
        int i = 11;
        while (i < MAX_OFFSETS.length) {
            MinimalPerfectHash.MAX_OFFSETS[i] = (int)((double)MAX_OFFSETS[i] * 2.5);
            ++i;
        }
        int last = 4;
        int i2 = 0;
        while (i2 < MAX_OFFSETS.length) {
            MinimalPerfectHash.SIZE_OFFSETS[i2] = last;
            last += MAX_OFFSETS[i2];
            ++i2;
        }
        MinimalPerfectHash.SIZE_OFFSETS[MinimalPerfectHash.SIZE_OFFSETS.length - 1] = last;
    }

    public MinimalPerfectHash(byte[] desc, UniversalHash<K> hash) {
        this.hash = hash;
        this.data = MinimalPerfectHash.expand(desc);
        byte[] b = this.data;
        this.seed = (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
        if (b[4] == 3) {
            this.rootLevel = b[b.length - 1] & 0xFF;
            int split = MinimalPerfectHash.readVarInt(b, 5);
            this.rootSize = new int[split];
            this.rootPos = new int[split];
            int pos = 5 + MinimalPerfectHash.getVarIntLength(b, 5);
            int sizeSum = 0;
            int i = 0;
            while (i < split) {
                this.rootSize[i] = sizeSum;
                this.rootPos[i] = pos;
                int start = pos;
                pos = this.getNextPos(pos);
                sizeSum += this.getSizeSum(start, pos);
                ++i;
            }
        } else {
            this.rootLevel = 0;
            this.rootSize = null;
            this.rootPos = null;
        }
    }

    public int get(K x) {
        return this.get(4, x, true, this.rootLevel);
    }

    private int get(int pos, K x, boolean isRoot, int level) {
        int s;
        int split;
        int n = MinimalPerfectHash.readVarInt(this.data, pos);
        if (n < 2) {
            return 0;
        }
        if (n > 3) {
            int size = MinimalPerfectHash.getSize(n);
            int offset = MinimalPerfectHash.getOffset(n, size);
            if (size >= 11) {
                int p = offset % (size + 1);
                int result = MinimalPerfectHash.hash(x, this.hash, level, this.seed, offset /= size + 1, size + 1);
                if (result >= p) {
                    --result;
                }
                return result;
            }
            return MinimalPerfectHash.hash(x, this.hash, level, this.seed, offset, size);
        }
        ++pos;
        if (n == 3) {
            split = MinimalPerfectHash.readVarInt(this.data, pos);
            pos += MinimalPerfectHash.getVarIntLength(this.data, pos);
        } else {
            split = n;
        }
        int h = MinimalPerfectHash.hash(x, this.hash, level, this.seed, 0, split);
        if (isRoot && this.rootPos != null) {
            s = this.rootSize[h];
            pos = this.rootPos[h];
        } else {
            int start = pos;
            int i = 0;
            while (i < h) {
                pos = this.getNextPos(pos);
                ++i;
            }
            s = this.getSizeSum(start, pos);
        }
        return s + this.get(pos, x, false, level + 1);
    }

    private int getNextPos(int pos) {
        int split;
        int n = MinimalPerfectHash.readVarInt(this.data, pos);
        pos += MinimalPerfectHash.getVarIntLength(this.data, pos);
        if (n < 2 || n > 3) {
            return pos;
        }
        if (n == 3) {
            split = MinimalPerfectHash.readVarInt(this.data, pos);
            pos += MinimalPerfectHash.getVarIntLength(this.data, pos);
        } else {
            split = n;
        }
        int i = 0;
        while (i < split) {
            pos = this.getNextPos(pos);
            ++i;
        }
        return pos;
    }

    private int getSizeSum(int start, int end) {
        int s = 0;
        int pos = start;
        while (pos < end) {
            int n = MinimalPerfectHash.readVarInt(this.data, pos);
            pos += MinimalPerfectHash.getVarIntLength(this.data, pos);
            if (n < 2) {
                s += n;
                continue;
            }
            if (n > 3) {
                s += MinimalPerfectHash.getSize(n);
                continue;
            }
            if (n != 3) continue;
            pos += MinimalPerfectHash.getVarIntLength(this.data, pos);
        }
        return s;
    }

    private static void writeSizeOffset(ByteArrayOutputStream out, int size, int offset) {
        MinimalPerfectHash.writeVarInt(out, SIZE_OFFSETS[size] + offset);
    }

    private static int getOffset(int n, int size) {
        return n - SIZE_OFFSETS[size];
    }

    private static int getSize(int n) {
        int i = 0;
        while (i < SIZE_OFFSETS.length) {
            if (n < SIZE_OFFSETS[i]) {
                return i - 1;
            }
            ++i;
        }
        return 0;
    }

    public static <K> byte[] generate(Set<K> set, UniversalHash<K> hash) {
        ArrayList<K> list = new ArrayList<K>(set);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int seed = RANDOM.nextInt();
        out.write(seed >>> 24);
        out.write(seed >>> 16);
        out.write(seed >>> 8);
        out.write(seed);
        MinimalPerfectHash.generate(list, hash, 0, seed, out);
        return MinimalPerfectHash.compress(out.toByteArray());
    }

    static <K> void generate(ArrayList<K> list, UniversalHash<K> hash, int level, int seed, ByteArrayOutputStream out) {
        ArrayList<ArrayList<K>> lists;
        int size = list.size();
        if (size <= 1) {
            out.write(size);
            return;
        }
        if (level > 32) {
            throw new IllegalStateException("Too many recursions;  incorrect universal hash function?");
        }
        if (size <= 14) {
            int maxOffset = MAX_OFFSETS[size];
            int[] hashes = new int[size];
            int i = 0;
            while (i < size) {
                hashes[i] = hash.hashCode(list.get(i), level, seed);
                ++i;
            }
            int testSize = size;
            if (size >= 11) {
                maxOffset /= ++testSize;
            }
            int offset = 0;
            while (offset < maxOffset) {
                block19: {
                    int n = 0;
                    int i2 = 0;
                    while (i2 < size) {
                        int x = hashes[i2];
                        int h = MinimalPerfectHash.hash(x, level, offset, testSize);
                        if ((n & 1 << h) == 0) {
                            n |= 1 << h;
                            ++i2;
                            continue;
                        }
                        break block19;
                    }
                    if (size >= 11) {
                        int pos = Integer.numberOfTrailingZeros(~n);
                        MinimalPerfectHash.writeSizeOffset(out, size, offset * (size + 1) + pos);
                    } else {
                        MinimalPerfectHash.writeSizeOffset(out, size, offset);
                    }
                    return;
                }
                ++offset;
            }
        }
        int split = size > 342 ? size / 216 : (size - 47) / 6;
        split = Math.max(2, split);
        boolean isRoot = level == 0;
        block3: do {
            lists = new ArrayList<ArrayList<K>>(split);
            int i = 0;
            while (i < split) {
                lists.add(new ArrayList(size / split));
                ++i;
            }
            i = 0;
            while (i < size) {
                K k = list.get(i);
                ArrayList l = (ArrayList)lists.get(MinimalPerfectHash.hash(k, hash, level, seed, 0, split));
                l.add(k);
                if (isRoot && split >= 3 && l.size() > 2160) {
                    ++level;
                    lists = null;
                    continue block3;
                }
                ++i;
            }
        } while (lists == null);
        if (split >= 3) {
            out.write(3);
        }
        MinimalPerfectHash.writeVarInt(out, split);
        boolean multiThreaded = isRoot && list.size() > 1000;
        list.clear();
        list.trimToSize();
        if (multiThreaded) {
            MinimalPerfectHash.generateMultiThreaded(lists, hash, level, seed, out);
        } else {
            for (ArrayList arrayList : lists) {
                MinimalPerfectHash.generate(arrayList, hash, level + 1, seed, out);
            }
        }
        if (isRoot && split >= 3) {
            out.write(level);
        }
    }

    private static <K> void generateMultiThreaded(final ArrayList<ArrayList<K>> lists, final UniversalHash<K> hash, final int level, final int seed, ByteArrayOutputStream out) {
        final ArrayList outList = new ArrayList();
        int processors = Runtime.getRuntime().availableProcessors();
        Thread[] threads = new Thread[processors];
        final AtomicInteger success = new AtomicInteger();
        final AtomicReference failure = new AtomicReference();
        int i = 0;
        while (i < processors) {
            threads[i] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (true) {
                            ArrayList list;
                            ByteArrayOutputStream temp = new ByteArrayOutputStream();
                            ArrayList arrayList = lists;
                            synchronized (arrayList) {
                                if (lists.isEmpty()) {
                                    break;
                                }
                                list = (ArrayList)lists.remove(0);
                                outList.add(temp);
                            }
                            MinimalPerfectHash.generate(list, hash, level + 1, seed, temp);
                        }
                    }
                    catch (Exception e) {
                        failure.set(e);
                        return;
                    }
                    success.incrementAndGet();
                }
            };
            ++i;
        }
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread t = threadArray[n2];
            t.start();
            ++n2;
        }
        try {
            threadArray = threads;
            n = threads.length;
            n2 = 0;
            while (n2 < n) {
                Thread t = threadArray[n2];
                t.join();
                ++n2;
            }
            if (success.get() != threads.length) {
                Exception e = (Exception)failure.get();
                if (e != null) {
                    throw new RuntimeException(e);
                }
                throw new RuntimeException("Unknown failure in one thread");
            }
            for (ByteArrayOutputStream temp : outList) {
                out.write(temp.toByteArray());
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static <K> int hash(K o, UniversalHash<K> hash, int level, int seed, int offset, int size) {
        int x = hash.hashCode(o, level, seed);
        x += level + offset * 32;
        x = (x >>> 16 ^ x) * 73244475;
        x = (x >>> 16 ^ x) * 73244475;
        x = x >>> 16 ^ x;
        return (x & Integer.MAX_VALUE) % size;
    }

    private static int hash(int x, int level, int offset, int size) {
        x += level + offset * 32;
        x = (x >>> 16 ^ x) * 73244475;
        x = (x >>> 16 ^ x) * 73244475;
        x = x >>> 16 ^ x;
        return (x & Integer.MAX_VALUE) % size;
    }

    private static int writeVarInt(ByteArrayOutputStream out, int x) {
        int len = 0;
        while ((x & 0xFFFFFF80) != 0) {
            out.write((byte)(0x80 | x & 0x7F));
            x >>>= 7;
            ++len;
        }
        out.write((byte)x);
        return ++len;
    }

    private static int readVarInt(byte[] d, int pos) {
        int x;
        if ((x = d[pos++]) >= 0) {
            return x;
        }
        x &= 0x7F;
        int s = 7;
        while (s < 64) {
            byte b = d[pos++];
            x |= (b & 0x7F) << s;
            if (b >= 0) break;
            s += 7;
        }
        return x;
    }

    private static int getVarIntLength(byte[] d, int pos) {
        byte x;
        if ((x = d[pos++]) >= 0) {
            return 1;
        }
        int len = 2;
        int s = 7;
        while (s < 64) {
            byte b;
            if ((b = d[pos++]) >= 0) break;
            ++len;
            s += 7;
        }
        return len;
    }

    private static byte[] compress(byte[] d) {
        Deflater deflater = new Deflater();
        deflater.setStrategy(2);
        deflater.setInput(d);
        deflater.finish();
        ByteArrayOutputStream out2 = new ByteArrayOutputStream(d.length);
        byte[] buffer = new byte[1024];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            out2.write(buffer, 0, count);
        }
        deflater.end();
        return out2.toByteArray();
    }

    private static byte[] expand(byte[] d) {
        Inflater inflater = new Inflater();
        inflater.setInput(d);
        ByteArrayOutputStream out = new ByteArrayOutputStream(d.length);
        byte[] buffer = new byte[1024];
        try {
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                out.write(buffer, 0, count);
            }
            inflater.end();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return out.toByteArray();
    }

    public static class LongHash
    implements UniversalHash<Long> {
        @Override
        public int hashCode(Long o, int index, int seed) {
            if (index == 0) {
                return o.hashCode();
            }
            if (index < 8) {
                long x = o;
                x += (long)index;
                x = (x >>> 32 ^ x) * 73244475L;
                x = (x >>> 32 ^ x) * 73244475L;
                return (int)(x ^ x >>> 32);
            }
            int shift = (index & 1) * 32;
            return (int)(o >>> shift);
        }
    }

    public static class StringHash
    implements UniversalHash<String> {
        @Override
        public int hashCode(String o, int index, int seed) {
            if (index == 0) {
                return o.hashCode();
            }
            if (index < 8) {
                return StringHash.getFastHash(o, index, seed);
            }
            return StringHash.getSipHash24(o, index, seed);
        }

        public static int getFastHash(String o, int index, int seed) {
            int x = index * 40763 ^ seed;
            int result = seed + o.length();
            int i = 0;
            while (i < o.length()) {
                x = 31 + x * 40763;
                result ^= x * ('\u0001' + o.charAt(i));
                ++i;
            }
            return result;
        }

        public static int getSipHash24(String o, long k0, long k1) {
            byte[] b = o.getBytes(StandardCharsets.UTF_8);
            return StringHash.getSipHash24(b, 0, b.length, k0, k1);
        }

        public static int getSipHash24(byte[] b, int start, int end, long k0, long k1) {
            long v0 = k0 ^ 0x736F6D6570736575L;
            long v1 = k1 ^ 0x646F72616E646F6DL;
            long v2 = k0 ^ 0x6C7967656E657261L;
            long v3 = k1 ^ 0x7465646279746573L;
            int off = start;
            while (off <= end + 8) {
                int repeat;
                int i;
                long m;
                if (off <= end) {
                    m = 0L;
                    i = 0;
                    while (i < 8 && off + i < end) {
                        m |= ((long)b[off + i] & 0xFFL) << 8 * i;
                        ++i;
                    }
                    if (i < 8) {
                        m |= (long)end - (long)start << 56;
                    }
                    v3 ^= m;
                    repeat = 2;
                } else {
                    m = 0L;
                    v2 ^= 0xFFL;
                    repeat = 4;
                }
                i = 0;
                while (i < repeat) {
                    v0 += v1;
                    v2 += v3;
                    v1 = Long.rotateLeft(v1, 13);
                    v3 = Long.rotateLeft(v3, 16);
                    v1 ^= v0;
                    v3 ^= v2;
                    v0 = Long.rotateLeft(v0, 32);
                    v2 += v1;
                    v0 += v3;
                    v1 = Long.rotateLeft(v1, 17);
                    v3 = Long.rotateLeft(v3, 21);
                    v1 ^= v2;
                    v3 ^= v0;
                    v2 = Long.rotateLeft(v2, 32);
                    ++i;
                }
                v0 ^= m;
                off += 8;
            }
            return (int)(v0 ^ v1 ^ v2 ^ v3);
        }
    }

    public static interface UniversalHash<T> {
        public int hashCode(T var1, int var2, int var3);
    }
}

