/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.hash;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class PerfectHash {
    private static final int MAX_SIZE = 16;
    private static final int OFFSETS = 16;
    private static final int MAX_SPLIT = 32;
    private final byte[] data;
    private final int[] plus;
    private final int[] next;

    public PerfectHash(byte[] data) {
        data = PerfectHash.expand(data);
        this.data = data;
        this.plus = new int[data.length];
        this.next = new int[data.length];
        int i = 0;
        int p = 0;
        while (i < data.length) {
            this.plus[i] = p;
            int n = data[i] & 0xFF;
            p += n < 2 ? n : (n >= 32 ? n / 16 : 0);
            ++i;
        }
    }

    public int get(int x) {
        return this.get(0, x, 0);
    }

    private int get(int pos, int x, int level) {
        int n = this.data[pos] & 0xFF;
        if (n < 2) {
            return this.plus[pos];
        }
        if (n >= 32) {
            return this.plus[pos] + PerfectHash.hash(x, level, n % 16, n / 16);
        }
        ++pos;
        int h = PerfectHash.hash(x, level, 0, n);
        int i = 0;
        while (i < h) {
            pos = this.read(pos);
            ++i;
        }
        return this.get(pos, x, level + 1);
    }

    private int read(int pos) {
        int p = this.next[pos];
        if (p == 0) {
            int n = this.data[pos] & 0xFF;
            if (n < 2 || n >= 32) {
                return pos + 1;
            }
            int start = pos++;
            int i = 0;
            while (i < n) {
                pos = this.read(pos);
                ++i;
            }
            this.next[start] = p = pos;
        }
        return p;
    }

    public static byte[] generate(Set<Integer> list, boolean minimal) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PerfectHash.generate(list, 0, minimal, out);
        return PerfectHash.compress(out.toByteArray());
    }

    /*
     * WARNING - void declaration
     */
    private static void generate(Collection<Integer> set, int level, boolean minimal, ByteArrayOutputStream out) {
        void var7_10;
        int size = set.size();
        if (size <= 1) {
            out.write(size);
            return;
        }
        if (size < 16) {
            int max = minimal ? size : Math.min(15, size * 2);
            int s = size;
            while (s <= max) {
                int n = 0;
                while (n < 16) {
                    block9: {
                        int bits = 0;
                        for (int x : set) {
                            int h = PerfectHash.hash(x, level, n, s);
                            if ((bits & 1 << h) == 0) {
                                bits |= 1 << h;
                                continue;
                            }
                            break block9;
                        }
                        out.write(s * 16 + n);
                        return;
                    }
                    ++n;
                }
                ++s;
            }
        }
        int split = minimal ? (size > 150 ? size / 83 : (size + 3) / 4) : (size > 265 ? size / 142 : (size + 5) / 7);
        split = Math.min(31, Math.max(2, split));
        out.write(split);
        ArrayList lists = new ArrayList(split);
        boolean bl = false;
        while (var7_10 < split) {
            lists.add(new ArrayList(size / split));
            ++var7_10;
        }
        for (int n : set) {
            ((List)lists.get(PerfectHash.hash(n, level, 0, split))).add(n);
        }
        for (List list : lists) {
            PerfectHash.generate(list, level + 1, minimal, out);
        }
    }

    private static int hash(int x, int level, int offset, int size) {
        x += level * 16 + offset;
        x = (x >>> 16 ^ x) * 73244475;
        x = (x >>> 16 ^ x) * 73244475;
        x = x >>> 16 ^ x;
        return Math.abs(x % size);
    }

    private static byte[] compress(byte[] d) {
        Deflater deflater = new Deflater();
        deflater.setStrategy(2);
        deflater.setInput(d);
        deflater.finish();
        ByteArrayOutputStream out2 = new ByteArrayOutputStream(d.length);
        byte[] buffer = new byte[1024];
        while (!deflater.finished()) {
            int count = deflater.deflate(buffer);
            out2.write(buffer, 0, count);
        }
        deflater.end();
        return out2.toByteArray();
    }

    private static byte[] expand(byte[] d) {
        Inflater inflater = new Inflater();
        inflater.setInput(d);
        ByteArrayOutputStream out = new ByteArrayOutputStream(d.length);
        byte[] buffer = new byte[1024];
        try {
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                out.write(buffer, 0, count);
            }
            inflater.end();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return out.toByteArray();
    }
}

