/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class PgTcpRedirect {
    private static final boolean DEBUG = false;

    public static void main(String ... args) throws Exception {
        PgTcpRedirect.loop(args);
    }

    private static void loop(String ... args) throws Exception {
        int portServer = 5432;
        int portClient = 5433;
        int i = 0;
        while (i < args.length) {
            if ("-client".equals(args[i])) {
                portClient = Integer.parseInt(args[++i]);
            } else if ("-server".equals(args[i])) {
                portServer = Integer.parseInt(args[++i]);
            }
            ++i;
        }
        ServerSocket listener = new ServerSocket(portClient);
        while (true) {
            Socket client = listener.accept();
            Socket server = new Socket("localhost", portServer);
            TcpRedirectThread c = new TcpRedirectThread(client, server, true);
            TcpRedirectThread s = new TcpRedirectThread(server, client, false);
            new Thread(c).start();
            new Thread(s).start();
        }
    }

    static synchronized void printData(byte[] buffer, int len) {
    }

    private static class TcpRedirectThread
    implements Runnable {
        private static final int STATE_INIT_CLIENT = 0;
        private static final int STATE_REGULAR = 1;
        private final Socket read;
        private final Socket write;
        private int state;
        private final boolean client;

        TcpRedirectThread(Socket read, Socket write, boolean client) {
            this.read = read;
            this.write = write;
            this.client = client;
            this.state = client ? 0 : 1;
        }

        String readStringNull(InputStream in) throws IOException {
            int x;
            StringBuilder buff = new StringBuilder();
            while ((x = in.read()) > 0) {
                buff.append((char)x);
            }
            return buff.toString();
        }

        private static void println(String s) {
        }

        private boolean processClient(InputStream inStream, OutputStream outStream) throws IOException {
            DataInputStream dataIn = new DataInputStream(inStream);
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(buff);
            if (this.state == 0) {
                this.state = 1;
                int len = dataIn.readInt();
                dataOut.writeInt(len);
                byte[] data = new byte[len -= 4];
                dataIn.readFully(data, 0, len);
                dataOut.write(data);
                dataIn = new DataInputStream(new ByteArrayInputStream(data, 0, len));
                int version = dataIn.readInt();
                if (version == 80877102) {
                    TcpRedirectThread.println("CancelRequest");
                    TcpRedirectThread.println(" pid: " + dataIn.readInt());
                    TcpRedirectThread.println(" key: " + dataIn.readInt());
                } else if (version == 80877103) {
                    TcpRedirectThread.println("SSLRequest");
                } else {
                    String param;
                    TcpRedirectThread.println("StartupMessage");
                    TcpRedirectThread.println(" version " + version + " (" + (version >> 16) + "." + (version & 0xFF) + ")");
                    while ((param = this.readStringNull(dataIn)).length() != 0) {
                        String value = this.readStringNull(dataIn);
                        TcpRedirectThread.println(" param " + param + "=" + value);
                    }
                }
            } else {
                int x = dataIn.read();
                if (x < 0) {
                    TcpRedirectThread.println("end");
                    return false;
                }
                dataOut.write(x);
                int len = dataIn.readInt();
                dataOut.writeInt(len);
                byte[] data = new byte[len -= 4];
                dataIn.readFully(data, 0, len);
                dataOut.write(data);
                dataIn = new DataInputStream(new ByteArrayInputStream(data, 0, len));
                switch (x) {
                    case 66: {
                        TcpRedirectThread.println("Bind");
                        TcpRedirectThread.println(" destPortal: " + this.readStringNull(dataIn));
                        TcpRedirectThread.println(" prepName: " + this.readStringNull(dataIn));
                        int formatCodesCount = dataIn.readShort();
                        int i = 0;
                        while (i < formatCodesCount) {
                            TcpRedirectThread.println(" formatCode[" + i + "]=" + dataIn.readShort());
                            ++i;
                        }
                        int paramCount = dataIn.readShort();
                        int i2 = 0;
                        while (i2 < paramCount) {
                            int paramLen = dataIn.readInt();
                            TcpRedirectThread.println(" length[" + i2 + "]=" + paramLen);
                            byte[] d2 = new byte[paramLen];
                            dataIn.readFully(d2);
                            ++i2;
                        }
                        int resultCodeCount = dataIn.readShort();
                        int i3 = 0;
                        while (i3 < resultCodeCount) {
                            TcpRedirectThread.println(" resultCodeCount[" + i3 + "]=" + dataIn.readShort());
                            ++i3;
                        }
                        break;
                    }
                    case 67: {
                        TcpRedirectThread.println("Close");
                        TcpRedirectThread.println(" type: (S:prepared statement, P:portal): " + dataIn.read());
                        break;
                    }
                    case 100: {
                        TcpRedirectThread.println("CopyData");
                        break;
                    }
                    case 99: {
                        TcpRedirectThread.println("CopyDone");
                        break;
                    }
                    case 102: {
                        TcpRedirectThread.println("CopyFail");
                        TcpRedirectThread.println(" message: " + this.readStringNull(dataIn));
                        break;
                    }
                    case 68: {
                        TcpRedirectThread.println("Describe");
                        TcpRedirectThread.println(" type (S=prepared statement, P=portal): " + (char)dataIn.readByte());
                        TcpRedirectThread.println(" name: " + this.readStringNull(dataIn));
                        break;
                    }
                    case 69: {
                        TcpRedirectThread.println("Execute");
                        TcpRedirectThread.println(" name: " + this.readStringNull(dataIn));
                        TcpRedirectThread.println(" maxRows: " + dataIn.readShort());
                        break;
                    }
                    case 72: {
                        TcpRedirectThread.println("Flush");
                        break;
                    }
                    case 70: {
                        TcpRedirectThread.println("FunctionCall");
                        TcpRedirectThread.println(" objectId:" + dataIn.readInt());
                        int columns = dataIn.readShort();
                        int i = 0;
                        while (i < columns) {
                            TcpRedirectThread.println(" formatCode[" + i + "]: " + dataIn.readShort());
                            ++i;
                        }
                        int count = dataIn.readShort();
                        int i4 = 0;
                        while (i4 < count) {
                            int l = dataIn.readInt();
                            TcpRedirectThread.println(" len[" + i4 + "]: " + l);
                            if (l >= 0) {
                                int j = 0;
                                while (j < l) {
                                    dataIn.readByte();
                                    ++j;
                                }
                            }
                            ++i4;
                        }
                        TcpRedirectThread.println(" resultFormat: " + dataIn.readShort());
                        break;
                    }
                    case 80: {
                        TcpRedirectThread.println("Parse");
                        TcpRedirectThread.println(" name:" + this.readStringNull(dataIn));
                        TcpRedirectThread.println(" query:" + this.readStringNull(dataIn));
                        int count = dataIn.readShort();
                        int i = 0;
                        while (i < count) {
                            TcpRedirectThread.println(" [" + i + "]: " + dataIn.readInt());
                            ++i;
                        }
                        break;
                    }
                    case 112: {
                        TcpRedirectThread.println("PasswordMessage");
                        TcpRedirectThread.println(" password: " + this.readStringNull(dataIn));
                        break;
                    }
                    case 81: {
                        TcpRedirectThread.println("Query");
                        TcpRedirectThread.println(" sql : " + this.readStringNull(dataIn));
                        break;
                    }
                    case 83: {
                        TcpRedirectThread.println("Sync");
                        break;
                    }
                    case 88: {
                        TcpRedirectThread.println("Terminate");
                        break;
                    }
                    default: {
                        TcpRedirectThread.println("############## UNSUPPORTED: " + (char)x);
                    }
                }
            }
            dataOut.flush();
            byte[] buffer = buff.toByteArray();
            PgTcpRedirect.printData(buffer, buffer.length);
            try {
                outStream.write(buffer, 0, buffer.length);
                outStream.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }

        private boolean processServer(InputStream inStream, OutputStream outStream) throws IOException {
            DataInputStream dataIn = new DataInputStream(inStream);
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(buff);
            int x = dataIn.read();
            if (x < 0) {
                TcpRedirectThread.println("end");
                return false;
            }
            dataOut.write(x);
            int len = dataIn.readInt();
            dataOut.writeInt(len);
            byte[] data = new byte[len -= 4];
            dataIn.readFully(data, 0, len);
            dataOut.write(data);
            dataIn = new DataInputStream(new ByteArrayInputStream(data, 0, len));
            switch (x) {
                case 82: {
                    TcpRedirectThread.println("Authentication");
                    int value = dataIn.readInt();
                    if (value == 0) {
                        TcpRedirectThread.println(" Ok");
                        break;
                    }
                    if (value == 2) {
                        TcpRedirectThread.println(" KerberosV5");
                        break;
                    }
                    if (value == 3) {
                        TcpRedirectThread.println(" CleartextPassword");
                        break;
                    }
                    if (value == 4) {
                        TcpRedirectThread.println(" CryptPassword");
                        byte b1 = dataIn.readByte();
                        byte b2 = dataIn.readByte();
                        TcpRedirectThread.println(" salt1=" + b1 + " salt2=" + b2);
                        break;
                    }
                    if (value == 5) {
                        TcpRedirectThread.println(" MD5Password");
                        byte b1 = dataIn.readByte();
                        byte b2 = dataIn.readByte();
                        byte b3 = dataIn.readByte();
                        byte b4 = dataIn.readByte();
                        TcpRedirectThread.println(" salt1=" + b1 + " salt2=" + b2 + " 3=" + b3 + " 4=" + b4);
                        break;
                    }
                    if (value != 6) break;
                    TcpRedirectThread.println(" SCMCredential");
                    break;
                }
                case 75: {
                    TcpRedirectThread.println("BackendKeyData");
                    TcpRedirectThread.println(" process ID " + dataIn.readInt());
                    TcpRedirectThread.println(" key " + dataIn.readInt());
                    break;
                }
                case 50: {
                    TcpRedirectThread.println("BindComplete");
                    break;
                }
                case 51: {
                    TcpRedirectThread.println("CloseComplete");
                    break;
                }
                case 67: {
                    TcpRedirectThread.println("CommandComplete");
                    TcpRedirectThread.println(" command tag: " + this.readStringNull(dataIn));
                    break;
                }
                case 100: {
                    TcpRedirectThread.println("CopyData");
                    break;
                }
                case 99: {
                    TcpRedirectThread.println("CopyDone");
                    break;
                }
                case 71: {
                    TcpRedirectThread.println("CopyInResponse");
                    TcpRedirectThread.println(" format: " + dataIn.readByte());
                    int columns = dataIn.readShort();
                    int i = 0;
                    while (i < columns) {
                        TcpRedirectThread.println(" formatCode[" + i + "]: " + dataIn.readShort());
                        ++i;
                    }
                    break;
                }
                case 72: {
                    TcpRedirectThread.println("CopyOutResponse");
                    TcpRedirectThread.println(" format: " + dataIn.readByte());
                    int columns = dataIn.readShort();
                    int i = 0;
                    while (i < columns) {
                        TcpRedirectThread.println(" formatCode[" + i + "]: " + dataIn.readShort());
                        ++i;
                    }
                    break;
                }
                case 68: {
                    TcpRedirectThread.println("DataRow");
                    int columns = dataIn.readShort();
                    TcpRedirectThread.println(" columns : " + columns);
                    int i = 0;
                    while (i < columns) {
                        int l = dataIn.readInt();
                        if (l > 0) {
                            int j = 0;
                            while (j < l) {
                                dataIn.readByte();
                                ++j;
                            }
                        }
                        ++i;
                    }
                    break;
                }
                case 73: {
                    TcpRedirectThread.println("EmptyQueryResponse");
                    break;
                }
                case 69: {
                    byte fieldType;
                    TcpRedirectThread.println("ErrorResponse");
                    while ((fieldType = dataIn.readByte()) != 0) {
                        String msg = this.readStringNull(dataIn);
                        TcpRedirectThread.println(" fieldType: " + fieldType + " msg: " + msg);
                    }
                    break;
                }
                case 86: {
                    TcpRedirectThread.println("FunctionCallResponse");
                    int resultLen = dataIn.readInt();
                    TcpRedirectThread.println(" len: " + resultLen);
                    break;
                }
                case 110: {
                    TcpRedirectThread.println("NoData");
                    break;
                }
                case 78: {
                    byte fieldType;
                    TcpRedirectThread.println("NoticeResponse");
                    while ((fieldType = dataIn.readByte()) != 0) {
                        String msg = this.readStringNull(dataIn);
                        TcpRedirectThread.println(" fieldType: " + fieldType + " msg: " + msg);
                    }
                    break;
                }
                case 65: {
                    TcpRedirectThread.println("NotificationResponse");
                    TcpRedirectThread.println(" processID: " + dataIn.readInt());
                    TcpRedirectThread.println(" condition: " + this.readStringNull(dataIn));
                    TcpRedirectThread.println(" information: " + this.readStringNull(dataIn));
                    break;
                }
                case 116: {
                    TcpRedirectThread.println("ParameterDescription");
                    TcpRedirectThread.println(" processID: " + dataIn.readInt());
                    int count = dataIn.readShort();
                    int i = 0;
                    while (i < count) {
                        TcpRedirectThread.println(" [" + i + "] objectId: " + dataIn.readInt());
                        ++i;
                    }
                    break;
                }
                case 83: {
                    TcpRedirectThread.println("ParameterStatus");
                    TcpRedirectThread.println(" parameter " + this.readStringNull(dataIn) + " = " + this.readStringNull(dataIn));
                    break;
                }
                case 49: {
                    TcpRedirectThread.println("ParseComplete");
                    break;
                }
                case 115: {
                    TcpRedirectThread.println("ParseComplete");
                    break;
                }
                case 90: {
                    TcpRedirectThread.println("ReadyForQuery");
                    TcpRedirectThread.println(" status (I:idle, T:transaction, E:failed): " + (char)dataIn.readByte());
                    break;
                }
                case 84: {
                    TcpRedirectThread.println("RowDescription");
                    int columns = dataIn.readShort();
                    TcpRedirectThread.println(" columns : " + columns);
                    int i = 0;
                    while (i < columns) {
                        TcpRedirectThread.println(" [" + i + "]");
                        TcpRedirectThread.println("  name:" + this.readStringNull(dataIn));
                        TcpRedirectThread.println("  tableId:" + dataIn.readInt());
                        TcpRedirectThread.println("  columnId:" + dataIn.readShort());
                        TcpRedirectThread.println("  dataTypeId:" + dataIn.readInt());
                        TcpRedirectThread.println("  dataTypeSize (pg_type.typlen):" + dataIn.readShort());
                        TcpRedirectThread.println("  modifier (pg_attribute.atttypmod):" + dataIn.readInt());
                        TcpRedirectThread.println("  format code:" + dataIn.readShort());
                        ++i;
                    }
                    break;
                }
                default: {
                    TcpRedirectThread.println("############## UNSUPPORTED: " + (char)x);
                }
            }
            dataOut.flush();
            byte[] buffer = buff.toByteArray();
            PgTcpRedirect.printData(buffer, buffer.length);
            try {
                outStream.write(buffer, 0, buffer.length);
                outStream.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return true;
        }

        @Override
        public void run() {
            try {
                boolean more;
                OutputStream out = this.write.getOutputStream();
                InputStream in = this.read.getInputStream();
                while (more = this.client ? this.processClient(in, out) : this.processServer(in, out)) {
                }
                try {
                    this.read.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.write.close();
                }
                catch (IOException iOException) {}
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

