/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.sort;

import java.util.Comparator;

public class InPlaceStableMergeSort<T> {
    private static final int TEMP_SIZE = 1024;
    private static final int INSERTION_SORT_SIZE = 16;
    private T[] data;
    private Comparator<T> comp;
    private T[] temp;

    public static <T> void sort(T[] data, Comparator<T> comp) {
        new InPlaceStableMergeSort<T>().sortArray(data, comp);
    }

    public void sortArray(T[] d, Comparator<T> c) {
        this.data = d;
        this.comp = c;
        int len = Math.max((int)(100.0 * Math.log(d.length)), 1024);
        len = Math.min(d.length, len);
        Object[] t = new Object[len];
        this.temp = t;
        this.mergeSort(0, d.length - 1);
    }

    void mergeSort(int from, int to) {
        if (to - from < 16) {
            this.binaryInsertionSort(from, to);
            return;
        }
        int m = from + to >>> 1;
        this.mergeSort(from, m);
        this.mergeSort(m + 1, to);
        this.merge(from, m + 1, to);
    }

    private void binaryInsertionSort(int from, int to) {
        int i = from + 1;
        while (i <= to) {
            T x = this.data[i];
            int ins = this.binarySearch(x, from, i - 1);
            int j = i - 1;
            while (j >= ins) {
                this.data[j + 1] = this.data[j];
                --j;
            }
            this.data[ins] = x;
            ++i;
        }
    }

    private int binarySearch(T x, int from, int to) {
        while (from <= to) {
            int m = from + to >>> 1;
            if (this.comp.compare(x, this.data[m]) >= 0) {
                from = m + 1;
                continue;
            }
            to = m - 1;
        }
        return from;
    }

    private void merge(int from, int second, int to) {
        int len1 = second - from;
        int len2 = to - second + 1;
        if (len1 == 0 || len2 == 0) {
            return;
        }
        if (len1 + len2 == 2) {
            if (this.comp.compare(this.data[second], this.data[from]) < 0) {
                this.swap(this.data, second, from);
            }
            return;
        }
        if (len1 <= this.temp.length) {
            System.arraycopy(this.data, from, this.temp, 0, len1);
            this.mergeSmall(this.data, from, this.temp, 0, len1 - 1, this.data, second, to);
            return;
        }
        if (len2 <= this.temp.length) {
            System.arraycopy(this.data, second, this.temp, 0, len2);
            System.arraycopy(this.data, from, this.data, to - len1 + 1, len1);
            this.mergeSmall(this.data, from, this.data, to - len1 + 1, to, this.temp, 0, len2 - 1);
            return;
        }
        this.mergeBig(from, second, to);
    }

    private void mergeBig(int from, int second, int to) {
        int newSecond;
        int secondCut;
        int firstCut;
        int len1 = second - from;
        int len2 = to - second + 1;
        if (len1 > len2) {
            firstCut = from + len1 / 2;
            secondCut = this.findLower(this.data[firstCut], second, to);
            int len = secondCut - second;
            newSecond = firstCut + len;
        } else {
            int len = len2 / 2;
            secondCut = second + len;
            firstCut = this.findUpper(this.data[secondCut], from, second - 1);
            newSecond = firstCut + len;
        }
        this.swapBlocks(firstCut, second, secondCut - 1);
        this.merge(from, firstCut, newSecond - 1);
        this.merge(newSecond, secondCut, to);
    }

    private void mergeSmall(T[] target, int pos, T[] s1, int from1, int to1, T[] s2, int from2, int to2) {
        T x1 = s1[from1];
        T x2 = s2[from2];
        while (true) {
            if (this.comp.compare(x1, x2) <= 0) {
                target[pos++] = x1;
                if (++from1 > to1) {
                    System.arraycopy(s2, from2, target, pos, to2 - from2 + 1);
                    break;
                }
                x1 = s1[from1];
                continue;
            }
            target[pos++] = x2;
            if (++from2 > to2) {
                System.arraycopy(s1, from1, target, pos, to1 - from1 + 1);
                break;
            }
            x2 = s2[from2];
        }
    }

    private int findLower(T x, int from, int to) {
        int len = to - from + 1;
        while (len > 0) {
            int half = len / 2;
            int m = from + half;
            if (this.comp.compare(this.data[m], x) < 0) {
                from = m + 1;
                len = len - half - 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    private int findUpper(T x, int from, int to) {
        int len = to - from + 1;
        while (len > 0) {
            int half = len / 2;
            int m = from + half;
            if (this.comp.compare(this.data[m], x) <= 0) {
                from = m + 1;
                len = len - half - 1;
                continue;
            }
            len = half;
        }
        return from;
    }

    private void swapBlocks(int from, int second, int to) {
        int len1 = second - from;
        int len2 = to - second + 1;
        if (len1 == 0 || len2 == 0) {
            return;
        }
        if (len1 < this.temp.length) {
            System.arraycopy(this.data, from, this.temp, 0, len1);
            System.arraycopy(this.data, second, this.data, from, len2);
            System.arraycopy(this.temp, 0, this.data, from + len2, len1);
            return;
        }
        if (len2 < this.temp.length) {
            System.arraycopy(this.data, second, this.temp, 0, len2);
            System.arraycopy(this.data, from, this.data, from + len2, len1);
            System.arraycopy(this.temp, 0, this.data, from, len2);
            return;
        }
        this.reverseBlock(from, second - 1);
        this.reverseBlock(second, to);
        this.reverseBlock(from, to);
    }

    private void reverseBlock(int from, int to) {
        while (from < to) {
            T old = this.data[from];
            this.data[from++] = this.data[to];
            this.data[to--] = old;
        }
    }

    private void swap(T[] d, int a, int b) {
        T t = d[a];
        d[a] = d[b];
        d[b] = t;
    }
}

