/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.PriorityQueue;

public class BinaryArithmeticStream {
    public static final int MAX_PROBABILITY = 4095;
    protected int low;
    protected int high = -1;

    public static class Huffman {
        private final int[] codes;
        private final Node tree;

        public Huffman(int[] frequencies) {
            PriorityQueue<Node> queue = new PriorityQueue<Node>();
            int i = 0;
            while (i < frequencies.length) {
                int f = frequencies[i];
                if (f > 0) {
                    queue.offer(new Node(i, f));
                }
                ++i;
            }
            while (queue.size() > 1) {
                queue.offer(new Node((Node)queue.poll(), (Node)queue.poll()));
            }
            this.codes = new int[frequencies.length];
            this.tree = (Node)queue.poll();
            if (this.tree != null) {
                this.tree.initCodes(this.codes, 1);
            }
        }

        public void write(Out out, int value) throws IOException {
            int code = this.codes[value];
            int bitCount = 30 - Integer.numberOfLeadingZeros(code);
            Node n = this.tree;
            int i = bitCount;
            while (i >= 0) {
                boolean goRight = (code >> i & 1) == 1;
                int prob = (int)(4095L * (long)n.right.frequency / (long)n.frequency);
                out.writeBit(goRight, prob);
                n = goRight ? n.right : n.left;
                --i;
            }
        }

        public int read(In in) throws IOException {
            Node n = this.tree;
            while (n.left != null) {
                int prob = (int)(4095L * (long)n.right.frequency / (long)n.frequency);
                boolean goRight = in.readBit(prob);
                Node node = n = goRight ? n.right : n.left;
            }
            return n.value;
        }
    }

    public static class In
    extends BinaryArithmeticStream {
        private final InputStream in;
        private int data;

        public In(InputStream in) throws IOException {
            this.in = in;
            this.data = (in.read() & 0xFF) << 24 | (in.read() & 0xFF) << 16 | (in.read() & 0xFF) << 8 | in.read() & 0xFF;
        }

        public boolean readBit(int probability) throws IOException {
            boolean value;
            int split = this.low + probability * (this.high - this.low >>> 12);
            if (this.data + Integer.MIN_VALUE > split + Integer.MIN_VALUE) {
                this.low = split + 1;
                value = false;
            } else {
                this.high = split;
                value = true;
            }
            while (this.low >>> 24 == this.high >>> 24) {
                this.data = this.data << 8 | this.in.read() & 0xFF;
                this.low <<= 8;
                this.high = this.high << 8 | 0xFF;
            }
            return value;
        }

        public int readGolomb(int divisor) throws IOException {
            int q = 0;
            while (this.readBit(2047)) {
                ++q;
            }
            int bit = 31 - Integer.numberOfLeadingZeros(divisor - 1);
            int r = 0;
            if (bit >= 0) {
                int cutOff = (2 << bit) - divisor;
                while (bit > 0) {
                    r = (r << 1) + (this.readBit(2047) ? 1 : 0);
                    --bit;
                }
                if (r >= cutOff) {
                    r = (r << 1) + (this.readBit(2047) ? 1 : 0) - cutOff;
                }
            }
            return q * divisor + r;
        }
    }

    private static class Node
    implements Comparable<Node> {
        int value;
        Node left;
        Node right;
        final int frequency;

        Node(int value, int frequency) {
            this.frequency = frequency;
            this.value = value;
        }

        Node(Node left, Node right) {
            this.left = left;
            this.right = right;
            this.frequency = left.frequency + right.frequency;
        }

        @Override
        public int compareTo(Node o) {
            return this.frequency - o.frequency;
        }

        void initCodes(int[] codes, int bits) {
            if (this.left == null) {
                codes[this.value] = bits;
            } else {
                this.left.initCodes(codes, bits << 1);
                this.right.initCodes(codes, (bits << 1) + 1);
            }
        }
    }

    public static class Out
    extends BinaryArithmeticStream {
        private final OutputStream out;

        public Out(OutputStream out) {
            this.out = out;
        }

        public void writeBit(boolean value, int probability) throws IOException {
            int split = this.low + probability * (this.high - this.low >>> 12);
            if (value) {
                this.high = split;
            } else {
                this.low = split + 1;
            }
            while (this.low >>> 24 == this.high >>> 24) {
                this.out.write(this.high >> 24);
                this.low <<= 8;
                this.high = this.high << 8 | 0xFF;
            }
        }

        public void flush() throws IOException {
            this.out.write(this.high >> 24);
            this.out.write(this.high >> 16);
            this.out.write(this.high >> 8);
            this.out.write(this.high);
        }

        public void writeGolomb(int divisor, int value) throws IOException {
            int q = value / divisor;
            int i = 0;
            while (i < q) {
                this.writeBit(true, 2047);
                ++i;
            }
            this.writeBit(false, 2047);
            int r = value - q * divisor;
            int bit = 31 - Integer.numberOfLeadingZeros(divisor - 1);
            if (r < (2 << bit) - divisor) {
                --bit;
            } else {
                r += (2 << bit) - divisor;
            }
            while (bit >= 0) {
                this.writeBit((r >>> bit & 1) == 1, 2047);
                --bit;
            }
        }
    }
}

