/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.h2.message.DbException;
import org.h2.util.Tool;

public class FileViewer
extends Tool {
    public static void main(String ... args) throws SQLException {
        new FileViewer().runTool(args);
    }

    @Override
    protected void showUsage() {
        this.out.println("A text file viewer that support very large files.");
        this.out.println("java " + this.getClass().getName() + "\n -file <file>     The name of the file to view\n [-find <text>]   Find a string and display the next lines\n [-start <x>]     Start at the given position\n [-head]          Display the first lines\n [-tail]          Display the last lines\n [-lines <x>]     Display only x lines (default: 30)\n [-quiet]         Do not print progress information");
    }

    @Override
    public void runTool(String ... args) throws SQLException {
        String file = null;
        String find = null;
        boolean head = false;
        boolean tail = false;
        int lines = 30;
        boolean quiet = false;
        long start = 0L;
        int i = 0;
        while (args != null && i < args.length) {
            String arg = args[i];
            if (arg.equals("-file")) {
                file = args[++i];
            } else if (arg.equals("-find")) {
                find = args[++i];
            } else if (arg.equals("-start")) {
                start = Long.decode(args[++i]);
            } else if (arg.equals("-head")) {
                head = true;
            } else if (arg.equals("-tail")) {
                tail = true;
            } else if (arg.equals("-lines")) {
                lines = Integer.decode(args[++i]);
            } else if (arg.equals("-quiet")) {
                quiet = true;
            } else {
                if (arg.equals("-help") || arg.equals("-?")) {
                    this.showUsage();
                    return;
                }
                this.showUsageAndThrowUnsupportedOption(arg);
            }
            ++i;
        }
        if (file == null) {
            this.showUsage();
            return;
        }
        if (!head && !tail && find == null) {
            head = true;
        }
        try {
            FileViewer.process(file, find, head, tail, start, lines, quiet);
        }
        catch (IOException e) {
            throw DbException.toSQLException(e);
        }
    }

    private static void process(String fileName, String find, boolean head, boolean tail, long start, int lines, boolean quiet) throws IOException {
        long pos;
        RandomAccessFile file = new RandomAccessFile(fileName, "r");
        long length = file.length();
        if (head) {
            file.seek(start);
            FileViewer.list(start, "Head", FileViewer.readLines(file, lines));
        }
        if (find != null) {
            file.seek(start);
            pos = FileViewer.find(file, find.getBytes(), quiet);
            if (pos >= 0L) {
                file.seek(pos);
                FileViewer.list(pos, "Found " + find, FileViewer.readLines(file, lines));
            }
        }
        if (tail) {
            pos = length - 100L * (long)lines;
            ArrayList<String> list = null;
            while (pos > 0L) {
                file.seek(pos);
                list = FileViewer.readLines(file, Integer.MAX_VALUE);
                if (list.size() > lines) break;
                pos -= 100L * (long)lines;
            }
            list.remove(0);
            while (list.size() > lines) {
                list.remove(0);
            }
            FileViewer.list(pos, "Tail", list);
        }
    }

    private static long find(RandomAccessFile file, byte[] find, boolean quiet) throws IOException {
        long pos = file.getFilePointer();
        long length = file.length();
        int bufferSize = 4096;
        byte[] data = new byte[bufferSize * 2];
        long last = System.nanoTime();
        while (pos < length) {
            long now;
            System.arraycopy(data, bufferSize, data, 0, bufferSize);
            if (pos + (long)bufferSize > length) {
                file.readFully(data, bufferSize, (int)(length - pos));
                return FileViewer.find(data, find, (int)((long)bufferSize + length - pos - (long)find.length));
            }
            if (!quiet && (now = System.nanoTime()) > last + TimeUnit.SECONDS.toNanos(5L)) {
                System.out.println(100L * pos / length + "%");
                last = now;
            }
            file.readFully(data, bufferSize, bufferSize);
            int f = FileViewer.find(data, find, bufferSize);
            if (f >= 0) {
                return (long)f + pos - (long)bufferSize;
            }
            pos += (long)bufferSize;
        }
        return -1L;
    }

    private static int find(byte[] data, byte[] find, int max) {
        int i = 0;
        while (i < max) {
            block3: {
                int j = 0;
                while (j < find.length) {
                    if (data[i + j] == find[j]) {
                        ++j;
                        continue;
                    }
                    break block3;
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static void list(long pos, String header, ArrayList<String> list) {
        System.out.println("-----------------------------------------------");
        System.out.println("[" + pos + "]: " + header);
        System.out.println("-----------------------------------------------");
        for (String l : list) {
            System.out.println(l);
        }
        System.out.println("-----------------------------------------------");
    }

    private static ArrayList<String> readLines(RandomAccessFile file, int maxLines) throws IOException {
        byte[] data;
        ArrayList<String> lines = new ArrayList<String>();
        ByteArrayOutputStream buff = new ByteArrayOutputStream(100);
        boolean lastNewline = false;
        while (maxLines > 0) {
            int x = file.read();
            if (x < 0) break;
            if (x == 13 || x == 10) {
                if (lastNewline) continue;
                --maxLines;
                lastNewline = true;
                byte[] data2 = buff.toByteArray();
                String s = new String(data2);
                lines.add(s);
                buff.reset();
                continue;
            }
            if (lastNewline) {
                lastNewline = false;
            }
            buff.write(x);
        }
        if ((data = buff.toByteArray()).length > 0) {
            String s = new String(data);
            lines.add(s);
        }
        return lines;
    }
}

