/*
 * Decompiled with CFR 0.152.
 */
package org.h2.dev.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import org.h2.tools.RunScript;

public class Migrate {
    private static final String USER = "sa";
    private static final String PASSWORD = "sa";
    private static final File OLD_H2_FILE = new File("./h2-1.2.127.jar");
    private static final String DOWNLOAD_URL = "https://repo1.maven.org/maven2/com/h2database/h2/1.2.127/h2-1.2.127.jar";
    private static final String CHECKSUM = "056e784c7cf009483366ab9cd8d21d02fe47031a";
    private static final String TEMP_SCRIPT = "backup.sql";
    private final PrintStream sysOut = System.out;
    private boolean quiet;

    public static void main(String ... args) throws Exception {
        new Migrate().execute(new File(args.length == 1 ? args[0] : "."), true, "sa", "sa", false);
    }

    public void execute(File file, boolean recursive, String user, String password, boolean runQuiet) throws Exception {
        String pathToJavaExe = Migrate.getJavaExecutablePath();
        this.quiet = runQuiet;
        if (file.isDirectory() && recursive) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.execute(f, recursive, user, password, runQuiet);
                ++n2;
            }
            return;
        }
        if (!file.getName().endsWith(".data.db")) {
            return;
        }
        this.println("Migrating " + file.getName());
        if (!OLD_H2_FILE.exists()) {
            this.download(OLD_H2_FILE.getAbsolutePath(), DOWNLOAD_URL, CHECKSUM);
        }
        Object url = "jdbc:h2:" + file.getAbsolutePath();
        url = ((String)url).substring(0, ((String)url).length() - ".data.db".length());
        this.exec(new String[]{pathToJavaExe, "-Xmx128m", "-cp", OLD_H2_FILE.getAbsolutePath(), "org.h2.tools.Script", "-script", TEMP_SCRIPT, "-url", url, "-user", user, "-password", password});
        file.renameTo(new File(String.valueOf(file.getAbsoluteFile()) + ".backup"));
        RunScript.execute((String)url, user, password, TEMP_SCRIPT, StandardCharsets.UTF_8, true);
        new File(TEMP_SCRIPT).delete();
    }

    private static String getJavaExecutablePath() {
        Object pathToJava = File.separator.equals("\\") ? System.getProperty("java.home") + File.separator + "bin" + File.separator + "java.exe" : System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        if (!new File((String)pathToJava).exists()) {
            pathToJava = "java";
        }
        return pathToJava;
    }

    private void download(String target, String fileURL, String sha1Checksum) {
        File targetFile = new File(target);
        if (targetFile.exists()) {
            return;
        }
        Migrate.mkdirs(targetFile.getAbsoluteFile().getParentFile());
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        try {
            this.println("Downloading " + fileURL);
            URL url = new URL(fileURL);
            BufferedInputStream in = new BufferedInputStream(url.openStream());
            long last = System.nanoTime();
            int len = 0;
            while (true) {
                long now;
                if ((now = System.nanoTime()) > last + TimeUnit.SECONDS.toNanos(1L)) {
                    this.println("Downloaded " + len + " bytes");
                    last = now;
                }
                int x = ((InputStream)in).read();
                ++len;
                if (x < 0) break;
                buff.write(x);
            }
            ((InputStream)in).close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error downloading", e);
        }
        byte[] data = buff.toByteArray();
        String got = Migrate.getSHA1(data);
        if (sha1Checksum == null) {
            this.println("SHA1 checksum: " + got);
        } else if (!got.equals(sha1Checksum)) {
            throw new RuntimeException("SHA1 checksum mismatch; got: " + got);
        }
        Migrate.writeFile(targetFile, data);
    }

    private static void mkdirs(File f) {
        if (!f.exists() && !f.mkdirs()) {
            throw new RuntimeException("Can not create directory " + f.getAbsolutePath());
        }
    }

    private void println(String s) {
        if (!this.quiet) {
            this.sysOut.println(s);
        }
    }

    private void print(String s) {
        if (!this.quiet) {
            this.sysOut.print(s);
        }
    }

    private static String getSHA1(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return Migrate.convertBytesToString(md.digest(data));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String convertBytesToString(byte[] value) {
        StringBuilder buff = new StringBuilder(value.length * 2);
        byte[] byArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            byte c = byArray[n2];
            int x = c & 0xFF;
            buff.append(Integer.toString(x >> 4, 16)).append(Integer.toString(x & 0xF, 16));
            ++n2;
        }
        return buff.toString();
    }

    private static void writeFile(File file, byte[] data) {
        try {
            RandomAccessFile ra = new RandomAccessFile(file, "rw");
            ra.write(data);
            ra.setLength(data.length);
            ra.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing to file " + String.valueOf(file), e);
        }
    }

    private int exec(String[] command) {
        try {
            String[] stringArray = command;
            int n = command.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                this.print(c + " ");
                ++n2;
            }
            this.println("");
            Process p = Runtime.getRuntime().exec(command);
            Migrate.copyInThread(p.getInputStream(), this.quiet ? null : this.sysOut);
            Migrate.copyInThread(p.getErrorStream(), this.quiet ? null : this.sysOut);
            p.waitFor();
            return p.exitValue();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void copyInThread(final InputStream in, final OutputStream out) {
        new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        int x;
                        if ((x = in.read()) < 0) {
                            return;
                        }
                        if (out == null) continue;
                        out.write(x);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }.start();
    }
}

