/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class QueryStatisticsData {
    private static final Comparator<QueryEntry> QUERY_ENTRY_COMPARATOR = Comparator.comparingLong(q -> q.lastUpdateTime);
    private final HashMap<String, QueryEntry> map = new HashMap();
    private int maxQueryEntries;

    public QueryStatisticsData(int maxQueryEntries) {
        this.maxQueryEntries = maxQueryEntries;
    }

    public synchronized void setMaxQueryEntries(int maxQueryEntries) {
        this.maxQueryEntries = maxQueryEntries;
    }

    public synchronized List<QueryEntry> getQueries() {
        ArrayList<QueryEntry> list = new ArrayList<QueryEntry>(this.map.values());
        list.sort(QUERY_ENTRY_COMPARATOR);
        return list.subList(0, Math.min(list.size(), this.maxQueryEntries));
    }

    public synchronized void update(String sqlStatement, long executionTimeNanos, long rowCount) {
        QueryEntry entry = this.map.get(sqlStatement);
        if (entry == null) {
            entry = new QueryEntry(sqlStatement);
            this.map.put(sqlStatement, entry);
        }
        entry.update(executionTimeNanos, rowCount);
        if ((float)this.map.size() > (float)this.maxQueryEntries * 1.5f) {
            ArrayList<QueryEntry> list = new ArrayList<QueryEntry>(this.map.values());
            list.sort(QUERY_ENTRY_COMPARATOR);
            HashSet<QueryEntry> oldestSet = new HashSet<QueryEntry>(list.subList(0, list.size() / 3));
            Iterator<Map.Entry<String, QueryEntry>> it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, QueryEntry> mapEntry = it.next();
                if (!oldestSet.contains(mapEntry.getValue())) continue;
                it.remove();
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class QueryEntry {
        public final String sqlStatement;
        public int count;
        public long lastUpdateTime;
        public long executionTimeMinNanos;
        public long executionTimeMaxNanos;
        public long executionTimeCumulativeNanos;
        public long rowCountMin;
        public long rowCountMax;
        public long rowCountCumulative;
        public double executionTimeMeanNanos;
        public double rowCountMean;
        private double executionTimeM2Nanos;
        private double rowCountM2;

        public QueryEntry(String sql) {
            this.sqlStatement = sql;
        }

        void update(long timeNanos, long rows) {
            ++this.count;
            this.executionTimeMinNanos = Math.min(timeNanos, this.executionTimeMinNanos);
            this.executionTimeMaxNanos = Math.max(timeNanos, this.executionTimeMaxNanos);
            this.rowCountMin = Math.min(rows, this.rowCountMin);
            this.rowCountMax = Math.max(rows, this.rowCountMax);
            double rowDelta = (double)rows - this.rowCountMean;
            this.rowCountMean += rowDelta / (double)this.count;
            this.rowCountM2 += rowDelta * ((double)rows - this.rowCountMean);
            double timeDelta = (double)timeNanos - this.executionTimeMeanNanos;
            this.executionTimeMeanNanos += timeDelta / (double)this.count;
            this.executionTimeM2Nanos += timeDelta * ((double)timeNanos - this.executionTimeMeanNanos);
            this.executionTimeCumulativeNanos += timeNanos;
            this.rowCountCumulative += rows;
            this.lastUpdateTime = System.currentTimeMillis();
        }

        public double getExecutionTimeStandardDeviation() {
            return Math.sqrt(this.executionTimeM2Nanos / (double)this.count);
        }

        public double getRowCountStandardDeviation() {
            return Math.sqrt(this.rowCountM2 / (double)this.count);
        }
    }
}

