/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.h2.command.CommandInterface;
import org.h2.engine.CastDataProvider;
import org.h2.engine.IsolationLevel;
import org.h2.engine.Mode;
import org.h2.jdbc.meta.DatabaseMeta;
import org.h2.message.Trace;
import org.h2.result.ResultInterface;
import org.h2.store.DataHandler;
import org.h2.util.NetworkConnectionInfo;
import org.h2.util.TimeZoneProvider;
import org.h2.util.Utils;
import org.h2.value.ValueLob;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class Session
implements CastDataProvider,
AutoCloseable {
    private final ReentrantLock lock = new ReentrantLock();
    private ArrayList<String> sessionState;
    boolean sessionStateChanged;
    private boolean sessionStateUpdating;
    volatile StaticSettings staticSettings;

    Session() {
    }

    public final void lock() {
        this.lock.lock();
    }

    public final void unlock() {
        this.lock.unlock();
    }

    public final boolean isLockedByCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }

    public abstract ArrayList<String> getClusterServers();

    public abstract CommandInterface prepareCommand(String var1, int var2);

    @Override
    public abstract void close();

    public abstract Trace getTrace();

    public abstract boolean isClosed();

    public abstract DataHandler getDataHandler();

    public abstract boolean hasPendingTransaction();

    public abstract void cancel();

    public abstract boolean getAutoCommit();

    public abstract void setAutoCommit(boolean var1);

    public abstract ValueLob addTemporaryLob(ValueLob var1);

    public abstract boolean isRemote();

    public abstract void setCurrentSchemaName(String var1);

    public abstract String getCurrentSchemaName();

    public abstract void setNetworkConnectionInfo(NetworkConnectionInfo var1);

    public abstract IsolationLevel getIsolationLevel();

    public abstract void setIsolationLevel(IsolationLevel var1);

    public abstract StaticSettings getStaticSettings();

    public abstract DynamicSettings getDynamicSettings();

    public abstract DatabaseMeta getDatabaseMeta();

    public abstract boolean isOldInformationSchema();

    void recreateSessionState() {
        if (this.sessionState != null && !this.sessionState.isEmpty()) {
            this.sessionStateUpdating = true;
            try {
                for (String sql : this.sessionState) {
                    CommandInterface ci = this.prepareCommand(sql, Integer.MAX_VALUE);
                    ci.executeUpdate(null);
                }
            }
            finally {
                this.sessionStateUpdating = false;
                this.sessionStateChanged = false;
            }
        }
    }

    public void readSessionState() {
        if (!this.sessionStateChanged || this.sessionStateUpdating) {
            return;
        }
        this.sessionStateChanged = false;
        this.sessionState = Utils.newSmallArrayList();
        CommandInterface ci = this.prepareCommand(!this.isOldInformationSchema() ? "SELECT STATE_COMMAND FROM INFORMATION_SCHEMA.SESSION_STATE" : "SELECT SQL FROM INFORMATION_SCHEMA.SESSION_STATE", Integer.MAX_VALUE);
        ResultInterface result = ci.executeQuery(0L, false);
        while (result.next()) {
            this.sessionState.add(result.currentRow()[0].getString());
        }
    }

    public Session setThreadLocalSession() {
        return null;
    }

    public void resetThreadLocalSession(Session oldSession) {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class DynamicSettings {
        public final Mode mode;
        public final TimeZoneProvider timeZone;

        public DynamicSettings(Mode mode, TimeZoneProvider timeZone) {
            this.mode = mode;
            this.timeZone = timeZone;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static final class StaticSettings {
        public final boolean databaseToUpper;
        public final boolean databaseToLower;
        public final boolean caseInsensitiveIdentifiers;

        public StaticSettings(boolean databaseToUpper, boolean databaseToLower, boolean caseInsensitiveIdentifiers) {
            this.databaseToUpper = databaseToUpper;
            this.databaseToLower = databaseToLower;
            this.caseInsensitiveIdentifiers = caseInsensitiveIdentifiers;
        }
    }
}

