/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.time.Instant;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.h2.api.JavaObjectSerializer;
import org.h2.command.Command;
import org.h2.command.Command0;
import org.h2.command.CommandInterface;
import org.h2.command.Parser;
import org.h2.command.ParserBase;
import org.h2.command.Prepared;
import org.h2.command.QueryScope;
import org.h2.command.ddl.Analyze;
import org.h2.command.query.Query;
import org.h2.constraint.Constraint;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbSettings;
import org.h2.engine.IsolationLevel;
import org.h2.engine.Mode;
import org.h2.engine.Procedure;
import org.h2.engine.Session;
import org.h2.engine.SysProperties;
import org.h2.engine.User;
import org.h2.index.Index;
import org.h2.index.QueryExpressionIndex;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.meta.DatabaseMeta;
import org.h2.jdbc.meta.DatabaseMetaLocal;
import org.h2.message.DbException;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.db.MVIndex;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.Store;
import org.h2.mvstore.tx.Transaction;
import org.h2.mvstore.tx.TransactionStore;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;
import org.h2.store.DataHandler;
import org.h2.store.InDoubtTransaction;
import org.h2.table.Table;
import org.h2.util.DateTimeUtils;
import org.h2.util.NetworkConnectionInfo;
import org.h2.util.SmallLRUCache;
import org.h2.util.TimeZoneProvider;
import org.h2.util.Utils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueNull;
import org.h2.value.ValueTimestampTimeZone;
import org.h2.value.ValueVarchar;
import org.h2.value.VersionedValue;
import org.h2.value.lob.LobData;
import org.h2.value.lob.LobDataDatabase;
import org.h2.value.lob.LobDataInMemory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class SessionLocal
extends Session
implements TransactionStore.RollbackListener {
    private static final String SYSTEM_IDENTIFIER_PREFIX = "_";
    private static int nextSerialId;
    private static final ThreadLocal<Session> THREAD_LOCAL_SESSION;
    private final int serialId = nextSerialId++;
    private Database database;
    private User user;
    private final int id;
    private NetworkConnectionInfo networkConnectionInfo;
    private final ArrayList<Table> locks = Utils.newSmallArrayList();
    private boolean autoCommit = true;
    private Random random;
    private int lockTimeout;
    private HashMap<SequenceAndPrepared, RowNumberAndValue> nextValueFor;
    private WeakHashMap<Sequence, Value> currentValueFor;
    private Value lastIdentity = ValueNull.INSTANCE;
    private HashMap<String, Savepoint> savepoints;
    private HashMap<String, Table> localTempTables;
    private HashMap<String, Index> localTempTableIndexes;
    private HashMap<String, Constraint> localTempTableConstraints;
    private int throttleMs;
    private long lastThrottleNs;
    private Command0 currentCommand;
    private boolean allowLiterals;
    private String currentSchemaName;
    private String[] schemaSearchPath;
    private Trace trace;
    private HashMap<String, ValueLob> removeLobMap;
    private int systemIdentifier;
    private HashMap<String, Procedure> procedures;
    private boolean autoCommitAtTransactionEnd;
    private String currentTransactionName;
    private volatile long cancelAtNs;
    private final ValueTimestampTimeZone sessionStart;
    private Instant commandStartOrEnd;
    private ValueTimestampTimeZone currentTimestamp;
    private HashMap<String, Value> variables;
    private int queryTimeout;
    private boolean commitOrRollbackDisabled;
    private Table waitForLock;
    private Thread waitForLockThread;
    private int modificationId;
    private int objectId;
    private final int queryCacheSize;
    private SmallLRUCache<String, Command> queryCache;
    private long modificationMetaID = -1L;
    private int createViewLevel;
    private volatile SmallLRUCache<Object, QueryExpressionIndex> viewIndexCache;
    private HashMap<Object, QueryExpressionIndex> derivedTableIndexCache;
    private boolean lazyQueryExecution;
    private BitSet nonKeywords;
    private TimeZoneProvider timeZone;
    private HashSet<Table> tablesToAnalyze;
    private LinkedList<TimeoutValue> temporaryResultLobs;
    private ArrayList<ValueLob> temporaryLobs;
    private Transaction transaction;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private long startStatement = -1L;
    private IsolationLevel isolationLevel = IsolationLevel.READ_COMMITTED;
    private long snapshotDataModificationId;
    private BitSet idsToRelease;
    private boolean truncateLargeLength;
    private boolean variableBinary;
    private boolean oldInformationSchema;
    private boolean quirksMode;

    static {
        THREAD_LOCAL_SESSION = new ThreadLocal();
    }

    static Session getThreadLocalSession() {
        Session session = THREAD_LOCAL_SESSION.get();
        if (session == null) {
            THREAD_LOCAL_SESSION.remove();
        }
        return session;
    }

    public SessionLocal(Database database, User user, int id) {
        this.database = database;
        this.queryTimeout = database.getSettings().maxQueryTimeout;
        this.queryCacheSize = database.getSettings().queryCacheSize;
        this.user = user;
        this.id = id;
        this.lockTimeout = database.getLockTimeout();
        Schema mainSchema = database.getMainSchema();
        this.currentSchemaName = mainSchema != null ? mainSchema.getName() : database.sysIdentifier("PUBLIC");
        this.timeZone = DateTimeUtils.getTimeZone();
        this.commandStartOrEnd = Instant.now();
        this.sessionStart = DateTimeUtils.currentTimestamp(this.timeZone, this.commandStartOrEnd);
    }

    public void setLazyQueryExecution(boolean lazyQueryExecution) {
        this.lazyQueryExecution = lazyQueryExecution;
    }

    public boolean isLazyQueryExecution() {
        return this.lazyQueryExecution;
    }

    public void setParsingCreateView(boolean parsingView) {
        this.createViewLevel += parsingView ? 1 : -1;
    }

    public boolean isParsingCreateView() {
        return this.createViewLevel != 0;
    }

    @Override
    public ArrayList<String> getClusterServers() {
        return new ArrayList<String>();
    }

    public boolean setCommitOrRollbackDisabled(boolean x) {
        boolean old = this.commitOrRollbackDisabled;
        this.commitOrRollbackDisabled = x;
        return old;
    }

    private void initVariables() {
        if (this.variables == null) {
            this.variables = this.newStringsMap();
        }
    }

    public void setVariable(String name, Value value) {
        Value old;
        this.initVariables();
        ++this.modificationId;
        if (value == ValueNull.INSTANCE) {
            old = this.variables.remove(name);
        } else {
            if (value instanceof ValueLob) {
                value = ((ValueLob)value).copy(this.getDatabase(), -1);
            }
            old = this.variables.put(name, value);
        }
        if (old instanceof ValueLob) {
            ((ValueLob)old).remove();
        }
    }

    public Value getVariable(String name) {
        this.initVariables();
        Value v = this.variables.get(name);
        return v == null ? ValueNull.INSTANCE : v;
    }

    public String[] getVariableNames() {
        if (this.variables == null) {
            return new String[0];
        }
        return this.variables.keySet().toArray(new String[0]);
    }

    public Table findLocalTempTable(String name) {
        if (this.localTempTables == null) {
            return null;
        }
        return this.localTempTables.get(name);
    }

    public List<Table> getLocalTempTables() {
        if (this.localTempTables == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Table>(this.localTempTables.values());
    }

    public void addLocalTempTable(Table table) {
        if (this.localTempTables == null) {
            this.localTempTables = this.newStringsMap();
        }
        if (this.localTempTables.putIfAbsent(table.getName(), table) != null) {
            StringBuilder builder = new StringBuilder();
            table.getSQL(builder, 3).append(" AS ");
            ParserBase.quoteIdentifier(table.getName(), 3);
            throw DbException.get(42101, builder.toString());
        }
        ++this.modificationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalTempTable(Table table) {
        if (this.localTempTables != null && this.localTempTables.remove(table.getName()) != null) {
            ++this.modificationId;
            Database db = this.database;
            if (db != null) {
                Database database = db;
                synchronized (database) {
                    table.removeChildrenAndResources(this);
                }
            }
        }
    }

    public Index findLocalTempTableIndex(String name) {
        if (this.localTempTableIndexes == null) {
            return null;
        }
        return this.localTempTableIndexes.get(name);
    }

    public HashMap<String, Index> getLocalTempTableIndexes() {
        if (this.localTempTableIndexes == null) {
            return new HashMap<String, Index>();
        }
        return this.localTempTableIndexes;
    }

    public void addLocalTempTableIndex(Index index) {
        if (this.localTempTableIndexes == null) {
            this.localTempTableIndexes = this.newStringsMap();
        }
        if (this.localTempTableIndexes.putIfAbsent(index.getName(), index) != null) {
            throw DbException.get(42111, index.getTraceSQL());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalTempTableIndex(Index index) {
        if (this.localTempTableIndexes != null) {
            this.localTempTableIndexes.remove(index.getName());
            Database database = this.database;
            synchronized (database) {
                index.removeChildrenAndResources(this);
            }
        }
    }

    public Constraint findLocalTempTableConstraint(String name) {
        if (this.localTempTableConstraints == null) {
            return null;
        }
        return this.localTempTableConstraints.get(name);
    }

    public HashMap<String, Constraint> getLocalTempTableConstraints() {
        if (this.localTempTableConstraints == null) {
            return new HashMap<String, Constraint>();
        }
        return this.localTempTableConstraints;
    }

    public void addLocalTempTableConstraint(Constraint constraint) {
        String name;
        if (this.localTempTableConstraints == null) {
            this.localTempTableConstraints = this.newStringsMap();
        }
        if (this.localTempTableConstraints.putIfAbsent(name = constraint.getName(), constraint) != null) {
            throw DbException.get(90045, constraint.getTraceSQL());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLocalTempTableConstraint(Constraint constraint) {
        if (this.localTempTableConstraints != null) {
            this.localTempTableConstraints.remove(constraint.getName());
            Database database = this.database;
            synchronized (database) {
                constraint.removeChildrenAndResources(this);
            }
        }
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public User getUser() {
        return this.user;
    }

    @Override
    public void setAutoCommit(boolean b) {
        this.autoCommit = b;
    }

    public int getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(int lockTimeout) {
        this.lockTimeout = lockTimeout;
        if (this.hasTransaction()) {
            this.transaction.setTimeoutMillis(lockTimeout);
        }
    }

    @Override
    public CommandInterface prepareCommand(String sql, int fetchSize) {
        this.lock();
        try {
            Command command = this.prepareLocal(sql);
            return command;
        }
        finally {
            this.unlock();
        }
    }

    public Prepared prepare(String sql) {
        return this.prepare(sql, false, false, null);
    }

    public Prepared prepare(String sql, boolean rightsChecked, boolean literalsChecked, QueryScope queryScope) {
        Parser parser = new Parser(this);
        parser.setRightsChecked(rightsChecked);
        parser.setLiteralsChecked(literalsChecked);
        parser.setQueryScope(queryScope);
        return parser.prepare(sql);
    }

    public Query prepareQueryExpression(String sql, QueryScope queryScope) {
        Parser parser = new Parser(this);
        parser.setRightsChecked(true);
        parser.setLiteralsChecked(true);
        parser.setQueryScope(queryScope);
        return parser.prepareQueryExpression(sql);
    }

    public Command prepareLocal(String sql) {
        Command command;
        if (this.isClosed()) {
            throw DbException.get(90067, "session closed");
        }
        if (this.queryCacheSize > 0) {
            if (this.queryCache == null) {
                this.queryCache = SmallLRUCache.newInstance(this.queryCacheSize);
                this.modificationMetaID = this.getDatabase().getModificationMetaId();
            } else {
                long newModificationMetaID = this.getDatabase().getModificationMetaId();
                if (newModificationMetaID != this.modificationMetaID) {
                    this.queryCache.clear();
                    this.modificationMetaID = newModificationMetaID;
                }
                if ((command = (Command)this.queryCache.get(sql)) != null && command.canReuse()) {
                    command.reuse();
                    return command;
                }
            }
        }
        Parser parser = new Parser(this);
        try {
            command = parser.prepareCommand(sql);
        }
        finally {
            this.derivedTableIndexCache = null;
        }
        if (this.queryCache != null && command.isCacheable()) {
            this.queryCache.put(sql, command);
        }
        return command;
    }

    void scheduleDatabaseObjectIdForRelease(int id) {
        if (this.idsToRelease == null) {
            this.idsToRelease = new BitSet();
        }
        this.idsToRelease.set(id);
    }

    public Database getDatabase() {
        if (this.database == null) {
            throw DbException.get(90098);
        }
        return this.database;
    }

    public void commit(boolean ddl) {
        this.beforeCommitOrRollback();
        if (this.hasTransaction()) {
            try {
                this.markUsedTablesAsUpdated();
                this.transaction.commit();
                this.removeTemporaryLobs(true);
                this.endTransaction();
            }
            finally {
                this.transaction = null;
            }
            if (!ddl) {
                this.cleanTempTables(false);
                if (this.autoCommitAtTransactionEnd) {
                    this.autoCommit = true;
                    this.autoCommitAtTransactionEnd = false;
                }
            }
            this.analyzeTables();
        }
    }

    private void markUsedTablesAsUpdated() {
        if (!this.locks.isEmpty()) {
            for (Table t : this.locks) {
                if (!(t instanceof MVTable)) continue;
                ((MVTable)t).commit();
            }
        }
    }

    private void analyzeTables() {
        if (this.tablesToAnalyze != null && this.isLockedByCurrentThread()) {
            HashSet<Table> tablesToAnalyzeLocal = this.tablesToAnalyze;
            this.tablesToAnalyze = null;
            int rowCount = this.getDatabase().getSettings().analyzeSample / 10;
            for (Table table : tablesToAnalyzeLocal) {
                Analyze.analyzeTable(this, table, rowCount, false);
            }
            this.getDatabase().unlockMeta(this);
            this.commit(true);
        }
    }

    private void removeTemporaryLobs(boolean onTimeout) {
        if (this.temporaryLobs != null) {
            for (ValueLob v : this.temporaryLobs) {
                if (v.isLinkedToTable()) continue;
                v.remove();
            }
            this.temporaryLobs.clear();
        }
        if (this.temporaryResultLobs != null && !this.temporaryResultLobs.isEmpty()) {
            long keepYoungerThan = System.nanoTime() - (long)this.getDatabase().getSettings().lobTimeout * 1000000L;
            while (!this.temporaryResultLobs.isEmpty()) {
                TimeoutValue tv = this.temporaryResultLobs.getFirst();
                if (onTimeout && tv.created - keepYoungerThan >= 0L) break;
                ValueLob v = this.temporaryResultLobs.removeFirst().value;
                if (v.isLinkedToTable()) continue;
                v.remove();
            }
        }
    }

    private void beforeCommitOrRollback() {
        if (this.commitOrRollbackDisabled && !this.locks.isEmpty()) {
            throw DbException.get(90058);
        }
        this.currentTransactionName = null;
        this.currentTimestamp = null;
        this.getDatabase().throwLastBackgroundException();
    }

    private void endTransaction() {
        if (this.removeLobMap != null && !this.removeLobMap.isEmpty()) {
            for (ValueLob v : this.removeLobMap.values()) {
                v.remove();
            }
            this.removeLobMap = null;
        }
        this.unlockAll();
        if (this.idsToRelease != null) {
            this.getDatabase().releaseDatabaseObjectIds(this.idsToRelease);
            this.idsToRelease = null;
        }
        if (this.hasTransaction() && !this.transaction.allowNonRepeatableRead()) {
            this.snapshotDataModificationId = this.getDatabase().getNextModificationDataId();
        }
    }

    public long getSnapshotDataModificationId() {
        return this.snapshotDataModificationId;
    }

    public void rollback() {
        this.beforeCommitOrRollback();
        if (this.hasTransaction()) {
            this.rollbackTo(null);
        }
        this.idsToRelease = null;
        this.cleanTempTables(false);
        if (this.autoCommitAtTransactionEnd) {
            this.autoCommit = true;
            this.autoCommitAtTransactionEnd = false;
        }
        this.endTransaction();
    }

    public void rollbackTo(Savepoint savepoint) {
        int index;
        int n = index = savepoint == null ? 0 : savepoint.logIndex;
        if (this.hasTransaction()) {
            this.markUsedTablesAsUpdated();
            if (savepoint == null) {
                this.transaction.rollback();
                this.transaction = null;
            } else {
                this.transaction.rollbackToSavepoint(savepoint.transactionSavepoint);
            }
        }
        if (this.savepoints != null) {
            String[] names;
            String[] stringArray = names = this.savepoints.keySet().toArray(new String[0]);
            int n2 = names.length;
            int n3 = 0;
            while (n3 < n2) {
                String name = stringArray[n3];
                Savepoint sp = this.savepoints.get(name);
                int savepointIndex = sp.logIndex;
                if (savepointIndex > index) {
                    this.savepoints.remove(name);
                }
                ++n3;
            }
        }
        if (this.queryCache != null) {
            this.queryCache.clear();
        }
    }

    @Override
    public boolean hasPendingTransaction() {
        return this.hasTransaction() && this.transaction.hasChanges() && this.transaction.getStatus() != 2;
    }

    public Savepoint setSavepoint() {
        Savepoint sp = new Savepoint();
        sp.transactionSavepoint = this.getStatementSavepoint();
        return sp;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void cancel() {
        this.cancelAtNs = Utils.currentNanoTime();
    }

    void suspend() {
        this.cancel();
        if (this.transitionToState(State.SUSPENDED, false) == State.SLEEP) {
            this.close();
        }
    }

    @Override
    public void close() {
        if (this.state.getAndSet(State.CLOSED) != State.CLOSED) {
            try {
                if (this.queryCache != null) {
                    this.queryCache.clear();
                }
                this.database.throwLastBackgroundException();
                this.database.checkPowerOff();
                if (this.hasPreparedTransaction()) {
                    this.removeLobMap = null;
                    this.endTransaction();
                } else {
                    this.rollback();
                    this.removeTemporaryLobs(false);
                    this.cleanTempTables(true);
                    this.commit(true);
                }
                this.database.unlockMeta(this);
            }
            finally {
                this.database.removeSession(this);
                this.database = null;
                this.user = null;
            }
        }
    }

    public void registerTableAsLocked(Table table) {
        if (SysProperties.CHECK && this.locks.contains(table)) {
            throw DbException.getInternalError(table.toString());
        }
        this.locks.add(table);
    }

    public void registerTableAsUpdated(Table table) {
        if (!this.locks.contains(table)) {
            this.locks.add(table);
        }
    }

    void unlock(Table t) {
        this.locks.remove(t);
    }

    private boolean hasTransaction() {
        return this.transaction != null;
    }

    private void unlockAll() {
        if (!this.locks.isEmpty()) {
            Table[] array;
            Table[] tableArray = array = this.locks.toArray(new Table[0]);
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Table t = tableArray[n2];
                if (t != null) {
                    t.unlock(this);
                }
                ++n2;
            }
            this.locks.clear();
        }
        Database.unlockMetaDebug(this);
        this.savepoints = null;
        this.sessionStateChanged = true;
    }

    private void cleanTempTables(boolean closeSession) {
        if (this.localTempTables != null && !this.localTempTables.isEmpty()) {
            Iterator<Table> it = this.localTempTables.values().iterator();
            while (it.hasNext()) {
                Table table = it.next();
                if (closeSession || table.getOnCommitDrop()) {
                    ++this.modificationId;
                    table.setModified();
                    it.remove();
                    this.database.lockMeta(this);
                    table.removeChildrenAndResources(this);
                    if (!closeSession) continue;
                    this.database.throwLastBackgroundException();
                    continue;
                }
                if (!table.getOnCommitTruncate()) continue;
                table.truncate(this);
            }
        }
    }

    public Random getRandom() {
        if (this.random == null) {
            this.random = new Random();
        }
        return this.random;
    }

    @Override
    public Trace getTrace() {
        if (this.trace != null && !this.isClosed()) {
            return this.trace;
        }
        String traceModuleName = "jdbc[" + this.id + "]";
        Database db = this.database;
        if (this.isClosed() || db == null) {
            return new TraceSystem(null).getTrace(traceModuleName);
        }
        this.trace = db.getTraceSystem().getTrace(traceModuleName);
        return this.trace;
    }

    public Value getNextValueFor(Sequence sequence, Prepared prepared) {
        Value value;
        Mode mode = this.getMode();
        if (mode.nextValueReturnsDifferentValues || prepared == null) {
            value = sequence.getNext(this);
        } else {
            if (this.nextValueFor == null) {
                this.nextValueFor = new HashMap();
            }
            SequenceAndPrepared key = new SequenceAndPrepared(sequence, prepared);
            RowNumberAndValue data = this.nextValueFor.get(key);
            long rowNumber = prepared.getCurrentRowNumber();
            if (data != null) {
                if (data.rowNumber == rowNumber) {
                    value = data.nextValue;
                } else {
                    data.nextValue = value = sequence.getNext(this);
                    data.rowNumber = rowNumber;
                }
            } else {
                value = sequence.getNext(this);
                this.nextValueFor.put(key, new RowNumberAndValue(rowNumber, value));
            }
        }
        WeakHashMap<Sequence, Value> currentValueFor = this.currentValueFor;
        if (currentValueFor == null) {
            this.currentValueFor = currentValueFor = new WeakHashMap();
        }
        currentValueFor.put(sequence, value);
        if (mode.takeGeneratedSequenceValue) {
            this.lastIdentity = value;
        }
        return value;
    }

    public Value getCurrentValueFor(Sequence sequence) {
        Value value;
        WeakHashMap<Sequence, Value> currentValueFor = this.currentValueFor;
        if (currentValueFor != null && (value = currentValueFor.get(sequence)) != null) {
            return value;
        }
        throw DbException.get(90148, sequence.getTraceSQL());
    }

    public void setLastIdentity(Value last) {
        this.lastIdentity = last;
    }

    public Value getLastIdentity() {
        return this.lastIdentity;
    }

    public boolean containsUncommitted() {
        return this.transaction != null && this.transaction.hasChanges();
    }

    public void addSavepoint(String name) {
        if (this.savepoints == null) {
            this.savepoints = this.newStringsMap();
        }
        this.savepoints.put(name, this.setSavepoint());
    }

    public void rollbackToSavepoint(String name) {
        Savepoint savepoint;
        this.beforeCommitOrRollback();
        if (this.savepoints == null || (savepoint = this.savepoints.get(name)) == null) {
            throw DbException.get(90063, name);
        }
        this.rollbackTo(savepoint);
    }

    public void prepareCommit(String transactionName) {
        if (this.hasPendingTransaction()) {
            this.getDatabase().prepareCommit(this, transactionName);
        }
        this.currentTransactionName = transactionName;
    }

    public boolean hasPreparedTransaction() {
        return this.currentTransactionName != null;
    }

    public void setPreparedTransaction(String transactionName, boolean commit) {
        if (this.hasPreparedTransaction() && this.currentTransactionName.equals(transactionName)) {
            if (commit) {
                this.commit(false);
            } else {
                this.rollback();
            }
        } else {
            ArrayList<InDoubtTransaction> list = this.getDatabase().getInDoubtTransactions();
            int state = commit ? 1 : 2;
            boolean found = false;
            for (InDoubtTransaction p : list) {
                if (!p.getTransactionName().equals(transactionName)) continue;
                p.setState(state);
                found = true;
                break;
            }
            if (!found) {
                throw DbException.get(90129, transactionName);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.state.get() == State.CLOSED;
    }

    public boolean isOpen() {
        State current = this.state.get();
        this.checkSuspended(current);
        return current != State.CLOSED;
    }

    public void setThrottle(int throttle) {
        this.throttleMs = throttle;
    }

    public void throttle() {
        if (this.throttleMs == 0) {
            return;
        }
        long time = System.nanoTime();
        if (this.lastThrottleNs != 0L && time - this.lastThrottleNs < 50000000L) {
            return;
        }
        this.lastThrottleNs = Utils.nanoTimePlusMillis(time, this.throttleMs);
        State prevState = this.transitionToState(State.THROTTLED, false);
        try {
            try {
                Thread.sleep(this.throttleMs);
            }
            catch (InterruptedException interruptedException) {
                this.transitionToState(prevState, false);
            }
        }
        finally {
            this.transitionToState(prevState, false);
        }
    }

    private void setCurrentCommand(Command0 command) {
        State targetState = command == null ? State.SLEEP : State.RUNNING;
        this.transitionToState(targetState, true);
        if (this.isOpen()) {
            this.currentCommand = command;
            this.commandStartOrEnd = Instant.now();
            if (command != null) {
                if (this.queryTimeout > 0) {
                    this.cancelAtNs = Utils.currentNanoTimePlusMillis(this.queryTimeout);
                }
            } else {
                if (this.currentTimestamp != null && !this.getMode().dateTimeValueWithinTransaction) {
                    this.currentTimestamp = null;
                }
                if (this.nextValueFor != null) {
                    this.nextValueFor.clear();
                }
            }
        }
    }

    private State transitionToState(State targetState, boolean checkSuspended) {
        State currentState;
        while (!((currentState = this.state.get()) == State.CLOSED || checkSuspended && !this.checkSuspended(currentState) || this.state.compareAndSet(currentState, targetState))) {
        }
        return currentState;
    }

    private boolean checkSuspended(State currentState) {
        if (currentState == State.SUSPENDED) {
            this.close();
            throw DbException.get(90135);
        }
        return true;
    }

    public void checkCanceled() {
        this.throttle();
        long cancel = this.cancelAtNs;
        if (cancel == 0L) {
            return;
        }
        if (System.nanoTime() - cancel >= 0L) {
            this.cancelAtNs = 0L;
            throw DbException.get(57014);
        }
    }

    public long getCancel() {
        return this.cancelAtNs;
    }

    public Command0 getCurrentCommand() {
        return this.currentCommand;
    }

    public ValueTimestampTimeZone getCommandStartOrEnd() {
        return DateTimeUtils.currentTimestamp(this.timeZone, this.commandStartOrEnd);
    }

    public boolean getAllowLiterals() {
        return this.allowLiterals;
    }

    public void setAllowLiterals(boolean b) {
        this.allowLiterals = b;
    }

    public void setCurrentSchema(Schema schema) {
        ++this.modificationId;
        if (this.queryCache != null) {
            this.queryCache.clear();
        }
        this.currentSchemaName = schema.getName();
    }

    @Override
    public String getCurrentSchemaName() {
        return this.currentSchemaName;
    }

    @Override
    public void setCurrentSchemaName(String schemaName) {
        Schema schema = this.getDatabase().getSchema(schemaName);
        this.setCurrentSchema(schema);
    }

    public JdbcConnection createConnection(boolean columnList) {
        String url = columnList ? "jdbc:columnlist:connection" : "jdbc:default:connection";
        return new JdbcConnection(this, this.getUser().getName(), url);
    }

    @Override
    public DataHandler getDataHandler() {
        return this.getDatabase();
    }

    public void removeAtCommit(ValueLob v) {
        if (v.isLinkedToTable()) {
            if (this.removeLobMap == null) {
                this.removeLobMap = new HashMap();
            }
            this.removeLobMap.put(v.toString(), v);
        }
    }

    public void removeAtCommitStop(ValueLob v) {
        if (v.isLinkedToTable() && this.removeLobMap != null) {
            this.removeLobMap.remove(v.toString());
        }
    }

    public String getNextSystemIdentifier(String sql) {
        String identifier;
        while (sql.contains(identifier = SYSTEM_IDENTIFIER_PREFIX + this.systemIdentifier++)) {
        }
        return identifier;
    }

    public void addProcedure(Procedure procedure) {
        if (this.procedures == null) {
            this.procedures = this.newStringsMap();
        }
        this.procedures.put(procedure.getName(), procedure);
    }

    public void removeProcedure(String name) {
        if (this.procedures != null) {
            this.procedures.remove(name);
        }
    }

    public Procedure getProcedure(String name) {
        if (this.procedures == null) {
            return null;
        }
        return this.procedures.get(name);
    }

    public void setSchemaSearchPath(String[] schemas) {
        ++this.modificationId;
        this.schemaSearchPath = schemas;
    }

    public String[] getSchemaSearchPath() {
        return this.schemaSearchPath;
    }

    public int hashCode() {
        return this.serialId;
    }

    public String toString() {
        return "#" + this.serialId + " (user: " + (this.user == null ? "<null>" : this.user.getName()) + ", " + String.valueOf((Object)this.state.get()) + ")";
    }

    public void begin() {
        this.autoCommitAtTransactionEnd = true;
        this.autoCommit = false;
    }

    public ValueTimestampTimeZone getSessionStart() {
        return this.sessionStart;
    }

    public Set<Table> getLocks() {
        if (this.getDatabase().getLockMode() == 0 || this.locks.isEmpty()) {
            return Collections.emptySet();
        }
        Object[] array = this.locks.toArray();
        switch (array.length) {
            case 1: {
                Object table = array[0];
                if (table != null) {
                    return Collections.singleton((Table)table);
                }
            }
            case 0: {
                return Collections.emptySet();
            }
        }
        HashSet<Table> set = new HashSet<Table>();
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object table = objectArray[n2];
            if (table != null) {
                set.add((Table)table);
            }
            ++n2;
        }
        return set;
    }

    /*
     * Unable to fully structure code
     */
    public void waitIfExclusiveModeEnabled() {
        this.transitionToState(State.RUNNING, true);
        if (this.getDatabase().getLobSession() != this) ** GOTO lbl11
        return;
        while ((exclusive = this.getDatabase().getExclusiveSession()) != null && exclusive != this && !exclusive.isLockedByCurrentThread()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException var2_2) {
                // empty catch block
            }
lbl11:
            // 3 sources

            if (this.isOpen()) continue;
        }
    }

    public Map<Object, QueryExpressionIndex> getViewIndexCache(boolean derivedTable) {
        if (derivedTable) {
            if (this.derivedTableIndexCache == null) {
                this.derivedTableIndexCache = new HashMap();
            }
            return this.derivedTableIndexCache;
        }
        SmallLRUCache<Object, QueryExpressionIndex> cache = this.viewIndexCache;
        if (cache == null) {
            this.viewIndexCache = cache = SmallLRUCache.newInstance(64);
        }
        return cache;
    }

    public void setQueryTimeout(int queryTimeout) {
        int max = this.getDatabase().getSettings().maxQueryTimeout;
        if (max != 0 && (max < queryTimeout || queryTimeout == 0)) {
            queryTimeout = max;
        }
        this.queryTimeout = queryTimeout;
        this.cancelAtNs = 0L;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setWaitForLock(Table waitForLock, Thread waitForLockThread) {
        this.waitForLock = waitForLock;
        this.waitForLockThread = waitForLockThread;
    }

    public Table getWaitForLock() {
        return this.waitForLock;
    }

    public Thread getWaitForLockThread() {
        return this.waitForLockThread;
    }

    public int getModificationId() {
        return this.modificationId;
    }

    public Value getTransactionId() {
        if (this.transaction == null || !this.transaction.hasChanges()) {
            return ValueNull.INSTANCE;
        }
        return ValueVarchar.get(Long.toString(this.transaction.getSequenceNum()));
    }

    public int nextObjectId() {
        return this.objectId++;
    }

    public Transaction getTransaction() {
        if (this.transaction == null) {
            Store store = this.getDatabase().getStore();
            if (store.getMvStore().isClosed()) {
                Throwable backgroundException = this.getDatabase().getBackgroundException();
                this.getDatabase().shutdownImmediately();
                throw DbException.get(90098, backgroundException, new String[0]);
            }
            this.transaction = store.getTransactionStore().begin(this, this.lockTimeout, this.id, this.isolationLevel);
            this.startStatement = -1L;
        }
        return this.transaction;
    }

    private long getStatementSavepoint() {
        if (this.startStatement == -1L) {
            this.startStatement = this.getTransaction().setSavepoint();
        }
        return this.startStatement;
    }

    public void startStatementWithinTransaction(Command0 command) {
        Transaction transaction = this.getTransaction();
        if (transaction != null) {
            HashSet<MVMap<Object, VersionedValue<Object>>> maps = new HashSet<MVMap<Object, VersionedValue<Object>>>();
            if (command != null) {
                Set<DbObject> dependencies = command.getDependencies();
                switch (transaction.getIsolationLevel()) {
                    case SNAPSHOT: 
                    case SERIALIZABLE: {
                        if (!transaction.hasStatementDependencies()) {
                            for (Schema schema : this.getDatabase().getAllSchemasNoMeta()) {
                                for (Table table : schema.getAllTablesAndViews(null)) {
                                    if (!(table instanceof MVTable)) continue;
                                    SessionLocal.addTableToDependencies((MVTable)table, maps);
                                }
                            }
                            break;
                        }
                    }
                    case READ_UNCOMMITTED: 
                    case READ_COMMITTED: {
                        for (DbObject dependency : dependencies) {
                            if (!(dependency instanceof MVTable)) continue;
                            SessionLocal.addTableToDependencies((MVTable)dependency, maps);
                        }
                        break;
                    }
                    case REPEATABLE_READ: {
                        HashSet<MVTable> processed = new HashSet<MVTable>();
                        for (DbObject dependency : dependencies) {
                            if (!(dependency instanceof MVTable)) continue;
                            SessionLocal.addTableToDependencies((MVTable)dependency, maps, processed);
                        }
                        break;
                    }
                }
            }
            transaction.markStatementStart(maps);
        }
        this.startStatement = -1L;
        if (command != null) {
            this.setCurrentCommand(command);
        }
    }

    private static void addTableToDependencies(MVTable table, HashSet<MVMap<Object, VersionedValue<Object>>> maps) {
        for (Index index : table.getIndexes()) {
            if (!(index instanceof MVIndex)) continue;
            maps.add(((MVIndex)index).getMVMap());
        }
    }

    private static void addTableToDependencies(MVTable table, HashSet<MVMap<Object, VersionedValue<Object>>> maps, HashSet<MVTable> processed) {
        if (!processed.add(table)) {
            return;
        }
        SessionLocal.addTableToDependencies(table, maps);
        ArrayList<Constraint> constraints = table.getConstraints();
        if (constraints != null) {
            for (Constraint constraint : constraints) {
                Table ref = constraint.getTable();
                if (ref == table || !(ref instanceof MVTable)) continue;
                SessionLocal.addTableToDependencies((MVTable)ref, maps, processed);
            }
        }
    }

    public void endStatement() {
        this.setCurrentCommand(null);
        if (this.hasTransaction()) {
            this.transaction.markStatementEnd();
        }
        this.startStatement = -1L;
    }

    public void clearViewIndexCache() {
        this.viewIndexCache = null;
    }

    @Override
    public ValueLob addTemporaryLob(ValueLob v) {
        LobData lobData = v.getLobData();
        if (lobData instanceof LobDataInMemory) {
            return v;
        }
        int tableId = ((LobDataDatabase)lobData).getTableId();
        if (tableId == -3 || tableId == -2) {
            if (this.temporaryResultLobs == null) {
                this.temporaryResultLobs = new LinkedList();
            }
            this.temporaryResultLobs.add(new TimeoutValue(v));
        } else {
            if (this.temporaryLobs == null) {
                this.temporaryLobs = new ArrayList();
            }
            this.temporaryLobs.add(v);
        }
        return v;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    public void markTableForAnalyze(Table table) {
        if (this.tablesToAnalyze == null) {
            this.tablesToAnalyze = new HashSet();
        }
        this.tablesToAnalyze.add(table);
    }

    public State getState() {
        return this.getBlockingSessionId() != 0 ? State.BLOCKED : this.state.get();
    }

    public int getBlockingSessionId() {
        return this.transaction == null ? 0 : this.transaction.getBlockerId();
    }

    @Override
    public void onRollback(MVMap<Object, VersionedValue<Object>> map, Object key, VersionedValue<Object> existingValue, VersionedValue<Object> restoredValue) {
        Store store = this.getDatabase().getStore();
        MVTable table = store.getTable(map.getName());
        if (table != null) {
            Row oldRow = existingValue == null ? null : (Row)existingValue.getCurrentValue();
            Row newRow = restoredValue == null ? null : (Row)restoredValue.getCurrentValue();
            table.fireAfterRow(this, oldRow, newRow, true);
            if (table.getContainsLargeObject()) {
                Value v;
                int len;
                int i;
                if (oldRow != null) {
                    i = 0;
                    len = oldRow.getColumnCount();
                    while (i < len) {
                        v = oldRow.getValue(i);
                        if (v instanceof ValueLob) {
                            this.removeAtCommit((ValueLob)v);
                        }
                        ++i;
                    }
                }
                if (newRow != null) {
                    i = 0;
                    len = newRow.getColumnCount();
                    while (i < len) {
                        v = newRow.getValue(i);
                        if (v instanceof ValueLob) {
                            this.removeAtCommitStop((ValueLob)v);
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public NetworkConnectionInfo getNetworkConnectionInfo() {
        return this.networkConnectionInfo;
    }

    @Override
    public void setNetworkConnectionInfo(NetworkConnectionInfo networkConnectionInfo) {
        this.networkConnectionInfo = networkConnectionInfo;
    }

    @Override
    public ValueTimestampTimeZone currentTimestamp() {
        ValueTimestampTimeZone ts = this.currentTimestamp;
        if (ts == null) {
            this.currentTimestamp = ts = DateTimeUtils.currentTimestamp(this.timeZone, this.commandStartOrEnd);
        }
        return ts;
    }

    @Override
    public Mode getMode() {
        return this.getDatabase().getMode();
    }

    @Override
    public JavaObjectSerializer getJavaObjectSerializer() {
        return this.getDatabase().getJavaObjectSerializer();
    }

    @Override
    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public void setIsolationLevel(IsolationLevel isolationLevel) {
        this.commit(false);
        this.isolationLevel = isolationLevel;
    }

    public BitSet getNonKeywords() {
        return this.nonKeywords;
    }

    public void setNonKeywords(BitSet nonKeywords) {
        this.nonKeywords = nonKeywords;
    }

    @Override
    public Session.StaticSettings getStaticSettings() {
        Session.StaticSettings settings = this.staticSettings;
        if (settings == null) {
            DbSettings dbSettings = this.getDatabase().getSettings();
            this.staticSettings = settings = new Session.StaticSettings(dbSettings.databaseToUpper, dbSettings.databaseToLower, dbSettings.caseInsensitiveIdentifiers);
        }
        return settings;
    }

    @Override
    public Session.DynamicSettings getDynamicSettings() {
        return new Session.DynamicSettings(this.getMode(), this.timeZone);
    }

    @Override
    public TimeZoneProvider currentTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZoneProvider timeZone) {
        if (!timeZone.equals(this.timeZone)) {
            this.timeZone = timeZone;
            ValueTimestampTimeZone ts = this.currentTimestamp;
            if (ts != null) {
                long dateValue = ts.getDateValue();
                long timeNanos = ts.getTimeNanos();
                int offsetSeconds = ts.getTimeZoneOffsetSeconds();
                this.currentTimestamp = DateTimeUtils.timestampTimeZoneAtOffset(dateValue, timeNanos, offsetSeconds, timeZone.getTimeZoneOffsetUTC(DateTimeUtils.getEpochSeconds(dateValue, timeNanos, offsetSeconds)));
            }
            ++this.modificationId;
        }
    }

    public boolean areEqual(Value a, Value b) {
        return a.compareTo(b, this, this.getCompareMode()) == 0;
    }

    public int compare(Value a, Value b) {
        return a.compareTo(b, this, this.getCompareMode());
    }

    public int compareWithNull(Value a, Value b, boolean forEquality) {
        return a.compareWithNull(b, forEquality, this, this.getCompareMode());
    }

    public int compareTypeSafe(Value a, Value b) {
        return a.compareTypeSafe(b, this.getCompareMode(), this);
    }

    public void setTruncateLargeLength(boolean truncateLargeLength) {
        this.truncateLargeLength = truncateLargeLength;
    }

    public boolean isTruncateLargeLength() {
        return this.truncateLargeLength;
    }

    public void setVariableBinary(boolean variableBinary) {
        this.variableBinary = variableBinary;
    }

    public boolean isVariableBinary() {
        return this.variableBinary;
    }

    public void setOldInformationSchema(boolean oldInformationSchema) {
        this.oldInformationSchema = oldInformationSchema;
    }

    @Override
    public boolean isOldInformationSchema() {
        return this.oldInformationSchema;
    }

    @Override
    public DatabaseMeta getDatabaseMeta() {
        return new DatabaseMetaLocal(this);
    }

    @Override
    public boolean zeroBasedEnums() {
        return this.getDatabase().zeroBasedEnums();
    }

    public void setQuirksMode(boolean quirksMode) {
        this.quirksMode = quirksMode;
    }

    public boolean isQuirksMode() {
        return this.quirksMode || this.getDatabase().isStarting();
    }

    @Override
    public Session setThreadLocalSession() {
        Session oldSession = THREAD_LOCAL_SESSION.get();
        THREAD_LOCAL_SESSION.set(this);
        return oldSession;
    }

    @Override
    public void resetThreadLocalSession(Session oldSession) {
        if (oldSession == null) {
            THREAD_LOCAL_SESSION.remove();
        } else {
            THREAD_LOCAL_SESSION.set(oldSession);
        }
    }

    private CompareMode getCompareMode() {
        return this.getDatabase().getCompareMode();
    }

    private <T> HashMap<String, T> newStringsMap() {
        return this.getDatabase().newStringMap();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class RowNumberAndValue {
        long rowNumber;
        Value nextValue;

        RowNumberAndValue(long rowNumber, Value nextValue) {
            this.rowNumber = rowNumber;
            this.nextValue = nextValue;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class Savepoint {
        int logIndex;
        long transactionSavepoint;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class SequenceAndPrepared {
        private final Sequence sequence;
        private final Prepared prepared;

        SequenceAndPrepared(Sequence sequence, Prepared prepared) {
            this.sequence = sequence;
            this.prepared = prepared;
        }

        public int hashCode() {
            return 31 * (31 + this.prepared.hashCode()) + this.sequence.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != SequenceAndPrepared.class) {
                return false;
            }
            SequenceAndPrepared other = (SequenceAndPrepared)obj;
            return this.sequence == other.sequence && this.prepared == other.prepared;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum State {
        INIT,
        RUNNING,
        BLOCKED,
        SLEEP,
        THROTTLED,
        SUSPENDED,
        CLOSED;

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class TimeoutValue {
        final long created = System.nanoTime();
        final ValueLob value;

        TimeoutValue(ValueLob v) {
            this.value = v;
        }
    }
}

