/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.Arrays;
import org.h2.engine.CastDataProvider;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.OperationN;
import org.h2.expression.TypedValueExpression;
import org.h2.expression.ValueExpression;
import org.h2.expression.function.CastSpecification;
import org.h2.expression.function.ConcatFunction;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueNull;
import org.h2.value.ValueVarbinary;
import org.h2.value.ValueVarchar;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ConcatenationOperation
extends OperationN {
    public ConcatenationOperation() {
        super(new Expression[4]);
    }

    public ConcatenationOperation(Expression op1, Expression op2) {
        super(new Expression[]{op1, op2});
        this.argsCount = 2;
    }

    @Override
    public boolean needParentheses() {
        return true;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        int i = 0;
        int l = this.args.length;
        while (i < l) {
            if (i > 0) {
                builder.append(" || ");
            }
            this.args[i].getSQL(builder, sqlFlags, 0);
            ++i;
        }
        return builder;
    }

    @Override
    public Value getValue(SessionLocal session) {
        int l = this.args.length;
        if (l == 2) {
            Value v1 = this.args[0].getValue(session);
            if ((v1 = v1.convertTo(this.type, (CastDataProvider)session)) == ValueNull.INSTANCE) {
                return ValueNull.INSTANCE;
            }
            Value v2 = this.args[1].getValue(session);
            if ((v2 = v2.convertTo(this.type, (CastDataProvider)session)) == ValueNull.INSTANCE) {
                return ValueNull.INSTANCE;
            }
            return this.getValue(session, v1, v2);
        }
        return this.getValue(session, l);
    }

    private Value getValue(SessionLocal session, Value l, Value r) {
        int valueType = this.type.getValueType();
        if (valueType == 2) {
            String s1 = l.getString();
            String s2 = r.getString();
            return ValueVarchar.get(new StringBuilder(s1.length() + s2.length()).append(s1).append(s2).toString());
        }
        if (valueType == 6) {
            byte[] leftBytes = l.getBytesNoCopy();
            byte[] rightBytes = r.getBytesNoCopy();
            int leftLength = leftBytes.length;
            int rightLength = rightBytes.length;
            byte[] bytes = Arrays.copyOf(leftBytes, leftLength + rightLength);
            System.arraycopy(rightBytes, 0, bytes, leftLength, rightLength);
            return ValueVarbinary.getNoCopy(bytes);
        }
        Value[] leftValues = ((ValueArray)l).getList();
        Value[] rightValues = ((ValueArray)r).getList();
        int leftLength = leftValues.length;
        int rightLength = rightValues.length;
        Value[] values = Arrays.copyOf(leftValues, leftLength + rightLength);
        System.arraycopy(rightValues, 0, values, leftLength, rightLength);
        return ValueArray.get((TypeInfo)this.type.getExtTypeInfo(), values, session);
    }

    private Value getValue(SessionLocal session, int l) {
        Value[] values = new Value[l];
        int i = 0;
        while (i < l) {
            Value v = this.args[i].getValue(session).convertTo(this.type, (CastDataProvider)session);
            if (v == ValueNull.INSTANCE) {
                return ValueNull.INSTANCE;
            }
            values[i] = v;
            ++i;
        }
        int valueType = this.type.getValueType();
        if (valueType == 2) {
            StringBuilder builder = new StringBuilder();
            int i2 = 0;
            while (i2 < l) {
                builder.append(values[i2].getString());
                ++i2;
            }
            return ValueVarchar.get(builder.toString(), session);
        }
        if (valueType == 6) {
            int totalLength = 0;
            int i3 = 0;
            while (i3 < l) {
                totalLength += values[i3].getBytesNoCopy().length;
                ++i3;
            }
            byte[] v = new byte[totalLength];
            int offset = 0;
            int i4 = 0;
            while (i4 < l) {
                byte[] a = values[i4].getBytesNoCopy();
                int length = a.length;
                System.arraycopy(a, 0, v, offset, length);
                offset += length;
                ++i4;
            }
            return ValueVarbinary.getNoCopy(v);
        }
        int totalLength = 0;
        int i5 = 0;
        while (i5 < l) {
            totalLength += ((ValueArray)values[i5]).getList().length;
            ++i5;
        }
        Value[] v = new Value[totalLength];
        int offset = 0;
        int i6 = 0;
        while (i6 < l) {
            Value[] a = ((ValueArray)values[i6]).getList();
            int length = a.length;
            System.arraycopy(a, 0, v, offset, length);
            offset += length;
            ++i6;
        }
        return ValueArray.get((TypeInfo)this.type.getExtTypeInfo(), v, session);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Expression optimize(SessionLocal session) {
        block12: {
            this.determineType(session);
            this.inlineArguments();
            if (this.type.getValueType() == 2 && session.getMode().treatEmptyStringsAsNull) {
                return new ConcatFunction(0, this.args).optimize(session);
            }
            l = this.args.length;
            allConst = true;
            anyConst = false;
            i = 0;
            while (i < l) {
                if (this.args[i].isConstant()) {
                    anyConst = true;
                } else {
                    allConst = false;
                }
                ++i;
            }
            if (allConst) {
                return TypedValueExpression.getTypedIfNull(this.getValue(session), this.type);
            }
            if (!anyConst) break block12;
            offset = 0;
            i = 0;
            while (i < l) {
                block14: {
                    block13: {
                        arg1 = this.args[i];
                        if (!arg1.isConstant()) break block13;
                        v1 = arg1.getValue(session).convertTo(this.type, (CastDataProvider)session);
                        if (v1 == ValueNull.INSTANCE) {
                            return TypedValueExpression.get(ValueNull.INSTANCE, this.type);
                        }
                        if (!ConcatenationOperation.isEmpty(v1)) ** GOTO lbl35
                        break block14;
lbl-1000:
                        // 1 sources

                        {
                            v2 = arg2.getValue(session).convertTo(this.type, (CastDataProvider)session);
                            if (v2 == ValueNull.INSTANCE) {
                                return TypedValueExpression.get(ValueNull.INSTANCE, this.type);
                            }
                            if (!ConcatenationOperation.isEmpty(v2)) {
                                v1 = this.getValue(session, v1, v2);
                            }
                            ++i;
lbl35:
                            // 2 sources

                            ** while (i + 1 < l && (arg2 = this.args[i + 1]).isConstant())
                        }
lbl36:
                        // 1 sources

                        arg1 = ValueExpression.get(v1);
                    }
                    this.args[offset++] = arg1;
                }
                ++i;
            }
            if (offset == 1) {
                arg = this.args[0];
                argType = arg.getType();
                if (TypeInfo.areSameTypes(this.type, argType)) {
                    return arg;
                }
                return new CastSpecification(arg, this.type);
            }
            this.argsCount = offset;
            this.doneWithParameters();
        }
        return this;
    }

    private void determineType(SessionLocal session) {
        int i;
        int l = this.args.length;
        boolean anyArray = false;
        boolean allBinary = true;
        boolean allCharacter = true;
        int i2 = 0;
        while (i2 < l) {
            Expression arg;
            this.args[i2] = arg = this.args[i2].optimize(session);
            int t = arg.getType().getValueType();
            if (t == 40) {
                anyArray = true;
                allCharacter = false;
                allBinary = false;
            } else if (t != 0) {
                if (DataType.isBinaryStringType(t)) {
                    allCharacter = false;
                } else if (DataType.isCharacterStringType(t)) {
                    allBinary = false;
                } else {
                    allCharacter = false;
                    allBinary = false;
                }
            }
            ++i2;
        }
        if (anyArray) {
            this.type = TypeInfo.getTypeInfo(40, -1L, 0, TypeInfo.getHigherType(this.args).getExtTypeInfo());
        } else if (allBinary) {
            long precision = this.getPrecision(0);
            i = 1;
            while (i < l) {
                precision = DataType.addPrecision(precision, this.getPrecision(i));
                ++i;
            }
            this.type = TypeInfo.getTypeInfo(6, precision, 0, null);
        } else if (allCharacter) {
            long precision = this.getPrecision(0);
            i = 1;
            while (i < l) {
                precision = DataType.addPrecision(precision, this.getPrecision(i));
                ++i;
            }
            this.type = TypeInfo.getTypeInfo(2, precision, 0, null);
        } else {
            this.type = TypeInfo.TYPE_VARCHAR;
        }
    }

    private long getPrecision(int i) {
        TypeInfo t = this.args[i].getType();
        return t.getValueType() != 0 ? t.getPrecision() : 0L;
    }

    private void inlineArguments() {
        int l;
        int valueType = this.type.getValueType();
        int count = l = this.args.length;
        int i = 0;
        while (i < l) {
            Expression arg = this.args[i];
            if (arg instanceof ConcatenationOperation && arg.getType().getValueType() == valueType) {
                count += arg.getSubexpressionCount() - 1;
            }
            ++i;
        }
        if (count > l) {
            Expression[] newArguments = new Expression[count];
            int i2 = 0;
            int offset = 0;
            while (i2 < l) {
                Expression arg = this.args[i2];
                if (arg instanceof ConcatenationOperation && arg.getType().getValueType() == valueType) {
                    ConcatenationOperation c = (ConcatenationOperation)arg;
                    Expression[] innerArgs = c.args;
                    int innerLength = innerArgs.length;
                    System.arraycopy(innerArgs, 0, newArguments, offset, innerLength);
                    offset += innerLength;
                } else {
                    newArguments[offset++] = arg;
                }
                ++i2;
            }
            this.args = newArguments;
            this.argsCount = count;
        }
    }

    private static boolean isEmpty(Value v) {
        int valueType = v.getValueType();
        if (valueType == 2) {
            return v.getString().isEmpty();
        }
        if (valueType == 6) {
            return v.getBytesNoCopy().length == 0;
        }
        return ((ValueArray)v).getList().length == 0;
    }
}

