/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.ExtTypeInfoRow;
import org.h2.value.TypeInfo;
import org.h2.value.Typed;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueRow;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ExpressionList
extends Expression {
    private final Expression[] list;
    private final boolean isArray;
    private TypeInfo type;

    public ExpressionList(Expression[] list, boolean isArray) {
        this.list = list;
        this.isArray = isArray;
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value[] v = new Value[this.list.length];
        int i = 0;
        while (i < this.list.length) {
            v[i] = this.list[i].getValue(session);
            ++i;
        }
        return this.isArray ? ValueArray.get((TypeInfo)this.type.getExtTypeInfo(), v, session) : ValueRow.get(this.type, v);
    }

    @Override
    public TypeInfo getType() {
        return this.type;
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level, int state) {
        Expression[] expressionArray = this.list;
        int n = this.list.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            e.mapColumns(resolver, level, state);
            ++n2;
        }
    }

    @Override
    public Expression optimize(SessionLocal session) {
        boolean allConst = true;
        int count = this.list.length;
        int i = 0;
        while (i < count) {
            Expression e = this.list[i].optimize(session);
            if (!e.isConstant()) {
                allConst = false;
            }
            this.list[i] = e;
            ++i;
        }
        this.initializeType();
        if (allConst) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    void initializeType() {
        this.type = this.isArray ? TypeInfo.getTypeInfo(40, this.list.length, 0, TypeInfo.getHigherType(this.list)) : TypeInfo.getTypeInfo(41, 0L, 0, new ExtTypeInfoRow(this.list));
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        Expression[] expressionArray = this.list;
        int n = this.list.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            e.setEvaluatable(tableFilter, b);
            ++n2;
        }
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return this.isArray ? ExpressionList.writeExpressions(builder.append("ARRAY ["), this.list, sqlFlags).append(']') : ExpressionList.writeExpressions(builder.append("ROW ("), this.list, sqlFlags).append(')');
    }

    @Override
    public void updateAggregate(SessionLocal session, int stage) {
        Expression[] expressionArray = this.list;
        int n = this.list.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            e.updateAggregate(session, stage);
            ++n2;
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        Expression[] expressionArray = this.list;
        int n = this.list.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            if (!e.isEverything(visitor)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public int getCost() {
        int cost = 1;
        Expression[] expressionArray = this.list;
        int n = this.list.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            cost += e.getCost();
            ++n2;
        }
        return cost;
    }

    @Override
    public TypeInfo getTypeIfStaticallyKnown(SessionLocal session) {
        int count = this.list.length;
        Typed[] types = new TypeInfo[count];
        int i = 0;
        while (i < count) {
            TypeInfo t = this.list[i].getTypeIfStaticallyKnown(session);
            if (t == null) {
                return null;
            }
            types[i] = t;
            ++i;
        }
        return this.isArray ? TypeInfo.getTypeInfo(40, this.list.length, 0, TypeInfo.getHigherType(types)) : TypeInfo.getTypeInfo(41, 0L, 0, new ExtTypeInfoRow(types));
    }

    @Override
    public boolean isConstant() {
        Expression[] expressionArray = this.list;
        int n = this.list.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            if (!e.isConstant()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public int getSubexpressionCount() {
        return this.list.length;
    }

    @Override
    public Expression getSubexpression(int index) {
        return this.list[index];
    }

    public boolean isArray() {
        return this.isArray;
    }

    public ExpressionList cloneWithOrder(int[] newOrder) {
        int length = this.list.length;
        if (newOrder.length != this.list.length) {
            throw DbException.getInternalError("Length of the new orders is different than list size.");
        }
        Expression[] newList = new Expression[length];
        int i = 0;
        while (i < length) {
            newList[i] = this.list[newOrder[i]];
            ++i;
        }
        ExpressionList clone = new ExpressionList(newList, this.isArray);
        clone.initializeType();
        return clone;
    }
}

