/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.HashSet;
import org.h2.command.query.AllColumnsForPlan;
import org.h2.engine.DbObject;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.Table;
import org.h2.table.TableFilter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ExpressionVisitor {
    public static final int INDEPENDENT = 0;
    public static final ExpressionVisitor INDEPENDENT_VISITOR = new ExpressionVisitor(0);
    public static final int OPTIMIZABLE_AGGREGATE = 1;
    public static final int DETERMINISTIC = 2;
    public static final ExpressionVisitor DETERMINISTIC_VISITOR = new ExpressionVisitor(2);
    public static final int EVALUATABLE = 3;
    public static final ExpressionVisitor EVALUATABLE_VISITOR = new ExpressionVisitor(3);
    private static final int CACHED = 8;
    private static final ExpressionVisitor[] INDEPENDENT_VISITORS;
    private static final ExpressionVisitor[] EVALUATABLE_VISITORS;
    public static final int SET_MAX_DATA_MODIFICATION_ID = 4;
    public static final int READONLY = 5;
    public static final ExpressionVisitor READONLY_VISITOR;
    public static final int NOT_FROM_RESOLVER = 6;
    public static final int GET_DEPENDENCIES = 7;
    public static final int QUERY_COMPARABLE = 8;
    public static final int GET_COLUMNS1 = 9;
    public static final int GET_COLUMNS2 = 10;
    public static final int DECREMENT_QUERY_LEVEL = 11;
    public static final ExpressionVisitor QUERY_COMPARABLE_VISITOR;
    private final int type;
    private final int queryLevel;
    private final HashSet<?> set;
    private final AllColumnsForPlan columns1;
    private final Table table;
    private final long[] maxDataModificationId;
    private final ColumnResolver resolver;

    static {
        ExpressionVisitor[] a = new ExpressionVisitor[8];
        a[0] = INDEPENDENT_VISITOR;
        int i = 1;
        while (i < 8) {
            a[i] = new ExpressionVisitor(0, i);
            ++i;
        }
        INDEPENDENT_VISITORS = a;
        a = new ExpressionVisitor[8];
        a[0] = EVALUATABLE_VISITOR;
        i = 1;
        while (i < 8) {
            a[i] = new ExpressionVisitor(3, i);
            ++i;
        }
        EVALUATABLE_VISITORS = a;
        READONLY_VISITOR = new ExpressionVisitor(5);
        QUERY_COMPARABLE_VISITOR = new ExpressionVisitor(8);
    }

    private ExpressionVisitor(int type, int queryLevel, HashSet<?> set, AllColumnsForPlan columns1, Table table, ColumnResolver resolver, long[] maxDataModificationId) {
        this.type = type;
        this.queryLevel = queryLevel;
        this.set = set;
        this.columns1 = columns1;
        this.table = table;
        this.resolver = resolver;
        this.maxDataModificationId = maxDataModificationId;
    }

    private ExpressionVisitor(int type) {
        this.type = type;
        this.queryLevel = 0;
        this.set = null;
        this.columns1 = null;
        this.table = null;
        this.resolver = null;
        this.maxDataModificationId = null;
    }

    private ExpressionVisitor(int type, int queryLevel) {
        this.type = type;
        this.queryLevel = queryLevel;
        this.set = null;
        this.columns1 = null;
        this.table = null;
        this.resolver = null;
        this.maxDataModificationId = null;
    }

    public static ExpressionVisitor getDependenciesVisitor(HashSet<DbObject> dependencies) {
        return new ExpressionVisitor(7, 0, dependencies, null, null, null, null);
    }

    public static ExpressionVisitor getOptimizableVisitor(Table table) {
        return new ExpressionVisitor(1, 0, null, null, table, null, null);
    }

    public static ExpressionVisitor getNotFromResolverVisitor(ColumnResolver resolver) {
        return new ExpressionVisitor(6, 0, null, null, null, resolver, null);
    }

    public static ExpressionVisitor getColumnsVisitor(AllColumnsForPlan columns) {
        return new ExpressionVisitor(9, 0, null, columns, null, null, null);
    }

    public static ExpressionVisitor getColumnsVisitor(HashSet<Column> columns, Table table) {
        return new ExpressionVisitor(10, 0, columns, null, table, null, null);
    }

    public static ExpressionVisitor getMaxModificationIdVisitor() {
        return new ExpressionVisitor(4, 0, null, null, null, null, new long[1]);
    }

    public static ExpressionVisitor getDecrementQueryLevelVisitor(HashSet<ColumnResolver> columnResolvers, int queryDecrement) {
        return new ExpressionVisitor(11, queryDecrement, columnResolvers, null, null, null, null);
    }

    public void addDependency(DbObject obj) {
        this.set.add(obj);
    }

    void addColumn1(Column column) {
        this.columns1.add(column);
    }

    void addColumn2(Column column) {
        if (this.table == null || this.table == column.getTable()) {
            this.set.add(column);
        }
    }

    public HashSet<DbObject> getDependencies() {
        return this.set;
    }

    public ExpressionVisitor incrementQueryLevel(int offset) {
        if (this.type == 0) {
            return (offset += this.queryLevel) < 8 ? INDEPENDENT_VISITORS[offset] : new ExpressionVisitor(0, offset);
        }
        if (this.type == 3) {
            return (offset += this.queryLevel) < 8 ? EVALUATABLE_VISITORS[offset] : new ExpressionVisitor(3, offset);
        }
        return this;
    }

    public ColumnResolver getResolver() {
        return this.resolver;
    }

    public HashSet<ColumnResolver> getColumnResolvers() {
        return this.set;
    }

    public void addDataModificationId(long value) {
        long m = this.maxDataModificationId[0];
        if (value > m) {
            this.maxDataModificationId[0] = value;
        }
    }

    public long getMaxDataModificationId() {
        return this.maxDataModificationId[0];
    }

    int getQueryLevel() {
        assert (this.type == 0 || this.type == 3 || this.type == 11);
        return this.queryLevel;
    }

    public Table getTable() {
        return this.table;
    }

    public int getType() {
        return this.type;
    }

    public static void allColumnsForTableFilters(TableFilter[] filters, AllColumnsForPlan allColumnsSet) {
        TableFilter[] tableFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            TableFilter filter = tableFilterArray[n2];
            if (filter.getSelect() != null) {
                filter.getSelect().isEverything(ExpressionVisitor.getColumnsVisitor(allColumnsSet));
            }
            ++n2;
        }
    }
}

