/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.util.Map;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.Operation1;
import org.h2.expression.TypedValueExpression;
import org.h2.message.DbException;
import org.h2.mvstore.db.Store;
import org.h2.util.ParserUtil;
import org.h2.util.json.JSONObject;
import org.h2.util.json.JSONValue;
import org.h2.value.ExtTypeInfoRow;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueJson;
import org.h2.value.ValueNull;
import org.h2.value.ValueRow;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class FieldReference
extends Operation1 {
    private final String fieldName;
    private int ordinal;

    public FieldReference(Expression arg, String fieldName) {
        super(arg);
        this.fieldName = fieldName;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return ParserUtil.quoteIdentifier(this.arg.getEnclosedSQL(builder, sqlFlags).append('.'), this.fieldName, sqlFlags);
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value l = this.arg.getValue(session);
        if (l != ValueNull.INSTANCE) {
            JSONValue jsonValue;
            if (this.ordinal >= 0) {
                return ((ValueRow)l).getList()[this.ordinal];
            }
            JSONValue value = l.convertToAnyJson().getDecomposition();
            if (value instanceof JSONObject && (jsonValue = ((JSONObject)value).getFirst(this.fieldName)) != null) {
                return ValueJson.fromJson(jsonValue);
            }
        }
        return ValueNull.INSTANCE;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.arg = this.arg.optimize(session);
        TypeInfo type = this.arg.getType();
        int valueType = type.getValueType();
        block0 : switch (valueType) {
            case 38: {
                this.type = TypeInfo.TYPE_JSON;
                this.ordinal = -1;
                break;
            }
            case 41: {
                int ordinal = 0;
                for (Map.Entry<String, TypeInfo> entry : ((ExtTypeInfoRow)type.getExtTypeInfo()).getFields()) {
                    if (this.fieldName.equals(entry.getKey())) {
                        this.type = type = entry.getValue();
                        this.ordinal = ordinal;
                        break block0;
                    }
                    ++ordinal;
                }
                throw DbException.get(42122, this.fieldName);
            }
            default: {
                throw Store.getInvalidExpressionTypeException("JSON | ROW", this.arg);
            }
        }
        if (this.arg.isConstant()) {
            return TypedValueExpression.get(this.getValue(session), type);
        }
        return this;
    }
}

