/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.Operation1;
import org.h2.expression.ValueExpression;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueJson;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Format
extends Operation1 {
    private final FormatEnum format;

    public Format(Expression arg, FormatEnum format) {
        super(arg);
        this.format = format;
    }

    @Override
    public Value getValue(SessionLocal session) {
        return this.getValue(this.arg.getValue(session));
    }

    public Value getValue(Value value) {
        return Format.applyJSON(value);
    }

    public static Value applyJSON(Value value) {
        switch (value.getValueType()) {
            case 0: {
                return ValueNull.INSTANCE;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return ValueJson.fromJson(value.getString());
            }
        }
        return value.convertToJson(TypeInfo.TYPE_JSON, 0, null);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.arg = this.arg.optimize(session);
        if (this.arg.isConstant()) {
            return ValueExpression.get(this.getValue(session));
        }
        if (this.arg instanceof Format && this.format == ((Format)this.arg).format) {
            return this.arg;
        }
        this.type = TypeInfo.TYPE_JSON;
        return this;
    }

    @Override
    public boolean isIdentity() {
        return this.arg.isIdentity();
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        return this.arg.getSQL(builder, sqlFlags, 0).append(" FORMAT ").append(this.format.name());
    }

    @Override
    public int getNullable() {
        return this.arg.getNullable();
    }

    @Override
    public String getTableName() {
        return this.arg.getTableName();
    }

    @Override
    public String getColumnName(SessionLocal session, int columnIndex) {
        return this.arg.getColumnName(session, columnIndex);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum FormatEnum {
        JSON;

    }
}

