/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.CastDataProvider;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.Operation1_2;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.util.DateTimeUtils;
import org.h2.util.TimeZoneProvider;
import org.h2.value.DataType;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueInterval;
import org.h2.value.ValueNull;
import org.h2.value.ValueTimeTimeZone;
import org.h2.value.ValueTimestampTimeZone;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class TimeZoneOperation
extends Operation1_2 {
    public TimeZoneOperation(Expression left, Expression right) {
        super(left, right);
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        this.left.getSQL(builder, sqlFlags, 0).append(" AT ");
        if (this.right != null) {
            this.right.getSQL(builder.append("TIME ZONE "), sqlFlags, 0);
        } else {
            builder.append("LOCAL");
        }
        return builder;
    }

    @Override
    public Value getValue(SessionLocal session) {
        Value b;
        Value l = this.left.getValue(session);
        Value a = l.convertTo(this.type, (CastDataProvider)session);
        if (a == ValueNull.INSTANCE) {
            return ValueNull.INSTANCE;
        }
        if (this.right == null) {
            int t = l.getValueType();
            if (t == 18 || t == 20) {
                return a;
            }
            b = null;
        } else {
            b = this.right.getValue(session);
            if (b == ValueNull.INSTANCE) {
                return ValueNull.INSTANCE;
            }
        }
        if (a.getValueType() == 21) {
            int newOffset;
            ValueTimestampTimeZone v = (ValueTimestampTimeZone)a;
            long dateValue = v.getDateValue();
            long timeNanos = v.getTimeNanos();
            int offsetSeconds = v.getTimeZoneOffsetSeconds();
            int n = newOffset = b != null ? TimeZoneOperation.parseTimeZone(b, dateValue, timeNanos, offsetSeconds, true) : session.currentTimeZone().getTimeZoneOffsetUTC(DateTimeUtils.getEpochSeconds(dateValue, timeNanos, offsetSeconds));
            if (offsetSeconds != newOffset) {
                a = DateTimeUtils.timestampTimeZoneAtOffset(dateValue, timeNanos, offsetSeconds, newOffset);
            }
        } else {
            int newOffset;
            ValueTimeTimeZone v = (ValueTimeTimeZone)a;
            long timeNanos = v.getNanos();
            int offsetSeconds = v.getTimeZoneOffsetSeconds();
            int n = newOffset = b != null ? TimeZoneOperation.parseTimeZone(b, 1008673L, timeNanos, offsetSeconds, false) : session.currentTimeZone().getTimeZoneOffsetUTC(DateTimeUtils.getEpochSeconds(session.currentTimestamp().getDateValue(), timeNanos, offsetSeconds));
            if (offsetSeconds != newOffset) {
                a = ValueTimeTimeZone.fromNanos(DateTimeUtils.normalizeNanosOfDay(timeNanos += (long)(newOffset - offsetSeconds) * 1000000000L), newOffset);
            }
        }
        return a;
    }

    private static int parseTimeZone(Value b, long dateValue, long timeNanos, int offsetSeconds, boolean allowTimeZoneName) {
        if (DataType.isCharacterStringType(b.getValueType())) {
            TimeZoneProvider timeZone;
            try {
                timeZone = TimeZoneProvider.ofId(b.getString());
            }
            catch (RuntimeException ex) {
                throw DbException.getInvalidValueException("time zone", b.getTraceSQL());
            }
            if (!allowTimeZoneName && !timeZone.hasFixedOffset()) {
                throw DbException.getInvalidValueException("time zone", b.getTraceSQL());
            }
            return timeZone.getTimeZoneOffsetUTC(DateTimeUtils.getEpochSeconds(dateValue, timeNanos, offsetSeconds));
        }
        return TimeZoneOperation.parseInterval(b);
    }

    public static int parseInterval(Value interval) {
        ValueInterval i = (ValueInterval)interval.convertTo(TypeInfo.TYPE_INTERVAL_HOUR_TO_SECOND);
        long h = i.getLeading();
        long seconds = i.getRemaining();
        if (h > 18L || h == 18L && seconds != 0L || seconds % 1000000000L != 0L) {
            throw DbException.getInvalidValueException("time zone", i.getTraceSQL());
        }
        int newOffset = (int)(h * 3600L + seconds / 1000000000L);
        if (i.isNegative()) {
            newOffset = -newOffset;
        }
        return newOffset;
    }

    @Override
    public Expression optimize(SessionLocal session) {
        this.left = this.left.optimize(session);
        if (this.right != null) {
            this.right = this.right.optimize(session);
        }
        TypeInfo type = this.left.getType();
        int valueType = 21;
        int scale = 9;
        int lType = type.getValueType();
        switch (lType) {
            case 20: 
            case 21: {
                scale = type.getScale();
                break;
            }
            case 18: 
            case 19: {
                valueType = 19;
                scale = type.getScale();
                break;
            }
            default: {
                StringBuilder builder = this.left.getSQL(new StringBuilder(), 3, 0);
                int offset = builder.length();
                builder.append(" AT ");
                if (this.right != null) {
                    this.right.getSQL(builder.append("TIME ZONE "), 3, 0);
                } else {
                    builder.append("LOCAL");
                }
                throw DbException.getSyntaxError(builder.toString(), offset, "time, timestamp");
            }
        }
        this.type = TypeInfo.getTypeInfo(valueType, -1L, scale, null);
        if (this.left.isConstant() && (lType == 19 || lType == 21) && this.right != null && this.right.isConstant()) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        if (visitor.getType() == 2) {
            if (this.right == null) {
                return false;
            }
            int lType = this.left.getType().getValueType();
            if (lType == 18 || lType == 20) {
                return false;
            }
        }
        return this.left.isEverything(visitor) && (this.right == null || this.right.isEverything(visitor));
    }
}

