/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.aggregate;

import org.h2.engine.SessionLocal;
import org.h2.expression.aggregate.AggregateDataBinarySet;
import org.h2.expression.aggregate.AggregateType;
import org.h2.message.DbException;
import org.h2.value.Value;
import org.h2.value.ValueDouble;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class AggregateDataCovar
extends AggregateDataBinarySet {
    private final AggregateType aggregateType;
    private long count;
    private double sumY;
    private double sumX;
    private double sumYX;

    AggregateDataCovar(AggregateType aggregateType) {
        this.aggregateType = aggregateType;
    }

    @Override
    void add(SessionLocal session, Value yValue, Value xValue) {
        double y = yValue.getDouble();
        double x = xValue.getDouble();
        this.sumY += y;
        this.sumX += x;
        this.sumYX += y * x;
        ++this.count;
    }

    @Override
    Value getValue(SessionLocal session) {
        double v;
        switch (this.aggregateType) {
            case COVAR_POP: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                v = (this.sumYX - this.sumX * this.sumY / (double)this.count) / (double)this.count;
                break;
            }
            case COVAR_SAMP: {
                if (this.count < 2L) {
                    return ValueNull.INSTANCE;
                }
                v = (this.sumYX - this.sumX * this.sumY / (double)this.count) / (double)(this.count - 1L);
                break;
            }
            case REGR_SXY: {
                if (this.count < 1L) {
                    return ValueNull.INSTANCE;
                }
                v = this.sumYX - this.sumX * this.sumY / (double)this.count;
                break;
            }
            default: {
                throw DbException.getInternalError("type=" + String.valueOf((Object)this.aggregateType));
            }
        }
        return ValueDouble.get(v);
    }
}

