/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.aggregate;

import java.util.ArrayList;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.expression.aggregate.AggregateData;
import org.h2.index.Index;
import org.h2.mvstore.db.MVSpatialIndex;
import org.h2.table.Column;
import org.h2.table.TableFilter;
import org.h2.util.geometry.GeometryUtils;
import org.h2.value.Value;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class AggregateDataEnvelope
extends AggregateData {
    private double[] envelope;

    AggregateDataEnvelope() {
    }

    static Index getGeometryColumnIndex(Expression on) {
        ArrayList<Index> indexes;
        TableFilter filter;
        ExpressionColumn col;
        Column column;
        if (on instanceof ExpressionColumn && (column = (col = (ExpressionColumn)on).getColumn()).getType().getValueType() == 37 && (filter = col.getTableFilter()) != null && (indexes = filter.getTable().getIndexes()) != null) {
            int i = 1;
            int size = indexes.size();
            while (i < size) {
                Index index = indexes.get(i);
                if (index instanceof MVSpatialIndex && index.isFirstColumn(column)) {
                    return index;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    void add(SessionLocal session, Value v) {
        if (v == ValueNull.INSTANCE) {
            return;
        }
        this.envelope = GeometryUtils.union(this.envelope, v.convertToGeometry(null).getEnvelopeNoCopy());
    }

    @Override
    Value getValue(SessionLocal session) {
        return ValueGeometry.fromEnvelope(this.envelope);
    }
}

