/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.aggregate;

import java.sql.SQLException;
import org.h2.api.Aggregate;
import org.h2.command.query.Select;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.aggregate.AbstractAggregate;
import org.h2.expression.aggregate.AggregateDataCollecting;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.DbException;
import org.h2.schema.UserAggregate;
import org.h2.util.ParserUtil;
import org.h2.value.TypeInfo;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;
import org.h2.value.ValueRow;
import org.h2.value.ValueToObjectConverter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JavaAggregate
extends AbstractAggregate {
    private final UserAggregate userAggregate;
    private int[] argTypes;
    private int dataType;
    private JdbcConnection userConnection;

    public JavaAggregate(UserAggregate userAggregate, Expression[] args, Select select, boolean distinct) {
        super(select, args, distinct);
        this.userAggregate = userAggregate;
    }

    @Override
    public int getCost() {
        int cost = 5;
        Expression[] expressionArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            cost += e.getCost();
            ++n2;
        }
        if (this.filterCondition != null) {
            cost += this.filterCondition.getCost();
        }
        return cost;
    }

    @Override
    public StringBuilder getUnenclosedSQL(StringBuilder builder, int sqlFlags) {
        ParserUtil.quoteIdentifier(builder, this.userAggregate.getName(), sqlFlags).append('(');
        JavaAggregate.writeExpressions(builder, this.args, sqlFlags).append(')');
        return this.appendTailConditions(builder, sqlFlags, false);
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        if (!super.isEverything(visitor)) {
            return false;
        }
        switch (visitor.getType()) {
            case 1: 
            case 2: {
                return false;
            }
            case 7: {
                visitor.addDependency(this.userAggregate);
            }
        }
        Expression[] expressionArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            Expression e = expressionArray[n2];
            if (e != null && !e.isEverything(visitor)) {
                return false;
            }
            ++n2;
        }
        return this.filterCondition == null || this.filterCondition.isEverything(visitor);
    }

    @Override
    public Expression optimize(SessionLocal session) {
        super.optimize(session);
        this.userConnection = session.createConnection(false);
        int len = this.args.length;
        this.argTypes = new int[len];
        int i = 0;
        while (i < len) {
            int type;
            this.argTypes[i] = type = this.args[i].getType().getValueType();
            ++i;
        }
        try {
            Aggregate aggregate = this.getInstance();
            this.dataType = aggregate.getInternalType(this.argTypes);
            this.type = TypeInfo.getTypeInfo(this.dataType);
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
        return this;
    }

    private Aggregate getInstance() {
        Aggregate agg = this.userAggregate.getInstance();
        try {
            agg.init(this.userConnection);
        }
        catch (SQLException ex) {
            throw DbException.convert(ex);
        }
        return agg;
    }

    @Override
    public Value getAggregatedValue(SessionLocal session, Object aggregateData) {
        try {
            Object obj;
            Aggregate agg;
            if (this.distinct) {
                agg = this.getInstance();
                AggregateDataCollecting data = (AggregateDataCollecting)aggregateData;
                if (data != null) {
                    for (Value value : data.values) {
                        if (this.args.length == 1) {
                            agg.add(ValueToObjectConverter.valueToDefaultObject(value, this.userConnection, false));
                            continue;
                        }
                        Value[] values = ((ValueRow)value).getList();
                        Object[] argValues = new Object[this.args.length];
                        int i = 0;
                        int len = this.args.length;
                        while (i < len) {
                            argValues[i] = ValueToObjectConverter.valueToDefaultObject(values[i], this.userConnection, false);
                            ++i;
                        }
                        agg.add(argValues);
                    }
                }
            } else {
                agg = (Aggregate)aggregateData;
                if (agg == null) {
                    agg = this.getInstance();
                }
            }
            if ((obj = agg.getResult()) == null) {
                return ValueNull.INSTANCE;
            }
            return ValueToObjectConverter.objectToValue(session, obj, this.dataType);
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
    }

    @Override
    protected void updateAggregate(SessionLocal session, Object aggregateData) {
        this.updateData(session, aggregateData, null);
    }

    private void updateData(SessionLocal session, Object aggregateData, Value[] remembered) {
        try {
            if (this.distinct) {
                AggregateDataCollecting data = (AggregateDataCollecting)aggregateData;
                Value[] argValues = new Value[this.args.length];
                Value arg = null;
                int i = 0;
                int len = this.args.length;
                while (i < len) {
                    argValues[i] = arg = remembered == null ? this.args[i].getValue(session) : remembered[i];
                    ++i;
                }
                data.add(session, this.args.length == 1 ? arg : ValueRow.get(argValues));
            } else {
                Aggregate agg = (Aggregate)aggregateData;
                Object[] argValues = new Object[this.args.length];
                Object arg = null;
                int i = 0;
                int len = this.args.length;
                while (i < len) {
                    Value v = remembered == null ? this.args[i].getValue(session) : remembered[i];
                    argValues[i] = arg = ValueToObjectConverter.valueToDefaultObject(v, this.userConnection, false);
                    ++i;
                }
                agg.add(this.args.length == 1 ? arg : argValues);
            }
        }
        catch (SQLException e) {
            throw DbException.convert(e);
        }
    }

    @Override
    protected void updateGroupAggregates(SessionLocal session, int stage) {
        super.updateGroupAggregates(session, stage);
        Expression[] expressionArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            Expression expr = expressionArray[n2];
            expr.updateAggregate(session, stage);
            ++n2;
        }
    }

    @Override
    protected int getNumExpressions() {
        int n = this.args.length;
        if (this.filterCondition != null) {
            ++n;
        }
        return n;
    }

    @Override
    protected void rememberExpressions(SessionLocal session, Value[] array) {
        int length = this.args.length;
        int i = 0;
        while (i < length) {
            array[i] = this.args[i].getValue(session);
            ++i;
        }
        if (this.filterCondition != null) {
            array[length] = ValueBoolean.get(this.filterCondition.getBooleanValue(session));
        }
    }

    @Override
    protected void updateFromExpressions(SessionLocal session, Object aggregateData, Value[] array) {
        if (this.filterCondition == null || array[this.getNumExpressions() - 1].isTrue()) {
            this.updateData(session, aggregateData, array);
        }
    }

    @Override
    protected Object createAggregateData() {
        return this.distinct ? new AggregateDataCollecting(true, false, AggregateDataCollecting.NullCollectionMode.IGNORED) : this.getInstance();
    }
}

