/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.analysis;

import java.util.ArrayList;
import java.util.Iterator;
import org.h2.command.query.QueryOrderBy;
import org.h2.command.query.Select;
import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.analysis.WindowFrame;
import org.h2.expression.analysis.WindowFrameBound;
import org.h2.expression.analysis.WindowFrameBoundType;
import org.h2.expression.analysis.WindowFrameUnits;
import org.h2.message.DbException;
import org.h2.result.SortOrder;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueRow;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class Window {
    private ArrayList<Expression> partitionBy;
    private ArrayList<QueryOrderBy> orderBy;
    private WindowFrame frame;
    private String parent;

    public static void appendOrderBy(StringBuilder builder, ArrayList<QueryOrderBy> orderBy, int sqlFlags, boolean forceOrderBy) {
        if (orderBy != null && !orderBy.isEmpty()) {
            Window.appendOrderByStart(builder);
            int i = 0;
            while (i < orderBy.size()) {
                QueryOrderBy o = orderBy.get(i);
                if (i > 0) {
                    builder.append(", ");
                }
                o.expression.getUnenclosedSQL(builder, sqlFlags);
                SortOrder.typeToString(builder, o.sortType);
                ++i;
            }
        } else if (forceOrderBy) {
            Window.appendOrderByStart(builder);
            builder.append("NULL");
        }
    }

    private static void appendOrderByStart(StringBuilder builder) {
        if (builder.charAt(builder.length() - 1) != '(') {
            builder.append(' ');
        }
        builder.append("ORDER BY ");
    }

    public Window(String parent, ArrayList<Expression> partitionBy, ArrayList<QueryOrderBy> orderBy, WindowFrame frame) {
        this.parent = parent;
        this.partitionBy = partitionBy;
        this.orderBy = orderBy;
        this.frame = frame;
    }

    public void mapColumns(ColumnResolver resolver, int level) {
        this.resolveWindows(resolver);
        if (this.partitionBy != null) {
            for (Expression e : this.partitionBy) {
                e.mapColumns(resolver, level, 1);
            }
        }
        if (this.orderBy != null) {
            for (QueryOrderBy o : this.orderBy) {
                o.expression.mapColumns(resolver, level, 1);
            }
        }
        if (this.frame != null) {
            this.frame.mapColumns(resolver, level, 1);
        }
    }

    private void resolveWindows(ColumnResolver resolver) {
        if (this.parent != null) {
            Window p;
            Select select = resolver.getSelect();
            while ((p = select.getWindow(this.parent)) == null) {
                if ((select = select.getParentSelect()) != null) continue;
                throw DbException.get(90136, this.parent);
            }
            p.resolveWindows(resolver);
            if (this.partitionBy == null) {
                this.partitionBy = p.partitionBy;
            }
            if (this.orderBy == null) {
                this.orderBy = p.orderBy;
            }
            if (this.frame == null) {
                this.frame = p.frame;
            }
            this.parent = null;
        }
    }

    public void optimize(SessionLocal session) {
        Iterator<Object> i;
        if (this.partitionBy != null) {
            i = this.partitionBy.listIterator();
            while (i.hasNext()) {
                Expression e = ((Expression)i.next()).optimize(session);
                if (e.isConstant()) {
                    i.remove();
                    continue;
                }
                i.set(e);
            }
            if (this.partitionBy.isEmpty()) {
                this.partitionBy = null;
            }
        }
        if (this.orderBy != null) {
            i = this.orderBy.iterator();
            while (i.hasNext()) {
                QueryOrderBy o = (QueryOrderBy)i.next();
                Expression e = o.expression.optimize(session);
                if (e.isConstant()) {
                    i.remove();
                    continue;
                }
                o.expression = e;
            }
            if (this.orderBy.isEmpty()) {
                this.orderBy = null;
            }
        }
        if (this.frame != null) {
            this.frame.optimize(session);
        }
    }

    public void setEvaluatable(TableFilter tableFilter, boolean value) {
        if (this.partitionBy != null) {
            for (Expression e : this.partitionBy) {
                e.setEvaluatable(tableFilter, value);
            }
        }
        if (this.orderBy != null) {
            for (QueryOrderBy o : this.orderBy) {
                o.expression.setEvaluatable(tableFilter, value);
            }
        }
    }

    public ArrayList<QueryOrderBy> getOrderBy() {
        return this.orderBy;
    }

    public WindowFrame getWindowFrame() {
        return this.frame;
    }

    public boolean isOrdered() {
        if (this.orderBy != null) {
            return true;
        }
        if (this.frame != null && this.frame.getUnits() == WindowFrameUnits.ROWS) {
            WindowFrameBound following;
            return this.frame.getStarting().getType() != WindowFrameBoundType.UNBOUNDED_PRECEDING || (following = this.frame.getFollowing()) == null || following.getType() != WindowFrameBoundType.UNBOUNDED_FOLLOWING;
        }
        return false;
    }

    public Value getCurrentKey(SessionLocal session) {
        if (this.partitionBy == null) {
            return null;
        }
        int len = this.partitionBy.size();
        if (len == 1) {
            return this.partitionBy.get(0).getValue(session);
        }
        Value[] keyValues = new Value[len];
        int i = 0;
        while (i < len) {
            Expression expr = this.partitionBy.get(i);
            keyValues[i] = expr.getValue(session);
            ++i;
        }
        return ValueRow.get(keyValues);
    }

    public StringBuilder getSQL(StringBuilder builder, int sqlFlags, boolean forceOrderBy) {
        builder.append("OVER (");
        if (this.partitionBy != null) {
            builder.append("PARTITION BY ");
            int i = 0;
            while (i < this.partitionBy.size()) {
                if (i > 0) {
                    builder.append(", ");
                }
                this.partitionBy.get(i).getUnenclosedSQL(builder, sqlFlags);
                ++i;
            }
        }
        Window.appendOrderBy(builder, this.orderBy, sqlFlags, forceOrderBy);
        if (this.frame != null) {
            if (builder.charAt(builder.length() - 1) != '(') {
                builder.append(' ');
            }
            this.frame.getSQL(builder, sqlFlags);
        }
        return builder.append(')');
    }

    public void updateAggregate(SessionLocal session, int stage) {
        if (this.partitionBy != null) {
            for (Expression expr : this.partitionBy) {
                expr.updateAggregate(session, stage);
            }
        }
        if (this.orderBy != null) {
            for (QueryOrderBy o : this.orderBy) {
                o.expression.updateAggregate(session, stage);
            }
        }
        if (this.frame != null) {
            this.frame.updateAggregate(session, stage);
        }
    }

    public String toString() {
        return this.getSQL(new StringBuilder(), 3, false).toString();
    }
}

