/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.h2.engine.SessionLocal;
import org.h2.expression.BinaryOperation;
import org.h2.expression.ValueExpression;
import org.h2.expression.analysis.Window;
import org.h2.expression.analysis.WindowFrameBound;
import org.h2.expression.analysis.WindowFrameBoundType;
import org.h2.expression.analysis.WindowFrameExclusion;
import org.h2.expression.analysis.WindowFrameUnits;
import org.h2.message.DbException;
import org.h2.result.SortOrder;
import org.h2.table.ColumnResolver;
import org.h2.value.Value;
import org.h2.value.ValueNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class WindowFrame {
    private final WindowFrameUnits units;
    private final WindowFrameBound starting;
    private final WindowFrameBound following;
    private final WindowFrameExclusion exclusion;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$h2$expression$analysis$WindowFrameUnits;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$h2$expression$analysis$WindowFrameBoundType;

    public static Iterator<Value[]> iterator(Window over, SessionLocal session, ArrayList<Value[]> orderedRows, SortOrder sortOrder, int currentRow, boolean reverse) {
        WindowFrame frame = over.getWindowFrame();
        if (frame != null) {
            return frame.iterator(session, orderedRows, sortOrder, currentRow, reverse);
        }
        int endIndex = orderedRows.size() - 1;
        return WindowFrame.plainIterator(orderedRows, 0, over.getOrderBy() == null ? endIndex : WindowFrame.toGroupEnd(orderedRows, sortOrder, currentRow, endIndex), reverse);
    }

    public static int getEndIndex(Window over, SessionLocal session, ArrayList<Value[]> orderedRows, SortOrder sortOrder, int currentRow) {
        WindowFrame frame = over.getWindowFrame();
        if (frame != null) {
            return frame.getEndIndex(session, orderedRows, sortOrder, currentRow);
        }
        int endIndex = orderedRows.size() - 1;
        return over.getOrderBy() == null ? endIndex : WindowFrame.toGroupEnd(orderedRows, sortOrder, currentRow, endIndex);
    }

    private static Iterator<Value[]> plainIterator(ArrayList<Value[]> orderedRows, int startIndex, int endIndex, boolean reverse) {
        if (endIndex < startIndex) {
            return Collections.emptyIterator();
        }
        return reverse ? new PlainReverseItr(orderedRows, startIndex, endIndex) : new PlainItr(orderedRows, startIndex, endIndex);
    }

    private static Iterator<Value[]> biIterator(ArrayList<Value[]> orderedRows, int startIndex1, int endIndex1, int startIndex2, int endIndex2, boolean reverse) {
        return reverse ? new BiReverseItr(orderedRows, startIndex1, endIndex1, startIndex2, endIndex2) : new BiItr(orderedRows, startIndex1, endIndex1, startIndex2, endIndex2);
    }

    private static Iterator<Value[]> triIterator(ArrayList<Value[]> orderedRows, int startIndex1, int endIndex1, int startIndex2, int endIndex2, int startIndex3, int endIndex3, boolean reverse) {
        return reverse ? new TriReverseItr(orderedRows, startIndex1, endIndex1, startIndex2, endIndex2, startIndex3, endIndex3) : new TriItr(orderedRows, startIndex1, endIndex1, startIndex2, endIndex2, startIndex3, endIndex3);
    }

    private static int toGroupStart(ArrayList<Value[]> orderedRows, SortOrder sortOrder, int offset, int minOffset) {
        Value[] row = orderedRows.get(offset);
        while (offset > minOffset && sortOrder.compare(row, orderedRows.get(offset - 1)) == 0) {
            --offset;
        }
        return offset;
    }

    private static int toGroupEnd(ArrayList<Value[]> orderedRows, SortOrder sortOrder, int offset, int maxOffset) {
        Value[] row = orderedRows.get(offset);
        while (offset < maxOffset && sortOrder.compare(row, orderedRows.get(offset + 1)) == 0) {
            ++offset;
        }
        return offset;
    }

    private static int getIntOffset(WindowFrameBound bound, Value[] values, SessionLocal session) {
        int value;
        Value v;
        Value value2 = v = bound.isVariable() ? values[bound.getExpressionIndex()] : bound.getValue().getValue(session);
        if (v == ValueNull.INSTANCE || (value = v.getInt()) < 0) {
            throw DbException.get(22013, v.getTraceSQL());
        }
        return value;
    }

    private static Value[] getCompareRow(SessionLocal session, ArrayList<Value[]> orderedRows, SortOrder sortOrder, int currentRow, WindowFrameBound bound, boolean add) {
        Value newValue;
        int sortIndex = sortOrder.getQueryColumnIndexes()[0];
        Value[] row = orderedRows.get(currentRow);
        Value currentValue = row[sortIndex];
        int type = currentValue.getValueType();
        Value range = WindowFrame.getValueOffset(bound, orderedRows.get(currentRow), session);
        switch (type) {
            case 0: {
                newValue = ValueNull.INSTANCE;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                BinaryOperation.OpType opType = add ^ (sortOrder.getSortTypes()[0] & 1) != 0 ? BinaryOperation.OpType.PLUS : BinaryOperation.OpType.MINUS;
                try {
                    newValue = new BinaryOperation(opType, ValueExpression.get(currentValue), ValueExpression.get(range)).optimize(session).getValue(session).convertTo(type);
                    break;
                }
                catch (DbException ex) {
                    switch (ex.getErrorCode()) {
                        case 22003: 
                        case 22004: {
                            return null;
                        }
                    }
                    throw ex;
                }
            }
            default: {
                throw DbException.getInvalidValueException("unsupported type of sort key for RANGE units", currentValue.getTraceSQL());
            }
        }
        Value[] newRow = (Value[])row.clone();
        newRow[sortIndex] = newValue;
        return newRow;
    }

    private static Value getValueOffset(WindowFrameBound bound, Value[] values, SessionLocal session) {
        Value value;
        Value value2 = value = bound.isVariable() ? values[bound.getExpressionIndex()] : bound.getValue().getValue(session);
        if (value == ValueNull.INSTANCE || value.getSignum() < 0) {
            throw DbException.get(22013, value.getTraceSQL());
        }
        return value;
    }

    public WindowFrame(WindowFrameUnits units, WindowFrameBound starting, WindowFrameBound following, WindowFrameExclusion exclusion) {
        this.units = units;
        this.starting = starting;
        if (following != null && following.getType() == WindowFrameBoundType.CURRENT_ROW) {
            following = null;
        }
        this.following = following;
        this.exclusion = exclusion;
    }

    public WindowFrameUnits getUnits() {
        return this.units;
    }

    public WindowFrameBound getStarting() {
        return this.starting;
    }

    public WindowFrameBound getFollowing() {
        return this.following;
    }

    public WindowFrameExclusion getExclusion() {
        return this.exclusion;
    }

    public boolean isValid() {
        WindowFrameBoundType f;
        WindowFrameBoundType s = this.starting.getType();
        WindowFrameBoundType windowFrameBoundType = f = this.following != null ? this.following.getType() : WindowFrameBoundType.CURRENT_ROW;
        return s != WindowFrameBoundType.UNBOUNDED_FOLLOWING && f != WindowFrameBoundType.UNBOUNDED_PRECEDING && s.compareTo(f) <= 0;
    }

    public boolean isVariableBounds() {
        if (this.starting.isVariable()) {
            return true;
        }
        return this.following != null && this.following.isVariable();
    }

    void mapColumns(ColumnResolver resolver, int level, int state) {
        this.starting.mapColumns(resolver, level, state);
        if (this.following != null) {
            this.following.mapColumns(resolver, level, state);
        }
    }

    void optimize(SessionLocal session) {
        this.starting.optimize(session);
        if (this.following != null) {
            this.following.optimize(session);
        }
    }

    void updateAggregate(SessionLocal session, int stage) {
        this.starting.updateAggregate(session, stage);
        if (this.following != null) {
            this.following.updateAggregate(session, stage);
        }
    }

    public Iterator<Value[]> iterator(SessionLocal session, ArrayList<Value[]> orderedRows, SortOrder sortOrder, int currentRow, boolean reverse) {
        int endIndex;
        int startIndex = this.getIndex(session, orderedRows, sortOrder, currentRow, this.starting, false);
        int n = this.following != null ? this.getIndex(session, orderedRows, sortOrder, currentRow, this.following, true) : (endIndex = this.units == WindowFrameUnits.ROWS ? currentRow : WindowFrame.toGroupEnd(orderedRows, sortOrder, currentRow, orderedRows.size() - 1));
        if (endIndex < startIndex) {
            return Collections.emptyIterator();
        }
        int size = orderedRows.size();
        if (startIndex >= size || endIndex < 0) {
            return Collections.emptyIterator();
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= size) {
            endIndex = size - 1;
        }
        return this.exclusion != WindowFrameExclusion.EXCLUDE_NO_OTHERS ? this.complexIterator(orderedRows, sortOrder, currentRow, startIndex, endIndex, reverse) : WindowFrame.plainIterator(orderedRows, startIndex, endIndex, reverse);
    }

    public int getStartIndex(SessionLocal session, ArrayList<Value[]> orderedRows, SortOrder sortOrder, int currentRow) {
        if (this.exclusion != WindowFrameExclusion.EXCLUDE_NO_OTHERS) {
            throw new UnsupportedOperationException();
        }
        int startIndex = this.getIndex(session, orderedRows, sortOrder, currentRow, this.starting, false);
        if (startIndex < 0) {
            startIndex = 0;
        }
        return startIndex;
    }

    private int getEndIndex(SessionLocal session, ArrayList<Value[]> orderedRows, SortOrder sortOrder, int currentRow) {
        int size;
        if (this.exclusion != WindowFrameExclusion.EXCLUDE_NO_OTHERS) {
            throw new UnsupportedOperationException();
        }
        int endIndex = this.following != null ? this.getIndex(session, orderedRows, sortOrder, currentRow, this.following, true) : (this.units == WindowFrameUnits.ROWS ? currentRow : WindowFrame.toGroupEnd(orderedRows, sortOrder, currentRow, orderedRows.size() - 1));
        if (endIndex >= (size = orderedRows.size())) {
            endIndex = size - 1;
        }
        return endIndex;
    }

    /*
     * Unable to fully structure code
     */
    private int getIndex(SessionLocal session, ArrayList<Value[]> orderedRows, SortOrder sortOrder, int currentRow, WindowFrameBound bound, boolean forFollowing) {
        size = orderedRows.size();
        last = size - 1;
        block0 : switch (WindowFrame.$SWITCH_TABLE$org$h2$expression$analysis$WindowFrameBoundType()[bound.getType().ordinal()]) {
            case 1: {
                index = -1;
                break;
            }
            case 2: {
                switch (WindowFrame.$SWITCH_TABLE$org$h2$expression$analysis$WindowFrameUnits()[this.units.ordinal()]) {
                    case 1: {
                        value = WindowFrame.getIntOffset(bound, orderedRows.get(currentRow), session);
                        index = value > currentRow ? -1 : currentRow - value;
                        break block0;
                    }
                    case 3: {
                        value = WindowFrame.getIntOffset(bound, orderedRows.get(currentRow), session);
                        if (!forFollowing) {
                            index = WindowFrame.toGroupStart(orderedRows, sortOrder, currentRow, 0);
                            while (value > 0 && index > 0) {
                                --value;
                                index = WindowFrame.toGroupStart(orderedRows, sortOrder, index - 1, 0);
                            }
                            if (value <= 0) break block0;
                            index = -1;
                            break block0;
                        }
                        if (value == 0) {
                            index = WindowFrame.toGroupEnd(orderedRows, sortOrder, currentRow, last);
                            break block0;
                        }
                        index = currentRow;
                        while (value > 0 && index >= 0) {
                            --value;
                            index = WindowFrame.toGroupStart(orderedRows, sortOrder, index, 0) - 1;
                        }
                        break block0;
                    }
                    case 2: {
                        index = currentRow;
                        row = WindowFrame.getCompareRow(session, orderedRows, sortOrder, index, bound, false);
                        if (row == null) ** GOTO lbl54
                        index = Collections.binarySearch(orderedRows, row, sortOrder);
                        if (index < 0) ** GOTO lbl47
                        if (forFollowing) ** GOTO lbl45
                        while (index > 0 && sortOrder.compare(row, orderedRows.get(index - 1)) == 0) {
                            --index;
                        }
                        break block0;
lbl-1000:
                        // 1 sources

                        {
                            ++index;
lbl45:
                            // 2 sources

                            ** while (index < last && sortOrder.compare((Value[])row, (Value[])orderedRows.get((int)(index + 1))) == 0)
                        }
lbl46:
                        // 1 sources

                        break block0;
lbl47:
                        // 1 sources

                        index ^= -1;
                        if (!forFollowing) {
                            if (index != 0) break block0;
                            index = -1;
                            break block0;
                        }
                        --index;
                        break block0;
lbl54:
                        // 1 sources

                        index = -1;
                        break block0;
                    }
                    default: {
                        throw DbException.getUnsupportedException("units=" + String.valueOf((Object)this.units));
                    }
                }
            }
            case 3: {
                switch (WindowFrame.$SWITCH_TABLE$org$h2$expression$analysis$WindowFrameUnits()[this.units.ordinal()]) {
                    case 1: {
                        index = currentRow;
                        break block0;
                    }
                    case 2: 
                    case 3: {
                        index = forFollowing != false ? WindowFrame.toGroupEnd(orderedRows, sortOrder, currentRow, last) : WindowFrame.toGroupStart(orderedRows, sortOrder, currentRow, 0);
                        break block0;
                    }
                }
                throw DbException.getUnsupportedException("units=" + String.valueOf((Object)this.units));
            }
            case 4: {
                switch (WindowFrame.$SWITCH_TABLE$org$h2$expression$analysis$WindowFrameUnits()[this.units.ordinal()]) {
                    case 1: {
                        value = WindowFrame.getIntOffset(bound, orderedRows.get(currentRow), session);
                        rem = last - currentRow;
                        index = value > rem ? size : currentRow + value;
                        break block0;
                    }
                    case 3: {
                        value = WindowFrame.getIntOffset(bound, orderedRows.get(currentRow), session);
                        if (forFollowing) {
                            index = WindowFrame.toGroupEnd(orderedRows, sortOrder, currentRow, last);
                            while (value > 0 && index < last) {
                                --value;
                                index = WindowFrame.toGroupEnd(orderedRows, sortOrder, index + 1, last);
                            }
                            if (value <= 0) break block0;
                            index = size;
                            break block0;
                        }
                        if (value == 0) {
                            index = WindowFrame.toGroupStart(orderedRows, sortOrder, currentRow, 0);
                            break block0;
                        }
                        index = currentRow;
                        while (value > 0 && index <= last) {
                            --value;
                            index = WindowFrame.toGroupEnd(orderedRows, sortOrder, index, last) + 1;
                        }
                        break block0;
                    }
                    case 2: {
                        index = currentRow;
                        row = WindowFrame.getCompareRow(session, orderedRows, sortOrder, index, bound, true);
                        if (row == null) ** GOTO lbl111
                        index = Collections.binarySearch(orderedRows, row, sortOrder);
                        if (index < 0) ** GOTO lbl108
                        if (!forFollowing) ** GOTO lbl106
                        while (index < last && sortOrder.compare(row, orderedRows.get(index + 1)) == 0) {
                            ++index;
                        }
                        break block0;
lbl-1000:
                        // 1 sources

                        {
                            --index;
lbl106:
                            // 2 sources

                            ** while (index > 0 && sortOrder.compare((Value[])row, (Value[])orderedRows.get((int)(index - 1))) == 0)
                        }
lbl107:
                        // 1 sources

                        break block0;
lbl108:
                        // 1 sources

                        if (!forFollowing || (index ^= -1) == size) break block0;
                        --index;
                        break block0;
lbl111:
                        // 1 sources

                        index = size;
                        break block0;
                    }
                    default: {
                        throw DbException.getUnsupportedException("units=" + String.valueOf((Object)this.units));
                    }
                }
            }
            case 5: {
                index = size;
                break;
            }
            default: {
                throw DbException.getUnsupportedException("window frame bound type=" + String.valueOf((Object)bound.getType()));
            }
        }
        return index;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Iterator<Value[]> complexIterator(ArrayList<Value[]> orderedRows, SortOrder sortOrder, int currentRow, int startIndex, int endIndex, boolean reverse) {
        if (this.exclusion == WindowFrameExclusion.EXCLUDE_CURRENT_ROW) {
            if (currentRow < startIndex || currentRow > endIndex) return WindowFrame.plainIterator(orderedRows, startIndex, endIndex, reverse);
            if (currentRow == startIndex) {
                ++startIndex;
                return WindowFrame.plainIterator(orderedRows, startIndex, endIndex, reverse);
            } else {
                if (currentRow != endIndex) return WindowFrame.biIterator(orderedRows, startIndex, currentRow - 1, currentRow + 1, endIndex, reverse);
                --endIndex;
            }
            return WindowFrame.plainIterator(orderedRows, startIndex, endIndex, reverse);
        } else {
            boolean includeCurrentRow;
            int exStart = WindowFrame.toGroupStart(orderedRows, sortOrder, currentRow, startIndex);
            int exEnd = WindowFrame.toGroupEnd(orderedRows, sortOrder, currentRow, endIndex);
            boolean bl = includeCurrentRow = this.exclusion == WindowFrameExclusion.EXCLUDE_TIES;
            if (includeCurrentRow) {
                if (currentRow == exStart) {
                    ++exStart;
                    includeCurrentRow = false;
                } else if (currentRow == exEnd) {
                    --exEnd;
                    includeCurrentRow = false;
                }
            }
            if (exStart > exEnd || exEnd < startIndex || exStart > endIndex) return WindowFrame.plainIterator(orderedRows, startIndex, endIndex, reverse);
            if (includeCurrentRow) {
                if (startIndex == exStart) {
                    if (endIndex != exEnd) return WindowFrame.biIterator(orderedRows, currentRow, currentRow, exEnd + 1, endIndex, reverse);
                    return Collections.singleton(orderedRows.get(currentRow)).iterator();
                }
                if (endIndex != exEnd) return WindowFrame.triIterator(orderedRows, startIndex, exStart - 1, currentRow, currentRow, exEnd + 1, endIndex, reverse);
                return WindowFrame.biIterator(orderedRows, startIndex, exStart - 1, currentRow, currentRow, reverse);
            }
            if (startIndex >= exStart) {
                startIndex = exEnd + 1;
                return WindowFrame.plainIterator(orderedRows, startIndex, endIndex, reverse);
            } else {
                if (endIndex > exEnd) return WindowFrame.biIterator(orderedRows, startIndex, exStart - 1, exEnd + 1, endIndex, reverse);
                endIndex = exStart - 1;
            }
        }
        return WindowFrame.plainIterator(orderedRows, startIndex, endIndex, reverse);
    }

    public StringBuilder getSQL(StringBuilder builder, int formattingFlags) {
        builder.append(this.units.getSQL());
        if (this.following == null) {
            builder.append(' ');
            this.starting.getSQL(builder, false, formattingFlags);
        } else {
            builder.append(" BETWEEN ");
            this.starting.getSQL(builder, false, formattingFlags).append(" AND ");
            this.following.getSQL(builder, true, formattingFlags);
        }
        if (this.exclusion != WindowFrameExclusion.EXCLUDE_NO_OTHERS) {
            builder.append(' ').append(this.exclusion.getSQL());
        }
        return builder;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$h2$expression$analysis$WindowFrameUnits() {
        if ($SWITCH_TABLE$org$h2$expression$analysis$WindowFrameUnits != null) {
            return $SWITCH_TABLE$org$h2$expression$analysis$WindowFrameUnits;
        }
        int[] nArray = new int[WindowFrameUnits.values().length];
        try {
            nArray[WindowFrameUnits.GROUPS.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WindowFrameUnits.RANGE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WindowFrameUnits.ROWS.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$h2$expression$analysis$WindowFrameUnits = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$h2$expression$analysis$WindowFrameBoundType() {
        if ($SWITCH_TABLE$org$h2$expression$analysis$WindowFrameBoundType != null) {
            return $SWITCH_TABLE$org$h2$expression$analysis$WindowFrameBoundType;
        }
        int[] nArray = new int[WindowFrameBoundType.values().length];
        try {
            nArray[WindowFrameBoundType.CURRENT_ROW.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WindowFrameBoundType.FOLLOWING.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WindowFrameBoundType.PRECEDING.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WindowFrameBoundType.UNBOUNDED_FOLLOWING.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[WindowFrameBoundType.UNBOUNDED_PRECEDING.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$h2$expression$analysis$WindowFrameBoundType = nArray;
        return nArray;
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class BiItr
    extends PlainItr {
        final int end1;
        final int start1;

        BiItr(ArrayList<Value[]> orderedRows, int startIndex1, int endIndex1, int startIndex2, int endIndex2) {
            super(orderedRows, startIndex1, endIndex2);
            this.end1 = endIndex1;
            this.start1 = startIndex2;
        }

        @Override
        public Value[] next() {
            if (this.cursor > this.endIndex) {
                throw new NoSuchElementException();
            }
            Value[] r = (Value[])this.orderedRows.get(this.cursor);
            this.cursor = this.cursor != this.end1 ? this.cursor + 1 : this.start1;
            return r;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class BiReverseItr
    extends PlainReverseItr {
        final int end1;
        final int start1;

        BiReverseItr(ArrayList<Value[]> orderedRows, int startIndex1, int endIndex1, int startIndex2, int endIndex2) {
            super(orderedRows, startIndex1, endIndex2);
            this.end1 = endIndex1;
            this.start1 = startIndex2;
        }

        @Override
        public Value[] next() {
            if (this.cursor < this.startIndex) {
                throw new NoSuchElementException();
            }
            Value[] r = (Value[])this.orderedRows.get(this.cursor);
            this.cursor = this.cursor != this.start1 ? this.cursor - 1 : this.end1;
            return r;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static abstract class Itr
    implements Iterator<Value[]> {
        final ArrayList<Value[]> orderedRows;
        int cursor;

        Itr(ArrayList<Value[]> orderedRows) {
            this.orderedRows = orderedRows;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class PlainItr
    extends Itr {
        final int endIndex;

        PlainItr(ArrayList<Value[]> orderedRows, int startIndex, int endIndex) {
            super(orderedRows);
            this.endIndex = endIndex;
            this.cursor = startIndex;
        }

        @Override
        public boolean hasNext() {
            return this.cursor <= this.endIndex;
        }

        @Override
        public Value[] next() {
            if (this.cursor > this.endIndex) {
                throw new NoSuchElementException();
            }
            return (Value[])this.orderedRows.get(this.cursor++);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class PlainReverseItr
    extends Itr {
        final int startIndex;

        PlainReverseItr(ArrayList<Value[]> orderedRows, int startIndex, int endIndex) {
            super(orderedRows);
            this.startIndex = startIndex;
            this.cursor = endIndex;
        }

        @Override
        public boolean hasNext() {
            return this.cursor >= this.startIndex;
        }

        @Override
        public Value[] next() {
            if (this.cursor < this.startIndex) {
                throw new NoSuchElementException();
            }
            return (Value[])this.orderedRows.get(this.cursor--);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class TriItr
    extends BiItr {
        private final int end2;
        private final int start2;

        TriItr(ArrayList<Value[]> orderedRows, int startIndex1, int endIndex1, int startIndex2, int endIndex2, int startIndex3, int endIndex3) {
            super(orderedRows, startIndex1, endIndex1, startIndex2, endIndex3);
            this.end2 = endIndex2;
            this.start2 = startIndex3;
        }

        @Override
        public Value[] next() {
            if (this.cursor > this.endIndex) {
                throw new NoSuchElementException();
            }
            Value[] r = (Value[])this.orderedRows.get(this.cursor);
            this.cursor = this.cursor != this.end1 ? (this.cursor != this.end2 ? this.cursor + 1 : this.start2) : this.start1;
            return r;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static final class TriReverseItr
    extends BiReverseItr {
        private final int end2;
        private final int start2;

        TriReverseItr(ArrayList<Value[]> orderedRows, int startIndex1, int endIndex1, int startIndex2, int endIndex2, int startIndex3, int endIndex3) {
            super(orderedRows, startIndex1, endIndex1, startIndex2, endIndex3);
            this.end2 = endIndex2;
            this.start2 = startIndex3;
        }

        @Override
        public Value[] next() {
            if (this.cursor < this.startIndex) {
                throw new NoSuchElementException();
            }
            Value[] r = (Value[])this.orderedRows.get(this.cursor);
            this.cursor = this.cursor != this.start1 ? (this.cursor != this.start2 ? this.cursor - 1 : this.end2) : this.end1;
            return r;
        }
    }
}

