/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression.analysis;

import org.h2.engine.SessionLocal;
import org.h2.expression.Expression;
import org.h2.expression.analysis.WindowFrameBoundType;
import org.h2.table.ColumnResolver;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class WindowFrameBound {
    private final WindowFrameBoundType type;
    private Expression value;
    private boolean isVariable;
    private int expressionIndex = -1;

    public WindowFrameBound(WindowFrameBoundType type, Expression value) {
        this.type = type;
        this.value = type == WindowFrameBoundType.PRECEDING || type == WindowFrameBoundType.FOLLOWING ? value : null;
    }

    public WindowFrameBoundType getType() {
        return this.type;
    }

    public Expression getValue() {
        return this.value;
    }

    public boolean isParameterized() {
        return this.type == WindowFrameBoundType.PRECEDING || this.type == WindowFrameBoundType.FOLLOWING;
    }

    public boolean isVariable() {
        return this.isVariable;
    }

    public int getExpressionIndex() {
        return this.expressionIndex;
    }

    void setExpressionIndex(int expressionIndex) {
        this.expressionIndex = expressionIndex;
    }

    void mapColumns(ColumnResolver resolver, int level, int state) {
        if (this.value != null) {
            this.value.mapColumns(resolver, level, state);
        }
    }

    void optimize(SessionLocal session) {
        if (this.value != null) {
            this.value = this.value.optimize(session);
            if (!this.value.isConstant()) {
                this.isVariable = true;
            }
        }
    }

    void updateAggregate(SessionLocal session, int stage) {
        if (this.value != null) {
            this.value.updateAggregate(session, stage);
        }
    }

    public StringBuilder getSQL(StringBuilder builder, boolean following, int sqlFlags) {
        if (this.type == WindowFrameBoundType.PRECEDING || this.type == WindowFrameBoundType.FOLLOWING) {
            this.value.getUnenclosedSQL(builder, sqlFlags).append(' ');
        }
        return builder.append(this.type.getSQL());
    }
}

